#ifndef MGLRotateTool_Header
#define MGLRotateTool_Header

#include <tools/MXYZToolType.h>

namespace AztecGUI {
  class MGLRotateToolType : public MXYZToolType
  {
  public:
     MGLRotateToolType();

     // MToolType methods
     std::string getName();
     virtual int drawTool(bool Select, const Aztec::MComponentPtr &comp);
     virtual int onMouseDown(const Aztec::MMouseEvent &event);
     virtual int onMouseUp(const Aztec::MMouseEvent &event);
     virtual int onMouseMove(const Aztec::MMouseEvent &event);
     virtual int getDefaultManip() {return 4;};

  private:
    Aztec::MVector3 m_Orig, m_VecA, m_VecB, m_VecC, m_VecD, m_PivotPoint, m_ViewNorm;
    float       m_RotAng;

    float calculateRotations(const Aztec::MVector3 &pivot, const Aztec::MVector3 &constraintNormal, const Aztec::MVector3 &downVector, const Aztec::MVector3 &currentVector);
  };


}
#endif