@echo off

rem This sets it so any environment changes we make are local to this batch file only

setlocal

if %1@ == @ goto Argument_Error

set TARGET_DIR=%AZTEC_REDIST_DIR%\aztec-win32-%1
echo Making a binary release %TARGET_DIR%

echo removing old release directory %TARGET_DIR%
rd /s/q %TARGET_DIR% > nul

echo Copying all the files from %AZTEC_REDIST_DIR%\release\common\*.* to %TARGET_DIR%\common\*.*
xcopy /e/s/c/q %AZTEC_REDIST_DIR%\release\common\*.* %TARGET_DIR%\common\*.*

echo Copying all the files from %AZTEC_REDIST_DIR%\release\win32-i386\bin\*.* to %TARGET_DIR%\win32-i386\bin\*.*
xcopy /e/s/c/q %AZTEC_REDIST_DIR%\release\win32-i386\bin\*.* %TARGET_DIR%\win32-i386\bin\*.*

echo Removing temporary files from the compilation process (*.lib, *.exp, *.pdb)
del /q %TARGET_DIR%\win32-i386\bin\*.lib > nul
del /q %TARGET_DIR%\win32-i386\bin\*.exp > nul
del /q %TARGET_DIR%\win32-i386\bin\*.pdb > nul

echo Removing the logs directory %TARGET_DIR%\win32-i386\bin\logs
rd /q/s %TARGET_DIR%\win32-i386\bin\Logs

echo copying README file from docs\README to %TARGET_DIR%\README
copy docs\README %TARGET_DIR% > nul

echo copying ReleaseNotes.html file from docs\ReleaseNotes.html to %TARGET_DIR%\ReleaseNotes.html
copy docs\ReleaseNotes.html %TARGET_DIR% > nul

echo copying changelogs.txt file from docs\changelogs.txt to %TARGET_DIR%\changelogs.txt
copy docs\changelogs.txt %TARGET_DIR% > nul

echo copying the examples from docs\samples\*.* to %TARGET_DIR%\common\samples\*.*
xcopy /e/s/c/q docs\samples\*.* %TARGET_DIR%\common\samples\*.*

echo removing any CVS directories in %TARGET_DIR%\*.*
for /r %TARGET_DIR% %%F in (CVS) do rd /q/s %%F > nul

echo Copying MSVCP60.DLL
copy c:\winnt\system32\MSVCP60.DLL %TARGET_DIR%\win32-i386\bin\

echo Renaming AztecMain.exe to Aztec.exe
rename %TARGET_DIR%\win32-i386\bin\AztecMain.exe %TARGET_DIR%\win32-i386\bin\Aztec.exe

echo All Done!

goto end


:Argument_Error

echo One argument needs to be specified, i.e the version number of the release
echo   e.g.  compile_source_release 1.5.2

goto end


:end

endlocal