-------------------------------------------------------------------------
-- MD2/MDX Exporter V3.0
-- Version 3.0 for 3ds Max 2012 by hypov8
--
-- previous versions:
-- Adam Barton (adam@add3d.co.uk)
-- Updated by Ruiner (http://www.netdoo.com/wodx)
-- New: Added Export Support for multiple object/mesh selections

-- hypov8 log:
-- Added setup for kingpin
-- skins using paths from diffuse slot. (md2/mdx importer default to setting this)
-- Added option to get multiple model bounds to fix seam errors in multi part player models.
-- Moved all code out of global varable. conflicts with other exporters.
-- Added frame file suport without comma seperated. CVS still works. "1,1,framename"  "2,20,framename"
-- v3.0 beta added glCommands. required by kingpin. (code base from quark py script)
-- added try/catch after open file. prevented file acess if script crashed.
-- added suport for .mdx and .md2 files in 1 script.
-- new feature to bake animation into new model. great for tweeking the vertex after bone animation.
-- Above also includes a way to split model at smothgroup edges. exporter will ignore smothgroups so this is used befor export.
-- optimized rollout. removed obsolete options that are required for kingpin.
-- Bake animation. Will copy all animations from selected objects and create a vertex animated mesh/s.
-- Added sprite option for exported models. including a qdt file import/reader.
-- changed glCommandt to test uv cords instead of indicies.
-- optimize glCommands. retry all triangles again, after match found
-- uv does not need to be optimized/welded anymore before export.
-- added support for multi selected models to have individual hitbox.
-- duplicate skins removed
-- skins renamed to lowercase


-- todo: tween frames?
-- todo: smothgroups. get each tri in sg and create array
-- todo: multi materal support
-- todo: import mdx sprite defines from models?
-- todo: export sprite to file?
-------------------------------------------------------------------------


----------------
-- additional code (glCommands)
-- QuArK  -  Quake Army Knife
-- Original code from Blender, md2_exporter.py, author - Bob Holcomb.",
-- "author":        "cdunde/DanielPharos",
-- "author e-mail": "cdunde@sbcglobal.net",
----------------



utility MD2Export_KP "_KP Model Export v3"
(
	----------------------------------
	-- global varables
	----------------------------------
	local Kingpin_MD2_Exporter_ver = "Kingpin MD2/MDX Exporter V3.0 update by hypov8"
	local md2lastfile_kp=""
	local framenamelist_kp=#()
	local nlist_kp=#([-0.525731, 0.000000, 0.850651],[-0.442863, 0.238856, 0.864188],[-0.295242, 0.000000, 0.955423],[-0.309017, 0.500000, 0.809017],[-0.162460, 0.262866, 0.951056],[0.000000, 0.000000, 1.000000],[0.000000, 0.850651, 0.525731],[-0.147621, 0.716567, 0.681718],[0.147621, 0.716567, 0.681718],[0.000000, 0.525731, 0.850651],[0.309017, 0.500000, 0.809017],[0.525731, 0.000000, 0.850651],[0.295242, 0.000000, 0.955423],[0.442863, 0.238856, 0.864188],[0.162460, 0.262866, 0.951056],[-0.681718, 0.147621, 0.716567],[-0.809017, 0.309017, 0.500000],[-0.587785, 0.425325, 0.688191],[-0.850651, 0.525731, 0.000000],[-0.864188, 0.442863, 0.238856],[-0.716567, 0.681718, 0.147621],[-0.688191, 0.587785, 0.425325],[-0.500000, 0.809017, 0.309017],[-0.238856, 0.864188, 0.442863],[-0.425325, 0.688191, 0.587785],[-0.716567, 0.681718, -0.147621],[-0.500000, 0.809017, -0.309017],[-0.525731, 0.850651, 0.000000],[0.000000, 0.850651, -0.525731],[-0.238856, 0.864188, -0.442863],[0.000000, 0.955423, -0.295242],[-0.262866, 0.951056, -0.162460],[0.000000, 1.000000, 0.000000],[0.000000, 0.955423, 0.295242],[-0.262866, 0.951056, 0.162460],[0.238856, 0.864188, 0.442863],[0.262866, 0.951056, 0.162460],[0.500000, 0.809017, 0.309017],[0.238856, 0.864188, -0.442863],[0.262866, 0.951056, -0.162460],[0.500000, 0.809017, -0.309017],[0.850651, 0.525731, 0.000000],[0.716567, 0.681718, 0.147621],[0.716567, 0.681718, -0.147621],[0.525731, 0.850651, 0.000000],[0.425325, 0.688191, 0.587785],[0.864188, 0.442863, 0.238856],[0.688191, 0.587785, 0.425325],[0.809017, 0.309017, 0.500000],[0.681718, 0.147621, 0.716567],[0.587785, 0.425325, 0.688191],[0.955423, 0.295242, 0.000000],[1.000000, 0.000000, 0.000000],[0.951056, 0.162460, 0.262866],[0.850651, -0.525731, 0.000000],[0.955423, -0.295242, 0.000000],[0.864188, -0.442863, 0.238856],[0.951056, -0.162460, 0.262866],[0.809017, -0.309017, 0.500000],[0.681718, -0.147621, 0.716567],[0.850651, 0.000000, 0.525731],[0.864188, 0.442863, -0.238856],[0.809017, 0.309017, -0.500000],[0.951056, 0.162460, -0.262866],[0.525731, 0.000000, -0.850651],[0.681718, 0.147621, -0.716567],[0.681718, -0.147621, -0.716567],[0.850651, 0.000000, -0.525731],[0.809017, -0.309017, -0.500000],[0.864188, -0.442863, -0.238856],[0.951056, -0.162460, -0.262866],[0.147621, 0.716567, -0.681718],[0.309017, 0.500000, -0.809017],[0.425325, 0.688191, -0.587785],[0.442863, 0.238856, -0.864188],[0.587785, 0.425325, -0.688191],[0.688191, 0.587785, -0.425325],[-0.147621, 0.716567, -0.681718],[-0.309017, 0.500000, -0.809017],[0.000000, 0.525731, -0.850651],[-0.525731, 0.000000, -0.850651],[-0.442863, 0.238856, -0.864188],[-0.295242, 0.000000, -0.955423],[-0.162460, 0.262866, -0.951056],[0.000000, 0.000000, -1.000000],[0.295242, 0.000000, -0.955423],[0.162460, 0.262866, -0.951056],[-0.442863, -0.238856, -0.864188],[-0.309017, -0.500000, -0.809017],[-0.162460, -0.262866, -0.951056],[0.000000, -0.850651, -0.525731],[-0.147621, -0.716567, -0.681718],[0.147621, -0.716567, -0.681718],[0.000000, -0.525731, -0.850651],[0.309017, -0.500000, -0.809017],[0.442863, -0.238856, -0.864188],[0.162460, -0.262866, -0.951056],[0.238856, -0.864188, -0.442863],[0.500000, -0.809017, -0.309017],[0.425325, -0.688191, -0.587785],[0.716567, -0.681718, -0.147621],[0.688191, -0.587785, -0.425325],[0.587785, -0.425325, -0.688191],[0.000000, -0.955423, -0.295242],[0.000000, -1.000000, 0.000000],[0.262866, -0.951056, -0.162460],[0.000000, -0.850651, 0.525731],[0.000000, -0.955423, 0.295242],[0.238856, -0.864188, 0.442863],[0.262866, -0.951056, 0.162460],[0.500000, -0.809017, 0.309017],[0.716567, -0.681718, 0.147621],[0.525731, -0.850651, 0.000000],[-0.238856, -0.864188, -0.442863],[-0.500000, -0.809017, -0.309017],[-0.262866, -0.951056, -0.162460],[-0.850651, -0.525731, 0.000000],[-0.716567, -0.681718, -0.147621],[-0.716567, -0.681718, 0.147621],[-0.525731, -0.850651, 0.000000],[-0.500000, -0.809017, 0.309017],[-0.238856, -0.864188, 0.442863],[-0.262866, -0.951056, 0.162460],[-0.864188, -0.442863, 0.238856],[-0.809017, -0.309017, 0.500000],[-0.688191, -0.587785, 0.425325],[-0.681718, -0.147621, 0.716567],[-0.442863, -0.238856, 0.864188],[-0.587785, -0.425325, 0.688191],[-0.309017, -0.500000, 0.809017],[-0.147621, -0.716567, 0.681718],[-0.425325, -0.688191, 0.587785],[-0.162460, -0.262866, 0.951056],[0.442863, -0.238856, 0.864188],[0.162460, -0.262866, 0.951056],[0.309017, -0.500000, 0.809017],[0.147621, -0.716567, 0.681718],[0.000000, -0.525731, 0.850651],[0.425325, -0.688191, 0.587785],[0.587785, -0.425325, 0.688191],[0.688191, -0.587785, 0.425325],[-0.955423, 0.295242, 0.000000],[-0.951056, 0.162460, 0.262866],[-1.000000, 0.000000, 0.000000],[-0.850651, 0.000000, 0.525731],[-0.955423, -0.295242, 0.000000],[-0.951056, -0.162460, 0.262866],[-0.864188, 0.442863, -0.238856],[-0.951056, 0.162460, -0.262866],[-0.809017, 0.309017, -0.500000],[-0.864188, -0.442863, -0.238856],[-0.951056, -0.162460, -0.262866],[-0.809017, -0.309017, -0.500000],[-0.681718, 0.147621, -0.716567],[-0.681718, -0.147621, -0.716567],[-0.850651, 0.000000, -0.525731],[-0.688191, 0.587785, -0.425325],[-0.587785, 0.425325, -0.688191],[-0.425325, 0.688191, -0.587785],[-0.425325, -0.688191, -0.587785],[-0.587785, -0.425325, -0.688191],[-0.688191, -0.587785, -0.425325])
	local img_with_kp=256
	local img_hight_kp=256
	local isMDX = true
	local rolloutOpen =false --too: get?


	--info about
	local string_1 = 	"Kingpin Compatable Model Exporter\n\n"+ \
						"Update: Texture path\n"+ \
						"Use the Bitmap path from material diffuse slot\n" + \
						"Path will be trimmed at  \"models/\"  or  \"players/ \"\n" + \
						"eg..   C:\Games\Kingpin\main\models\weapons\pipe\p.tga\n"  + \
						"to..   models/weapons/pipe/p.tga\n"  + \
						"\n" + \
						"Update: Seam fix on Player Models\n" + \
						"For players, select 3 model parts in the viewport then, hit \"Add\"\n" + \
						"Then select each model part in viewport and \"Export\"\n" + \
						"\n"+ \
						"This fixes vertex miss aligment at model seams\n"+ \
						"\n" + \
						"Update: CSV file Support\n" + \
						"Frame file supoorts comma seperated \"time,time,name\"\n1,1,Tpose\n2,10,Jumping\n11,22,Running\n" + \
						"\n" + \
						"Update: Bake\n" + \
						"Bake out vertex animation into a new mesh.\n"+ \
						"Usefull when model is animated by a link or Skin Modifier.\n"+ \
						"This alows you to add addition vertex animations.\n"+ \
						"\n" + \
						"Update: Bake (Hard Edges)\n" + \
						"Bake also supports making hard edges from smoothgroups.\n"



	--todo tooltip max length
	local string_Tip_BAKE =	"Create new model's from the selected model's and bakes the animation into the vertex.\n" + \
							"Use when you animated the model via a link/skin and want to tweek the vertex animation\n" + \
							"\n" + \
							"Will bake every frame on timeline unless you set from/to above."


	local string_Tip_SG =	"Bake Animation with Smothing Group edges split\n" + \
							"Exporter ignores smoothing groups so model needs to be split at seams.\n" + \
							"\n" + \
							"Use with CAUTION!!.\n"+ \
							"Confirm model animation is ok when complete.\n" + \
							"Vertex count changes and uses xyz cords to get animation refrence.\n"

	local string_Tip_Weld =	"Bake Animation with duplicate vertex welded\n" + \
							"Fix used to smooth hard edges on animated models.\n" + \
							"\n" + \
							"Use with CAUTION!!.\n"+ \
							"Confirm model animation is ok when complete.\n" + \
							"Vertex count changes and uses xyz cords to get animation refrence.\n"

	local string_Tip_MDL =	"Merged multiple selected models into one\n" + \
							"Used to vertex edit gun/player as 1 complete model.\n" + \
							"\n" + \
							"Use with CAUTION!!.\n"+ \
							"Confirm model animation is ok when complete.\n"


	local string_Tip_PPM = 	"Fix for multi part Player Model seam aligment issues.\n"+ \
							"Sets bounding box to the size of all model parts.\n"+ \
							"DISABLE for player weapons, map models etc.."


	local MAX_TRI = 4096
	local MAX_VERT = 2048
	local MAX_FRAMES=512
	local MAX_SKINS = 32

	----------------------------------
	-- user controls
	----------------------------------
	checkbox 	UI_ckBox_save_ani 		"Animated" 			align:#left  	checked:false offset:[-10,0] across:2  tooltip:"Export an Animated model\nUn-check for static map models"
	checkbox 	UI_ckBox_use_TimeLine 	"Use Timeline" 		align:#right 	checked:True   offset:[10,0]tooltip:"Use timeline range.\nOr use defined time range below"
	spinner 	UI_spin_timeStart 		"from" 				align:#left 	offset:[-10,0] fieldwidth:35 range:[0,1000,0] type:#integer across:2
	spinner 	UI_spin_timeEnd 		"to"  				align:#left 	fieldwidth:35 range:[0,1000,40] type:#integer
	button 		UI_btn_frameFile 		"Frame names" 		align:#left 	width:75 offset:[-10,0]		across:2 height:18
	editText 	UI_eTex_frameFile 		"" 					align:#right 	width:80 offset:[10,0]

	groupBox 	group1 										pos:[-1,65] 	width:164 height:7
	checkbox 	UI_ckBox_PPM 			"Player Model" 		align:#left 	checked:false  offset:[-10,0]	across:2 tooltip:string_Tip_PPM
	checkbox 	UI_ckBox_1stPerson 		"1stPerson" 		align:#right 	checked:false   offset:[10,0] tooltip:"First person view models have the light direction invert so they apear brigher when a light is infront"
	listbox 	UI_lbox_PPM 			"" 					align:#left 	width:120  height:3 offset:[-10,0] items:#("head", "body", "legs") across:2 tooltip:"pick head body and legs"
	button 		UI_btn_AddModelToList 	"Add" 				align:#right 	width:32 height:44 offset:[10,0] 		tooltip:"Add all body parts"

	groupBox 	group3 										pos:[-1,145] 	width:164 height:7
	checkbox 	UI_ckBox_bakeWeld 		"Weld" 		align:#left 	checked:false offset:[-10,0] across:3 tooltip:string_Tip_Weld
	checkbox 	UI_ckBox_bakeSG 		"Split" 			align:#left 	checked:false  tooltip:string_Tip_SG
	checkbox 	UI_ckBox_mergeMDL 		"Merge" 			align:#left 	checked:false  tooltip:string_Tip_MDL


	button 		UI_btn_bakeModel 		"Bake Animation" 	align:#left		width:120  height:24 offset:[-10,0]	across:2 tooltip:string_Tip_BAKE
	button 		UI_btn_info_about 		"Info" 				align:#right  	width:32  height:24  offset:[10,0] tooltip:"Need Help?"
	groupBox 	group4 					"" 					pos:[-1,200] 	width:164 height:7
	button 		UI_btn_export 			"Export .MD2/.MDX"	align:#left		width:120  height:42 offset:[-10,0]	across:2 tooltip:"WOOHOO!! We are Ready to Do this"
	button 		UI_btn_SFX 				"SFX" 				align:#right  	width:32  height:42  offset:[10,0] tooltip:"Add Sprite Special Effects"


	global sfx_1TypeArray=#("0: Blood (Called SFX_SPRITE_SURF_BLOOD1 in code)", "1: Bullet Hole (Called SFX_SPRITE_SURF_BULLET1 in code)", "2: Riple (Called SFX_SPRITE_SURF_RIPPLE in code)", "5: Blood Pool (Called SFX_SPRITE_SURF_BLOOD_POOL in code)", "6: Blood Splat", "7: Blood Drop", "8: Smoke Small", "9: Fire", "10: Carona", "16: Same as 9:", "17: Carona Amber", "18: Carona Red", "19: Carona Green", "20: Carona Blue", "21: Rain", "22: Smoke Small R (Red? but is not red. unfisched texture)", "23: Sniper 1c (Missing texture)", "24: Sniper 2 (Missing texture)", "25: Same as 2.", "71: Blood 1", "72: Blood 1b", "73: Blood 1c", "74: Blood 1d", "75: Blood 1e", "76: Blood 1f", "77: Blood 1g", "78: Blood 1h", "79: Blood 1i", "80: Muzzle flash 3", "100: Muzzle flash HMG (Used for HMG)", "101: Muzzle flash 1 (Used for Pistol)", "102: Muzzle flash 2", "103: Same as 80.", "104: Muzzle flash 4", "106: Muzzle flash 1a", "107: Muzzle flash 2a", "108: Muzzle flash 2b", "110: Explode 1", "111: Explode 2", "116: Smoke Animated", "120: Flame Thrower", "121: Return error texture.", "122: Flame Thrower Blue", "123: Same as 121.", "124: Splash 1", "125: Splash 2", "126: Splash 3", "127: Splash 4", "128: Firewall")
	global sfx_3dirArray=#("0: UP", "1: Down", "-1: g", "-2: h", "2: x", "180: y")

	--default pistol
	local sfx_01_Type =#( 31,31,31,31) 				--101   // type (fire) [index31]
	local sfx_02_flags =# (0,0,0,0)					--0		// flags
	local sfx_03_dir =# (0,0,0,0)					--0		// VEL_TYPE_UP (will move upwards)
	local sfx_04_speed =# (3,3,3,3)					--3    // vel_speed
	local sfx_05_grav=# (0,0,0,0)					--0		// gravity
	local sfx_06_msec=# (2,2,2,2)					--2		// spawn interval, 2 = 0.1 seconds
	local sfx_07_rand=# (0.5,0.5,0.5,0.5)			--0.5		// random spawn interval (sprite will be spawned 80% of the time)
	local sfx_08_stAlpha=# (0.9,0.9,0.9,0.9)			--0.9   // start alpha
	local sfx_09_endAplha=# (0.0,0.0,0.0,0.0)		--0.0		// end alpha
	local sfx_10_inTime=# (0.2,0.2,0.2,0.2)			--0.2   // fadein time
	local sfx_11_lifeTime=# (4.0,4.0,4.0,4.0)		--4.0   // lifetime
	local sfx_12_randScale=# (0.2,0.2,0.2,0.2)		--0.2		// random time scale (fadein and lifetime will be multiplied by (x * 0.5), where x is a random number between -1 and 1
	local sfx_13_stWidth=# (4.25,4.25,4.25,4.25)		--4.25   // start width
	local sfx_14_endWidth=# (4.25,4.25,4.25,4.25)	--4.25   // end width
	local sfx_15_stHeight=# (4.25,4.25,4.25,4.25)	--4.25   // start height
	local sfx_16_endHeight=# (4.25,4.25,4.25,4.25)	--4.25   // end height
	local sfx_17_randScale=# (0.5,0.5,0.5,0.5)		--0.5   // random size scale (same as random time scale, but effects onle sizes)

	local sfx_numDefines = 0
	local sfx_numEntry =0
	local sfx_18_vert= 0	--2   // INDEX (assigned to the first vertex) --hypo add +1
	local sfx_19_define= 0	--0		// uses the first sfx_define (above)
	local sfx_20_type= 0	--0   // tells the engine to use the above INDEX is a vertex index

	local sfx_range1st= 8	--8 - 8  // frame ranges to enable the effect for
	local sfx_range1end= 8
	local sfx_range2st= -1	--8 - 8  // frame ranges to enable the effect for
	local sfx_range2end= -1
	local sfx_range3st= -1	--8 - 8  // frame ranges to enable the effect for
	local sfx_range3end= -1
	local sfx_range4st= -1	--8 - 8  // frame ranges to enable the effect for
	local sfx_range4end= -1
	local sfx_range5st= -1	--8 - 8  // frame ranges to enable the effect for
	local sfx_range5end= -1

	rollout SFX "Define Sprite"
	(
		label UI2_SFX_TypeLabel 	"SFX Type " 		align:#right across:2
		dropdownlist UI2_SFX_Type 	""			align:#right height:10	items:sfx_1TypeArray selection:31 	--1 type

		spinner UI2_SFX_Flags  		"Flags"			align:#right fieldWidth:59 type:#integer range:[0,2048,0] 			--int flags;

		label UI2_SFX_dirLabel 		"Direction " align:#right across:2
		dropdownlist UI2_SFX_dir 	""			align:#right items:sfx_3dirArray selection:1 	--int velocity_type;

		spinner UI2_SFX_speed  		"Speed"				align:#right fieldWidth:59 type:#integer range:[1,2048,3] 			--int velocity_speed_up;
		spinner UI2_SFX_grav  		"Gravity "			align:#right fieldWidth:59 type:#integer range:[0,2048,0] 			--float gravity;
		spinner UI2_SFX_time  		"Time 0.1s * "		align:#right fieldWidth:59 type:#integer range:[1,2048,2] 			--int spawn_interval time;
		spinner UI2_SFX_timeRan 	"Rand Time "		align:#right fieldWidth:59 type:#float  range:[0.1,	1.0,	0.5]	--float random_spawn_interval;
		spinner UI2_SFX_startAlp 	"Start Alpha "		align:#right fieldWidth:59 type:#float  range:[0.0,	1,		0.9]	-- float start_alpha;
		spinner UI2_SFX_endAlpha 	"End Alpha "		align:#right fieldWidth:59 type:#float  range:[0.0,	1,		0.0]	-- float end_alpha;
		spinner UI2_SFX_fadeIn 		"Fade In "			align:#right fieldWidth:59 type:#float  range:[0.0,	1,		0.2]	-- float fadein_time;
		spinner UI2_SFX_life 		"Lifetime: "		align:#right fieldWidth:59 type:#float  range:[0.0,	100.0,	4.0]	---float lifetime;
		spinner UI2_SFX_randScale 	 "Rand Scale "		align:#right fieldWidth:59 type:#float 	range:[-1.0,1.0,	0.2]	--- float random_time_scale;
		spinner UI2_SFX_startW 		"Start Width "		align:#right fieldWidth:59 type:#float  range:[0.0,	100.0,	4.25]	--- float start_width;
		spinner UI2_SFX_endW 		"End Width "		align:#right fieldWidth:59 type:#float  range:[0.0,	100.0,	4.25]	--- float end_width;
		spinner UI2_SFX_startH 		"Start Height "		align:#right fieldWidth:59 type:#float  range:[0.0,	100.0,	4.25]	--- float start_height;
		spinner UI2_SFX_endH 		"End Height "		align:#right fieldWidth:59 type:#float  range:[0.0,	100.0,	4.25]	--- float end_height;
		spinner UI2_SFX_randWH 	"Rand W/H "			align:#right fieldWidth:59 type:#float  range:[-1.0,1.0,	0.5]	--- float random_size_scale;

		group "Select position (Vertex)"
		(
			spinner UI2_SFX2_vertex 	"Vertex # "		align:#right fieldWidth:59 type:#integer range:[0,2048,0] tooltip:"Get vertex number by selecting it in\nedit_mesh->vertex mode.\nIts index will be show in 'Selection' rollout."
			label UI2_SFX2_Tip1 "Note: SFX added only when\nVertex # is 1 or above" align:#left height:28
		)
		group "Select frame/s (0based)"
		(
			spinner UI2_SFX2_1frameFrom 	"from "			align:#left fieldWidth:30 type:#integer  range:[0,512,8] across:2 tooltip:"0based frame numbers\n1st frame range to show sprite"
			spinner UI2_SFX2_1frameTo 		"to "			align:#right fieldWidth:30 type:#integer range:[0,512,8] tooltip:"0based frame numbers\n1st frame range to show sprite"
			spinner UI2_SFX2_2frameFrom 	"from "			align:#left fieldWidth:30 type:#integer range:[-1,511,-1] across:2 tooltip:"0based frame numbers\n2nd frame range to show sprite"
			spinner UI2_SFX2_2frameTo 		"to "			align:#right fieldWidth:30 type:#integer range:[-1,511,-1] tooltip:"0based frame numbers\n2nd frame range to show sprite"
			spinner UI2_SFX2_3frameFrom 	"from:"			align:#left fieldWidth:30 type:#integer range:[-1,511,-1] across:2 tooltip:"0based frame numbers\n3rd frame range to show sprite"
			spinner UI2_SFX2_3frameTo 		"to:"			align:#right fieldWidth:30 type:#integer range:[-1,511,-1] tooltip:"0based frame numbers\n3rd frame range to show sprite"
			spinner UI2_SFX2_4frameFrom 	"from:"			align:#left fieldWidth:30 type:#integer range:[-1,511,-1] across:2 tooltip:"0based frame numbers\n4th frame range to show sprite"
			spinner UI2_SFX2_4frameTo 		"to:"			align:#right fieldWidth:30 type:#integer range:[-1,511,-1] tooltip:"0based frame numbers\n4th frame range to show sprite"
			spinner UI2_SFX2_5frameFrom 	"from:"			align:#left fieldWidth:30 type:#integer range:[-1,511,-1] across:2 tooltip:"0based frame numbers\n5th frame range to show sprite"
			spinner UI2_SFX2_5frameTo 		"to:"			align:#right fieldWidth:30 type:#integer range:[-1,511,-1] tooltip:"0based frame numbers\n5th frame range to show sprite"
		)


		group "QDT Sprite Files"
		(
			button 	UI2_SFX2_ImportSFX "Import .qdt"	align:#centre height:32  tooltip:"Import .qdt sprite file" across:2
			--button 	UI2_SFX2_ExportSFX "Export"			align:#centre height:32 tooltip:"Save .qdt file to load later" --todo export
		)


		fn UI2_SFX_Type_selected iValue readVal=
		(
			local returnVal, idx = 1
			if readVal == true then
			(
				local tmpStr = sfx_1TypeArray[UI2_SFX_Type.selection]
				returnVal = (substring tmpStr 1 ((findstring tmpStr ":")-1)) as integer
				format "returnVal= %\n" returnVal
				return 	returnVal
			)
			else --set value UI used
			(
				local tmpStr = sfx_1TypeArray[iValue]
				sfx_01_Type[idx] = (substring tmpStr 1 ((findstring tmpStr ":")-1)) as integer
				format "returnVal= %\n" sfx_01_Type[idx]
			)
		)

		fn UI2_SFX_dir_selected iValue readVal=
		(
			local returnVal, idx = 1
			if readVal == true then
			(
				local tmpStr = sfx_3dirArray[UI2_SFX_dir.selection]
				returnVal = (substring tmpStr 1 ((findstring tmpStr ":")-1)) as integer
				format "returnVal=% intVal=%\n" returnVal ivalue
				return 	returnVal
			)
			else --set value. UI used
			(
				local tmpStr = sfx_3dirArray[iValue]
				returnVal = (substring tmpStr 1 ((findstring tmpStr ":")-1)) as integer
				format "returnVal=% intVal=%\n" returnVal ivalue
				sfx_03_dir[idx] = returnVal
			)
		)



		fn ImportUI_SFXSettings=
		(
			if UI2_SFX2_vertex.value < 1 then
			(
				sfx_numDefines = 0
				sfx_numEntry = 0
			)
			else
			(
				local idx = 1 -- getSFXIdx --todo not useable??

				sfx_numDefines = 1 -- UI2_SFX2_Count.value --todo not useable??
				sfx_numEntry = 1

				sfx_01_Type[idx] = UI2_SFX_Type_selected 0 true
				sfx_02_flags[idx] = UI2_SFX_Flags.value
				sfx_03_dir[idx] =  UI2_SFX_dir_selected 0 true
				sfx_04_speed[idx] = UI2_SFX_speed.value
				sfx_05_grav[idx] = UI2_SFX_grav.value
				sfx_06_msec[idx] = UI2_SFX_time.value
				sfx_07_rand[idx] = UI2_SFX_timeRan.value
				sfx_08_stAlpha[idx] = UI2_SFX_startAlp.value
				sfx_09_endAplha[idx] = UI2_SFX_endAlpha.value
				sfx_10_inTime[idx] = UI2_SFX_fadeIn.value
				sfx_11_lifeTime[idx] = UI2_SFX_life.value
				sfx_12_randScale[idx] = UI2_SFX_randScale.value
				sfx_13_stWidth[idx] = UI2_SFX_startW.value
				sfx_14_endWidth[idx] = UI2_SFX_endW.value
				sfx_15_stHeight[idx] = UI2_SFX_startH.value
				sfx_16_endHeight[idx] = UI2_SFX_endH.value
				sfx_17_randScale[idx] = UI2_SFX_randWH.value

				sfx_18_vert = UI2_SFX2_vertex.value
				sfx_19_define = 0 --todo: only use 1 def??
				sfx_20_type = 0 --todo:

				sfx_range1st = UI2_SFX2_1frameFrom.value; 	sfx_range1end= UI2_SFX2_1frameTo.value
				sfx_range2st= UI2_SFX2_2frameFrom.value;	sfx_range2end= UI2_SFX2_2frameTo.value
				sfx_range3st= UI2_SFX2_3frameFrom.value;	sfx_range3end= UI2_SFX2_3frameTo.value
				sfx_range4st= UI2_SFX2_4frameFrom.value;	sfx_range4end= UI2_SFX2_4frameTo.value
				sfx_range5st= UI2_SFX2_5frameFrom.value;	sfx_range5end= UI2_SFX2_5frameTo.value
				format "sfxtype=% dir=%\n" sfx_01_Type sfx_03_dir
				format "sfx_range1st=% sfx_range1end=%\n" sfx_range1st sfx_range1end

			)
		)


		fn uiMatchString1 iValue=
		(
			for i= 1 to sfx_1TypeArray.count do
			(
				local tmpNum = (substring sfx_1TypeArray[i] 1 ((findstring sfx_1TypeArray[i] ":")-1)) as integer
				if tmpNum == iValue then
					return i
			)
			print "=== Error in qdt 'SXF type' ==="
			return UI2_SFX_Type.selection -- keep same if error

		)
		fn uiMatchString3 iValue=
		(
			for i=1 to sfx_3dirArray.count do
			(
				local tmpNum = (substring sfx_3dirArray[i] 1 ((findstring sfx_3dirArray[i] ":")-1)) as integer
				if  tmpNum == iValue then
					return i
			)
			print "=== Error in qdt 'Direction' ==="
			return 	UI2_SFX_dir.selection
		)

		fn resetSFX_FromTo =
		(
			UI2_SFX2_1frameFrom.value = 0
			UI2_SFX2_1frameTo.value = 0
			UI2_SFX2_2frameFrom.value = -1
			UI2_SFX2_2frameTo.value = -1
			UI2_SFX2_3frameFrom.value = -1
			UI2_SFX2_3frameTo.value = -1
			UI2_SFX2_4frameFrom.value = -1
			UI2_SFX2_4frameTovalue = -1
			UI2_SFX2_5frameFrom.value = -1
			UI2_SFX2_5frameTo.value = -1
		)

		fn fn_SendFrames fFrom fTo &iCount=
		(
			local iFrom = fFrom as integer
			local iTo = fTo as integer

			if not iFrom == undefined then
			(
				if iCount == 1 then	UI2_SFX2_1frameFrom.value = iFrom
				if iCount == 2 then	UI2_SFX2_2frameFrom.value = iFrom
				if iCount == 3 then	UI2_SFX2_3frameFrom.value = iFrom
				if iCount == 4 then	UI2_SFX2_4frameFrom.value = iFrom
				if iCount == 5 then	UI2_SFX2_5frameFrom.value = iFrom
			)
			if not iTo == undefined then
			(
				if iCount == 1 then	UI2_SFX2_1frameTo.value = iTo
				if iCount == 2 then	UI2_SFX2_2frameTo.value = iTo
				if iCount == 3 then	UI2_SFX2_3frameTo.value = iTo
				if iCount == 4 then	UI2_SFX2_4frameTo.value = iTo
				if iCount == 5 then	UI2_SFX2_5frameTo.value = iTo
			)
			iCount +=1
		)


		local qdtLastfile_kp = "TEST.QDT"

		fn ImportQDTFile=
		(
			local qdtFile = undefined
			qdtFilename_kp=getOpenFileName  caption:"Save MD2" filename:qdtLastfile_kp types:"Kingpin .QDT (*.qdt)|*.qdt|Text File (*.txt)|*.txt|All Files (*.*)|*.*|"
			format "qdtFilename_kp=%\n" qdtFilename_kp

			if not qdtFilename_kp == undefined then
				qdtFile = openFile qdtFilename_kp mode:"r"

			if not qdtFile == undefined then
			(
				qdtLastfile_kp = qdtFilename_kp
				print"Found File"
				local sfxStart = 0
				local idxLine = 1

				local fileToSArray=#()

				while not EOF qdtFile do
				(
					--readToken  --peekToken
					local sline = readLine qdtFile
					local strLine = sline as stringStream
					local tokenStr = readToken strLine
					format "tokenStr= %\n" tokenStr

					--format "string=%\n" sline
					if not tokenStr == undefined then --null?
					(
						if sfxStart == 0 then
						(
							if (stricmp tokenStr "$sfx_define") == 0  then
							(
								sfxStart = 1; idxLine =1; print "found $sfx_define"
								continue
							)
							if (stricmp tokenStr  "$sfx_add") == 0  then
							(
								sfxStart = 2; idxLine =1; print "found $sfx_add"
								continue
							)
						)

						if sfxStart == 1 and idxLine <= 17 then --todo  17
						(
							local iValue

							if idxLine >=1 and idxLine <=6 then
								iValue = tokenStr as integer
							else
								iValue = tokenStr as float

							format "($sfx_define) idx=% value=%\n" idxLine iValue

							if not iValue == undefined then
							(
								if idxLine == 1 then  		UI2_SFX_Type.selection = uiMatchString1 iValue
								else if  idxLine == 2 then 	UI2_SFX_Flags.value = iValue
								else if  idxLine == 3 then 	UI2_SFX_dir.selection = uiMatchString3 iValue
								else if  idxLine == 4 then 	UI2_SFX_speed.value = iValue
								else if  idxLine == 5 then 	UI2_SFX_grav.value = iValue
								else if  idxLine == 6 then 	UI2_SFX_time.value = iValue
								else if  idxLine == 7 then 	UI2_SFX_timeRan.value = iValue
								else if  idxLine == 8 then 	UI2_SFX_startAlp.value = iValue
								else if  idxLine == 9 then 	UI2_SFX_endAlpha.value = iValue
								else if  idxLine == 10 then UI2_SFX_fadeIn.value = iValue
								else if  idxLine == 11 then UI2_SFX_life.value = iValue
								else if  idxLine == 12 then UI2_SFX_randScale.value = iValue
								else if  idxLine == 13 then UI2_SFX_startW.value = iValue
								else if  idxLine == 14 then UI2_SFX_endW.value = iValue
								else if  idxLine == 15 then UI2_SFX_startH.value = iValue
								else if  idxLine == 16 then UI2_SFX_endH.value = iValue
								else if  idxLine == 17 then (
									UI2_SFX_randWH.value = iValue
									sfxStart = 0 --the end!!!
								)
							)
						)
						else if sfxStart == 2 then
						(
							local iValue
							local idx (findstring sline "//")
							if not idx == undefined and idx > 1 then sline = (substring sline 1 idx)

							if idxLine >=1 and idxLine <=3 then
								iValue = sline as integer


							format "($sfx_define) idx=% value=%\n" idxLine iValue

							if  idxLine == 1 then			(if not iValue == undefined then UI2_SFX2_vertex.value = (iValue+1)) --0based in qdt. max 1based
							else if  idxLine == 2 then		sfx_19_define = 0
							else if  idxLine == 3 then		sfx_20_type = 0 -- 0=vert  todo: tri/face??
							else if  idxLine == 4 then
							(
								local  i, j=1
								local frameArray =#()
								resetSFX_FromTo()
								for i=1 to sline.count do
								(
									if (isSpace sline[i]) == false then
										frameArray[j] = sline[i] --add numbers or "-" char
									else
										j+=1 --space or tab
								)

								i = 1
								if frameArray.count >= 3 then --should be "1-1"
								(
									local iCount=1, fFrom, fTo

									do
									(
										if frameArray[i] == "-" then (
											fTo = frameArray[i+1]
											format "from=% to=%\n" fFrom fTo
											fn_SendFrames fFrom fTo &iCount
											i+=1 --skip next line
										)
										else
											fFrom = frameArray[i]

										i+=1
									) while (i <= frameArray.count and iCount <= 5 )
								)
								sfxStart = 0 --the end!!!
							)
						)
					)
					idxLine += 1
				)
				fclose qdtFile
				ImportUI_SFXSettings() --Done with file.. update the internal varables
			)
		)

		fn ExportQDTFile =
		(

		)

		-----------------------------------
		--complete UI interaction
		-----------------------------------
		on UI2_SFX_Type selected ival do UI2_SFX_Type_selected ival false
		on UI2_SFX_Flags changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_dir selected ival do UI2_SFX_dir_selected ival false
		on UI2_SFX_speed changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_grav changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_time changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_timeRan changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_startAlp changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_endAlpha changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_fadeIn changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_life changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_randScale changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_startW changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_endW changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_startH changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_endH changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX_randWH changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_vertex changed sValue spinr do if spinr == false then ImportUI_SFXSettings()

		on UI2_SFX2_1frameFrom changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_1frameTo changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_2frameFrom changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_2frameTo changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_3frameFrom changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_3frameTo changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_4frameFrom changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_4frameTo changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_5frameFrom changed sValue spinr do if spinr == false then ImportUI_SFXSettings()
		on UI2_SFX2_5frameTo changed sValue spinr do if spinr == false then ImportUI_SFXSettings()


		--on UI2_SFX_Type
		on UI2_SFX_Flags entered do ImportUI_SFXSettings()
		--on UI2_SFX_dir
		on UI2_SFX_speed entered do ImportUI_SFXSettings()
		on UI2_SFX_grav entered do ImportUI_SFXSettings()
		on UI2_SFX_time entered do ImportUI_SFXSettings()
		on UI2_SFX_timeRan entered do ImportUI_SFXSettings()
		on UI2_SFX_startAlp entered do ImportUI_SFXSettings()
		on UI2_SFX_endAlpha entered do ImportUI_SFXSettings()
		on UI2_SFX_fadeIn entered do ImportUI_SFXSettings()
		on UI2_SFX_life entered do ImportUI_SFXSettings()
		on UI2_SFX_randScale entered do ImportUI_SFXSettings()
		on UI2_SFX_startW entered do ImportUI_SFXSettings()
		on UI2_SFX_endW entered do ImportUI_SFXSettings()
		on UI2_SFX_startH entered do ImportUI_SFXSettings()
		on UI2_SFX_endH entered do ImportUI_SFXSettings()
		on UI2_SFX_randWH entered do ImportUI_SFXSettings()
		on UI2_SFX2_vertex entered do ImportUI_SFXSettings()

		on UI2_SFX2_1frameFrom entered do ImportUI_SFXSettings()
		on UI2_SFX2_1frameTo entered do ImportUI_SFXSettings()
		on UI2_SFX2_2frameFrom entered do ImportUI_SFXSettings()
		on UI2_SFX2_2frameTo entered do ImportUI_SFXSettings()
		on UI2_SFX2_3frameFrom entered do ImportUI_SFXSettings()
		on UI2_SFX2_3frameTo entered do ImportUI_SFXSettings()
		on UI2_SFX2_4frameFrom entered do ImportUI_SFXSettings()
		on UI2_SFX2_4frameTo entered do ImportUI_SFXSettings()
		on UI2_SFX2_5frameFrom entered do ImportUI_SFXSettings()
		on UI2_SFX2_5frameTo entered do ImportUI_SFXSettings()

		-- Import/export Button
		on UI2_SFX2_ImportSFX pressed do ImportQDTFile()
		on UI2_SFX2_ExportSFX pressed do ExportQDTFile()
	)


	on UI_btn_SFX pressed do
	(
		if rolloutOpen == true then (
			SFX.open = false
			rolloutOpen =false
		)
		else (
			addRollout SFX
			SFX.open = true
			rolloutOpen =true
		)
	)



	fn getUserTimeRange &timeStart &timeEnd isBake=
	(
		if UI_ckBox_save_ani.checked == false and isBake == false then
		(
			timeStart = currentTime.frame as Integer
			timeEnd = currentTime.frame  as Integer
		)
		else if UI_ckBox_use_TimeLine.checked == true then
		(
			timeStart = animationrange.start.frame as Integer
			timeEnd = animationrange.end.frame as Integer
		)
		else
		(	--use imput time
			timeStart = UI_spin_timeStart.value as Integer
			timeEnd = UI_spin_timeEnd.value as Integer
		)
	)


	fn BakeAnimatedModel weldVert splitSG combineMDL =
	(
		local end_task=false
		local aniStartIdx, aniEndIdx, targName, sourceObj, targetObj
		local vertSrc, vertTrg, _num_vertSrc, _num_vertTrg

		getUserTimeRange &aniStartIdx &aniEndIdx true

		--todo is mesh/poly?
		with redraw off
		try
		(
			--suspendEditing()
			progressStart "Bake Animation Frames"

			--get current tangent type (max 8+)
			maxops.getDefaultTangentType &inTangent &outTangent
			--set tangent to step { #smooth|#linear|#step|#fast|#slow|#custom|#flat }
			maxops.setDefaultTangentType #step #step


			local objArray=#()
			for o in $selection do
				append  objArray o

			--combine multiple selectred model into 1
			if combineMDL then
			(
				if objArray.count >=2 then
				(
					animate on
					(
						--create first object
						tmpMesh = snapshotAsMesh objArray[1] -- name:targName
						targetObj = (mesh mesh:tmpMesh)

						-- append
						for i = 2 to objArray.count do
						(
							tmpMesh = snapshotAsMesh objArray[i]
							meshop.attach targetObj tmpMesh
						)

						--animate the new mesh with old objects
						for f = aniStartIdx to aniEndIdx do
						(
							if (bit.and 3 f) !=0 then(
								progressUpdate (100.0 * f / aniEndIdx))

							end_task=getProgressCancel()

							if end_task == false then
							(
								at time f in coordsys world --currentTime.frame
								(
									local vertCntr = 0
									local aVertPos=#()
									local aVertIdx=#{}

									for sourceObj in objArray do
									(
										tmpMesh = snapshotAsMesh sourceObj

										for i=1 to tmpMesh.numVerts do
										(
											keyPos = getVert tmpMesh i
											append aVertPos keyPos
											append aVertIdx (vertCntr + i)
										)
										vertCntr += sourceObj.numVerts
									)
									meshop.setVert targetObj aVertIdx aVertPos
								)
							)
						)--> frame num
						tmpMesh = 0
					)
					--objArray=#()
					--append objArray	targetObj
					update targetObj
					select targetObj
				)
			)
			else
			(
				format "object count= %\n" objArray.count

				for sourceObj in objArray do
				(
					local refVertID=#()
					local  _num_edge, _num_vertTrg, _num_vertSrc
					print "001"
					targName = uniqueName (sourceObj.name + "_Baked_")

					--create clone
					 at time currentTime.frame in coordsys world
					(
						targetObj_Mesh = snapshotAsMesh sourceObj -- name:targName
						targetObj = mesh mesh:targetObj_Mesh
						targetObj.name = targName

						if not sourceObj.material == Undefined  then
							targetObj.material = sourceObj.material
					)

					if end_task == false then
					(
						if weldVert == true then
						(
							print "Weld duplicate vertex"
							convertTo targetObj Editable_poly
							tmpWeld = targetObj.weldThreshold
							targetObj.weldThreshold = 0.01
							polyop.weldVertsByThreshold targetObj #all
							targetObj.weldThreshold = tmpWeld
						)--end weld vertex

						if splitSG == True then
						(
							fn getSG sgroup_val =
							(
								local sg_bitarray=#{}
								if sgroup_val < 0 do
								(
									sg_bitarray[32]=true
									sgroup_val -= 2^31
								)
								for i = 1 to 31 do
								(
									sg_bitarray[i]= (mod sgroup_val 2 > .5)
									sgroup_val /= 2
								)
								sg_bitarray
							)

							local edgesToSplit=#()
							print "Split Edges at smoothgroup border"
							convertTo targetObj Editable_poly
							local _num_edge = polyOp.getNumEdges targetObj --targetObj.edges.count

							for edge = 1 to _num_edge do --edgeCount do
							(
								local sg1, sg2
								local tFaces = (polyop.getFacesUsingEdge targetObj #(edge)) as array
								if 	tFaces.count == 2 then
								(
									sg1 = (polyop.getFaceSmoothGroup targetObj  tFaces[1])
									sg2 = (polyop.getFaceSmoothGroup targetObj  tFaces[2])
									format "edge=% face1=% face2=% sg1=% sg2=% \n" edge tFaces[1] tFaces[2] sg1 sg2

									-- check for matching sg
									if sg1 !=0 and sg2 != 0 then
									(
										local isMatch = false
										local sg1A=(getSG sg1)
										local sg2A=(getSG sg2)


										for sgCnt=1 to 32 do
										(
											if (sg1A[sgCnt] == true ) and (sg2A[sgCnt] == true) then
												isMatch = true

											if (sgCnt == 32) and (isMatch == false) then
											(
												format "split=%\n" edge
												append edgesToSplit edge
											)
										)
									)
								)
							)
							polyop.splitEdges targetObj edgesToSplit
						)--end split

						convertToMesh targetObj

						if weldVert == true then --vertex can move after weld. this take special care to find best match
						(
							local dotvalue, vertIndex, maxdot
							at time currentTime.frame in coordsys world
							(
								sourceObj_Mesh = snapshotAsMesh  sourceObj

								_num_vertSrc = getNumVerts sourceObj_Mesh
								_num_vertTrg = getNumVerts targetObj
								for i = 1 to _num_vertTrg do
								(
									if (bit.and 3 i) !=0 then(
										progressUpdate (100.0 * i / _num_vertTrg))
									end_task=getProgressCancel()

									if end_task == false then
									(
										maxdot=99999.0
										vertTrg = getvert targetObj i
										for j=1 to _num_vertSrc do
										(
											vertSrc = getvert sourceObj_Mesh j
											dotvalue = distance vertSrc vertTrg
											if dotvalue<maxdot then
											(
												maxdot = dotvalue
												vertIndex=j
											)
										)
										append refVertID vertIndex
									)
								)
							)
						)
						else if splitSG == True  then --index count changed. match vertex.pos on old mesh
						(
							at time currentTime.frame in coordsys world
							(
								sourceObj_Mesh = snapshotAsMesh  sourceObj
								_num_vertSrc = getNumVerts sourceObj_Mesh
								_num_vertTrg = getNumVerts targetObj
								for i = 1 to _num_vertTrg do
								(
									vertTrg =  getvert targetObj i

									j = 0
									do(
										j+=1
										vertSrc = getvert sourceObj_Mesh j
										--format "i=% trg=% src=%\n" j	vertTrg	vertSrc
									) while (j < _num_vertSrc and not vertSrc == vertTrg) --todo findItem <array> <value> --<mesh>.verts
									append refVertID j
									--format "j=%\n" j
								)
							)
						)


						animate on
						(
							for t = aniStartIdx to aniEndIdx do
							(
								if end_task == false then
								(
									if (bit.and 3 t) !=0 then(
										progressUpdate (100.0 * t / aniEndIdx)
										end_task=getProgressCancel()
									)
									aVertPos=#()
									aVertIdx=#{}
									at time t in coordsys world
									(
										sourceObj_Mesh = snapshotAsMesh  sourceObj
										for i = 1 to targetObj.numVerts do
										(
											if splitSG == True or weldVert == true then
												keyPos = getVert sourceObj_Mesh refVertID[i]
											else
												keyPos = getVert sourceObj_Mesh i
											append aVertPos keyPos
											append aVertIdx i
										)
										meshop.setVert targetObj aVertIdx aVertPos
									)
								)
							)
						)
						update targetObj
						select targetObj
					)
				)--end selection
			)
			--set tangent back to default. linear? { #smooth | #linear | #step | #fast | #slow | #custom | #flat }
			maxops.setDefaultTangentType inTangent outTangent
			progressend()
			resumeEditing()
		)
		catch
		(
			print "error"
			maxops.setDefaultTangentType inTangent outTangent
			progressend()
			resumeEditing()
			throw()
		)
	)


	-- Unbelievably, doesFileExist doesn't work properly!
	-- Here's my replacement...
	fn doesMyKPFileExist fname=
	(
		local temp = fopen fname "rb"
		if temp != undefined then
		(
			fclose temp
			true
		)
		else
		(
			false
		)
	)


	fn makemd2_kp &objArray=
	(
		struct MD2_Tex
		(
			s,t,
			x,y --add hypov8 float for gl commands
		)

		struct MD2_Frame
		(
			scale, translate, name,
			vList,vNorm,
			vListFloat, --add hypov8 float for bbox/hitbox
			objID, 		--add hypov8 mdx object-id
			frameName
		)

		struct MD2_Tri
		(
			v1,v2,v3,				--vertIndices
			t1,t2,t3,				--texCoordIndices
			gl_vertInd,
			gl_textInd,
			objID					--mdx object-id
			--gl_v1, gl_v2, gl_v3, 	--hypov8 glcmd index.
			--gl_t1, gl_t2, gl_t3		--store triangles in original windings before calculating glComands
		)

		struct MD2_glcmd--add hypov8 glCommands
		(
			s, --s texture coord.
			t, --t texture coord.
			index --vertex index
		)
		struct MD2_glcmd_list
		(
			num, --tri count
			objID, --mdx object-id
			cmd_list
		)

		struct MD2_model
		(
			skinlist,
			texlist,
			trilist,
			framelist,
			glcmdlist,
			frameNameList,
			glcmd_num
		)


		-----------------------------------------------------------------------------------------------------
		-----------------------------------------------------------------------------------------------------
		md2=md2_model skinlist:#() texlist:#() trilist:#() framelist:#() glcmdlist:#()  frameNameList:#() glcmd_num:0
		-----------------------------------------------------------------------------------------------------
		-----------------------------------------------------------------------------------------------------

		--hypo textures list. get material name

		local modelTexName
		local modelIndex
		local skinError
		local fdslash = "/"
		local bkslash	= "\\"
		local mdlPath ="models/"
		local plyerPath ="players/"
		local aniStartIdx, aniEndIdx
		getUserTimeRange &aniStartIdx &aniEndIdx false
		format "time range (%, %)\n" aniStartIdx aniEndIdx

		--for o in $selection do append  objArray o

		--for obj in objArray do

		--for k=1 to objArray.count do

		------------------------------------
		-- build skins
		------------------------------------
		--hypov8 todo: should only be 1 skin per group items.
		--allow multi material to set consecitive skins
		for obj in objArray do	--for k = 1 to $selection.count do
		(
			skinError = 0
			addSkin = True
			if obj.material == Undefined  then
			(
				skinError = 1
				print "--> NO valid skin on model"
			)
			else if (stricmp (classof obj.material as string) "Standardmaterial") == 0 then
			(	--set folder path
				if (stricmp (classof obj.material.diffusemap as string) "Bitmaptexture")==0 then
				(
					--print ("--> skin index:  "+(k as string)+"\n" )
					print ("--> skin name:  " +(obj.material.diffusemap.filename as string)+"\n" )

					modelTexName = obj.material.diffusemap.filename
					try
					(
						img_with_kp = obj.material.diffusemap.bitmap.width --hypov8 todo: error on .pcx
						img_hight_kp = obj.material.diffusemap.bitmap.height
					)
					catch
					(
						skinError = 1
						if (stricmp (getFilenameType modelTexName) ".pcx") == 0 then
						(
							skinError = 2
							messagebox ("Error: Cannot read image dimensions in\n" + modelTexName + "\n\nExport using 256x256 image size")	title:"ERROR PCX Bitmaptexture"
						)
					)
					if img_with_kp == undefined or img_hight_kp == undefined  then
					(
						if skinError != 2 then
						(
							print "err1\n"
							skinError = 1
						)
					)

					if obj.material != undefined then
					(
						--print( "--> skin strip root <--")
						modelTexName = substituteString modelTexName bkslash fdslash --replace backSlash with forwardSlash
						modelIndex = findString modelTexName mdlPath					--find index to a folder named "models/"
						if modelIndex == undefined then
							modelIndex = findString modelTexName plyerPath
						if modelIndex == undefined then
							modelIndex = 1 --error in path name. use whole string

						if modelIndex < 1 then
							modelIndex = 1

						modelTexName = substring modelTexName modelIndex -1 	--rename  to mod path
						print ( "--> skin trunc: " +(modelTexName as string)+"\n")
					)
					else
					(
						skinError = 1
						print "err2\n"
					)
				)
				else
				(
					modelTexName = obj.material.name
					if modelTexName != undefined then
					(
						skinError = 1
						print "err1\n"
					)
				)
			)
			else
			(
				skinError = 1
			)

			format "error= % \n" skinError

			if skinError == 1 then
			(
				messagebox "Cannot find image for model\nUsing defaults\ntris.tga and 256px" title:"ERROR Bitmap Missing!!"
				modelTexName = "tris.tga"
				img_with_kp = 256
				img_hight_kp = 256
			)
			if skinError == 2 then
			(
				img_with_kp = 256
				img_hight_kp = 256
			)

			-- check duplicates
			for skin_ in md2.skinlist do
			(
				if (stricmp skin_ modelTexName) == 0 then
					addSkin = False
			)
			if addSkin then append md2.skinlist (toLower modelTexName)
		)
		-->end get material name

		------------------------------------
		-- build texture vert list
		------------------------------------
		for obj in objArray do --for k = 1 to $selection.count do
		(
			for i=1 to getnumtverts obj do
			(
				s=(((getTVert obj i).x)*img_with_kp) as integer
				t=((-(getTVert obj i).y+1)*img_hight_kp) as integer
				--float for glCmds
				x=((getTVert obj i).x) as float --hypov8 	glCmd
				y=((getTVert obj i).y) as float --hypov8	 glCmd

				append md2.texlist (md2_tex s:s t:t x:x y:y)
			)
		)
		-->end texture vert list

		------------------------------------
		-- build triangle list
		------------------------------------
		total_v = total_t = 0 --vertex total count
		objID = 0
		for obj in objArray do --for k = 1 to $selection.count do
		(
			local tmpV, temp = 0
			objID += 1 --mdx object-id

			for i=1 to obj.numfaces do
			(
				tmpV = getFace obj i
				v1=(tmpV.z)-1 --index
				v2=(tmpV.y)-1 --index
				v3=(tmpV.x)-1 --index

				if v1 > temp then temp = v1
				if v2 > temp then temp = v2
				if v3 > temp then temp = v3

				v1 = (v1 +total_v) as integer
				v2 = (v2 +total_v) as integer
				v3 = (v3 +total_v) as integer

				tmpV = getTVFace obj i
				t1=(tmpV.z)-1
				t2=(tmpV.y)-1
				t3=(tmpV.x)-1

				t1 = (t1 + total_t) as integer
				t2 = (t2 + total_t) as integer
				t3 = (t3 + total_t) as integer

				--glCommands
				gl_vertInd = [v1, v2, v3]
				gl_textInd = [t1, t2, t3]

				append md2.trilist (MD2_Tri v1 v2 v3 t1 t2 t3 gl_vertInd gl_textInd objID)

				if i == obj.numfaces then
				(	--add group counts to vertex numbers
					total_v = total_v + temp + 1
					total_t += getnumtverts obj -- total_t + temp2 + 1
				)
			)
		)

		-------------------------------------
		-- build framename list
		-------------------------------------
		framenamelist_kp=#()
		frameNamelist_Range=#()
		format "str cnt=%\n" UI_eTex_frameFile.text.count
		if UI_eTex_frameFile.text.count > 0 then
		(
			local file = openFile UI_eTex_frameFile.text mode:"r"
			local lineNum = 1
			local fIndex = 1 --frame index

			if not file == undefined then
			(
				while not EOF file do
				(
					local strTmp = readLine file
					if (findString strTmp ",") == undefined then --missing "," delimiter
					(
							print ("--> using line name= " +strTmp)
							append framenamelist_kp strTmp
					)
					else --found token. use < frame x > to < frame x > and < name >
					(
						local lineDelim = filterString strTmp ","
						if lineDelim.count < 3 then
						(
							messagebox ("ERROR in frame file. missing ',' in line " + lineNum as string)
						)
						else
						(
							local framefrom = lineDelim[1] as integer
							local frameto = lineDelim[2] as integer
							local frameName = lineDelim[3] as string
							local counter = 1
							for i = frameFrom to frameTo do
							(
								append framenamelist_kp (frameName+"_" +counter as string) --"aniName_1" "aniName_2"
								counter += 1
							)
						)
					)
				)
				close file
			)
		)


		-------------------------------------
		-- build frame list
		-------------------------------------
		--local frameindex = aniStartIdx as integer + 1
		local end_task=false-- getProgressCancel()
		local fCount =0
		progressStart "Calculating Frames"
		format "--= start=% end=%\n" aniStartIdx aniEndIdx


		fn roundVertPos vPos scale =
		(
			vPos.x = ((vPos.x / scale.x) + 0.5) as integer
			vPos.y = ((vPos.y / scale.y) + 0.5) as integer
			vPos.z = ((vPos.z / scale.z) + 0.5) as integer
		)


		for f = aniStartIdx to aniEndIdx by 1 do --by UI_frame_steps.value do
		(
			fCount += 1

			if end_task == false then
			(
				local vertlist=#()
				local vertlistFloats=#() --add hypov8 bbox/hitbox calculation
				local normlist=#()
				local objectID=#() -- add hypov7 mdx object-id
				local fName=""
				local vmin=[9999,9999,9999] --hypo todo: ok?? not all models touch centre
				local vmax=[-9999,-9999,-9999]

				progressUpdate (100.0*f/aniEndIdx)
				end_task=getProgressCancel()


				if fCount <= framenamelist_kp.count then
					fName = framenamelist_kp[fCount]
				else
					fName = "FRAME_" + (fCount) as string

				fName = substring fName 1 16 --hypov8 todo: check 16

				frame = MD2_frame scale:[1,1,1] translate:[0,0,0] name:fName

				-- PPM. test listbox for valid models
				local validListbox = true
				for arrayMDL in UI_lbox_PPM.items do
				(
					local	objMDL = getNodeByName arrayMDL
					if objMDL == undefined	then --hypo todo: mesh?
					(
						validListbox = false
						exit
					)
				)

				--local test1 =false
				--if test1 == true then
				if end_task == false then
				(
					--print("using multi models= "+(UI_ckBox_PPM.state as string))
					--hypo models with multilpe parts are going out of alignment at the seams. Calculating bbox size for complet model
					if UI_ckBox_PPM.checked == true and UI_lbox_PPM.items.count >= 2 and validListbox == True then --must have 2 or more
					(
						--print("using multi models")
						for arrayMDL in UI_lbox_PPM.items do
						(
							obj = getNodeByName arrayMDL
							for i=1 to obj.numverts do at time f
							(
								local v=in coordsys world(getvert obj i)
								if v.x<vmin.x then vmin.x=v.x
								if v.y<vmin.y then vmin.y=v.y
								if v.z<vmin.z then vmin.z=v.z
								if v.x>vmax.x then vmax.x=v.x
								if v.y>vmax.y then vmax.y=v.y
								if v.z>vmax.z then vmax.z=v.z
							)
						)
					)
					else
					(
						for obj in objArray do --for k = 1 to $selection.count do
						(
							for i=1 to obj.numverts do at time f
							(
								local v=in coordsys world(getvert obj i)
								if v.x<vmin.x then vmin.x=v.x
								if v.y<vmin.y then vmin.y=v.y
								if v.z<vmin.z then vmin.z=v.z
								if v.x>vmax.x then vmax.x=v.x
								if v.y>vmax.y then vmax.y=v.y
								if v.z>vmax.z then vmax.z=v.z
							)
						)
					)
					--print "vertex min/max"
				)
				--print "vertex min/max DONE"

				frame.translate=vmin
				frame.scale=(vmax-vmin)/[255,255,255]

				objID = 0
				for obj in objArray do --for k = 1 to $selection.count do
				(--obj =at time currentTime.frame in coordsys world snapshotAsMesh sourceObj
					objID += 1
					if end_task == false then
					at time f
					(
						for i=1 to obj.numverts do
						(
							local maxdot=0.000
							local normindex=6, dotvalue
							local v = in coordsys world  getvert obj i
							local vn = in coordsys world getnormal obj i
							append vertlistFloats v	--add hypov8 bbox/hitbox

							v-=frame.translate
							--v/=frame.scale
							roundVertPos v frame.scale
							append vertlist v

							------------------------------------
							--do normals
							------------------------------------
							-- rotate normals if model is for first person
							if UI_ckBox_1stPerson.checked == true then
							(
								--rm = rotateZMatrix -135
								--rm += rotateYMatrix 135
								rm = rotateYMatrix 180
								--rm += rotateXMatrix -90
								vn *= rm
								vn = normalize vn
							)

							idxCnt = nlist_kp.count
							j=0
							do(
								j+=1
								dotvalue = dot nlist_kp[j] vn
								if dotvalue > maxdot then
								(
									maxdot=dotvalue
									normindex=j
								)

							) while (j < idxCnt and dotvalue < 0.999 ) --stop looking if close enough

							append normlist (normindex-1) -- hypov8 add -1
							append objectID objID
						)
					)
				)
				frame.vList = vertlist
				frame.vListFloat = vertlistFloats	--add hypov8 bbox/hitbox
				frame.vNorm = normlist
				frame.objID = objectID
				append md2.framelist frame
			)
		)
		--progressEnd()

		------------------------------------
		-- build glcmdlist (note useing quark python method)
		------------------------------------
		progressStart "Calculating glCommands"

		--######################################################
		--# Tri-Strip/Tri-Fan functions
		--######################################################
		fn find_strip_length md2_trilist start_tri start_vert glCmd_tris glCmd_vert glCmd_text glCmd_used md2_texlist =
		(
			--return 0 --debug
			local strip_count = 1
			local tri_max = md2_trilist.count
			local m1, m2, u1, u2
			glCmd_used[start_tri] = 2
			glCmd_tris[1] = start_tri
			--look for matching triangle
			check = start_tri + 1

			-- store first tri + texture
			glCmd_vert[1] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+0) 3)+1]
			glCmd_vert[2] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+1) 3)+1]
			glCmd_vert[3] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+2) 3)+1]
			glCmd_text[1] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+0) 3)+1]
			glCmd_text[2] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+1) 3)+1]
			glCmd_text[3] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+2) 3)+1]
			-- tmp store last 2 verts for compare
			m1 = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+2) 3)+1]
			m2 = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+1) 3)+1]
			u1 = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+2) 3)+1]
			u2 = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+1) 3)+1]

			tri_counter = start_tri + 1
			while tri_counter <= tri_max do
			(
				if md2_trilist[tri_counter].objID == md2_trilist[start_tri].objID then
				for k=1 to 3 do --loop through the 3 side of current triangle. looking 4 match
				(
					uvID1 = md2_trilist[tri_counter].gl_textInd[int(mod (k+0) 3)+1]
					uvID2 = md2_trilist[tri_counter].gl_textInd[int(mod (k+1) 3)+1]
					if 	md2_trilist[tri_counter].gl_vertInd[int(mod (k+0) 3)+1] == m1 and
						md2_trilist[tri_counter].gl_vertInd[int(mod (k+1) 3)+1] == m2 and
						md2_texlist[uvID1+1].x == md2_texlist[u1+1].x and
						md2_texlist[uvID1+1].y == md2_texlist[u1+1].y and
						md2_texlist[uvID2+1].x == md2_texlist[u2+1].x and
						md2_texlist[uvID2+1].y == md2_texlist[u2+1].y then
					(
						--found match. if in use. exit loop. todo: speed test if removed
						if (glCmd_used[tri_counter] == 0) then
						(
							if  (mod strip_count 2) == 1 then(   -- is this an odd tri
								m2 = md2_trilist[tri_counter].gl_vertInd[int(mod (k+2) 3)+1]
								u2 = md2_trilist[tri_counter].gl_textInd[int(mod (k+2) 3)+1]
							)
							else(
								m1 = md2_trilist[tri_counter].gl_vertInd[int(mod (k+2) 3)+1]
								u1 = md2_trilist[tri_counter].gl_textInd[int(mod (k+2) 3)+1]
							)

							glCmd_vert[strip_count+3 ]= md2_trilist[tri_counter].gl_vertInd[int(mod (k+2) 3)+1]
							glCmd_text[strip_count+3] =	md2_trilist[tri_counter].gl_textInd[int(mod (k+2) 3)+1]
							glCmd_tris[strip_count+1] = tri_counter

							strip_count += 1
							glCmd_used[tri_counter] = 2

							tri_counter = start_tri -- go back to start tri
						)
					)
				)
				tri_counter += 1 --next tri
			)
			-- free all tempory tri
			for clear_counter=start_tri to tri_max do --ok? was +1
			(	if glCmd_used[clear_counter] == 2 then
					glCmd_used[clear_counter] = 0
			)
			strip_count --return
		)

		fn find_fan_length md2_trilist start_tri start_vert glCmd_tris glCmd_vert glCmd_text glCmd_used md2_texlist =
		(
			--return 0 --debug
			--print ("-= fan0 Start=-")
			local fan_count =1
			local tri_max= md2_trilist.count
			local m1, m2, u1, u2, finished_tri
			glCmd_used[start_tri]=2
			glCmd_tris[1] = start_tri --temp store triangle used array

			-- hypov8 note vertex are stored in reverse order
			glCmd_vert[1] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+0) 3)+1]
			glCmd_vert[2] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+2) 3)+1]
			glCmd_vert[3] = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+1) 3)+1]
			glCmd_text[1] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+0) 3)+1]
			glCmd_text[2] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+2) 3)+1]
			glCmd_text[3] = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+1) 3)+1]

			m2 = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+0) 3)+1]
			m1 = md2_trilist[start_tri].gl_vertInd[int(mod (start_vert+1) 3)+1]
			u2 = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+0) 3)+1]
			u1 = md2_trilist[start_tri].gl_textInd[int(mod (start_vert+1) 3)+1]

			tri_counter = start_tri + 1
			while tri_counter <= tri_max do
			(
				if md2_trilist[tri_counter].objID == md2_trilist[start_tri].objID then
				for k=1 to 3 do --loop through the 3 side of current triangle. looking 4 match
				(
					uvID1 = md2_trilist[tri_counter].gl_textInd[int(mod (k+0) 3)+1]
					uvID2 = md2_trilist[tri_counter].gl_textInd[int(mod (k+1) 3)+1]
					if 	md2_trilist[tri_counter].gl_vertInd[int(mod (k+0) 3)+1] == m1 and
						md2_trilist[tri_counter].gl_vertInd[int(mod (k+1) 3)+1] == m2 and
						md2_texlist[uvID1+1].x == md2_texlist[u1+1].x and
						md2_texlist[uvID1+1].y == md2_texlist[u1+1].y and
						md2_texlist[uvID2+1].x == md2_texlist[u2+1].x and
						md2_texlist[uvID2+1].y == md2_texlist[u2+1].y then
					(
						--found match. if in use. exit loop. todo: speed test of removed
						if (glCmd_used[tri_counter] == 0) then
						(
							m1 = md2_trilist[tri_counter].gl_vertInd[int(mod (k +2) 3)+1]
							u1 = md2_trilist[tri_counter].gl_textInd[int(mod (k +2) 3)+1]

							glCmd_vert[fan_count +3] = md2_trilist[tri_counter].gl_vertInd[int(mod (k +2) 3)+1]
							glCmd_text[fan_count +3] = md2_trilist[tri_counter].gl_textInd[int(mod (k +2) 3)+1]
							glCmd_tris[fan_count +1] = tri_counter

							fan_count += 1
							glCmd_used[tri_counter] = 2

							tri_counter = start_tri -- go back to start tri
						)
					)
				)
				tri_counter += 1
			)

			-- free all tempory tri
			for clear_counter=start_tri to tri_max do --ok? was +1
			(	if glCmd_used[clear_counter] == 2 then
					glCmd_used[clear_counter] = 0
			)
			fan_count
		)

		------------------------------------
		-- build glcmdlist (note useing quark python method)
		------------------------------------
		(
			--variables
			local num_commands=0 --add up byte pool for writing model
			local fan_length=strip_length=0
			local best_type=0
			local best_vert = #()
			local best_st = #()
			local best_tris = #()
			local s=0.0
			local t=0.0
			local time_int = timeStamp()
			local total_tri_count=md2.trilist.count

			--variables shared between fan and strip functions
			local glCmd_tris = #()
			local glCmd_vert=#()
			local glCmd_text=#()
			local glCmd_used=#()

			glCmd_tris[MAX_TRI]=0
			glCmd_vert[MAX_VERT]=0
			glCmd_text[MAX_VERT]=0
			best_vert[MAX_VERT]=0
			best_st[MAX_VERT]=0
			best_tris[MAX_TRI]=0
			glCmd_used[total_tri_count]=0

			--setup default vale's for arrays
			for i=1 to MAX_VERT do(	glCmd_vert[i]=0 ;glCmd_text[i]=0 ;best_vert[i]=0 ;best_st[i]=0 )
			for i=1 to MAX_TRI do(	glCmd_tris[i]=0; best_tris[i]=0	)
			for i=1 to total_tri_count do( glCmd_used[i]=0 )

			for face_counter = 1 to	total_tri_count do
			(
				objID = md2.trilist[face_counter].objID
				--time_int = timeStamp()
				--format "timestamp1: #% face: #%\n" (timeStamp() - time_int) face_counter
				if end_task == false then
				(
					if (bit.and 10 face_counter) !=0 then	(
						progressUpdate (100.0*face_counter/total_tri_count)
						end_task=getProgressCancel()
					)

					if glCmd_used[face_counter]!=1 then
					(
						local best_length=0

						--loop through each vertex of the face
						for start_vert=1 to 3 do
						(
							--strip_length=0
							strip_length = find_strip_length md2.trilist face_counter start_vert glCmd_tris glCmd_vert glCmd_text glCmd_used md2.texlist --do fn
							if (strip_length > best_length) then
							(
								best_type=0
								best_length=strip_length
								for index=1 to (best_length+2) do(
									best_st[index]=glCmd_text[index]
									best_vert[index]=glCmd_vert[index]
								)
								for index=1 to (best_length) do
									best_tris[index]=glCmd_tris[index]
							)
							--fan_length =0
							fan_length = find_fan_length md2.trilist face_counter start_vert glCmd_tris glCmd_vert glCmd_text glCmd_used md2.texlist --do fn
							if (fan_length > best_length) then
							(
								best_type = 1
								best_length=fan_length
								for index = 1 to best_length+2 do(
									best_st[index]=glCmd_text[index]
									best_vert[index]=glCmd_vert[index]
								)
								for index = 1 to (best_length) do
									best_tris[index] = glCmd_tris[index]
							)
						)

						for used_counter = 1 to (best_length) do
							glCmd_used[best_tris[used_counter]] = 1

						local num = 0
						if best_type == 1 then --fan
							num = (-(best_length + 2))
						else --strip
							num = best_length + 2

						num_commands += 1	 --add fantype to byte pool

						if isMDX == true then num_commands +=1 --hypov8 add group number to byte pool

						local temp_cmdlist = MD2_glcmd_list num:num objID:objID cmd_list:#()
						for command_counter = 1 to (best_length + 2) do
						(
							local index=best_st[command_counter]
							s=md2.texlist[index+1].x --hypov8 add+1 q2 uses vIndex0
							t=(1-md2.texlist[index+1].y)  --invert V
							append temp_cmdlist.cmd_list(MD2_glcmd s:s t:t index:best_vert[command_counter])
							num_commands+=3
						)
						append md2.glcmdlist temp_cmdlist --) (MD2_glcmd_list
					)
				)
				--format "timestamp5: #% face: #%\n" (timeStamp() - time_int) face_counter
			)	--end of triangle list

			--Done. insert blank record (end)
			num_commands+=1 --fan type 0
			if isMDX == true then num_commands +=1 --hypov8 objectnumber
			append md2.glcmdlist (MD2_glcmd_list num:0 objID:0 cmd_list:0)
			num_commands+=3 --S T Idx
			md2.glcmd_num = num_commands
			format "numGLCommands=%" num_commands
		)


		progressEnd()

		md2
	)

	----------------------------------
	-- write md2
	----------------------------------
	fn WriteMD2_kp md2file=
	(
		local objArray=#()

		for o in $selection do
		(
			if (classof o)!=editable_mesh then
				return "Object is not a mesh"
			append  objArray o
		)

		if objArray.count < 1 then return"No object selected"

		--for obj in objArray do

		--for k=1 to objArray.count do


		--process the objects into uable data
		model=MakeMD2_kp &objArray

		print("begin: open file")
		f=fopen md2file "wb"

		try
		(
		----------------------------------------
		-- write the header
		----------------------------------------
		if isMDX == False then
		(
			magic=844121161
			version=8
			skinw=img_with_kp
			skinh=img_hight_kp
			framenum=model.framelist.count
			skinnum=model.skinlist.count
			print( "skinn count= " +(model.skinlist.count as string))

			vertnum=model.framelist[1].vlist.count
			texnum=model.texlist.count
			trinum=model.trilist.count
			glnum=model.glcmd_num --model.glcmdlist.count
			texsize=4
			trisize=12
			framesize=40+(4*vertnum)

			headersize=68				-- bytes in header
			offsetskins=headersize
			offsettexcoords=offsetskins+(skinnum*64)
			offsettris=offsettexcoords+(texnum*texsize)
			offsetframes=offsettris+(trinum*trisize)
			offsetgl=offsetframes+(framenum*framesize)
			offsetend=offsetgl+(glnum*4) --hypov8 add last zero..


			print("write headder")
			writelong f magic
			writelong f version
			writelong f skinw				--[kp dont care]
			writelong f skinh				--[kp dont care]
			writelong f framesize
			writelong f skinnum
			writelong f vertnum

			writelong f texnum
			writelong f trinum
			writelong f glnum  --36 offset
			writelong f framenum
			writelong f offsetskins		--offset to skins
			writelong f offsettexcoords	--offset to texture coords
			writelong f offsettris		--offset to triangles
			writelong f offsetframes		--offset to frames
			writelong f offsetgl			--offset to gl commands
			writelong f offsetend			--offset to end --64 offset
		)
		else
		(
			magic=1481655369
			version=4
			skinw=img_with_kp
			skinh=img_hight_kp
			framesize=40+(4*model.framelist[1].vlist.count)
			skinnum=model.skinlist.count;print( "skinn count= " +(model.skinlist.count as string))
			vertnum=model.framelist[1].vlist.count
			--texnum=model.texlist.count
			trinum=model.trilist.count
			glnum=model.glcmd_num --model.glcmdlist.count
			framenum=model.framelist.count
			numSfxDefines =	sfx_numDefines
			numSfxEntries =	sfx_numEntry
			numSubObjects = objArray.count --1 --todo


			headersize=(23*4) --92				-- bytes in header
			offsetskins=headersize
			--offsettexcoords=offsetskins+(skinnum*64)
			offsettris=offsetskins+(skinnum*64)
			offsetframes=offsettris+(trinum*12) --short x y z t1 t2 t3
			offsetgl=offsetframes+(framenum*framesize)
			offsetVertexInfo=offsetgl+(glnum*4) --hypov8 add object number
			offsetSfxDefines=offsetVertexInfo+(vertnum*4) --verts containing group num
			offsetSfxEntries=offsetSfxDefines+(numSfxDefines* (17 * 4))
			offsetBBoxFrames=offsetSfxEntries+(numSfxEntries* (3 * 4))+(numSfxEntries * 64) -- 64char
			offsetDummyEnd=offsetBBoxFrames+(framenum * numSubObjects*24) --[6vert * 4bytes] todo subobjects
			offsetend=offsetDummyEnd

			format "offsettrisH=%\n" (bit.intAsHex offsettris)
			format "offsetframes=%\n" (bit.intAsHex offsetframes)
			format "offsetgl=%\n" (bit.intAsHex offsetgl)
			format "offsetVertexInfo=%\n" (bit.intAsHex offsetVertexInfo)
			format "offsetSfxDefines=%\n" (bit.intAsHex offsetSfxDefines)
			format "offsetSfxEntries=%\n" (bit.intAsHex offsetSfxEntries)

			format "offsetFrameCount=====%\n" (bit.intAsHex (offsetSfxEntries+12))

			format "offsetBBoxFrames=%\n" (bit.intAsHex offsetBBoxFrames)


			print("write headder")
			writelong f magic		--4
			writelong f version		--8
			writelong f skinw		--12
			writelong f skinh		--16
			writelong f framesize	--20
			writelong f skinnum		--24
			writelong f vertnum		--28
			writelong f trinum		--32
			writelong f glnum  		--36 offset
			writelong f framenum		--40
			writelong f numSfxDefines	--44
			writelong f numSfxEntries	--48
			writelong f numSubObjects	--52

			writelong f offsetskins		--56 offset to skins
			writelong f offsettris		--60 offset to triangles
			writelong f offsetframes	--64 offset to frames
			writelong f offsetgl		--68 offset to gl commands

			writelong f offsetVertexInfo	--72
			writelong f	offsetSfxDefines	--76
			writelong f	offsetSfxEntries	--80
			writelong f	offsetBBoxFrames	--84
			writelong f	offsetDummyEnd		--88
			writelong f offsetend			--offset to end --92 offset

		)
		-----------------------------------------------------
		-- end of header
		-----------------------------------------------------

		-----------------------------------------------------
		-- write out the skin names
		-----------------------------------------------------
		print("write out the skin names")
		for i in model.skinlist do
		(
			local index = 1
			skinname=i
			if 	skinname.count >64 then	MessageBox("Skin name is to long. 64 char's is maximum allowed.\n\nSkin index = " +(index as string) +"\nSkin char count = " +(skinname.count as string) +"\nSkin name = "+skinname) title:"Error: Skin Name"

			for k=1 to 64 do
			(
				if k > skinname.count then
					writebyte f 0 --add NULL
				else
					writebyte f (bit.charAsInt skinname[k])
			)
			index += 1
		)


		-----------------------------------------------------
		-- write texture coordinate list
		-----------------------------------------------------
		if isMDX == False then
		(
			print("write texture coordinate list")
			for i in model.texlist do
			(
				writeshort f i.s #unsigned
				writeshort f i.t #unsigned
			)
		)
		-----------------------------------------------------
		--write triangles
		-----------------------------------------------------
		print("write triangles")
		for i in model.trilist do
		(
			--format "--vert=%\n" i.v1
			writeshort f i.v1 #unsigned
			writeshort f i.v2 #unsigned
			writeshort f i.v3 #unsigned
			writeshort f i.t1 #unsigned
			writeshort f i.t2 #unsigned
			writeshort f i.t3 #unsigned
		)

		-----------------------------------------------------
		-- write frames
		-----------------------------------------------------
		print("write frames")
		for i in model.framelist do
		(
			writefloat f i.scale.x
			writefloat f i.scale.y
			writefloat f i.scale.z
			writefloat f i.translate.x
			writefloat f i.translate.y
			writefloat f i.translate.z
			writestring f i.name
			for l = 1 to (16 - i.name.count) - 1 do
			(
				writestring f ""
			)
			k=0
			for j=1 to i.vlist.count do
			(
				writebyte f i.vlist[j].x
				writebyte f i.vlist[j].y
				writebyte f i.vlist[j].z
				writebyte f i.vNorm[j]
			)
		)

		-----------------------------------------------------
		-- write glcmds --add hypov8
		-----------------------------------------------------
		print("write glcmds")
		--if UI_glCommands.state then
		(
			for i in model.glcmdlist do
			(
				writelong f i.num --write gl cmd strip/fan count

				if isMDX == true then
					writelong f i.objID #unsigned --object number hypov8 todo: objects??

				if i.num > 0 then -- write strip
				(
					for j = 1 to i.num do
					(
						writefloat f i.cmd_list[j].s
						writefloat f i.cmd_list[j].t
						writelong f i.cmd_list[j].index
					)
				)
				else if  i.num < 0 then --write fan.
				(
					writefloat f i.cmd_list[1].s
					writefloat f i.cmd_list[1].t
					writelong f i.cmd_list[1].index

					for j = i.cmd_list.count to 2 by -1 do --reverse fan windings
					(
						writefloat f i.cmd_list[j].s
						writefloat f i.cmd_list[j].t
						writelong f i.cmd_list[j].index
					)
				)
				else --must be 0
				(	--null last object
					writefloat f 0.0
					writefloat f 0.0
					writelong f 0
					print "end glCmds"
				)
			)
		)

		-----------------------------------------------------
		-- write vertexInfo --add hypov8
		-----------------------------------------------------
		print("write MDX")
		if isMDX == true then
		(
			--offsetVertexInfo		--todo groups
			for i = 1 to model.framelist[1].vlist.count do
			(
				bit_ =  bit.shift 1 (model.framelist[1].objID[i]-1)
				writelong f bit_ --1 --object1
			)

			format "--======sfx_numDefines=%\n" sfx_numDefines

			--todo groups!!!
			if sfx_numDefines >= 1 then
			(
				--offsetSfxDefines
				for iSfx = 1 to sfx_numDefines	do
				(
					writelong f sfx_01_Type[iSfx]
					writelong f sfx_02_flags[iSfx]
					writelong f sfx_03_dir[iSfx]
					writelong f sfx_04_speed[iSfx]
					writelong f sfx_05_grav[iSfx]
					writelong f sfx_06_msec[iSfx]
					writefloat f sfx_07_rand[iSfx]
					writefloat f sfx_08_stAlpha[iSfx]
					writefloat f sfx_09_endAplha[iSfx]
					writefloat f sfx_10_inTime[iSfx]
					writefloat f sfx_11_lifeTime[iSfx]
					writefloat f sfx_12_randScale[iSfx]
					writefloat f sfx_13_stWidth[iSfx]
					writefloat f sfx_14_endWidth[iSfx]
					writefloat f sfx_15_stHeight[iSfx]
					writefloat f sfx_16_endHeight[iSfx]
					writefloat f sfx_17_randScale[iSfx]
				)

				--offsetSfxEntries
				writelong f (sfx_18_vert-1)
				writelong f sfx_19_define
				writelong f sfx_20_type

				local arrayrameID=#()
				for i=1 to 512 do arrayrameID[i]= 0 --0 to 511

				for i= sfx_range1st to sfx_range1end do arrayrameID[i+1]= 1

				if 	sfx_range2st >-1 and  sfx_range2end >-1 then
				for i= sfx_range2st to sfx_range2end do arrayrameID[i+1]= 1

				if 	sfx_range3st >-1 and  sfx_range3end >-1 then
				for i= sfx_range3st to sfx_range3end do arrayrameID[i+1]= 1

				if 	sfx_range4st >-1 and  sfx_range4end >-1 then
				for i= sfx_range4st to sfx_range4end do arrayrameID[i+1]= 1

				if 	sfx_range5st >-1 and  sfx_range5end >-1 then
				for i= sfx_range5st to sfx_range5end do arrayrameID[i+1]= 1
					format "aframes=%\n"  arrayrameID

				local j=0 --count 512 frames
				for i=1 to 64 do
				(
					local tmpByte1=0
					local flip = 7 --reverse.

					for k=1 to 8 do
					(
						if arrayrameID[j+k] == 1 then
						(
							tmpByte1 += bit.shift 1 (flip)
						)
						flip -=1
					)
					j+=8
					writebyte f tmpByte1
				)
			)


			--offsetBBoxFrames;			--todo: groups
			for obj_id = 1 to objArray.count do --count
			(
				for i = 1 to model.framelist.count do --per frame
				(
					local vmin=[9999,9999,9999]
					local vmax=[-9999,-9999,-9999]

					for j = 1 to model.framelist[i].vListFloat.count do --per vertex
					(
						--only add verts that match id
						if model.framelist[i].objID[j] == obj_id then
						(
							local v=model.framelist[i].vListFloat[j]
							--format "vert=%\n" v

							if v.x<vmin.x then vmin.x=v.x
							if v.y<vmin.y then vmin.y=v.y
							if v.z<vmin.z then vmin.z=v.z

							if v.x>vmax.x then vmax.x=v.x
							if v.y>vmax.y then vmax.y=v.y
							if v.z>vmax.z then vmax.z=v.z
						)
					)
					--writelong  f i --write frame num??
					writefloat  f vmin.x
					writefloat  f vmin.y
					writefloat  f vmin.z

					writefloat  f vmax.x
					writefloat  f vmax.y
					writefloat  f vmax.z
				)
			)


			--offsetDummyEnd;
			--WriteString   f "hypo"
		)

		------------------------------------------------------
		-- end of file writing
		------------------------------------------------------

		fclose f
		--MessageBox("Export Done!!") --todo re'enable
		)
	catch --hypov8 todo re'enable
		(
			fclose f --closes file
			MessageBox("--= ERROR: Export invalid =--\nSee log \n")
			throw() --hypov8 terminate the program. closes file first
		)
	)
	-->end write md2


	----------------------------------
	-- local functions
	----------------------------------
	fn md2_addcheck_kp cb=
	(
		if classof cb==string then messagebox cb title:"MD2 Export Error"
	)


	----------------------------------
	-- startup defaults
	----------------------------------
	on MD2Export_KP open do
	(
		UI_eTex_frameFile.enabled = false
		UI_ckBox_use_TimeLine.enabled = false
		UI_btn_frameFile.enabled = false
		UI_spin_timeStart.enabled = false
		UI_spin_timeEnd.enabled = false
		UI_lbox_PPM.enabled = false
		--addRollout SFX
	)	-- on MD2Export_KP open do

	on MD2Export_KP close do
	(
		removeRollout SFX
	)
	----------------------------------
	-- ui state change events
	----------------------------------
	on UI_ckBox_PPM  changed state do
	(
		if state ==  true then
			UI_ckBox_1stPerson.checked = false

	)
	on UI_ckBox_1stPerson changed state do
	(
			if state ==  true then
			UI_ckBox_PPM.checked = false
	)

	on UI_ckBox_use_TimeLine changed state do
	(
		if state == true then
		(
			UI_spin_timeStart.enabled = false
			UI_spin_timeEnd.enabled = false
		)
		else
		(
			UI_spin_timeStart.enabled = true
			UI_spin_timeEnd.enabled = true
		)
	)


	on UI_ckBox_save_ani changed enablAni do
	(
		if enablAni == true then
		(
			UI_ckBox_use_TimeLine.enabled = true
			UI_btn_frameFile.enabled = true

			if UI_ckBox_use_TimeLine.checked == true then
			(
				UI_spin_timeStart.enabled = false
				UI_spin_timeEnd.enabled = false
			)
			else
			(
				UI_spin_timeStart.enabled = true
				UI_spin_timeEnd.enabled = true
			)
		)
		else --disable animation
		(
			UI_ckBox_use_TimeLine.enabled = false
			UI_btn_frameFile.enabled = false
			UI_spin_timeStart.enabled = false
			UI_spin_timeEnd.enabled = false
		)
	)


	----------------------------------
	---| button |--- info
	----------------------------------
	on UI_btn_info_about pressed do
	(
		messagebox string_1 title:Kingpin_MD2_Exporter_ver
	)
	----------------------------------
	---| button |--- brows for frames file
	----------------------------------
	on UI_btn_frameFile pressed do
	(
		framefilePath = getopenfilename caption:"Open Frame File" filename:"" types:"MD2 Frame File (*.txt)|*.txt|All Files (*.*)|*.*|"
		if framefilePath != undefined then
		(
			if (doesMyKPFileExist framefilePath) == true then
			(
				UI_eTex_frameFile.text = framefilePath
			)
		)
	)
	----------------------------------
	---| button |--- add player models to list
	----------------------------------
	on UI_btn_AddModelToList pressed do
	(
		if UI_lbox_PPM.items.count > 0 then
		(
			for listnum=1 to UI_lbox_PPM.items.count do
			UI_lbox_PPM.items = deleteItem UI_lbox_PPM.items 1  -- UI_lbox_PPM.selection
		)

		For CurrentObject in $selection do
		(
			if (superClassOf CurrentObject == GeometryClass) and
				(classOf CurrentObject != BoneGeometry) and (classOf CurrentObject != Biped_Object) and
				(classOf CurrentObject != Blizzard) and (classOf CurrentObject != PF_Source) and (classOf CurrentObject != Spray) and
				(classOf CurrentObject != PCloud) and (classOf CurrentObject != Snow) and
				(classOf CurrentObject != PArray) and (classOf CurrentObject != SuperSpray)	then
			(
				temp_array = UI_lbox_PPM.items --todo ok?
				insertItem (CurrentObject.name as string) temp_array 1
				UI_lbox_PPM.items = temp_array
			)
		)
	)
	----------------------------------
	---| button |--- export md2
	----------------------------------
	on UI_btn_export pressed do
	(
		local timeStart
		print("Export button pressed")
		md2Savefilename_kp=getsavefilename 	caption:"Save Kingpin Models MDX/MD2" \
											filename:md2lastfile_kp \
											types:"Kingpin MDX (*.mdx)|*.mdx|Kingpin MD2 (*.md2)|*.md2|All Files (*.*)|*.*"
		print("Save file name selected")
		if md2Savefilename_kp!=undefined then
		(
			local fileExt = getFilenameType md2Savefilename_kp
			format "fileEXT= %\n" fileExt

			if (stricmp fileExt ".mdx") == 0 then
				isMDX = True
			else if (stricmp fileExt ".md2") == 0 then
				isMDX = False
			else
			(
				messageBox "Incorrect file type" title:"MDX/MD2 Exporter"
				return false
			)

			timeStart = timeStamp()

			print("--== Start Write File ==--")
			md2_addcheck_kp (WriteMD2_kp md2Savefilename_kp) --hypov8 todo report error and remove ok messagebox
			print("--== File Write Done ==--")

			md2lastfile_kp = getFilenamePath  md2Savefilename_kp --store last opened dir

			timeEnd = timeStamp()
			format "Time=%\n" ((timeEnd - timeStart) / 1000.0)
		)
		--redraw/update models that were not selected
		slidertime = 1
		slidertime = 0
	)


	on UI_btn_bakeModel pressed do
	(

		local weldVert = UI_ckBox_bakeWeld.checked
		local splitSG = UI_ckBox_bakeSG.checked
		local combineMDL = UI_ckBox_mergeMDL.checked

		format "weld= %\n" weldVert
		format "SG=   %\n" splitSG

		timeStart = timeStamp()
		BakeAnimatedModel weldVert splitSG combineMDL

		timeEnd = timeStamp()
		format "Time=%\n" ((timeEnd - timeStart) / 1000.0)
	)

	-- bake animation check boxes
	on UI_ckBox_mergeMDL changed null do
	(
		UI_ckBox_bakeWeld.checked = false
		UI_ckBox_bakeSG.checked = false
	)
	on UI_ckBox_bakeWeld changed null do
	(
		UI_ckBox_mergeMDL.checked = false
	)
	on UI_ckBox_bakeSG changed null do
	(
		UI_ckBox_mergeMDL.checked = false
	)


)

