//---------------------------------------------------------------------------
// Rage of Mages RES plug-in
// (Doesn't understand the directory structures, only filenames are used)
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
//---------------------------------------------------------------------------
#define EXPORT __declspec (dllexport)
//---------------------------------------------------------------------------
typedef struct image_list_t *ilist_t;
typedef struct image_list_t
{
        unsigned long width;
        unsigned long height;
        unsigned long offset;
        ilist_t nextim;
} image_list_t;
//---------------------------------------------------------------------------
typedef struct entry_list_t *elist_t;
typedef struct entry_list_t {
  char name[256]; //name of the entry
  unsigned long size; //size, must be correct for entry saving, not for images
  unsigned long csize; //compressed size
  unsigned long comptype; //compression type, 0 = none, 1 = Daikatana RLE, 2 = deflate
  unsigned long offset; // offset to file data or image data (past the header and palette)
  unsigned long format; //0 = regular image, 1 = art, 2 = 16-bit, ...
  unsigned long palette_offset; //Offset to palette data (if exists), -1 = no palette
  unsigned long palette_type; // 0 = regular 768, 1 = bmp 1024, ...
  unsigned long image_offset; //Offset to raw image data
  unsigned long width; // 0 if not image
  unsigned long height; // 0 if not image
  unsigned long extra; // for extra stuff used with plugins (output size when retrieving data)
  unsigned long numtex; // 1 = normal image, 0 if not image, > 1 for textures with more than one images
  elist_t next;
  ilist_t nextim;
} entry_list_t;
//---------------------------------------------------------------------------
elist_t mapped = NULL;
HANDLE hentry;
EXPORT void CALLBACK delete_entry (void);
//---------------------------------------------------------------------------
#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void *yuck)
{
        switch (reason)
        {
                case DLL_PROCESS_DETACH:
                        delete_entry();
                break;
        }

        return 1;
}
//---------------------------------------------------------------------------
// how many different extensions are supported
EXPORT short CALLBACK get_ext_count (void)
{
        return 1;
}
//---------------------------------------------------------------------------
// extensions that this plugin wants to handle
#pragma argsused
EXPORT char * CALLBACK get_ext (int number)
{
	return "res";
}
//---------------------------------------------------------------------------
// returns a short description of extension
#pragma argsused
EXPORT char * CALLBACK get_format_desc (int number)
{
        return "Rage of Mages RES";
}
//---------------------------------------------------------------------------
typedef struct reshead_t
{
	long rm;
   long some1;   //files?
   long some2;   //dirs?
   long some3;
   long offset;
   long entries;
} reshead_t;
//---------------------------------------------------------------------------
typedef struct resentry_t
{
   long offset;
   long size;
   long type;  // 0 = file, 1 = directory?
   char name[20];
} resentry_t;
//---------------------------------------------------------------------------
// returns a short description string of the plug-in (showns on the menu)
EXPORT char * CALLBACK get_desc (void)
{
        return "Rage of Mages RES resource file";
}
//---------------------------------------------------------------------------
// displaying the "About" -dialog
EXPORT void CALLBACK plugin_info (HWND hwnd)
{
	MessageBox(hwnd, "Another GFE test plug-in!", "The Amazing RES Plug-in", MB_OK);
}
//---------------------------------------------------------------------------
void destroy_list (void)
{
	elist_t node_ptr = mapped, ptr;

	if (node_ptr == NULL) return;
	else {
   	while (node_ptr != NULL)
      {
      	ptr = node_ptr->next;
         UnmapViewOfFile(node_ptr);
         node_ptr = ptr;
      }
      mapped = NULL;
   }
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_entry (void)
{
        destroy_list();
}
//---------------------------------------------------------------------------
// Let's determine if we can recognize the file
#pragma argsused
EXPORT elist_t CALLBACK open (HWND hwnd, char *fullname, char *filename, int size, int offset)
{
        FILE *sourcef;
        //char error[256]; //, dir[512] = "\0";
        reshead_t res;
        resentry_t entry;
        elist_t previous = NULL;
        int i; //, next = 0;

        if (mapped != NULL) {
        		return mapped;
        }

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                //wsprintf (error, "Couldn't open file %s !", fullname);
                //MessageBox(hwnd, error, "RES Plug-in error", MB_OK);
                return NULL;
        }
        fseek(sourcef, offset, 0);
        fread(&res, sizeof(reshead_t), 1, sourcef);

        //wsprintf (error, "res.rm: %x\nres.some1: %li\nres.some2: %li\nres.some3: %li\nres.offset: %li\nres.what: %li", res.rm, res.some1, res.some2, res.some3, res.offset, res.entries);
        //MessageBox(hwnd, error, "RES Plug-in error", MB_OK);

        if (res.rm != 0x31415926)
        {
                //wsprintf (error, "Not a proper RES file! (type: %X)", res.rm);
                //MessageBox(hwnd, error, "RES Plug-in error", MB_OK);
                fclose(sourcef);
                return NULL;  //format not supported
        }
        else {
                fseek(sourcef, res.offset + 4, SEEK_SET);

                for (i=0;i<res.entries;i++)
                {
                	hentry = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, sizeof(entry_list_t), NULL);
                  if (hentry != NULL)
                  {
                  	fread(&entry, sizeof(resentry_t), 1, sourcef);

                     //wsprintf (error, "entry.offset: %li\nentry.size: %li\nentry.type: %li\nentry.name: %s", entry.offset, entry.size, entry.type, entry.name);
                     //MessageBox(hwnd, error, "RES Plug-in error", MB_OK);

                     if (entry.type == 0)
                     {
                           //next = 1;
                				mapped = (elist_t) MapViewOfFile(hentry, FILE_MAP_WRITE, 0, 0, 0);
                        	
                				if (mapped != NULL)
                				{
                              //strcpy(mapped->name, dir);
                        		strcpy(mapped->name, entry.name);
                        		mapped->offset = entry.offset;
  										mapped->image_offset = 0;
                        		mapped->numtex = 0;
  										mapped->palette_offset = 0;
  										mapped->palette_type = 0;
  										mapped->format = 0;
                        		mapped->width = 0;
  										mapped->height = 0;
  										mapped->size = entry.size;
  										mapped->csize = 0;
  										mapped->comptype = 0;
                        		mapped->extra = 0;
  										mapped->next = NULL;
  										mapped->nextim = NULL;
                				}
                     		else {
                        		CloseHandle(hentry);
                     			delete_entry();
                        		fclose(sourcef);
                        		return NULL;
                				}
                  			mapped->next = previous;
      							previous = mapped;

                        	CloseHandle(hentry);
                           if (feof(sourcef)) break;
                     }
                     else{
                     	//if (next == 1) strcpy(dir, entry.name);
                        //else strcat(dir, entry.name);
                        //strcat(dir, "/");
                        //i--;
                        //next = 0;
                     }
                  }
        		}

            return mapped;  // we are in business...
        }
}
//---------------------------------------------------------------------------
