/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.ExtrudeRadiusFactorCalculator;
import generators.PipeGenerator;
import generators.PipeShinglesGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class PipeGeneratorGUI
extends JFrame {
    public static final int SHINGLES_TYPE_CYL = 0;
    public static final int SHINGLES_TYPE_RAMP_SQTOP = 1;
    public static final int SHINGLES_TYPE_RAMP_TRITOP = 2;
    private Config configuration;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String radiusTitle = "Radius";
    private String radiusDescription = "The radius of the face of the ramp.";
    private String slicesTitle = "Slices";
    private String slicesDescription = "The number of individual surfaces that will make up the ramp.";
    private String crossSectionTitle = "Cross Section";
    private String crossSectionDescription = "The overall height and depth of the ramp. This parameter is ignored if shingles are being generated.";
    private String lengthTitle = "Length";
    private String lengthDescription = "How long the pipe is. Can also be described as the width of the ramp face.";
    private String extrudeTopNSlicesTitle = "extrudeTopNSlices";
    private String extrudeTopNSlicesDescription = "If this is greater than zero and if extrudeRadiusFactor is greater than one, the topmostTopNSlices vertices of the ramp will be pushed back so that the top of the ramp is no longer vertical. It \"relaxes\" the top of the ramp to have a less steep slope.";
    private String extrudeRadiusFactorTitle = "Extrude Radius Factor";
    private String extrudeRadiusFactorDescription = "Used together with extrudeTopNSlices. This value should be greater than one and extrudeTopNSlices should be greater than zero to make the top of the map less steep. It is possible to use values slightly less than one here to generate an \"oversteep\" top, but if used improperly, poor results will be generated, or [possibly] nothing will be generated at all. A value of 1.0 corresponds to a normal ramp with perfectly vertical top. Otherwise, the top vertices are generated based on a radius of\n(radius * extrudeRadiusFactor).\n\nUse the calculator in the top menu to calculate this value for a given lip offset.";
    private String adjustForOverlappingPipeCutsTitle = "Adjust For Overlapping Pipe Cuts";
    private String adjustForOverlappingPipeCutsDescription = "In the case where overlapping pipe brushes are needed, the overlapping brushes may be cut at the top of the ramp (at z = 0) and a the bottom of the ramp (at x = 0) in order to make a perfect quarter pipe with no brushes sticking out beyond these two planes. Use this flag to adjust vertex positions so that after the cuts, the resulting brushes are aligned along integer coordinates. Use this flag on non-overlapping brush generation also in case normal brushes are superimposed on top of overlapping brushes.";
    private String adjustForOverlappingBowlCutsTitle = "Adjust For Overlapping Bowl Cuts";
    private String adjustForOverlappingBowlCutsDescription = "If this pipe is going to fit perfectly at the seam of a quarter bowl, and if that bowl will be made of overlapping brushes which will be cut at the top (at z = 0), use this flag on both the bowl and on the pipe so that the resulting cut brushes from the bowl will lie on integer coordinates.";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a slick ramp for jumping purposes, you will either have to add shingles to the ramp or generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nonsolid.";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making slick ramps (for jumping) such that the player doesn't \"bounce\" off the surface. However, it is not advises to texture the overlapping brush faces with drawn textures. Instead, apply slick caulk which does no damage to all of the overlapping brushes, then superimpose a set of non-overlapping brushes that have surfaceparm nonsolid.";
    private String opCylinderShinglesTitle = "Generate cylinder shingles";
    private String opCylinderShinglesDescription = "Can be used together with non-overlapping brushes to create smooth surfaces that allow for high speeds while clinging to the inside of a cylinder. These shingles are one-directional. Cylinder shingles are useful when the pipe is put on its side to form a cylinder. They are also used for the top half of a vertical loop.";
    private String opSquareRampShinglesTitle = "Generate ramp shingles, top shingle square";
    private String opSquareRampShinglesDescription = "Can be used together with non-overlapping brushes to make smooth slick ramps for jumping. You may want to generate cylinder shingles if the pipe brushes are to be used as an upright cylinder or as the top part of a tube or loop. The top shingle is square to prevent lemmings.";
    private String opTriRampShinglesTitle = "Generate ramp shingles, top shingle triangular";
    private String opTriRampShinglesDescription = "Same as above, only top shingle is just like the rest of them. These shingles should be used for the fourth quarter of a loop.";
    private JCheckBox adjustForOverlappingBowlCuts;
    private JPanel adjustForOverlappingBowlCutsPanel;
    private JCheckBox adjustForOverlappingPipeCuts;
    private JPanel adjustForOverlappingPipeCutsPanel;
    private JButton calculate;
    private JMenuItem calculateExtrudeRadiusFactor;
    private JDialog calculateExtrudeRadiusPopup;
    private JPanel calculatePanel;
    private JMenu calculator;
    private JTextArea calculatorDescription;
    private JPanel calculatorDescriptionPanel;
    private JPanel calculatorOptionPanel;
    private JPanel calculatorPanel;
    private JLabel calculatorStatus;
    private JPanel calculatorStatusPanel;
    private JPanel crossSectionPanel;
    private JPanel cylinderShinglesOptionPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JLabel descriptionTitle;
    private JPanel extrudeRadiusFactorPanel;
    private JPanel extrudeTopNSlicesPanel;
    private JButton generate;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inCrossSection;
    private JTextField inExtrudeRadiusFactor;
    private JTextField inExtrudeTopNSlices;
    private JTextField inLength;
    private JTextField inLipOffset;
    private JTextField inRadius;
    private JTextField inSlices;
    private JScrollPane jScrollPane1;
    private JLabel laLipOffset;
    private JLabel labCrossSection;
    private JLabel labExtrudeRadiusFactor;
    private JLabel labExtrudeTopNSlices;
    private JLabel labLength;
    private JLabel labRadius;
    private JLabel labSlices;
    private JPanel lengthPanel;
    private JMenuBar menuBar;
    private JPanel normalOptionPanel;
    private JRadioButton opCylinderShingles;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private JRadioButton opSquareRampShingles;
    private JRadioButton opTriRampShingles;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel overlappingBrushOptionPanel;
    private JPanel radiusPanel;
    private JScrollPane scrollPane;
    private JPanel slicesPanel;
    private JPanel squareShinglesOptionPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel triShinglesOptionPanel;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public PipeGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.calculateExtrudeRadiusPopup = new JDialog();
        this.calculatorPanel = new JPanel();
        this.calculatorOptionPanel = new JPanel();
        this.laLipOffset = new JLabel();
        this.inLipOffset = new JTextField();
        this.calculatorStatusPanel = new JPanel();
        this.calculatorStatus = new JLabel();
        this.calculatePanel = new JPanel();
        this.calculate = new JButton();
        this.calculatorDescriptionPanel = new JPanel();
        this.calculatorDescription = new JTextArea();
        this.scrollPane = new JScrollPane();
        this.viewPanel = new JPanel();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.cylinderShinglesOptionPanel = new JPanel();
        this.opCylinderShingles = new JRadioButton();
        this.squareShinglesOptionPanel = new JPanel();
        this.opSquareRampShingles = new JRadioButton();
        this.triShinglesOptionPanel = new JPanel();
        this.opTriRampShingles = new JRadioButton();
        this.descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.valuesPanel = new JPanel();
        this.radiusPanel = new JPanel();
        this.labRadius = new JLabel();
        this.inRadius = new JTextField();
        this.crossSectionPanel = new JPanel();
        this.labCrossSection = new JLabel();
        this.inCrossSection = new JTextField();
        this.slicesPanel = new JPanel();
        this.labSlices = new JLabel();
        this.inSlices = new JTextField();
        this.lengthPanel = new JPanel();
        this.labLength = new JLabel();
        this.inLength = new JTextField();
        this.extrudeRadiusFactorPanel = new JPanel();
        this.labExtrudeRadiusFactor = new JLabel();
        this.inExtrudeRadiusFactor = new JTextField();
        this.adjustForOverlappingBowlCutsPanel = new JPanel();
        this.adjustForOverlappingBowlCuts = new JCheckBox();
        this.extrudeTopNSlicesPanel = new JPanel();
        this.labExtrudeTopNSlices = new JLabel();
        this.inExtrudeTopNSlices = new JTextField();
        this.adjustForOverlappingPipeCutsPanel = new JPanel();
        this.adjustForOverlappingPipeCuts = new JCheckBox();
        this.menuBar = new JMenuBar();
        this.calculator = new JMenu();
        this.calculateExtrudeRadiusFactor = new JMenuItem();
        this.calculateExtrudeRadiusPopup.setTitle("Extrude Radius Factor Calculator");
        this.calculateExtrudeRadiusPopup.setMinimumSize(new Dimension(330, 372));
        this.laLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.laLipOffset.setText("lipOffset:");
        this.inLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.inLipOffset.setText("5");
        this.inLipOffset.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inLipOffsetFocusLost(evt);
            }
        });
        this.inLipOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PipeGeneratorGUI.this.inLipOffsetPropertyChange(evt);
            }
        });
        this.inLipOffset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PipeGeneratorGUI.this.inLipOffsetKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                PipeGeneratorGUI.this.inLipOffsetKeyTyped(evt);
            }
        });
        GroupLayout calculatorOptionPanelLayout = new GroupLayout(this.calculatorOptionPanel);
        this.calculatorOptionPanel.setLayout(calculatorOptionPanelLayout);
        calculatorOptionPanelLayout.setHorizontalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorOptionPanelLayout.createSequentialGroup().addContainerGap(37, Short.MAX_VALUE).addComponent(this.laLipOffset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inLipOffset, -2, 48, -2).addContainerGap()));
        calculatorOptionPanelLayout.setVerticalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorOptionPanelLayout.createSequentialGroup().addGap(0, 30, Short.MAX_VALUE).addGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inLipOffset, -2, -1, -2).addComponent(this.laLipOffset))));
        this.calculatorStatus.setFont(new Font("Tahoma", 0, 12));
        this.calculatorStatus.setText("Enter a value for the lip offset");
        GroupLayout calculatorStatusPanelLayout = new GroupLayout(this.calculatorStatusPanel);
        this.calculatorStatusPanel.setLayout(calculatorStatusPanelLayout);
        calculatorStatusPanelLayout.setHorizontalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorStatusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorStatus, -1, 289, Short.MAX_VALUE).addContainerGap()));
        calculatorStatusPanelLayout.setVerticalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorStatusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorStatus).addContainerGap()));
        this.calculate.setText("Calculate");
        this.calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.calculateActionPerformed(evt);
            }
        });
        GroupLayout calculatePanelLayout = new GroupLayout(this.calculatePanel);
        this.calculatePanel.setLayout(calculatePanelLayout);
        calculatePanelLayout.setHorizontalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculate, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculatePanelLayout.setVerticalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addGap(0, 24, Short.MAX_VALUE).addComponent(this.calculate)));
        this.calculatorDescription.setEditable(false);
        this.calculatorDescription.setBackground(new Color(240, 240, 240));
        this.calculatorDescription.setColumns(20);
        this.calculatorDescription.setLineWrap(true);
        this.calculatorDescription.setRows(5);
        this.calculatorDescription.setText("Calculates the extrudeRadiusFactor based on the values of radius, slices and topNSlices.\n\nThe lipOffset is the number of units the top edge of the circular arc is to be nudged outward.\n\nNote that specifying a lipOffset of greater than what is possible to extrude (by setting a radius to be very large)  will generate erroneous results. ");
        this.calculatorDescription.setWrapStyleWord(true);
        GroupLayout calculatorDescriptionPanelLayout = new GroupLayout(this.calculatorDescriptionPanel);
        this.calculatorDescriptionPanel.setLayout(calculatorDescriptionPanelLayout);
        calculatorDescriptionPanelLayout.setHorizontalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescription).addContainerGap(13, Short.MAX_VALUE)));
        calculatorDescriptionPanelLayout.setVerticalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorDescription).addGap(245, 245, 245)));
        GroupLayout calculatorPanelLayout = new GroupLayout(this.calculatorPanel);
        this.calculatorPanel.setLayout(calculatorPanelLayout);
        calculatorPanelLayout.setHorizontalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.calculatorStatusPanel, -1, -1, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createSequentialGroup().addComponent(this.calculatorOptionPanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.calculatePanel, -1, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.calculatorDescriptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        calculatorPanelLayout.setVerticalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescriptionPanel, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calculatorOptionPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.calculatePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.calculatorStatusPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout calculateExtrudeRadiusPopupLayout = new GroupLayout(this.calculateExtrudeRadiusPopup.getContentPane());
        this.calculateExtrudeRadiusPopup.getContentPane().setLayout(calculateExtrudeRadiusPopupLayout);
        calculateExtrudeRadiusPopupLayout.setHorizontalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculateExtrudeRadiusPopupLayout.setVerticalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setTitle("Quarter Pipe Generator");
        this.setLocationByPlatform(true);
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/quarterPipeIcon.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addGap(18, 18, 18).addComponent(this.generate).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.generate)).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 46, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        this.options.add(this.opCylinderShingles);
        this.opCylinderShingles.setText("generate cylinder shingles");
        this.opCylinderShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.opCylinderShinglesActionPerformed(evt);
            }
        });
        this.opCylinderShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.opCylinderShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.opCylinderShinglesFocusLost(evt);
            }
        });
        GroupLayout cylinderShinglesOptionPanelLayout = new GroupLayout(this.cylinderShinglesOptionPanel);
        this.cylinderShinglesOptionPanel.setLayout(cylinderShinglesOptionPanelLayout);
        cylinderShinglesOptionPanelLayout.setHorizontalGroup(cylinderShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cylinderShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opCylinderShingles).addContainerGap(-1, Short.MAX_VALUE)));
        cylinderShinglesOptionPanelLayout.setVerticalGroup(cylinderShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opCylinderShingles));
        this.options.add(this.opSquareRampShingles);
        this.opSquareRampShingles.setText("generate ramp shingles, top shingle square");
        this.opSquareRampShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.opSquareRampShinglesActionPerformed(evt);
            }
        });
        this.opSquareRampShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.opSquareRampShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.opSquareRampShinglesFocusLost(evt);
            }
        });
        GroupLayout squareShinglesOptionPanelLayout = new GroupLayout(this.squareShinglesOptionPanel);
        this.squareShinglesOptionPanel.setLayout(squareShinglesOptionPanelLayout);
        squareShinglesOptionPanelLayout.setHorizontalGroup(squareShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(squareShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opSquareRampShingles).addContainerGap(-1, Short.MAX_VALUE)));
        squareShinglesOptionPanelLayout.setVerticalGroup(squareShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(squareShinglesOptionPanelLayout.createSequentialGroup().addComponent(this.opSquareRampShingles).addGap(0, 4, Short.MAX_VALUE)));
        this.options.add(this.opTriRampShingles);
        this.opTriRampShingles.setText("generate ramp shingles, top shingle triangular");
        this.opTriRampShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.opTriRampShinglesActionPerformed(evt);
            }
        });
        this.opTriRampShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.opTriRampShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.opTriRampShinglesFocusLost(evt);
            }
        });
        GroupLayout triShinglesOptionPanelLayout = new GroupLayout(this.triShinglesOptionPanel);
        this.triShinglesOptionPanel.setLayout(triShinglesOptionPanelLayout);
        triShinglesOptionPanelLayout.setHorizontalGroup(triShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(triShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opTriRampShingles).addContainerGap(-1, Short.MAX_VALUE)));
        triShinglesOptionPanelLayout.setVerticalGroup(triShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opTriRampShingles));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.cylinderShinglesOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.squareShinglesOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.triShinglesOptionPanel, -2, -1, -2)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cylinderShinglesOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.squareShinglesOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.triShinglesOptionPanel, -2, -1, -2).addGap(163, 163, 163)));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 297, -2).addGap(26, 26, 26)));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates a quarter pipe ramp as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, -1, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.radiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.radiusPanelFocusGained(evt);
            }
        });
        this.labRadius.setLabelFor(this.inRadius);
        this.labRadius.setText("radius:");
        this.inRadius.setText("512");
        this.inRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inRadiusFocusLost(evt);
            }
        });
        GroupLayout radiusPanelLayout = new GroupLayout(this.radiusPanel);
        this.radiusPanel.setLayout(radiusPanelLayout);
        radiusPanelLayout.setHorizontalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRadius, -2, 64, -2).addContainerGap()));
        radiusPanelLayout.setVerticalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labRadius).addComponent(this.inRadius, -2, -1, -2)).addContainerGap()));
        this.labCrossSection.setLabelFor(this.inCrossSection);
        this.labCrossSection.setText("crossSection:");
        this.inCrossSection.setText("768");
        this.inCrossSection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inCrossSectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inCrossSectionFocusLost(evt);
            }
        });
        GroupLayout crossSectionPanelLayout = new GroupLayout(this.crossSectionPanel);
        this.crossSectionPanel.setLayout(crossSectionPanelLayout);
        crossSectionPanelLayout.setHorizontalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCrossSection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCrossSection, -2, 64, -2).addContainerGap()));
        crossSectionPanelLayout.setVerticalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCrossSection).addComponent(this.inCrossSection, -2, -1, -2)).addContainerGap()));
        this.labSlices.setLabelFor(this.inSlices);
        this.labSlices.setText("slices:");
        this.inSlices.setText("24");
        this.inSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inSlicesFocusLost(evt);
            }
        });
        GroupLayout slicesPanelLayout = new GroupLayout(this.slicesPanel);
        this.slicesPanel.setLayout(slicesPanelLayout);
        slicesPanelLayout.setHorizontalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlices, -2, 64, -2).addContainerGap()));
        slicesPanelLayout.setVerticalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlices).addComponent(this.inSlices, -2, -1, -2)).addContainerGap()));
        this.labLength.setLabelFor(this.inLength);
        this.labLength.setText("length:");
        this.inLength.setText("256");
        this.inLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inLengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inLengthFocusLost(evt);
            }
        });
        GroupLayout lengthPanelLayout = new GroupLayout(this.lengthPanel);
        this.lengthPanel.setLayout(lengthPanelLayout);
        lengthPanelLayout.setHorizontalGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLength, -2, 64, -2).addContainerGap()));
        lengthPanelLayout.setVerticalGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLength).addComponent(this.inLength, -2, -1, -2))));
        this.labExtrudeRadiusFactor.setLabelFor(this.inExtrudeRadiusFactor);
        this.labExtrudeRadiusFactor.setText("extrudeRadiusFactor:");
        this.labExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.setText("1.0");
        this.inExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inExtrudeRadiusFactorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inExtrudeRadiusFactorFocusLost(evt);
            }
        });
        GroupLayout extrudeRadiusFactorPanelLayout = new GroupLayout(this.extrudeRadiusFactorPanel);
        this.extrudeRadiusFactorPanel.setLayout(extrudeRadiusFactorPanelLayout);
        extrudeRadiusFactorPanelLayout.setHorizontalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeRadiusFactorPanelLayout.createSequentialGroup().addComponent(this.labExtrudeRadiusFactor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inExtrudeRadiusFactor).addContainerGap()));
        extrudeRadiusFactorPanelLayout.setVerticalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeRadiusFactorPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeRadiusFactor).addComponent(this.inExtrudeRadiusFactor, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingBowlCuts.setText("adjustForOverlappingBowlCuts");
        this.adjustForOverlappingBowlCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingBowlCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingBowlCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.adjustForOverlappingBowlCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.adjustForOverlappingBowlCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingBowlCutsPanelLayout = new GroupLayout(this.adjustForOverlappingBowlCutsPanel);
        this.adjustForOverlappingBowlCutsPanel.setLayout(adjustForOverlappingBowlCutsPanelLayout);
        adjustForOverlappingBowlCutsPanelLayout.setHorizontalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addContainerGap(82, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCuts).addContainerGap()));
        adjustForOverlappingBowlCutsPanelLayout.setVerticalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCuts, -2, 23, -2)));
        this.labExtrudeTopNSlices.setText("extrudeTopNSlices:");
        this.inExtrudeTopNSlices.setText("0");
        this.inExtrudeTopNSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.inExtrudeTopNSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.inExtrudeTopNSlicesFocusLost(evt);
            }
        });
        GroupLayout extrudeTopNSlicesPanelLayout = new GroupLayout(this.extrudeTopNSlicesPanel);
        this.extrudeTopNSlicesPanel.setLayout(extrudeTopNSlicesPanelLayout);
        extrudeTopNSlicesPanelLayout.setHorizontalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labExtrudeTopNSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inExtrudeTopNSlices, -2, 64, -2).addContainerGap()));
        extrudeTopNSlicesPanelLayout.setVerticalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeTopNSlices).addComponent(this.inExtrudeTopNSlices, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingPipeCuts.setText("adjustForOverlappingPipeCuts");
        this.adjustForOverlappingPipeCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingPipeCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingPipeCuts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.adjustForOverlappingPipeCutsActionPerformed(evt);
            }
        });
        this.adjustForOverlappingPipeCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PipeGeneratorGUI.this.adjustForOverlappingPipeCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PipeGeneratorGUI.this.adjustForOverlappingPipeCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingPipeCutsPanelLayout = new GroupLayout(this.adjustForOverlappingPipeCutsPanel);
        this.adjustForOverlappingPipeCutsPanel.setLayout(adjustForOverlappingPipeCutsPanelLayout);
        adjustForOverlappingPipeCutsPanelLayout.setHorizontalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts).addContainerGap()));
        adjustForOverlappingPipeCutsPanelLayout.setVerticalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts, -2, 23, -2)));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radiusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.slicesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.crossSectionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.lengthPanel, -1, -1, Short.MAX_VALUE).addComponent(this.extrudeTopNSlicesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.extrudeRadiusFactorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCutsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCutsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.radiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossSectionPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lengthPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeTopNSlicesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeRadiusFactorPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingPipeCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingBowlCutsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addGap(62, 62, 62).addComponent(this.iconPanel, -2, -1, -2)).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.statusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.subtitlePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.descriptionPanel, -2, -1, -2)))).addContainerGap()));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.valuesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionPanel, -2, -1, -2)).addGap(18, 18, 18).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconPanel, -2, -1, -2).addComponent(this.optionsPanel, -2, 168, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.scrollPane.setViewportView(this.viewPanel);
        this.calculator.setText("Calculator");
        this.calculator.setToolTipText("Calculates the extrudeRadiusFactor for a given lip offset");
        this.calculateExtrudeRadiusFactor.setText("Calculate the extrudeRadiusFactor");
        this.calculateExtrudeRadiusFactor.setToolTipText("extrudeTopNSlices must be positive to use the calculator");
        this.calculateExtrudeRadiusFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PipeGeneratorGUI.this.calculateExtrudeRadiusFactorActionPerformed(evt);
            }
        });
        this.calculator.add(this.calculateExtrudeRadiusFactor);
        this.menuBar.add(this.calculator);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane).addGap(0, 0, 0)));
        this.pack();
    }

    private void inRadiusFocusGained(FocusEvent evt) {
        this.radiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.radiusTitle);
        this.description.setText(this.radiusDescription);
    }

    private void inRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void radiusPanelFocusGained(FocusEvent evt) {
    }

    private void inCrossSectionFocusGained(FocusEvent evt) {
        this.crossSectionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.crossSectionTitle);
        this.description.setText(this.crossSectionDescription);
    }

    private void inCrossSectionFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesFocusGained(FocusEvent evt) {
        this.slicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesTitle);
        this.description.setText(this.slicesDescription);
    }

    private void inSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inLengthFocusGained(FocusEvent evt) {
        this.lengthPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.lengthTitle);
        this.description.setText(this.lengthDescription);
    }

    private void inLengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingPipeCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingPipeCutsTitle);
        this.description.setText(this.adjustForOverlappingPipeCutsDescription);
    }

    private void adjustForOverlappingPipeCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.normal);
    }

    private void inExtrudeRadiusFactorFocusGained(FocusEvent evt) {
        this.extrudeRadiusFactorPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeRadiusFactorTitle);
        this.description.setText(this.extrudeRadiusFactorDescription);
    }

    private void inExtrudeRadiusFactorFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        if (this.opNormal.isSelected() || this.opOverlapping.isSelected()) {
            String[] args = new String[]{this.inRadius.getText(), this.inSlices.getText(), this.inCrossSection.getText(), this.inLength.getText(), Boolean.toString(this.opOverlapping.isSelected()), this.inExtrudeTopNSlices.getText(), this.inExtrudeRadiusFactor.getText(), Boolean.toString(this.adjustForOverlappingPipeCuts.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected())};
            this.status.setText("Generating cylinder...");
            PipeGenerator.main(args);
        }
        if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected()) {
            int shingles = 0;
            if (this.opCylinderShingles.isSelected()) {
                shingles = 0;
            }
            if (this.opSquareRampShingles.isSelected()) {
                shingles = 1;
            }
            if (this.opTriRampShingles.isSelected()) {
                shingles = 2;
            }
            String[] args = new String[]{this.inRadius.getText(), this.inSlices.getText(), this.inLength.getText(), this.inExtrudeTopNSlices.getText(), this.inExtrudeRadiusFactor.getText(), Boolean.toString(this.adjustForOverlappingPipeCuts.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected()), Integer.toString(shingles)};
            this.status.setText("Generating cylinder...");
            PipeShinglesGenerator.main(args);
        }
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void adjustForOverlappingPipeCutsActionPerformed(ActionEvent evt) {
    }

    private void opTriRampShinglesFocusLost(FocusEvent evt) {
        this.triShinglesOptionPanel.setBackground(this.normal);
    }

    private void opTriRampShinglesFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.triShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opTriRampShinglesTitle);
        this.description.setText(this.opTriRampShinglesDescription);
    }

    private void opTriRampShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opSquareRampShinglesFocusLost(FocusEvent evt) {
        this.squareShinglesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opSquareRampShinglesFocusGained(FocusEvent evt) {
        this.squareShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opSquareRampShinglesTitle);
        this.description.setText(this.opSquareRampShinglesDescription);
    }

    private void opSquareRampShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opCylinderShinglesFocusLost(FocusEvent evt) {
        this.cylinderShinglesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opCylinderShinglesFocusGained(FocusEvent evt) {
        this.cylinderShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opCylinderShinglesTitle);
        this.description.setText(this.opCylinderShinglesDescription);
    }

    private void opCylinderShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inExtrudeTopNSlicesFocusGained(FocusEvent evt) {
        this.extrudeTopNSlicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeTopNSlicesTitle);
        this.description.setText(this.extrudeTopNSlicesDescription);
    }

    private void inExtrudeTopNSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingBowlCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingBowlCutsTitle);
        this.description.setText(this.adjustForOverlappingBowlCutsDescription);
    }

    private void adjustForOverlappingBowlCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.normal);
    }

    private void calculateExtrudeRadiusFactorActionPerformed(ActionEvent evt) {
        this.calculateExtrudeRadiusPopup.setVisible(true);
    }

    private void inLipOffsetFocusLost(FocusEvent evt) {
        this.status.setText("");
        try {
            int temp = Integer.parseInt(this.inLipOffset.getText());
            if (temp < 0) {
                throw new Exception("lipOffset cannot be negative");
            }
            this.calculatorOptionPanel.setBackground(this.normal);
            this.calculatorStatusPanel.setBackground(this.normal);
            this.calculate.setEnabled(true);
        }
        catch (Exception ex) {
            this.calculate.setEnabled(false);
            if (ex instanceof NumberFormatException) {
                this.calculatorStatus.setText("Please enter a number");
            } else {
                this.calculatorStatus.setText(ex.getMessage());
            }
            this.calculatorOptionPanel.setBackground(Color.red);
            this.calculatorStatusPanel.setBackground(Color.yellow);
        }
    }

    private void inLipOffsetPropertyChange(PropertyChangeEvent evt) {
    }

    private void calculateActionPerformed(ActionEvent evt) {
        String[] args = new String[]{this.inRadius.getText(), this.inSlices.getText(), this.inExtrudeTopNSlices.getText(), this.inLipOffset.getText()};
        this.inExtrudeRadiusFactor.setText(Double.toString(ExtrudeRadiusFactorCalculator.calculate(args)));
        this.calculateExtrudeRadiusPopup.setVisible(false);
    }

    private void inLipOffsetKeyPressed(KeyEvent evt) {
    }

    private void inLipOffsetKeyTyped(KeyEvent evt) {
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        boolean calculateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inRadius.getText());
            if (temp <= 0) {
                throw new Exception("outerRadius must be positive");
            }
            this.radiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.radiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlices.getText());
            if (temp < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inLength.getText());
            if (temp2 <= 1) {
                throw new Exception("Min length is 1");
            }
            this.lengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.lengthPanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inExtrudeTopNSlices.getText());
            if (temp3 <= 0) {
                calculateOK = false;
                this.labExtrudeRadiusFactor.setEnabled(false);
                this.inExtrudeRadiusFactor.setEnabled(false);
            } else {
                this.labExtrudeRadiusFactor.setEnabled(true);
                this.inExtrudeRadiusFactor.setEnabled(true);
            }
            if (temp3 < 0) {
                throw new Exception("ExtrudeTopNSlices cannot be negative");
            }
            this.extrudeTopNSlicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.extrudeTopNSlicesPanel.setBackground(Color.red);
        }
        try {
            double temp4 = Double.parseDouble(this.inExtrudeRadiusFactor.getText());
            if (temp4 <= 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.extrudeRadiusFactorPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.extrudeRadiusFactorPanel.setBackground(Color.red);
        }
        if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected()) {
            this.labCrossSection.setEnabled(false);
            this.inCrossSection.setEnabled(false);
        } else {
            this.labCrossSection.setEnabled(true);
            this.inCrossSection.setEnabled(true);
            try {
                int temp5 = Integer.parseInt(this.inCrossSection.getText());
                if (temp5 <= 0) {
                    throw new Exception("inCrossSection cannot be negative");
                }
                this.crossSectionPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                this.statusPanel.setBackground(Color.yellow);
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.crossSectionPanel.setBackground(Color.red);
            }
        }
        if (calculateOK) {
            this.calculateExtrudeRadiusFactor.setEnabled(true);
        } else {
            this.calculateExtrudeRadiusFactor.setEnabled(false);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PipeGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

