/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class VolcanoGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int j;
        int i;
        int i2;
        Thread.currentThread().setPriority(1);
        int topCircumferenceRadius = Integer.parseInt(args[0]);
        int slopeRadius = Integer.parseInt(args[1]);
        int slicesCircumference = Integer.parseInt(args[2]);
        int slicesSlope = Integer.parseInt(args[3]);
        int crossSection = Integer.parseInt(args[4]);
        boolean offsetTopInsteadOfBottom = Boolean.valueOf(args[5]);
        int extrudeTopNSlices = Integer.parseInt(args[6]);
        double extrudeRadiusFactor = Double.parseDouble(args[7]);
        boolean adjustForOverlappingPipeCuts = Boolean.valueOf(args[8]);
        boolean adjustForOverlappingBowlCuts = Boolean.valueOf(args[9]);
        boolean invertSlopeVertices = Boolean.valueOf(args[10]);
        boolean generateOnlySeam = Boolean.valueOf(args[11]);
        boolean adjustSeamForJoining = Boolean.valueOf(args[12]);
        int adjustMask = 0;
        if (adjustForOverlappingBowlCuts) {
            adjustMask |= 2;
        }
        if (adjustForOverlappingPipeCuts) {
            adjustMask |= 1;
        }
        Point3D[] curve = VolcanoGenerator.generatePipeCurve(slopeRadius, slicesSlope, extrudeTopNSlices, extrudeRadiusFactor, adjustMask);
        if (invertSlopeVertices) {
            Point3D[] newCurve = new Point3D[curve.length];
            for (i2 = 0; i2 < curve.length; ++i2) {
                newCurve[curve.length - i2 - 1] = new Point3D(-curve[i2].z, curve[i2].y, -curve[i2].x);
            }
            curve = newCurve;
        }
        for (int i3 = 0; i3 < curve.length; ++i3) {
            curve[i3] = new Point3D(curve[i3].x - (double)(topCircumferenceRadius + slopeRadius), curve[i3].y, curve[i3].z);
        }
        Point3D[][] mesh = new Point3D[slicesCircumference + 1][slicesSlope + 1];
        for (i2 = 0; i2 <= slicesSlope; ++i2) {
            mesh[0][i2] = curve[i2];
        }
        AxisRotation3D rot = new AxisRotation3D(4, Math.PI / (double)(4 * slicesCircumference));
        for (i = 0; i <= slicesSlope; ++i) {
            if (!offsetTopInsteadOfBottom && i % 2 == 1) {
                mesh[0][i] = rot.transform(mesh[0][i]);
            }
            if (!offsetTopInsteadOfBottom || i % 2 != 0) continue;
            mesh[0][i] = rot.transform(mesh[0][i]);
        }
        for (i = 1; i <= slicesCircumference; ++i) {
            rot = new AxisRotation3D(4, Math.PI * (double)i / (double)(2 * slicesCircumference));
            for (j = 0; j <= slicesSlope; ++j) {
                mesh[i][j] = rot.transform(mesh[0][j]);
            }
        }
        if (adjustSeamForJoining) {
            for (i = 0; i < curve.length; ++i) {
                if ((offsetTopInsteadOfBottom || i % 2 != 1) && (!offsetTopInsteadOfBottom || i % 2 != 0)) continue;
                mesh[slicesCircumference][i] = new Point3D(0.0, curve[i].x, curve[i].z);
            }
        }
        VolcanoGenerator.startMap();
        for (i = 0; i < slicesCircumference * 2; ++i) {
            if (generateOnlySeam && i != slicesCircumference * 2 - 1) continue;
            for (j = 0; j < slicesSlope; ++j) {
                Point3D pt6;
                Point3D pt5;
                Point3D pt4;
                Point3D pt3;
                Point3D pt2;
                Point3D pt1;
                boolean bottomPiece = false;
                if (i % 2 == 0) {
                    if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                        pt1 = mesh[i / 2][j];
                        pt2 = mesh[i / 2 + 1][j];
                        pt3 = mesh[i / 2][j + 1];
                    } else {
                        pt1 = mesh[i / 2 + 1][j + 1];
                        pt2 = mesh[i / 2][j + 1];
                        pt3 = mesh[i / 2][j];
                        bottomPiece = true;
                    }
                } else if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                    pt1 = mesh[i / 2 + 1][j + 1];
                    pt2 = mesh[i / 2][j + 1];
                    pt3 = mesh[i / 2 + 1][j];
                    bottomPiece = true;
                } else {
                    pt1 = mesh[i / 2][j];
                    pt2 = mesh[i / 2 + 1][j];
                    pt3 = mesh[i / 2 + 1][j + 1];
                }
                if (j >= (slicesSlope + 1) / 2) {
                    VolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt3, false);
                    continue;
                }
                if (i < slicesCircumference - 1) {
                    pt4 = new Point3D(pt1.y, pt1.y, pt1.z);
                    pt5 = new Point3D(pt2.y, pt2.y, pt2.z);
                    pt6 = new Point3D(pt3.y, pt3.y, pt3.z);
                } else if (i > slicesCircumference - 1) {
                    pt4 = new Point3D(pt1.x, pt1.x, pt1.z);
                    pt5 = new Point3D(pt2.x, pt2.x, pt2.z);
                    pt6 = new Point3D(pt3.x, pt3.x, pt3.z);
                } else {
                    boolean oddSlices;
                    pt6 = null;
                    boolean offset = offsetTopInsteadOfBottom;
                    boolean oddRow = j % 2 != 0;
                    boolean bl = oddSlices = slicesCircumference % 2 != 0;
                    pt4 = offset ^ oddRow ? (oddSlices ? mesh[slicesCircumference / 2 + 1][j + 1] : mesh[slicesCircumference / 2][j]) : (oddSlices ? mesh[slicesCircumference / 2 + 1][j] : mesh[slicesCircumference / 2][j + 1]);
                    pt5 = new Point3D(pt4.x, pt4.x, pt4.z);
                    VolcanoGenerator.startBrush();
                    VolcanoGenerator.writeFace(pt1, pt2, pt3);
                    VolcanoGenerator.writeFace(pt1, pt5, pt2);
                    VolcanoGenerator.writeFace(pt2, pt5, pt3);
                    VolcanoGenerator.writeFace(pt3, pt5, pt1);
                    VolcanoGenerator.endBrush();
                }
                if (pt6 != null) {
                    VolcanoGenerator.startBrush();
                    VolcanoGenerator.writeFace(pt1, pt2, pt3);
                    VolcanoGenerator.writeFace(pt4, pt6, pt5);
                    if (VolcanoGenerator.equals(pt1, pt4)) {
                        VolcanoGenerator.writeFace(pt2, pt1, pt5);
                    } else {
                        VolcanoGenerator.writeFace(pt2, pt1, pt4);
                    }
                    if (VolcanoGenerator.equals(pt2, pt5)) {
                        VolcanoGenerator.writeFace(pt3, pt2, pt6);
                    } else {
                        VolcanoGenerator.writeFace(pt3, pt2, pt5);
                    }
                    if (VolcanoGenerator.equals(pt3, pt6)) {
                        VolcanoGenerator.writeFace(pt1, pt3, pt4);
                    } else {
                        VolcanoGenerator.writeFace(pt1, pt3, pt6);
                    }
                    if (i == slicesCircumference * 2 - 1 && !adjustSeamForJoining) {
                        VolcanoGenerator.writeFace(new Point3D(128.0, -128.0, 0.0), new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 0.0, -128.0));
                    }
                    VolcanoGenerator.endBrush();
                }
                if (!bottomPiece || j != (slicesSlope + 1) / 2 - 1) continue;
                if (i < slicesCircumference - 2 || i > slicesCircumference) {
                    if (i == slicesCircumference * 2 - 1 && !adjustSeamForJoining) {
                        VolcanoGenerator.startBrush();
                        VolcanoGenerator.writeFace(pt1, pt2, pt5);
                        VolcanoGenerator.writeFace(pt1, new Point3D(pt1.x, pt1.y, -crossSection), pt2);
                        VolcanoGenerator.writeFace(pt2, new Point3D(pt2.x, pt2.y, -crossSection), pt5);
                        VolcanoGenerator.writeFace(pt5, new Point3D(pt5.x, pt5.y, -crossSection), pt4);
                        VolcanoGenerator.writeFace(pt4, new Point3D(pt4.x, pt4.y, -crossSection), pt1);
                        VolcanoGenerator.writeFace(new Point3D(pt5.x, pt5.y, -crossSection), new Point3D(pt2.x, pt2.y, -crossSection), new Point3D(pt1.x, pt1.y, -crossSection));
                        VolcanoGenerator.writeFace(new Point3D(128.0, -128.0, 0.0), new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 0.0, -128.0));
                        VolcanoGenerator.endBrush();
                        continue;
                    }
                    VolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt5, pt4);
                    continue;
                }
                if (i == slicesCircumference - 1) {
                    VolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt5, false);
                    continue;
                }
                if (i == slicesCircumference - 2) {
                    VolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt5, false);
                    continue;
                }
                VolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt4, false);
            }
        }
        VolcanoGenerator.endMap();
    }
}

