#DEFINE DEBUG 0

    'Here goes:
    'I'm loading kpcheck.ini BEFORE opening the .map file, so I'm preaching tons of useless crap
    'that I must then rig -- that's lame. Also, there's no efficiant check for .map file
    'structure-related errors, be careful. Since there is lot of imporvement to be done (multiple
    '.ini files loading could be useful, for instance), this tool is considered ALPHA, always
    'backup your files before using this stuff!
    '             [ACC] -- Laaaaaaater. Peace!

    DECLARE FUNCTION  FUNC_STRTRIM      (byval StringLump as string)  as string
    declare function  FUNC_CleanDir     (byval TmpStr as string)      as string
    declare function  LOAD_INIFILES     (byval FileName as string)    as ubyte
    declare function  LOAD_MAPFILES     (byval Filename as string)    as ubyte
    declare FUNCTION  RETURNFlags       (byval FlagStuff as uinteger, byval flagtype as ubyte) as string
    declare sub       SAVE_MAPFILES     (byval FileName as string)
    declare sub       INIT_TEXTURES     ()
    declare sub       FUNC_READSURF     (byval StringLump as string)  'using Byval do not change a thing with strings, so we still NEED to make a copy of the string manualy
    declare sub       FUNC_READENTITY   (byval StringLump as string)  'using Byval do not change a thing with strings, so we still NEED to make a copy of the string manualy
    declare sub       APPLY_SURFACEFLAGS()
    declare SUB       APPLY_FIXCONTENT  ()
    declare sub       APPLY_CONTENTFLAGS()
    declare SUB       ShowUsage         ()
    declare SUB       vprint            (text AS STRING)
    declare SUB       LogPrint          (text as string)
    
    Type MUs
      FlagVal as uinteger
      Counter as short
    end type
    Type TSetType
      FileName as string
      FlagCont as uinteger
      FlagSurf as uinteger
      Available as ubyte
    end type
    redim shared as TSetType  TextureSet(0 to 0)    'Dirty way: I'm loading kpcheck.ini before opening .map file
    redim shared as TSetType  TextureUse(0 to 0)    'so I'm precaching all defined textures BEFORE checking the one I need, that's lame.
    redim shared as string    MapData(0 to 0)       'Precache for .MAP
    dim shared as uinteger    Square(1 to 32): for i as ubyte = 1 to 32:Square(i) = 2^(i-1) :next i
    dim shared as string      Surface(1 to 32), Content(1 to 32)
    dim shared as string      PlaneData(1 to 12), EntityData(1 to 2)      'Stores all 12 info to make a perfect plane! wow!
    dim shared as uinteger    MapLine                                     'Line number, mainly for error and warnings
    dim shared as integer     TotalEntities, BrushNumber, BrushContent    'Misc useful stuff
    dim shared as integer     OldBrushNumber, OldTotalEntities            'Backup data to check previous state
    dim shared as string      EntityClassname

    dim as double         TimerCounter = TIMER
    dim shared as ubyte   TEMP_ToolFlag, F_VERBOSE=1, F_NOSURF=2, F_NONULL=4, F_DUMP=8, F_CONTENT=16, F_ZERO=32
    dim as ubyte          TEMP_CurrentCommand=1
    dim as string         TEMP_Com, TEMP_SourceFileName


    print "---- KPCHECK ALPHA ----"
    print "Programmed by [ACC], ALPHA ("+__DATE__+")": print

#IF (DEBUG = 0)
    DO
      TEMP_Com = LTRIM$(RTRIM$(LCASE$(COMMAND$(TEMP_CurrentCommand))))
      IF TEMP_Com = "" THEN ShowUsage:END
      IF (TEMP_Com = "-h") OR (TEMP_Com = "-help") THEN
        ShowUsage:END
      ELSEIF ((TEMP_Com = "-v") OR (TEMP_Com = "-verbose")) AND ((TEMP_ToolFlag AND F_VERBOSE) = 0) THEN
        TEMP_ToolFlag += F_VERBOSE
      ELSEIF ((TEMP_Com = "-n") OR (TEMP_Com = "-nonull")) AND ((TEMP_ToolFlag AND F_NONULL) = 0) THEN
        TEMP_ToolFlag += F_NONULL
      ELSEIF ((TEMP_Com = "-s") OR (TEMP_Com = "-nosurf")) AND ((TEMP_ToolFlag AND F_NOSURF) = 0) THEN
        TEMP_ToolFlag += F_NOSURF
      ELSEIF ((TEMP_Com = "-c") OR (TEMP_Com = "-content")) AND ((TEMP_ToolFlag AND F_CONTENT) = 0) THEN
        TEMP_ToolFlag += F_CONTENT
      ELSEIF ((TEMP_Com = "-z") OR (TEMP_Com = "-zero")) AND ((TEMP_ToolFlag AND F_ZERO) = 0) THEN
        TEMP_ToolFlag += F_ZERO        
      ELSEIF ((TEMP_Com = "-d") OR (TEMP_Com = "-dump")) AND ((TEMP_ToolFlag AND F_DUMP) = 0) THEN
        TEMP_ToolFlag += F_DUMP
        LogPrint (string(30,"="))
        LogPrint ("Log date: "+date+" "+time)
      ELSE
        IF LEFT$(TEMP_Com,1) = "-" THEN
          PRINT "WARNING: Option unknown "+CHR$(34)+TEMP_Com+CHR$(34)
        ELSE
          if instr(TEMP_COM,".") = 0 then TEMP_Com += ".map"
          dim as string FFormat: FFormat = lcase$(right$(TEMP_Com, len(TEMP_Com)-instr(TEMP_Com,".")+1))
          if (FFormat = ".map") then
            TEMP_SourceFileName = TEMP_Com
            if dir$(TEMP_SourceFileName) = "" then print "ERROR: "+TEMP_SourceFileName+" not found!":end
          else
            print "ERROR: Source file must be .MAP!":end
          end if
        END IF
      END IF
      TEMP_CurrentCommand += 1
    LOOP WHILE COMMAND$(TEMP_CurrentCommand) <> ""   
#ELSEIF (DEBUG = 1)
  TEMP_SourceFileName = "out3.map"
#ENDIF
    
    if TEMP_ToolFlag then
      print "---- Settings ----"
      if (TEMP_ToolFlag and F_NONULL) then  print " -nonull enabled (never replace NULL)"
      if (TEMP_ToolFlag and F_NOSURF) then  print " -nosurf enabled (skip already defined surfaces)"
      if (TEMP_ToolFlag and F_CONTENT) then print " -content enabled (auto set content)"
      if (TEMP_ToolFlag and F_VERBOSE) then print " -verbose enabled (display more info)"
      if (TEMP_ToolFlag and F_DUMP) then    print " -dump enabled (write kpcheck.log)"
      if (TEMP_ToolFlag and F_ZERO) then    print " -zero enable (never ignore null content flag)"
    end if
    
    print "---- Initialization ----"
    Print "Loading kpcheck.ini..."
    if LOAD_INIFILES ("kpcheck.ini") = 0 then print "kpcheck.ini not found!":end 
    if ubound(TextureSet) = 0 then print "no textures defined!":end
    vprint str$(ubound(TextureSet))+" textures defined."
    print "Entering "+TEMP_SourceFileName+"..."
    if LOAD_MAPFILES (TEMP_SourceFileName) = 0 then print "Cannot open "+TEMP_SourceFileName+" file":end
    if ubound(MapData) = 0 then print TEMP_SourceFileName+" is empty!":end
    vprint "Read "+str$(MapLine)+" lines, "+str$(ubound(MapData))+" relevant lines"
    SAVE_MAPFILES TEMP_SourceFileName+".backup" 'making a backup
    INIT_TEXTURES                               'check for used textures
    
    print "---- Map check ----"
    APPLY_SURFACEFLAGS                                        'replace surface flags
    if (TEMP_ToolFlag and F_CONTENT) then APPLY_CONTENTFLAGS  'replace content flags
    APPLY_FIXCONTENT                                          'check for "mixed face contents"
    SAVE_MAPFILES TEMP_SourceFileName                         'save changes !!! DEBUG !!!
    print "   "+str$(cint(TIMER-TimerCounter))+" seconds elapsed"
    end
    
    
    
    
    
    
    
        ' USAGE
        '-----------------------------------------------------------------------
        SUB ShowUsage ()
          PRINT "usage:  KPCHECK.EXE filename[.MAP] [commands]"
          PRINT "   -h (-help)          This help message"
          print "   -v (-verbose)       Display details"
          print "   -d (-dump)          Dump additional info to kpcheck.log"
          print "   -n (-nonull)        Do not replace NULL with common/0_sky1"
          print "   -s (-nosurf)        Do not replace existing surface flags"
          print "   -c (-content)       Enable auto-content"
          print "   -z (-zero)          Do not ignore null content flag"
        END SUB
        
        
        ' ADD STUFF TO THE LOG
        '-----------------------------------------------------------------------
        sub LogPrint (text as string)
          if ((TEMP_ToolFlag and F_DUMP) = 0) then exit sub
          dim as ubyte ff = freefile
          open "kpcheck.log" for append as #ff
            print #ff, text
          close #ff
        end sub

        ' VERBOSE DISPLAY
        '-----------------------------------------------------------------------
        SUB vprint (text AS STRING)
          IF (TEMP_ToolFlag AND F_VERBOSE) THEN PRINT text
        END SUB

        ' OPEN AN .INI FILE AND SET UP VARIABLES
        '-----------------------------------------------------------------------------
        function LOAD_INIFILES (byval FileName as string) as ubyte
          LOAD_INIFILES = 1
          dim as ushort     FF = freefile
          dim as uinteger   FileLine
          dim as string     CODELINE, CodeKey, CodeValue, CurrentMode, BaseString, CodeString
          if dir$(FileName,32) = "" then return 0
          open FileName for input as #FF
          if lof(ff) = 0 then close #ff:return 0
          do
            FileLine += 1
            line input #FF, CodeString
            BaseString = CodeString
            CodeString = FUNC_STRTRIM(CodeString)
            if left$(CodeString,1) = ";" then CodeString = ""
            if CodeString <> "" then
              if left$(CodeString,1) = "[" and right$(CodeString,1) = "]" then
                CurrentMode = ucase$(mid$(CodeString,2,len(CodeString)-2))
              elseif instr(CodeString, "=") then
                CodeKey = ucase$(FUNC_STRTRIM(left$(CodeString,instr(CodeString,"=")-1)))
                CodeValue = FUNC_STRTRIM(right$(CodeString, len(CodeString)-instr(CodeString,"=")))
                if (CodeKey <> "") and (CodeValue <> "") then
                  if CurrentMode = "CONTENT" then
                    if left$(CodeKey,4 ) = "FLAG" then Content(val(right$(CodeKey,len(CodeKey)-4))) = CodeValue
                  elseif CurrentMode = "SURFACE" then
                    if left$(CodeKey,4 ) = "FLAG" then Surface(val(right$(CodeKey,len(CodeKey)-4))) = CodeValue
                  elseif CurrentMode = "TEXTURES" then
                    redim preserve TextureSet(1 to ubound(TextureSet)+1)
                    TextureSet(ubound(TextureSet)).Filename = FUNC_CleanDir(lcase$(CodeKey))
                    for i as ubyte  = 1 to 32
                      if instr(lcase$(CodeValue),lcase$(Content(i))) then TextureSet(ubound(textureSet)).FlagCont += Square(i)
                      if instr(lcase$(CodeValue),lcase$(Surface(i))) then TextureSet(ubound(textureSet)).FlagSurf += Square(i)
                    next i
                  elseif CurrentMode = "" then
                    Print "INIT_INI: No mode set for "+chr$(34)+CodeKey+" = "+CodeValue+chr$(34)+" in "+ucase$(FileName)+"! [L"+str$(FileLine)+"]"
                  else
                    Print "INIT_INI: Mode/pair unknown "+chr$(34)+CodeKey+" = "+CodeValue+chr$(34)+" in "+ucase$(FileName)+"! [L"+str$(FileLine)+"]"
                  end if
                else
                  Print "INIT_INI: Pair undefined "+chr$(34)+CodeKey+" = "+CodeValue+chr$(34)+" in "+ucase$(FileName)+"! [L"+str$(FileLine)+"]"
                end if
              end if
            end if
          loop while not eof(FF)
          close #FF
        end function

        ' Clean a directory string
        '-----------------------------------------------------------------------------
        function FUNC_CleanDir(byval TmpStr as string) as string
          dim as string TmpStr2 = FUNC_STRTRIM(TmpStr)
          for tmp as ushort = 1 to len(TmpStr2)
            if mid$(TmpStr2,tmp,1) = "\" then mid$(TmpStr2,tmp,1) = "/"
          next tmp
          if (left$(TmpStr2,1) = "/")  then TmpStr2 = right$(TmpStr2,len(TmpStr2)-1)
          if (right$(TmpStr2,1) = "/") then TmpStr2 =  left$(TmpStr2,len(TmpStr2)-1)
          return TmpStr2
        end function
        
        ' REMOVE ALL SPACES, INDENTS AND SUCH FROM A STRING
        '-----------------------------------------------------------------------
        function FUNC_STRTRIM (byval StringLump as string) as string
          if instr(StringLump, "//") then StringLump = left$(StringLump,instr(StringLump,"//")-1)
          do while (left$(StringLump,1) = chr$(9)) or (left$(StringLump,1) = chr$(32))
            StringLump = right$(StringLump,len(StringLump)-1)
          loop
          do while (right$(StringLump,1) = chr$(9)) or (right$(StringLump,1) = chr$(32))
            StringLump = left$(StringLump,len(StringLump)-1)
          loop
          FUNC_STRTRIM = StringLump
        end function
        
        ' READ AN ENTITY STRING
        '-----------------------------------------------------------------------
        sub FUNC_READENTITY (byval UnbuggyString as string)
          dim as ubyte TempValue
          dim as string StringLump
          StringLump = UnbuggyString
          EntityData(1) = "": EntityData(2) = ""
          do
            if left$(StringLump,1) = chr$(34) then
              TempValue += 1
            else
              if TempValue = 1 then
                EntityData(1) += left$(StringLump,1)
              elseif TempValue = 3 then
                EntityData(2) += left$(StringLump,1)
              end if
            end if
            StringLump = right$(StringLump,len(StringLump)-1)
          loop while (StringLump <> "")
        end sub
        
        ' READ A SURFACE STRING
        '-----------------------------------------------------------------------
        sub FUNC_READSURF (byval UnbuggyString as string)
          '1,2,3_Vectors    4_Texture   5,6_Offset    7_Rotation    8,9_Scale   10_Content    11_Surface  12_Light
          dim as ubyte   TempValue
          dim as string  ReturnString, StringLump
          StringLump  = UnbuggyString
          for Dataobject as ubyte = 1 to 12
            if (DataObject <=3) then 'reading plane's vectors
              do
                if left$(StringLump,1) = "(" then
                  TempValue =1
                elseif left$(StringLump,1) =")" then
                  if TempValue = 1 then TempValue = 2
                  'else
                    'print "Corrupted .MAP file! [L"+str$(MapLine)+"]":TempValue = 0:exit sub
                  'end if
                end if
                ReturnString += left$(StringLump,1)
                StringLump = right$(StringLump, len(StringLump)-1)
              loop while TempValue <> 2
              TempValue = 0
            else
              do
                ReturnString += left$(StringLump,1)
                StringLump = right$(StringLump,len(StringLump)-1)
              loop while (left$(StringLump,1) <> " ") and (StringLump <> "")
            end if
            PlaneData(DataObject) = FUNC_STRTRIM(ReturnString)
            ReturnString = ""
          next DataObject
        end sub
        
        ' Save a new .MAP file
        '-----------------------------------------------------------------------       
        sub SAVE_MAPFILES (byval FileName as string)
          print "Writing "+Filename
          TotalEntities = 0: BrushNumber = 0
          dim as ubyte DataLevel
          dim as ubyte ff = freefile
          open FileName for output as #ff
          print #ff, ""
          for k as uinteger = 1 to ubound(MapData)
            if (mid$(MapData(k),1,1) = "{") then
              DataLevel += 1 'add ONE (one: new entity, two: new brush)
              if DataLevel = 1 then
                TotalEntities += 1: BrushNumber = 0:OldBrushNumber = -1: OldTotalEntities = -1 'rester BrushNumber
                print #ff, "// entity "+str$(TotalEntities-1)
              elseif DataLevel  =2 then
                BrushNumber += 1: OldBrushNumber = -1
                print #ff, "// brush "+str$(BrushNumber-1)
              end if
            elseif mid$(MapData(k),1,1) = "}" then
              DataLevel -= 1
            end if
            print #ff, MapData(k)
          next k
          close #ff
        end sub
          
        ' Read and cache the whole file
        '-----------------------------------------------------------------------
        function LOAD_MAPFILES (byval filename as string) as ubyte
          LOAD_MAPFILES = 1
          redim MapData(0 to 0)
          dim as string   TmpLine, DataLine
          dim as ubyte    ff = freefile
          if dir$(FileName, 32) = "" then return 0
          open FileName for input as #ff
          if lof(ff) = 0 then close #ff: return 0
          do
            line input #ff, TmpLine
            MapLine += 1 'amount of lines IN THE FILE
            DataLine = FUNC_STRTRIM(TmpLine)
            if (DataLine <> "") then
              redim preserve MapData(1 to ubound(MapData)+1)
              MapData(ubound(MapData)) = DataLine
            end if
          loop while not eof(ff)
          close #ff
        end function
        
        ' Read the map data, check for unique textures, recreate the textureset
        '-----------------------------------------------------------------------
        sub INIT_TEXTURES ()
          TotalEntities = 0: BrushNumber = 0
          dim as uinteger           SetTo, NoFound
          dim as ubyte              DataLevel                                   'DataLevel can be 0 (no data), 1 (entity pairs) or 2 (brush)
          dim as string             Texturename
          for k as uinteger = 1 to ubound(MapData)
            if (mid$(MapData(k),1,1) = "{") then
              DataLevel += 1 'add ONE (one: new entity, two: new brush)
              if DataLevel = 1 then
                TotalEntities += 1: BrushNumber = 0:OldBrushNumber = -1: OldTotalEntities = -1 'rester BrushNumber
              elseif DataLevel  =2 then
                BrushNumber += 1: OldBrushNumber = -1
              end if
            elseif mid$(MapData(k),1,1) = "}" then
              DataLevel -= 1
            else
              if (DataLevel = 2) then
                FUNC_READSURF(MapData(k))
                Texturename = FUNC_CleanDir(lcase$(PlaneData(4)))
                if ((TEMP_ToolFlag and F_NONULL) = 0) and (lcase$(Texturename) = "null") then Texturename = "common/0_sky1"
                SetTo = 0
                if ubound(TextureUse) = 0 then  'we have no precached stuff yet, so let's add this one
                  SetTo = 1
                else 'we already have something in precache, let's check if we precached current texture already...
                  for x as uinteger = 1 to ubound(TextureUse)+1
                    if x = ubound(TextureUse)+1 then SetTo = ubound(TextureUse)+1: exit for 'no precached yet
                    if TextureUse(x).Filename = Texturename then SetTo = 0: exit for 'already precached
                  next x
                end if
                if SetTo then 'We didn't find the texture in the stack, let's add it at rank "SetTo"
                  redim preserve TextureUse(1 to SetTo)
                  TextureUse(SetTo).FileName = Texturename
                  for y as uinteger = 1 to ubound(TextureSet)+1
                    if y = ubound(textureSet)+1 then
                      if NoFound = 0 then
                        LogPrint ("-- WARNING --")
                        LogPrint ("The following textures are not defined and will be ignored:")
                      end if
                      LogPrint ("     "+TextureUse(SetTo).FileName)
                      NoFound +=1 :exit for
                    end if
                    if TextureUse(SetTo).FileName = TextureSet(y).FileName then
                      textureUse(SetTo).FlagSurf = textureSet(y).FlagSurf
                      textureUse(SetTo).FlagCont = textureSet(y).FlagCont
                      textureUSe(SetTo).Available = 1 'so we know we can use the new flags, it's not really "precached"
                      exit for
                    end if
                  next y
                end if
                SetTo = 0
              end if
            end if
          next k
          redim TextureSet(0 to 0)
          vprint "Found "+str$(ubound(textureUse))+" uniques textures ("+str$(NoFound)+" textures undefined in kpcheck.ini)"
        end sub

        ' Return a string of readable flags
        '-----------------------------------------------------------------------
        FUNCTION RETURNFlags (byval FlagStuff as uinteger, byval flagtype as ubyte) as string
          dim as string Readable
          for k as ubyte = 1 to 32
            if (FlagStuff and Square(k)) then
              if Readable <> "" then Readable +=", "
              if (FlagType = 2) then
                Readable += Content(k)
              else
                Readable += Surface(k)
              end if
            end if
          next k
          Return Readable
        end function

        ' Read the map data, use new textureset to replace flags
        '-----------------------------------------------------------------------
        SUB APPLY_SURFACEFLAGS ()
          print "Setting surfaces... ";
          TotalEntities = 0: BrushNumber = 0
          dim as string     TextureName, Initial, Became
          dim as ubyte      DataLevel
          dim as uinteger   Replaced
          for k as uinteger = 1 to ubound(MapData)
            if (mid$(MapData(k),1,1) = "{") then
              DataLevel += 1 'add ONE (one: new entity, two: new brush)
              if DataLevel = 1 then
                TotalEntities += 1: BrushNumber = 0:OldBrushNumber = -1: OldTotalEntities = -1 'rester BrushNumber
              elseif DataLevel  =2 then
                BrushNumber += 1: OldBrushNumber = -1
              end if
            elseif mid$(MapData(k),1,1) = "}" then
              DataLevel -= 1
            else
              if (DataLevel = 2) then
                FUNC_READSURF(MapData(k))
                if ((val(PlaneData(11)) <> 0) and (TEMP_ToolFlag and F_NOSURF)) = 0 then
                  if ((TEMP_ToolFlag and F_NONULL) = 0) and (lcase$(PlaneData(4)) = "null") then PlaneData(4) = "common/0_sky1"
                  Texturename = FUNC_CleanDir(lcase$(PlaneData(4)))
                  for y as uinteger = 1 to ubound(TextureUse)
                    if (TextureUse(y).Filename = Texturename) and (TextureUse(y).FlagSurf <> val(PlaneData(11))) and (TextureUse(y).Available = 1) then
                      if ((TotalEntities <> OldTotalEntities) or (BrushNumber <> OldBrushNumber)) then LogPrint ("--Entity "+str$(totalEntities)+", brush "+str$(BrushNumber)+"--")
                      OldTotalEntities = totalEntities: OldBrushNumber = BrushNumber
                      Initial = chr$(34)+RETURNFlags(val(PlaneData(11)),1)+chr$(34)
                      Became = chr$(34)+RETURNFlags(TextureUse(y).FlagSurf,1)+chr$(34)
                      if len(Initial) = 2 then Initial = "NOTHING"
                      if len(Became) = 2 then Became = "NOTHING"                      
                      LogPrint ("["+Texturename+"] "+Initial+" >> "+Became)
                      PlaneData(11) = str$(TextureUse(y).FlagSurf)
                      MapData(k) = PlaneData(1)+" "+PlaneData(2)+" "+PlaneData(3)+" "+PlaneData(4)+" "+str$(val(PlaneData(5)))+" "+str$(val(PlaneData(6)))+" "+str$(val(PlaneData(7)))+" "+str$(val(PlaneData(8)))+" "+str$(val(PlaneData(9)))+" "+str$(val(PlaneData(10)))+" "+str$(val(PlaneData(11)))+" "+str$(val(PlaneData(12)))
                      Replaced += 1: exit for
                    end if
                  next y
                end if
              end if
            end if
          next k
          if Replaced > 1 then print "done ("+str$(Replaced)+" surfaces replaced)" else print "done ("+str$(Replaced)+" surface replaced)"
        END SUB

        ' Read the map data, use new textureset to replace flags
        '-----------------------------------------------------------------------
        SUB APPLY_FIXCONTENT ()
          print "Fixing content... ";
          TotalEntities = 0: BrushNumber = 0
          redim as string     BrushFace(0 to 0)     'Store a whole brush
            dim as string     Initial
            dim as ubyte      DataLevel, NeedAFix
            dim as uinteger   Replaced, BrushContent, MostCount
          for k as uinteger = 1 to ubound(MapData)
            if (mid$(MapData(k),1,1) = "{") then
              DataLevel += 1
              if DataLevel = 1 then
                TotalEntities += 1: BrushNumber = 0:OldBrushNumber = -1: OldTotalEntities = -1 'rester BrushNumber
              elseif DataLevel  =2 then
                BrushNumber += 1: OldBrushNumber = -1
              end if
            elseif mid$(MapData(k),1,1) = "}" then
              if (lbound(BrushFace) <> 0) then
                if (NeedAFix = 1) then 'Okay, at least ONE flag do not match
                  Replaced += 1: redim as MUs MostUsed(1 to 1)
                  'let's check for the most used flag and set as default BrushContent
                  for x as ubyte = 1 to ubound(BrushFace)
                    FUNC_READSURF(BrushFace(x))
                    for l as ubyte = 1 to ubound(MostUsed)+1
                      if l = ubound(MostUsed)+1 then
                        redim preserve MostUsed (1 to ubound(MostUsed)+1)
                        MostUsed(ubound(Mostused)).FlagVal  = val(PlaneData(10))
                        MostUsed(ubound(MostUsed)).Counter  = 1
                        exit for
                      else
                        if MostUsed(l).FlagVal = val(PlaneData(10)) then MostUsed(l).Counter += 1:exit for
                      end if
                    next l
                  next x
                  if ((TEMP_ToolFlag and F_ZERO) = 0) then    'set FLAG 0 count to -1, so it's discarded for good
                    for l as ubyte = 1 to ubound(MostUsed)
                      if MostUsed(l).FlagVal = 0 then MostUsed(l).Counter = -1:exit for
                    next l
                  end if
                  for x as ubyte = 1 to ubound(MostUsed)-1
                    if (MostUsed(x).Counter > MostUsed(x+1).Counter) then BrushContent = MostUsed(x).FlagVal:MostCount = MostUsed(x).Counter
                  next x
                  Initial = chr$(34)+RETURNFlags(BrushContent,2)+chr$(34)
                  if len(Initial) = 2 then Initial = "DEFAULT CONTENT"
                  LogPrint ("Entity "+str$(TotalEntities-1)+", Brush "+str$(BrushNumber-1)+": mixed face contents -- new content "+Initial)
                  'now, let's rewrite all those lines in MapData
                  dim as uinteger MCL = k-(ubound(Brushface))
                  for x as uinteger = 1 to ubound(BrushFace)
                    FUNC_READSURF(MapData(MCL+(x-1)))
                    PlaneData(10) = str$(BrushContent)
                    MapData(MCL+(x-1)) = PlaneData(1)+" "+PlaneData(2)+" "+PlaneData(3)+" "+PlaneData(4)+" "+str$(val(PlaneData(5)))+" "+str$(val(PlaneData(6)))+" "+str$(val(PlaneData(7)))+" "+str$(val(PlaneData(8)))+" "+str$(val(PlaneData(9)))+" "+str$(val(PlaneData(10)))+" "+str$(val(PlaneData(11)))+" "+str$(val(PlaneData(12)))
                  next x
                  'Reset MostUsed and shit.
                  redim MostUsed(1 to 1): NeedAFix = 0
                end if
              end if
              DataLevel -= 1
            else
              if (DataLevel = 2) then
                FUNC_READSURF(MapData(k))
                if (BrushNumber = OldBrushNumber) and (TotalEntities = OldTotalEntities) then
                  redim preserve BrushFace(1 to ubound(BrushFace)+1)
                  BrushFace(ubound(BrushFace)) = MapData(k)
                  if (val(PlaneData(10)) <> BrushContent) and (NeedAFix= 0) then NeedAFix = 1
                else
                  redim BrushFace(1 to 1) 'we're starting a brand new brush, reset stack
                  BrushFace(1) = MapData(k)
                  BrushContent = val(PlaneData(10))
                  OldBrushNumber  = BrushNumber
                  OldTotalEntities = TotalEntities
                end if                
              end if
            end if
          next k
          if Replaced > 1 then print "done ("+str$(Replaced)+" brushes fixed)" else print "done ("+str$(Replaced)+" brush fixed)"
        END SUB
        
        ' Asign new content flags based on texture name
        '-----------------------------------------------------------------------        
        sub APPLY_CONTENTFLAGS()
          print "Setting cpntents... ";
          TotalEntities = 0: BrushNumber = 0
          dim as string     TextureName, Initial, Became
          dim as ubyte      DataLevel, IsDetail
          dim as uinteger   Replaced
          for k as uinteger = 1 to ubound(MapData)
            if (mid$(MapData(k),1,1) = "{") then
              DataLevel += 1 'add ONE (one: new entity, two: new brush)
              if DataLevel = 1 then
                TotalEntities += 1: BrushNumber = 0:OldBrushNumber = -1: OldTotalEntities = -1 'rester BrushNumber
              elseif DataLevel  =2 then
                BrushNumber += 1: OldBrushNumber = -1
              end if
            elseif mid$(MapData(k),1,1) = "}" then
              DataLevel -= 1
            else
              if (DataLevel = 2) then
                FUNC_READSURF(MapData(k))
                if (val(PlaneData(10)) and Square(28)) then IsDetail = 1 else IsDetail = 0
                Texturename = FUNC_CleanDir(lcase$(PlaneData(4)))
                for y as uinteger = 1 to ubound(TextureUse)
                  if (TextureUse(y).Filename = Texturename) and (TextureUse(y).FlagCont <> val(PlaneData(10))) and (TextureUse(y).Available = 1) then
                    if ((TotalEntities <> OldTotalEntities) or (BrushNumber <> OldBrushNumber)) then LogPrint ("--Entity "+str$(totalEntities)+", brush "+str$(BrushNumber)+"--")
                    OldTotalEntities = totalEntities: OldBrushNumber = BrushNumber
                    Initial = chr$(34)+RETURNFlags(val(PlaneData(10)),2)+chr$(34)
                    Became = chr$(34)+RETURNFlags(TextureUse(y).FlagCont+(Square(28)*IsDetail),2)+chr$(34)
                    if len(Initial) = 2 then Initial = "NOTHING"
                    if len(Became) = 2 then Became = "NOTHING"                      
                    LogPrint ("["+Texturename+"] "+Initial+" >> "+Became)
                    PlaneData(10) = str$(TextureUse(y).FlagCont+(Square(28)*IsDetail))
                    MapData(k) = PlaneData(1)+" "+PlaneData(2)+" "+PlaneData(3)+" "+PlaneData(4)+" "+str$(val(PlaneData(5)))+" "+str$(val(PlaneData(6)))+" "+str$(val(PlaneData(7)))+" "+str$(val(PlaneData(8)))+" "+str$(val(PlaneData(9)))+" "+str$(val(PlaneData(10)))+" "+str$(val(PlaneData(11)))+" "+str$(val(PlaneData(12)))
                    Replaced += 1: exit for
                  end if
                next y
              end if
            end if
          next k
          if Replaced > 1 then print "done ("+str$(Replaced)+" face contents replaced)" else print "done ("+str$(Replaced)+" face content replaced)"          
        end sub
        