unit AlsoInc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

type
  TFormInclude = class(TForm)
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    FilterComboBox: TFilterComboBox;
    GroupBox1: TGroupBox;
    EditRule: TEdit;
    MemoUsage: TMemo;
    BtnOK: TButton;
    BtnCancel: TButton;
    BtnAdd: TButton;
    MemoSorry: TMemo;
    procedure BtnOKClick(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure DirectoryListBoxChange(Sender: TObject);
    procedure MemoSorryClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormInclude: TFormInclude;

implementation

uses
   Main;

var
   preceding: string;

{$R *.dfm}

{==============================================================================}
procedure TFormInclude.BtnOKClick(Sender: TObject);
var
   i: integer;
   s: string;
begin
   if FileListBox.SelCount = 0 then
   begin
      MessageDlg('Please select file(s).', mtInformation, [mbOK], 0);
   end
   else begin
      for i := 0 to FileListBox.Items.Count - 1 do
      begin
         if FileListBox.Selected[i] then
         begin
            s := preceding+'/'+FileListBox.Items[i];
            MainForm.ListBoxInclude.Items.Add(s);
            CustomList.Add(s);
         end;
      end;
      ModalResult := mrOK;
   end;
end;

{==============================================================================}
procedure TFormInclude.BtnAddClick(Sender: TObject);
var
   c: char;
   s: string;
begin
   c := EditRule.Text[Length(EditRule.Text)];
   if c in ['/','\'] then
   begin
      MessageDlg('Incomplete rule.', mtInformation, [mbOK], 0);
   end
   else begin
      s := EditRule.Text;
      MainForm.ListBoxInclude.Items.Add(s);
      MainForm.ApplyIncludeRule(s,arAddToList);
      ModalResult := mrOK;
   end;
end;

{==============================================================================}
procedure TFormInclude.BtnCancelClick(Sender: TObject);
begin
   ModalResult := mrCancel;
end;

{==============================================================================}
procedure TFormInclude.DirectoryListBoxChange(Sender: TObject);
begin
   if Pos(KingpinInstallDir,DirectoryListBox.Directory) = 0 then
   begin
      FileListBox.Visible := False;
      FilterComboBox.Visible := False;
      MemoSorry.Visible := True;
   end
   else begin
      MemoSorry.Visible := False;
      FileListBox.Visible := True;
      FilterComboBox.Visible := True;
      preceding := StringReplace(DirectoryListBox.Directory, KingpinInstallDir, '', [rfReplaceAll,rfIgnoreCase]);
      preceding := StringReplace(preceding,'\','/',[rfReplaceAll]);
      EditRule.Text := preceding+'/';
    end;
end;

{==============================================================================}
procedure TFormInclude.MemoSorryClick(Sender: TObject);
begin
   DirectoryListBox.Directory := KingpinInstallDir;
end;

end.
