/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.entdata;

import com.technofovea.hl2parse.entdata.MapEntity;
import com.technofovea.hl2parse.entdata.PathFixer;
import com.technofovea.hl2parse.entdata.ValueSource;
import com.technofovea.hl2parse.fgd.FgdEntClass;
import com.technofovea.hl2parse.fgd.FgdProperty;
import com.technofovea.hl2parse.fgd.FgdSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFinder {
    private static final Logger log = LoggerFactory.getLogger(DependencyFinder.class);
    public static final String BASECLASS = "BaseClass";
    public static final String PROPTYPE_MATERIAL = "material";
    public static final String PROPTYPE_SCENE = "scene";
    public static final String PROPTYPE_SOUND = "sound";
    public static final String PROPTYPE_SPRITE = "sprite";
    public static final String PROPTYPE_MODEL = "studio";
    public static final String PROPTYPE_DECAL = "decal";
    public static final ValueSource TYPE_SKYBOX = new ValueSource("worldspawn", "skyname", "string");
    public static final ValueSource TYPE_COLOR_CORRECTION = new ValueSource("color_correction", "filename", "string");
    public static final ValueSource TYPE_COLOR_CORRECTION_VOLUME = new ValueSource("color_correction_volume", "filename", "string");
    FgdSpec fgd;
    List<MapEntity> entities;
    List<ValueSource> allSources = new ArrayList<ValueSource>();
    PathFixer fixer;

    public DependencyFinder(FgdSpec spec, List<MapEntity> entities, PathFixer fixer) {
        this.fgd = spec;
        this.entities = entities;
        this.fixer = fixer;
        this.createCache();
    }

    void createCache() {
        log.debug("Creating entity property cache structures");
        this.allSources = new ArrayList<ValueSource>();
        for (String classname : this.fgd.getEntClassNames()) {
            FgdEntClass entclass = this.fgd.getEntClass(classname);
            if (entclass.getType().equalsIgnoreCase(BASECLASS)) {
                log.trace("Skipping baseclass {}", (Object)entclass.getType());
                continue;
            }
            FgdEntClass combined = entclass.getInherited(this.fgd);
            Map<String, FgdProperty> props = combined.getProps();
            for (String propname : props.keySet()) {
                FgdProperty prop = props.get(propname);
                ValueSource newVal = new ValueSource(classname, propname, prop.getType());
                this.allSources.add(newVal);
            }
        }
        this.allSources.addAll(this.getSpecialWorldspawnCases());
    }

    List<ValueSource> getSpecialWorldspawnCases() {
        ArrayList<ValueSource> ret = new ArrayList<ValueSource>();
        ret.add(new ValueSource("worldspawn", "detailmaterial", PROPTYPE_MATERIAL));
        return ret;
    }

    public PathFixer getFixer() {
        return this.fixer;
    }

    public void setFixer(PathFixer fixer) {
        this.fixer = fixer;
    }

    public Set<ValueSource> getPropertiesByType(String type) {
        HashSet<ValueSource> matching = new HashSet<ValueSource>();
        for (ValueSource candidate : this.allSources) {
            if (!type.equalsIgnoreCase(candidate.getDataType())) continue;
            matching.add(candidate);
        }
        return matching;
    }

    public List<String> getValues(ValueSource valSrc) {
        ArrayList<String> ret = new ArrayList<String>();
        for (MapEntity ent : this.entities) {
            String entClass = ent.getEntityClass();
            String propName = valSrc.getPropertyName();
            if (!entClass.equalsIgnoreCase(valSrc.getClassName()) || !ent.containsKey(propName)) continue;
            List<String> rawStrings = ent.getValues(valSrc.getPropertyName());
            ArrayList<String> fixedStrings = new ArrayList<String>(rawStrings.size());
            for (String s : rawStrings) {
                String fixed = this.fixer.fixPath(s, valSrc);
                if (fixed.startsWith(this.fixer.getNonPathPrefix())) {
                    log.debug("Skipping apparent non-path: {}", (Object)fixed.substring(this.fixer.getNonPathPrefix().length()));
                }
                fixedStrings.add(fixed);
            }
            ret.addAll(fixedStrings);
        }
        return ret;
    }
}

