/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.mdl;

import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.mdl.PhyParseException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhyData {
    protected static final Charset CHARSET = Charset.forName("ASCII");
    private static final Logger logger = LoggerFactory.getLogger(PhyData.class);
    ByteBuffer bb;
    int id = -1;
    int checksum = 0;
    int solidCount = 0;
    ByteBuffer[] collisionSections = null;
    String propData = null;

    public PhyData(ByteBuffer bb) throws PhyParseException {
        this.bb = bb;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        logger.debug("Parsing phy data, {} remaining", (Object)this.bb.remaining());
        try {
            this.load();
        }
        catch (BufferUnderflowException bue) {
            throw new PhyParseException(bue);
        }
    }

    private void load() {
        int hdrsize = this.readInt();
        this.id = this.readInt();
        this.solidCount = this.readInt();
        this.checksum = this.bb.getInt();
        int extra = hdrsize - this.bb.position();
        if (extra > 0) {
            this.bb.position(this.bb.position() + extra);
        }
        this.collisionSections = new ByteBuffer[this.solidCount];
        for (int i = 0; i < this.collisionSections.length; ++i) {
            int len = this.bb.getInt();
            int oldLimit = this.bb.limit();
            this.bb.limit(this.bb.position() + len);
            ByteBuffer sectionData = this.bb.slice();
            sectionData.order(ByteOrder.LITTLE_ENDIAN);
            this.bb.position(this.bb.limit());
            this.bb.limit(oldLimit);
            this.collisionSections[i] = sectionData;
        }
        this.propData = ParseUtil.readString(this.bb, this.bb.remaining());
    }

    private int readShort() {
        return this.bb.getShort();
    }

    private int readInt() {
        return this.bb.getInt();
    }

    private byte[] readBytes(int count) {
        byte[] ret = new byte[count];
        this.bb.get(ret);
        return ret;
    }

    private byte readByte() {
        return this.bb.get();
    }

    private float readFloat() {
        return this.bb.getFloat();
    }

    private String readString(int len) {
        return ParseUtil.readString(this.bb, len);
    }

    private int[] readIntArray(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.bb.getInt();
        }
        return ret;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public ByteBuffer[] getCollisionSections() {
        return this.collisionSections;
    }

    public int getId() {
        return this.id;
    }

    public String getPropData() {
        return this.propData;
    }

    public int getSolidCount() {
        return this.solidCount;
    }
}

