/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.bsp;

import com.technofovea.hl2parse.bsp.BspParseException;
import java.nio.ByteBuffer;

public class BspLumpHeader {
    protected static int IDENT_LEN = 4;
    protected int offset;
    protected int length;
    protected int version;
    protected byte[] identCode = new byte[IDENT_LEN];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BspLumpHeader(ByteBuffer lumpData) throws BspParseException {
        int originalPosition = lumpData.position();
        boolean resetPosition = true;
        try {
            this.offset = lumpData.getInt();
            this.length = lumpData.getInt();
            this.version = lumpData.getInt();
            lumpData.get(this.identCode);
            if (this.offset < 0) {
                throw new BspParseException("Lump header has negative offset");
            }
            if (this.length < 0) {
                throw new BspParseException("Lump header has negative length");
            }
            resetPosition = false;
        }
        finally {
            if (resetPosition) {
                lumpData.position(originalPosition);
            }
        }
    }

    public byte[] getIdentCode() {
        return this.identCode;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getVersion() {
        return this.version;
    }
}

