//Quake2 .md2 file viewer
//source code released on Dec 8, 1997
//by Trey Harrison    -     trey@crack.com
//learn. do not steal.

#include <windows.h>
#include <math.h>
#include <glide.h>
#include "md2view.h"

static char szAppName[] = "MD2View";

LRESULT CALLBACK Md2WindowProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{	
  PAINTSTRUCT ps;
  HDC         hdc;

  switch (iMsg)
  {
 	case WM_PAINT:		
		BeginPaint(hwnd,&ps);
		EndPaint(hwnd,&ps);
    hdc = GetDC(hwnd);
    //i dunno why the 3dfx sometimes switches back to VGA display.
    //this will tell them how to get it back, if it happens
    TextOut(hdc,
            0,
            0,
            "READ README.TXT FOR INSTRUCTIONS",
            32);
    
    TextOut(hdc,
            0,
            GetSystemMetrics(SM_CYSCREEN)/2,
            "Hit Left Control + F9 to view the model",
            39);

    ReleaseDC(hwnd,hdc);
    return 0;		

  case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
  
  return(DefWindowProc(hwnd,iMsg,wParam,lParam));
}

HWND StartWindow(HINSTANCE hInstance, int iCmdShow)
{
  HWND                hwnd;
  WNDCLASSEX            wc;

  wc.cbSize        = sizeof(wc);
  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = Md2WindowProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon(hInstance, IDI_APPLICATION);
  wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground = GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = szAppName;
  wc.hIconSm       = LoadIcon(hInstance, IDI_APPLICATION);
  RegisterClassEx(&wc);
    
  hwnd = CreateWindowEx(
         0,							
         szAppName,
         szAppName,
         WS_POPUP,        
		     0,
         0,
         GetSystemMetrics(SM_CXSCREEN),
		     GetSystemMetrics(SM_CYSCREEN),
		     GetDesktopWindow(),
		     NULL,
         hInstance,
         NULL );    
    
  ShowWindow(hwnd, SW_SHOWNORMAL);
  UpdateWindow(hwnd);
	 
  mainhwnd = hwnd;
	return(hwnd);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	HWND                 hwnd;
	MSG                  msg;
	GrHwConfiguration    hwconfig;
	GrFog_t              fogtable[GR_FOG_TABLE_SIZE];	
	float                xrot,yrot,zrot,Zdist,speed;
	int                  dx,dy,last_x,last_y,frame_int,draw_skin;
  float                frame,skin_interp;
  int                  cur_skin_num;
	char                 mdlname[256];		
  char                 pakname[256];
  char                 pcxname[256];
  char                 lstname[256];
  char                 *cmdline_skin;
  int                  screen_x,screen_y;
  int                  i,key_num;
  POINT                pt;		  

  ExtractExtName(".md2",szCmdLine,mdlname);	
  ExtractExtName(".pak",szCmdLine,pakname);  
  ExtractExtName(".pcx",szCmdLine,pcxname);
	ExtractExtName(".lst",szCmdLine,lstname);

  //was the skin name overridden on the command line?
  if (pcxname[0])
    cmdline_skin = pcxname;
  else
    cmdline_skin = 0;

  //no pak specified? try to load directly
  if (pakname[0]==0)
    model = LoadMDLFromMDL(mdlname);
  else
  {
    if (mdlname[0]==0)
    {
      //just a pak file? create mdlfiles.txt
      WriteMdlList(pakname);
      exit(0);
    }
    else
    {
      model = LoadMDLFromPAK(pakname,mdlname);
    }
  }

  if (lstname[0])
  {
    //if a moron specifies a .pcx AND a .lst, just ignore the .pcx
    cmdline_skin = 0;
    AddSkinNamesToModel(lstname,model);
  }
  SetIntelPrecision();
	
  hwnd = StartWindow(hInstance,iCmdShow);

  grGlideInit();
	
	if (!grSstQueryHardware(&hwconfig)) 
		ExitWithError("grSstQueryHardware failed");		
    
	grSstSelect(0);
    
  if (!grSstOpen(GR_RESOLUTION_640x480,
                 GR_REFRESH_60Hz,
                 GR_COLORFORMAT_ARGB,
                 GR_ORIGIN_UPPER_LEFT,
                 GR_SMOOTHING_ENABLE,2))
	  ExitWithError("grSstOpen failed");

  cur_skin_num = 0;
  InitModelTexture(model,pakname,cur_skin_num,cmdline_skin);
	
  //sets up color mode for gouraud shaded texturemapping	
  guColorCombineFunction(GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB);
  
  //bilinear filtering ON
  grTexFilterMode(GR_TMU0,GR_TEXTUREFILTER_BILINEAR,GR_TEXTUREFILTER_BILINEAR);
  
  //texture wrap ON
  grTexClampMode(GR_TMU0,GR_TEXTURECLAMP_WRAP,GR_TEXTURECLAMP_WRAP);  

  //setup for "decal" mapping.
	grTexCombine(GR_TMU0,GR_COMBINE_FUNCTION_LOCAL,GR_COMBINE_FACTOR_NONE,GR_COMBINE_FUNCTION_LOCAL,GR_COMBINE_FACTOR_NONE,FXFALSE,FXFALSE);
  
  //setup fog stuph
  grFogMode( GR_FOG_WITH_TABLE );
	grFogColorValue( 0x00000000 );
	guFogGenerateExp2(fogtable,0.003f);
	grFogTable( fogtable );
	
	//wbuffer, obviously (1/z sorting)
  grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);		
  grDepthBufferFunction(GR_CMP_LESS);
	grDepthMask(FXTRUE);
	
  grCullMode(GR_CULL_DISABLE);//NEGATIVE);

  xrot = 0.f;
  yrot = 0.f;
  zrot = 0.f;
  
	skin_interp = 0.f;

  frame = 0.0;  
	Zdist = 100.f;
  speed = 0.125;
	
  //set initial mouse coordinates
  last_x = GetSystemMetrics(SM_CXSCREEN)/2;
  last_y = GetSystemMetrics(SM_CYSCREEN)/2;
  
  SetCursorPos(last_x,last_y);	
  
  //sometimes keypresses are leftover from startup.
  //dont want to accidentally trigger these 
  while (keywaspressed('S'));
  while (keywaspressed(VK_RETURN));
  while (keywaspressed(VK_TAB));

  for (i=0; i<10; i++)         
    while (keywaspressed(i+'0'));
  
  screen_x = 320;
  screen_y = 270;

  draw_skin = 0;

  while (1)
  {
    //clear the back buffer
    grBufferClear(0x00000000,0,GR_WDEPTHVALUE_FARTHEST);					  

    //whats the base frame we're on?
    frame_int = (int)frame;

    if (!keydown('I'))
    {      
      //draw without linear interpolation
      //frame-frame_int tells us how much to interpolate between this
      //and the next frame
      DrawModel(model,xrot,yrot,zrot,frame_int,frame-frame_int,screen_x,screen_y,Zdist,skin_interp);
    }
    else
    {
		  //draw with linear interpolation
      DrawModel(model,xrot,yrot,zrot,frame_int,0,screen_x,screen_y,Zdist,skin_interp);
    }
		
		while (grBufferNumPending());
		grBufferSwap(1);

		//account for keyboard input
    if (keydown(VK_UP))      screen_y--;		
    if (keydown(VK_DOWN))    screen_y++;
    
    if (keydown(VK_LEFT))    screen_x--;
    if (keydown(VK_RIGHT))   screen_x++;

    if (keydown('A'))        Zdist -= 1;
    if (keydown('Z'))        Zdist += 1;

    if (keydown(VK_ESCAPE)) DestroyWindow(hwnd);
		
		if (keydown(VK_ADD))       speed += 0.001;
    if (keydown(VK_SUBTRACT))  speed -= 0.001;

    if (keydown(VK_LBUTTON)) Zdist -= 1;
    if (keydown(VK_RBUTTON)) Zdist += 1;    
    
    //account for mouse input
    GetCursorPos(&pt);
    ScreenToClient(hwnd,&pt);
 
    dx = pt.x - last_x;
	  dy = pt.y - last_y;    
  
    xrot += dy;
    yrot -= dx;    

    pt.x = last_x;
    pt.y = last_y;
    
    ClientToScreen(hwnd,&pt);
    SetCursorPos(pt.x,pt.y);	
    
    if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
      if (msg.message == WM_QUIT) break;
      TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		
		if (!keydown('F') && (skin_interp == 0.f)) frame += speed;

    if (draw_skin)
    {
      if (skin_interp < 1.f)
        skin_interp += 0.02f;
      
      if (skin_interp > 1.f)
        skin_interp = 1.f;
    }
    else
    {
      if (skin_interp > 0.f)
        skin_interp -= 0.02f;
      
      if (skin_interp < 0.f)
        skin_interp = 0.f;
    }

    if (keywaspressed(VK_RETURN))
      draw_skin = !draw_skin;

    if (keywaspressed('S'))
      Write3dfxTga();        
    
    //process skin-changing keys
    if (model->num_skins)
    {
      if (keywaspressed(VK_TAB))
      {
        if (keydown(VK_SHIFT))
          cur_skin_num--;
        else
          cur_skin_num++;
              
        if (cur_skin_num>=model->num_skins)
          cur_skin_num = 0;
        else
        if (cur_skin_num < 0)
          cur_skin_num = model->num_skins-1;
        
        InitModelTexture(model,pakname,cur_skin_num,cmdline_skin);
      }
    
      for (i=0,key_num='0'; i<10; i++)
      {      
        if (keywaspressed(key_num))
        {
          //key 1 is actually skin 0, key 0 is actually skin 9
          cur_skin_num = key_num - '0' - 1;
          if (cur_skin_num==-1) cur_skin_num = 9;
  
          if (cur_skin_num >= model->num_skins)
            cur_skin_num = model->num_skins-1;

          InitModelTexture(model,pakname,cur_skin_num,cmdline_skin);
          break;
        }
        key_num++;
      }
    }
	}
	grGlideShutdown();	
	FreeModel(model);
	return msg.wParam;
}
