
#include "bsp5.h"
#include "curs.h"
#include <stdarg.h>
#include <signal.h>

int             StatusLine;             /* Output line for status info */
long int	StartTime;
long int	LastCheck;
int		TotalStatusEntries;	/* How many status entries have gone by (out of 32) */
int		CurPercent;
int		CurMajorPercent;

long int	TotalAlloc = 0L;
long int	LastAlloc = 0L; 	/* To keep speed up */

void ScrnShutDown(void)
{
	long int now = (long)I_FloatTime ();
	long int diff = now - StartTime;

	fflush(stdout);

        InitText();
	if (LogFile != NULL) {
		fflush(LogFile);
		fclose(LogFile);
        }

	printf("Ctrl+C hit.  Aborting compile after %02ld:%02ld:%02ld.\n",
		diff / 360, (diff / 60) % 59, diff % 59, TotalAlloc);
	fflush(stdout);

	exit(-1);
}

void ScrnInit(void)
{
        InitText();

	signal(SIGINT, ScrnShutDown);
	signal(SIGQUIT, ScrnShutDown);

	LastCheck = StartTime = (long)I_FloatTime ();

        SetForeColor(ANSI_WHITE);
	SetBackColor(ANSI_BLUE);
	DrawFilledBox(0,0, ScrnWidth,ScrnHeight);

	CurPercent = CurMajorPercent = -1;
        StatusLine = 5;
        
	MoveCurs(2, 1);
	SetForeColor(ANSI_WHITE);
	SetBackColor(ANSI_BLUE);
	DrawVLine(45, 5, ScrnHeight-6);
	DrawHLine(1,4, ScrnWidth-2);
	MoveCurs(2, 3);
	CPrintf("$f3Elapsed time: $f200:00:00       $f30 $f7Kbytes $f4--------------------------------------$f3");
	MajorPercentBar(0);
        PercentBar(0);
}

void ShowStatusEntry(char *format, ...)
{
	char text[1024];
	va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	SetBackColor(ANSI_BLUE);
	SetForeColor(ANSI_WHITE);

        if (StatusLine > ScrnHeight-2) {
		CopyText(2, 8, 42, ScrnHeight-9, 2, 7);
		FillBox(1, ScrnHeight-2, 42, 1, ' ');
		StatusLine--;
        }

        MoveCurs(2, StatusLine);
	CPrintf("%s", text);

	if (LogFile != NULL)
		CfPrintf(LogFile, "%s", text);

        StatusLine++;

        PrintBSPFileSizes();
	TimeUpdate();
}

void ShowTempEntry(char *format, ...)
{
	char text[1024];
	va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	SetBackColor(ANSI_BLUE);

        if (StatusLine > ScrnHeight-2) {
		SetForeColor(ANSI_WHITE);
		CopyText(2, 8, 42, ScrnHeight-9, 2, 7);
		FillBox(1, ScrnHeight-2, 42, 1, ' ');
		StatusLine--;
        }

        SetForeColor(ANSI_GREEN);

	MoveCurs(4, StatusLine);
	CPrintf("%s", text);

	if (LogFile != NULL)
		CfPrintf(LogFile, "$t%s", text);

	StatusLine++;

	PrintBSPFileSizes();
	TimeUpdate();
}

void ShowWarningEntry(char *format, ...)
{
	char text[1024];
	va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	SetBackColor(ANSI_BLUE);

        if (StatusLine > ScrnHeight-2) {
		SetForeColor(ANSI_WHITE);
		CopyText(2, 8, 42, ScrnHeight-9, 2, 7);
		FillBox(1, ScrnHeight-2, 42, 1, ' ');
		StatusLine--;
        }

	SetForeColor(ANSI_RED);

	MoveCurs(4, StatusLine);
	CPrintf("$f1*** %s", text);

	if (LogFile != NULL)
		CfPrintf(LogFile, "*** %s", text);

	StatusLine++;

	PrintBSPFileSizes();
	TimeUpdate();
}

void PercentBar(int percent)
{
        if (percent > 256) percent = 256;

        if (percent != CurPercent) {
		int n = (percent * 38) / 256;

		SetBackColor(ANSI_BLUE);
		SetForeColor(ANSI_GREEN);
		FillBox(40, 3, n, 1, '#');
		SetForeColor(ANSI_BLUE);
		FillBox(40+n, 3, 38-n, 1, '-');

                CurPercent = percent;
        }
        TimeUpdate();
}

void MajorPercentBar(int percent)
{
	if (percent > 256) percent = 256;

        if (percent != CurMajorPercent) {
		int n = (percent * 76) / 256;

		SetBackColor(ANSI_BLUE);
		SetForeColor(ANSI_GREEN);
		FillBox(2, 2, n, 1, '#');
		SetForeColor(ANSI_BLUE);
		FillBox(2+n, 2, 76-n, 1, '-');

                CurMajorPercent = percent;
        }

        TimeUpdate();   
}

void TimeUpdate(void)
{
	long int now = (long)I_FloatTime ();

	if (now != LastCheck) {
		long int diff = now - StartTime;

		if (diff > 0) {
			MoveCurs(16, 3);
			CPrintf("$f2%02ld:%02ld:%02ld $f3%7ld$f7 Kbytes", diff / 360, (diff / 60) % 59, diff % 59, TotalAlloc/1024L);
		}
		LastCheck = now;
        }
}

void CfPrintf(FILE *file, char *format, ...)
{
	register char c;
	register char *ptr, *src;
        char text[1024];
	char text2[1024];
        va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	for (ptr = text2, src = text; *src != '\0'; src++) {
		c = *src;

		if (c == '$') {
			switch (*++src) {
			case '$':
				*ptr++ = '$';
                                break;
                        case 'a':
				*ptr = '\0';
				fputs(ptr = text2, file);
                                break;
			case 't':
				*ptr = '\0';
				cputs(ptr = text2);
				fputs("\t", file);
                                break;
                        case 'n':
				*ptr = '\0';
				cputs(ptr = text2);
				fputs("\n", file);
                                break;
			case 'f':
				*ptr = '\0';
				fputs(ptr = text2, file);
                                ++src;
                                break;
			case 'b':
				*ptr = '\0';
				fputs(ptr = text2, file);
                                ++src;
				break;
			case 'c':
				*ptr = '\0';
				fputs(ptr = text2, file);
				++src;
				break;
                        }
                }
		else if (c >= 32 && c <= 126)
			*ptr++ = c;
	}
	*ptr = '\0';
	fputs(ptr = text2, file);
	fputs("\n", file);

	fflush(file);
}

void *qmalloc(int size)
{
#undef malloc
	int total = size + sizeof(int);
	void *mem = malloc(total);
	long int diff;

	if (mem == NULL)
		Error("Insufficient memory.");

	*((int *)mem) = size+sizeof(int);
	TotalAlloc += total;

	diff = TotalAlloc - LastAlloc;
	if (diff < 0L) diff = -diff;
	if (diff > 131072L) {
		LastAlloc = TotalAlloc;
		LastCheck = -1L;
                TimeUpdate();
        }

        return(mem + sizeof(int));
}

void qfree(void *mem)
{
#undef free
	long int diff;

        mem -= sizeof(int);

	TotalAlloc -= *((int *)mem);

	diff = TotalAlloc - LastAlloc;
	if (diff < 0L) diff = -diff;
	if (diff > 131072L) {
		LastAlloc = TotalAlloc;
		LastCheck = -1L;
                TimeUpdate();
        }

        free(mem);
}

