/* lighting.c */

#include "light.h"
#include "curs.h"

/*

NOTES
-----

*/

float		scaledist = 1.0;
float		scalecos = 0.5;

byte		*filebase, *file_p, *file_end;

dmodel_t	*bspmodel;
int			bspfileface;	/* next surface to dispatch */

vec3_t	bsp_origin;

qboolean	extrasamples;

float		minlights[MAX_MAP_FACES];

FILE		*LogFile;

int		nummapbrushes = 0;
int		num_entities = 0;
int		nummiptex = 0;

qboolean	visbsp = 0;
qboolean	visbspfast = 0;
qboolean	fastlight = 0;

long		facebrightness;
long            facebrightnesscount;
long		levelbrightness = 0;

byte *GetFileSpace (int size)
{
	byte	*buf;
	
	LOCK;
	file_p = (byte *)(((long)file_p + 3)&~3);
	buf = file_p;
	file_p += size;
	UNLOCK;
	if (file_p > file_end)
		Error ("GetFileSpace: overrun");
	return buf;
}


void LightThread (void *junk)
{
	int			i;

	ShowStatusEntry("Starting lighting thread.");
	ShowTempEntry("Lighting %d faces total.", numfaces);
        
	MoveCurs(4, 17);
	CPrintf("$b4$f6"
		"$f3-----------------------------" "$n"
		"  $f6Face $f2    0$f6 of $f2%ld$f6  " "$n"
		"    Face number:      $f2    0$f6  " "$n"
		"    Face brightness:  $f2    0$f6  " "$n"
		"    Level brightness: $f2    0$f6  ", (long)numfaces);

        while (1)
	{
		LOCK;
		i = bspfileface++;
		UNLOCK;
		MajorPercentBar(i * 256 / numfaces);
                fflush(stdout);
		if (i >= numfaces) {
			MajorPercentBar(256);
                        return;
		}

                LightFace (i);

                SetForeColor(ANSI_GREEN);
		SetBackColor(ANSI_BLUE);
		MoveCurs(11, 18);
		CPrintf("%5i", i);
		MoveCurs(26, 19);
		CPrintf("%5i$n%5li$n%5li", i, facebrightness,
			(levelbrightness += facebrightness) / bspfileface);
        }

        MoveCurs(4, 17);
	CPrintf("$b4$f6"
		"                             $n"
		"                             $n"
		"                             $n"
		"                             $n"
		"                             ");
}

/*
=============
LightWorld
=============
*/
void LightWorld (void)
{
	filebase = file_p = dlightdata;
	file_end = filebase + MAX_MAP_LIGHTING;

	RunThreadsOn (LightThread);

	lightdatasize = file_p - filebase;
	
	ShowTempEntry("Light data size: %i bytes\n", lightdatasize);
}


/*
========
main

light modelfile
========
*/
int main (int argc, char **argv)
{
	int		i;
        char            source[1024];
	char		log[1024];
        long            diff;

	for (i=1 ; i<argc ; i++)
	{
#if 0
                if (!strcmp(argv[i],"-threads"))
		{
			numthreads = atoi (argv[i+1]);
			i++;
		}
#endif
		if (!strcmp(argv[i],"-extra"))
		{
			extrasamples = true;
		}
		else if (!strcmp(argv[i],"-fast"))
			fastlight = true;
                else if (!strcmp(argv[i],"-v"))
			visbsp = true;
		else if (!strcmp(argv[i],"-vf")) {
			visbsp = true;
                        visbspfast = true;
		}
                else if (!strcmp(argv[i],"-dist"))
		{
			scaledist = atof (argv[i+1]);
			i++;
		}
		else if (argv[i][0] == '-') {
			fprintf(stderr, "light: Unknown option \"%s\"", argv[i]);
		}
                else
			break;
	}

	if (i != argc - 1) {
		fprintf(stderr, "Usage:   light [-extra] [-dist #] [-v] [-vf] bspfile\n"
				"\n"
				"   -extra      Perform extra scans for better lighting\n"
				"   -dist       Set scaling distance to #\n"
				"   -fast       Perform a fast but inaccurate scan\n"
				"   -v          Run \"vis\" when done with lighting\n"
				"   -vf         Run \"vis -fast\" when done with lighting\n");
                exit(-1);
        }

	ScrnInit();
	MoveCurs(2, 1);
	CPrintf("$b4$f7Light$f4 -");

	strcpy (source, argv[i]);
	DefaultExtension (source, ".bsp");

	strcpy(log, source);
	StripExtension(log);
	DefaultExtension (log, ".log");

	LogFile = fopen(log, "at");
	fprintf(LogFile, "\n-------------------------------------------\n"
			 "*** BEGIN LIGHT ***\n\n");

        InitThreads ();

	MoveCurs(10, 1);
	CPrintf("$f2%s", source);

        LoadBSPFile (source);
	LoadEntities ();
		
	MakeTnodes (&dmodels[0]);

	LightWorld ();

	WriteEntitiesToString ();	
	WriteBSPFile (source);

	ShowTempEntry("Average light level: %ld of 255", levelbrightness / (long)numfaces);

	diff = LastCheck - StartTime;
	fprintf(LogFile, "\nLight completed successfully.  Elapsed time: %02d:%02d:%02d\n",
		diff / 360, (diff / 60) % 59, diff % 59);
	fprintf(LogFile, "-------------------------------------------\n\n");
        fclose(LogFile);
	LogFile = NULL;

	InitText();
	printf("Light completed successfully.  Elapsed time: %02d:%02d:%02d\n",
		diff / 360, (diff / 60) % 59, diff % 59);

        if (visbsp) {
		printf("Running vis...\n");

                if (visbspfast)
                        execlp("vis", "vis", "-fast", source, NULL);
		else
			execlp("vis", "vis", source, NULL);
        }

	return 0;
}
