/*
===============================
PCX2WAL (c) Iikka Keranen 1997

An utility to convert PCX files
to Quake2 .wal files. Read
PCX2WAL.TXT for info about usage.
===============================
*/

/* Fixed to work with compilers other than DOS GCC by Petteri Kangaslampi */

#include <stdio.h>
#include <string.h>

/*
======= PROTOTYPES FOR FUNCS =======
*/

short pcxpalload(unsigned char *name);
short pcxload(unsigned char *name, unsigned char *pal);
//short pcxsave(unsigned char *fname, unsigned char *bu, unsigned char *pa, long w, long h);
short mip(char fac);  // fac is always 1?
short pcx2wal(unsigned char *src, unsigned char *dst, unsigned char *name,
              unsigned char *next, long flags, long contents, long value);
long countval(char *str);

/*
======= MAIN =======
Allocates memory, loads files, calls mip-map routine, saves dest. file,
deallocates memory, and says goodbye.
*/

// Glob vars here... indecent, right?-)
unsigned char *srcpic;
unsigned char *dstpic;
unsigned char *palette;
unsigned char *srcpal;
long width, height;

void main(int argc, char *argv[])
{
  unsigned char *animname=NULL;
  long flags=0, contents=0, value=0;
  long x;

  printf("PCX2WAL (c) Iikka Kernen 1997\n\n");
  if (argc<4)
	{
    printf("Usage: PCX2WAL <source> <destination> <name> [options]\n");
    printf("Options:\n");
    printf("-n next     -- next texture frame in animation loop\n");
    printf("-f flags    -- default surface flags (light, slick, warp..)\n");
    printf("-c contents -- default content flags (solid, water, currents..)\n");
    printf("-v value    -- default value (for lighting)\n\n");
    printf("Examples:\n");
    printf("PCX2WAL coolwall.pcx coolwall.wal coolwall\n");
    printf("PCX2WAL animwal0.pcx animwal0.wal animwal0 -n animwal1 -f 1 -v 400\n");
    return;
  }

  for (x=4;x<argc-1;x++)
  {
    if (!strcmp(argv[x],"-n"))
      animname=argv[x+1];
    if (!strcmp(argv[x],"-f"))
      flags=countval(argv[x+1]);
    if (!strcmp(argv[x],"-c"))
      contents=countval(argv[x+1]);
    if (!strcmp(argv[x],"-v"))
      value=countval(argv[x+1]);
  }

  printf("allocing mem for palette...\n");

  palette=(char *)malloc(768);  // always
  srcpal=(char *)malloc(768);  // always
  pcxpalload("palette.pcx");

  printf("starting pcx2wal routine...\n");
  pcx2wal(argv[1], argv[2], argv[3], animname, flags, contents, value);

  free(dstpic);  // dealloc
  free(srcpic);
  free(palette);
}

short pcx2wal(unsigned char *src, unsigned char *dst, unsigned char *name,
              unsigned char *next, long flags, long contents, long value)
{
  FILE *wal;
  long x;

  pcxload(src, srcpal);
  wal=fopen(dst,"wb");
  if (!wal)
  {
    printf("Error: can't write file! Disk full?\n");
    exit(1);
  }
  for (x=0;x<32;x++)
  {
    if (x<strlen(name))
      fputc(name[x],wal);
    else
      fputc(0,wal);
  }
  fwrite(&width,1,4,wal);
  fwrite(&height,1,4,wal);
  x=100;
  fwrite(&x,1,4,wal);
  x+=width*height;
  fwrite(&x,1,4,wal);
  x+=(width/2)*(height/2);
  fwrite(&x,1,4,wal);
  x+=(width/4)*(height/4);
  fwrite(&x,1,4,wal);
  for (x=0;x<32;x++)
  {
    if (next!=NULL && x<strlen(next))
      fputc(next[x],wal);
    else
      fputc(0,wal);
  }
  fwrite(&flags,1,4,wal);
  fwrite(&contents,1,4,wal);
  fwrite(&value,1,4,wal);

//  memcpy(dstpic,srcpic,width*height);
  mip(0);
  fwrite(dstpic,1,width*height,wal);
  mip(1);
  width>>=1; height>>=1;
  fwrite(dstpic,1,width*height,wal);
  memcpy(srcpic,dstpic,width*height);
  mip(1);
  width>>=1; height>>=1;
  fwrite(dstpic,1,width*height,wal);
  memcpy(srcpic,dstpic,width*height);
  mip(1);
  width>>=1; height>>=1;
  fwrite(dstpic,1,width*height,wal);

  fclose(wal);

  return 0;  
}

/*
=======================================
Quick Zsoft PCX load/save funcs
only supports 256 colours,
no functional RLE compression in saving
=======================================
*/

short pcxpalload(unsigned char *name) // Load palette from .pcx..
{
	unsigned long p;
	unsigned long w,h;

	FILE *pcx=fopen(name,"rb");
	if (!pcx)
	{
    printf("Can't find file %s\n",name);
		return(1);
	}
  fseek(pcx,-768,SEEK_END);   // Load palette
  fread(palette,1,768,pcx);
	fclose(pcx);
	return 0;
}

short pcxload(unsigned char *name, unsigned char *pal)
{
	unsigned long p;
	short tavu1,tavu2;
	unsigned long w,h;

	FILE *pcx=fopen(name,"rb");
	if (!pcx)
	{
		printf("Can't find file %s\n",name);
		return(1);
	}
	fseek(pcx,8,SEEK_SET);
/* [Petteri] *LART* The C standard does NOT guarantee left-to-right
   evaluation - this code breaks on at least Watcom C
  w=fgetc(pcx)+(fgetc(pcx)<<8)+1;
	h=fgetc(pcx)+(fgetc(pcx)<<8)+1;
        */
  w=fgetc(pcx);
  w+=(fgetc(pcx)<<8)+1;
  h=fgetc(pcx);
  h+=(fgetc(pcx)<<8)+1;
  width=w;
  height=h;
  printf("allocing mem for pictures...\n");
  srcpic=(char*)malloc(w*h);
  dstpic=(char*)malloc(w*h);

	fseek(pcx,128,SEEK_SET);  // Load image
	for(p=0;p<w*h;)
	{
		tavu1=fgetc(pcx);
		if (tavu1>192)
		{
			tavu2=fgetc(pcx);
			for(;tavu1>192;tavu1--)
        srcpic[p++]=tavu2;
			}
      else srcpic[p++]=tavu1;
		}


	if (pal)
	{
		fseek(pcx,-768,SEEK_END);   // Load palette
		fread(pal,1,768,pcx);
	}
  printf("PCX loaded successfully...\n");

	fclose(pcx);
	return 0;
}

/*
short pcxsave(unsigned char *fname, unsigned char *bu, unsigned char *pa, long w, long h)
{
	short tavu1,tavu2,c,tmp;
	long pos, size, po2;
	FILE *out;
	unsigned char hdr[128];

	if (w==0 || h==0)
		return(1);

	for (c=0;c<128;c++)  // clean up
		hdr[c]=0;

	hdr[0]=10; hdr[1]=5; hdr[2]=1; hdr[3]=8;  // standard PCX header start
	hdr[8] =w-1&0xff; hdr[9] =w-1>>8;           // "Window size"
	hdr[10]=h-1&0xff; hdr[11]=h-1>>8;
  hdr[12]=1; hdr[14]=1; // 256DPI. (TOTALLY unnecessary)
	hdr[65]=1;            // "Nplanes"
	hdr[66]=w&0xff; hdr[67]=w>>8;           // Bytes per line..
	hdr[70]=w&0xff; hdr[71]=w>>8;           // screen size
	hdr[72]=h&0xff; hdr[73]=h>>8;

	out=fopen(fname,"wb");
	if (!out)
	{
		return(1);
	}

	for (pos=0;pos<128;pos++)
		fputc(hdr[pos],out);
	//fwrite(hdr,1,128,out);
	pos=0;
	size=w*h;
	while (pos<size)
	{
		c=bu[pos++];
    if (c>190)
      fputc(193,out);
		fputc(c,out);
	}
	fputc(12,out);
	for (c=0;c<768;c++)
		fputc(pa[c],out);
	fclose(out);

	return 0;
}*/

/*
====================
Mip-mapping routines
====================
*/

short findcol(int r, int g, int b, int beg, int end) // FIND RGB COLOUR
{
	int c1,c=0,e,ee=768;

  for (c1=beg;c1<end;c1++)
	{
    e=abs(palette[c1+c1+c1]-r)+
      abs(palette[c1+c1+c1+1]-g)+
      abs(palette[c1+c1+c1+2]-b);
    if (e<ee)
    {
      c=c1; ee=e;
    }
	}
	return c;
}

short mip(char fac)  // fac is always 1?
{
  long x,y,x1,y1,xs,ys,c,fb,n;
  long r,g,b,vx,vy;
	unsigned int po,po1;
  long w=width, h=height;

  printf("Mip-mapping... ");

  xs=w>>fac;
  ys=h>>fac;

	for(y=0;y<ys;y++)
		for (x=0;x<xs;x++)
		{
			x1=x<<fac; y1=y<<fac;
			r=0;g=0;b=0;fb=0;n=0;
			for (vy=y1;vy<y1+(1<<fac);vy++)
			{
        po1=vy*w+x1;
				for (vx=x1;vx<x1+(1<<fac);vx++)
				{
          c=srcpic[po1];
          r+=srcpal[c*3];
          g+=srcpal[c*3+1];
          b+=srcpal[c*3+2];
          n++;
					po1++;
				}
			}
			r=r*1.0/n+.5;
			g=g*1.0/n+.5;
			b=b*1.0/n+.5;
      c=findcol(r,g,b,0,256);
			po=y*xs+x;
      dstpic[po]=c;
		}

  printf("Done.\n");

	return 0;
}

/*
========
MISC
========
*/

long countval(char *str)
{
  long val=0,n,l;

	l=strlen(str);
	for (n=0;n<l;n++)
		if (str[n]>47 && str[n]<58)
			val=val*10+str[n]-48;

	return val;
}
