
Info = {
   "plug-in":       "Side Tag & Glue",
   "desc":          "Basic Side tagging and gluing to tagged side",
   "date":          "1999",
   "author":        "tiglari",
   "author e-mail": "tiglari@hexenworld.net",
   "quark":         "Version 6" }


import quarkx
import quarkpy.mapmenus
import quarkpy.mapentities
import quarkpy.qmenu
import quarkpy.mapeditor
import quarkpy.mapcommands
from quarkpy.maputils import *

class Tagging:
    tagged = None

def gettagged(o):
    try:
        return o.tagging.tagged
    except (AttributeError): return None

def tagSideClick (m):
    editor = mapeditor()
    #
    #  do we have an editor? the function mapeditor() returns the editor
    #   from which the command was invoked.  If we don't, bail.
    #
    if editor is None: return
    #
    #  attach a new tagging object to it (to keep track of what side
    #  is tagged).  `Tagging()' is the `default constructor', automatically
    #  provided to make a new instance of the class, if no explicit
    #  constructor has been defined
    #
    editor.tagging = Tagging()
    #
    # get the editor's selection-list and stick it in a local variable
    #
    tagged = editor.layout.explorer.sellist
    #
    # now check that what's selected is exactly one side
    #
    if (len(tagged) < 1):
        quarkx.msgbox("No selection", MT_ERROR, MB_OK)
    elif (len(tagged) > 1):
        quarkx.msgbox("Only one selection allowed", MT_ERROR, MB_OK) 
    elif (tagged[0].type!= ":f"):
        quarkx.msgbox("The selected object is not a face", MT_ERROR, MB_OK) 
    #
    # and at last we're ready to rock and roll!
    #
    else:
        #
        #  This actually stashes our tagged side (the first & only
        #  element of a one-element list) in the tagging object
        #  that we've attached to the editor.
        #
        editor.tagging.tagged = tagged[0]
        editor.invalidateviews()



def glueSideClick (m):
    editor = mapeditor()
    if editor is None: return
    tagged = gettagged(editor)
    if tagged is None:
        quarkx.msgbox("Something must be tagged",MT_WARNING,MB_OK)
    #
    # get the selection (which will be a list)
    #
    sides = editor.layout.explorer.sellist
    #
    # check that it meets conditions (this could be done more slickly)
    #
    if len(sides) < 1:
        quarkx.msgbox("Something must be selected for glueing", MT_WARNING, MB_OK)
        return
    if len(sides) > 1:
        quarkx.msgbox("Only one thing may be selected for glueing", MT_WARNING, MB_OK)
        return
    if sides[0].type != ":f":
        quarkx.msgbox("The selection must be a face", MT_WARNING, MB_OK)
    #
    # Now derive the new side
    #
    side = sides[0]
    newside = glueToTagged(side, tagged)
    # First create an `undo' object with the quarkx.action()
    #  function.  This will keep track of the actions performed.
    #
    undo = quarkx.action()
    #
    # Now substitute the new side for the old one (in the undo object)
    #
    undo.exchange(side, newside)
    #
    # and perform the action for real in the map
    #
    undo.ok(editor.Root, "glue to tagged")

def glueToTagged(side, tagged):
    #
    # Make a copy of the original (so that texture etc. info is preserved)
    #
    new = side.copy()
    #
    # .distortion rotates the face into a new position; we have
    #  to make sure that the normal is going to point outward from
    #  its parent poly.
    #
    if new.normal*tagged.normal < 0:
        new.distortion(-tagged.normal, new.origin)
    else: new.distortion(tagged.normal, new.origin)
    #
    #  Now shift our new side into position:
    #
    new.translate(tagged.origin-new.origin)
    return new

def cleartag(editor):
    try:
       del editor.tagging
    except (AttributeError):
       pass
    editor.invalidateviews()

def clearTagClick(m):
    editor = mapeditor()
    if editor is None: return
    cleartag(editor)

def tagfinishdrawing(editor, view, oldfinish=quarkpy.mapeditor.MapEditor.finishdrawing):
    "the new finishdrawing routine"
    oldfinish(editor, view)

    tagged = gettagged(editor)
    if tagged is None: return

    def checktagged(tagged=tagged, editor=editor):
        if not checktree(editor.Root, tagged):
            cleartag(editor)
            return 0
        return 1

    if tagged is None or not checktagged():
        return
    
    #
    # OK, so there is something tagged, so lets draw it.  A `view' is one
    #  of the map-displays on the screen, such as the top-down or side on
    #  one in the classic layout.
    #
    cv = view.canvas()
    #
    # We'll color them like Duplicators so we can see an effect
    #
    cv.pencolor = MapColor("Duplicator")
    #
    #  A face has a list of lists of vertexes.  A list of lists because
    #   each face might be used in several polyhedrons, in each polyhedron
    #   the vertexes are listed in a clockwise order as you move around
    #   the edge of the face's manifestation in the polyhedron.
    #
    for vtx in editor.tagging.tagged.vertices: # for a face-manifestation
        #
        # proj turns a 3D point in the map into a point in the display,
        # as determined by the properties of the view  (it's got three
        # coordinates but the functions of z vary).  We start with the
        # last vertex (index pozzie -1 in Python), and cycle through,
        # connecting the last to the first, and so on
        #
        p2 = view.proj(vtx[-1])
        for v in vtx:
            p1 = p2
            p2 = view.proj(v)
            cv.line(p1,p2)  # draw the line

quarkpy.mapeditor.MapEditor.finishdrawing = tagfinishdrawing



def selFace(editor):
    sel = editor.layout.explorer.sellist
    if len(sel)!=1 or sel[0].type!=":f":
        return None
    return sel[0]

def commandsclick(menu, oldcommand=quarkpy.mapcommands.onclick):
    editor = mapeditor()
    if editor is None: return
    oldcommand(menu)
    mentagside.state = menglueside.state = mencleartag.state = qmenu.normal
    sel = selFace(editor)
    if sel is None:
        mentagside.state = qmenu.disabled
        menglueside.state = qmenu.disabled
    tagged = gettagged(editor)
    if tagged is None:
        menglueside.state = qmenu.disabled
        mencleartag.state = qmenu.disabled
    elif sel == tagged:
        menglueside.state = mentagside.state = qmenu.disabled



quarkpy.mapcommands.onclick = commandsclick

mentagside  = qmenu.item("&Tag Side", tagSideClick)
menglueside = qmenu.item("&Glue to Tagged", glueSideClick)
mencleartag = qmenu.item("&Clear Tag", clearTagClick)

quarkpy.mapcommands.items.append(qmenu.sep)   # separator
quarkpy.mapcommands.items.append(mentagside)
quarkpy.mapcommands.items.append(menglueside)
quarkpy.mapcommands.items.append(mencleartag)

quarkpy.mapcommands.shortcuts["Ctrl+T"] = mentagside
quarkpy.mapcommands.shortcuts["Ctrl+G"] = menglueside



