    '' this could use a lookup list to convert specific entities to other things (fetch an
    '' entity based on multiple fields, convert to another entity), and could also use a
    '' conversion table for texture names... but I'm not sure I care enough. Eh, that'll do
    '' the job. Maybe some days. - ACC
    
    type bspHeader_t field = 1
      as uinteger magic
      as uinteger version 
    end type
    
    type bspLump_t field = 1
      as uinteger offset
      as uinteger length
    end type
    
    type bspFile_t
      as bspHeader_t     header
      as   bspLump_t ptr directory
      as   ubyte ptr ptr buffer
      declare sub initialize()
      declare sub destroy()
      declare sub update()
    end type
    
    '' update lump directory's offsets
    private sub bspFile_t.update()
      dim as integer offset = sizeof(typeof(this.header)) + (sizeof(typeof(*this.directory)) * 19)
      if (this.directory) then
        for i as integer = 0 to 18
          this.directory[i].offset = offset
          offset += this.directory[i].length
        next i
      end if
    end sub

    '' initialize memory (not including actual buffers)
    private sub bspFile_t.initialize()
      this.directory = callocate(sizeof(typeof(*this.directory)) * 19)
      this.buffer    = callocate(sizeof(typeof(*this.buffer))    * 19)
    end sub
    
    '' free memory
    private sub bspFile_t.destroy()
      this.header.magic   = 0
      this.header.version = 0
      if (this.directory) then deallocate(this.directory): this.directory = 0
      if (this.buffer) then
        for i as integer = 0 to 18
          if (this.buffer[i]) then deallocate(this.buffer[i]): this.buffer[i] = 0
        next i
        deallocate(this.buffer): this.buffer = 0
      end if
    end sub
    
    '' load BSP file
    private function loadBSP(byref filename as string, byref bsp as bspFile_t) as integer
      dim as     integer     ff = freefile
      
      if (lcase(right(filename, 4)) <> ".bsp") then filename += ".bsp"
      if (dir(filename, &h23) = "") then return -1 ' file no found
      if (ff = 0) then return -2 ' no handle
      if (open(filename for binary as #ff)) then return -3 ' I/O error
      if (lof(ff) < sizeof(typeof(bsp.header))) then close #ff: return -6 ' Reading outside boundaries
      
      '' loading header
      get #ff,, bsp.header
      if (bsp.header.magic <> &h50534249) then close #ff: return -4 ' not a BSP file
      if (bsp.header.version <> 38) then close #ff: return -5 ' wrong version number
      
      '' loading directory
      get #ff,, *cptr(ubyte ptr, bsp.directory), (sizeof(typeof(*bsp.directory)) * 19)
    
      '' loading chunks
      for i as integer = 0 to 18
        with bsp.directory[i]
          if ((.length + .offset) > lof(ff)) then close #ff: return -6 ' Reading outside boundaries
          if (.length) then
            bsp.buffer[i] = callocate(.length * sizeof(typeof(*bsp.buffer[i])))
            get #ff, .offset + 1, *bsp.buffer[i], .length
          end if
        end with
      next i
    
      '' done
      close #ff
      return 0
    end function
    
    '' write BSP file
    private sub writeBSP(byref filename as string, byref bsp as bspFile_t)
      dim as integer ff = freefile
      
      if (lcase(right(filename, 4)) <> ".bsp") then filename += ".bsp"
      if (dir(filename, &h23) <> "") then kill filename ' erase existing file
      open filename for binary as #ff
      
      '' writing header & directory
      put #ff,, bsp.header
      put #ff,, *cptr(ubyte ptr, bsp.directory), sizeof(typeof(*bsp.directory)) * 19
      
      '' writing each lump
      for i as integer = 0 to 18
        put #ff,, *bsp.buffer[i], bsp.directory[i].length
      next i
      
      close #ff
    end sub
  
    '' super dirty, but that'll do it
    private sub parseEntities(byref buffer as ubyte ptr, byref length as uinteger)
      dim as   string     newBuffer   = ""
      dim as   string     tmpField    = ""
      
      for i as integer = 0 to length - 1
        ' Start/Stop entity
        if ((buffer[i] = &h7B) or (buffer[i] = &h7D)) then
          newBuffer += chr(buffer[i])
          
        ' End of line, could be a field
        elseif (Buffer[i] = &h0A) then
          if (tmpField = "") then
            newBuffer += chr(&h0A)
          else
            dim as    ubyte ptr xPtr        = cptr(ubyte ptr, strptr(tmpField))
            dim as uinteger     xLen        = len(tmpField)
            dim as    ubyte     inField     = 0
            dim as    ubyte     cancelNext  = 0
            dim as   string     key         = ""
            dim as   string     value       = ""
            
            for j as integer = 0 to xLen - 1
              if (cancelNext = 0) then
                if (tmpField[j] = 34) then inField   += 1: continue for
                if (tmpField[j] = 92) then cancelNext = 1
              end if
              
              if (inField = 1) then
                key   += chr(tmpField[j])
              elseif (inField = 3) then
                value += chr(tmpField[j])
              end if
              
              cancelNext = 0
            next j

            if (lcase(key) = "classname") then
              if (value = "ammo_bullets")           then value = "ammo_cylinder"
              if (value = "ammo_cells")             then value = "ammo_308"
              if (value = "ammo_grenades")          then value = "ammo_grenades"
              if (value = "ammo_rockets")           then value = "ammo_rockets"
              if (value = "ammo_shells")            then value = "ammo_shells"
              if (value = "ammo_slugs")             then value = "ammo_flametank"
              
              if (value = "item_armor_body")        then value = "item_armor_helmet_heavy"
              if (value = "item_armor_combat")      then value = "item_armor_legs_heavy"
              if (value = "item_armor_jacket")      then value = "item_armor_jacket_heavy"
              if (value = "item_armor_shard")       then value = "item_health_sm"
              
              if (value = "item_health")            then value = "item_health_sm"
              if (value = "item_health_large")      then value = "item_health_lg"
              if (value = "item_health_mega")       then value = "item_adrenaline"
              if (value = "item_health_small")      then value = "item_health_sm"

              if (value = "item_adrenaline")        then value = "item_adrenaline"
              if (value = "item_bandolier")         then value = "item_pack"
              if (value = "item_breather")          then value = "item_health_sm"
              if (value = "item_enviro")            then value = "item_health_sm"
              if (value = "item_invulnerability")   then value = "item_adrenaline"
              if (value = "item_pack")              then value = "item_pack"
              if (value = "item_power_screen")      then value = "item_armor_jacket_heavy"
              if (value = "item_power_shield")      then value = "item_armor_jacket_heavy"
              if (value = "item_quad")              then value = "item_adrenaline"
              if (value = "item_silencer")          then value = "weapon_spistol"
              
              if (value = "weapon_bfg")             then value = "weapon_heavymachinegun"
              if (value = "weapon_chaingun")        then value = "weapon_tommygun"
              if (value = "weapon_grenadelauncher") then value = "weapon_grenadelauncher"
              if (value = "weapon_hyperblaster")    then value = "weapon_heavymachinegun"
              if (value = "weapon_machinegun")      then value = "weapon_tommygun"
              if (value = "weapon_railgun")         then value = "weapon_flamethrower"
              if (value = "weapon_rocketlauncher")  then value = "weapon_bazooka"
              if (value = "weapon_shotgun")         then value = "weapon_shotgun"
              if (value = "weapon_supershotgun")    then value = "weapon_shotgun"
              
              if (left(value, 8) = "monster_")      then value = "info_null"
            end if
            
            newBuffer += chr(34) + key + chr(34) + " " + chr(34) + value + chr(34) + chr(&h0A)
            tmpField = ""
          end if

        ' Append to line
        else
          tmpField += chr(Buffer[i])
        end if
      next i
      
      '' Trash old buffer, replace with new string
      deallocate(buffer): buffer = 0
      length = len(newBuffer) + 1
      buffer = callocate(length)
      *cptr(zstring ptr, buffer) = newBuffer
    end sub







  dim as bspFile_t bsp
  dim as   integer er = any
  dim as    string source = command(1)
  dim as    string target = command(2)
  
  ? "Super dirty Q2 to KP entity list converter..."
  
  if ((source = "") OR (target = "")) then
    ? "Usage: Q2KPconv <source.bsp> <target.bsp>"
    ? "IMPORTANT: there is NO overwrite check!"
    end
  end if

  '' load BSP file
  bsp.initialize()
  er = loadBSP(source, bsp)
  if (er) then
    if (er = -1) then
      ? "ERROR: file no found"
    elseif (er = -2) then
      ? "ERROR: no handle available (close some files)"
    elseif (er = -3) then
      ? "ERROR: I/O error (file could be locked by another application)"
    elseif (er = -4) then
      ? "ERROR: not a BSP file"
    elseif (er = -5) then
      ? "ERROR: unsupported BSP version"
    elseif (er = -6) then
      ? "ERROR: reading outside boundaries of BSP file (corrupted)"
    else
      ? "ERROR: something went wrong, code " + str(er)
    end if
    bsp.destroy()
    end
  end if

  parseEntities(bsp.buffer[0], bsp.directory[0].length)

  '' write BSP file
  bsp.update()
  writeBSP(target, bsp)

  '' all done
  bsp.destroy()

  ? "Entities converted."
  end
