float4x4 matWVP;
sampler BaseSampler			: register(s0);

struct PEFF_VERTEX {
	float3 position: POSITION0;
	float2 texcoord: TEXCOORD0;
	//fdiffuse is casted to a 32bit integer in FFP mode
	float4 fdiffuse: TEXCOORD1;
};

struct PEFF_TVERTEX {
	float4 Position: POSITION0;
	float2 texcoord: TEXCOORD0;
	float4 fdiffuse: TEXCOORD1;
};

void TransformVertex (in PEFF_VERTEX IN, out PEFF_TVERTEX OUT) 
{
	OUT.Position = mul(float4(IN.position.xyz, 1.0f), matWVP);
	OUT.texcoord = IN.texcoord;
	OUT.fdiffuse = IN.fdiffuse;
}

float4 ColorVertex (in PEFF_TVERTEX v): COLOR0
{
	float4 color;
	float4 base;
	
	base = tex2D(BaseSampler, v.texcoord);
	color = v.fdiffuse * base;
	
	return color;
}

technique techDefault {
	pass p0 { 
		VertexShader	= compile vs_2_0 TransformVertex();
		PixelShader		= compile ps_2_0 ColorVertex();
	}
}