/*
  t2.cpp
		
  Q3Plug 1.2b1
		
  Tribes 2 server query

  Author:   Markus Baumgartner
  Compiler: Microsoft Visual C++ 6.0
  Last Mod: 03/11/2001
	Tab size: 2
*/


#include <assert.h>
#include <string.h>
#include <windows.h>
#include <stdio.h>

#include "npapi.h"
#include "commctrl.h"

#ifndef _T2_H_
#include "t2.h"
#endif

#ifndef _Q3PLUG_H_
#include "q3plug.h"
#endif

// game-specific information
void T2_getInfo(char* text[]) {
  text[0] = "Starsiege Tribes 2";
  text[1] = "Starsiege Tribes 2 server query code written by Markus Baumgartner\nmarkus.baumgartner@liwest.at";
  text[2] = "tribes2.exe";
  text[3] = "-connect IP:%s:%s";                     // connect string used in command line (hostname:port)
}

// column names
void T2_getColumns(char* cols[]) {
  cols[0] = "Ping";
  cols[1] = "Score";
  cols[2] = "Player";
}

// custom compare function to compare columns correctly
int T2_compareFunc(char *val1, char *val2, int sortCol, int sortDir) {
  switch (sortCol) {
    case 0: return sortDir*(atoi(val1) - atoi(val2));
    case 1: return sortDir*(atoi(val1) - atoi(val2));
 	case 2: return sortDir*stricmp(val1,val2);
    default: return 0;
  }
}


// extract sematics from some rules
void T2_checkRule(PluginInstance *This, structRule r) {
}

// extracts a Pascal-style string from a Tribes packet
int ExtractString(char *tmp, char *buf);


// strips invalid characters from string
char *nice_string(char *string) {
  char tmp[256];
  char *cur=tmp;
  char *x = string; 

  if (!string)
    return "";

  strncpy(tmp, string, 255);

  while (*cur) {
    if (*cur >= ' ' && *cur <= 'z')
	  *x++ = *cur;
	cur++;
  }
  *x = 0;
  return string;
}

//  
// check if buffer valid
BOOL T2_initBuffer(PluginInstance *This) {

  assert(This);
  assert(This->buffer);

  structRule rule;
  structPlayer player;
  char string[256], tmp[256];
  char *cur;
  char *x;
  int players;

  // check if packet is valid
  if (!(*This->buffer == 16 || *This->buffer == 20))
    return FALSE; 

  // ping packet?
  if (*This->buffer == 16) {
    cur = This->buffer+6;
	cur += ExtractString(string, cur);
	if (string[3] >= '5')
	  cur+=4;
	cur+=8;
    cur+=ExtractString(string,cur);
    strcpy(This->hostname, string);
    return TRUE;
  }

  cur=This->buffer+6;  // skip header

  // parse
  rule.name = "Game";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Game Version";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Map";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  cur+=1; // skip status byte

  players = *cur++;
  sprintf(This->numplayers, "%d", (char) players);
  sprintf(This->maxclients, "%d", (char) *cur++);
  
  sprintf(string, "%d", (char) *cur++);
  rule.name = "No. bots";
  rule.value = string;
  UI_insertRule(This, rule);

  sprintf(string, "%hu", * (unsigned short *) cur);
  rule.name = "Server CPU speed";
  rule.value = string;
  UI_insertRule(This, rule);
  cur+=2;

  rule.name = "Server Info";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  cur+=2;
  
  // skip to first
  while (*cur != '\t') 
    cur++;
  cur++;
  while (*cur != '\t') 
    cur++;
  while (*cur != 0xa) 
    cur++;

  cur++;
  
  int i=0;
  int score=0;
  while (i++<players) {
    sscanf(cur,"%i", &score);
	  while (*cur != 0xa)
	    cur++;
	  cur+=2;
    x = string;

	  while (*cur != '\t')
		  *x++ = *cur++;
	  *x = 0;
	  cur++;
  
	  while (*cur != '\t') 
      cur++;

	  cur++;

	  player.name = nice_string(string);
	  sprintf(tmp, "%i", score);
	  player.frags = tmp;
	  player.ping = "0";
	  UI_insertPlayer(This, player);
 
  }

  return TRUE;
}


// this function is called when the plugin window is notified of the arrival
// of a packet on its socket
BOOL T2_receivePacket(PluginInstance *p) {
 
  LARGE_INTEGER counter, freq;
  
  int count=0;

  assert(p);
  assert(p->text);
 
  
  p->buffer = (char*) malloc(BUFSIZE);
  assert(p->buffer);

  // clear buffer (don't remove this!)
  unsigned int i=0; unsigned int c=0;
  while ( c < BUFSIZE ) {
		p->buffer[c] = i++ % 255;
		c++;
	}

  /* receive packet */
  if (recv(p->sock, p->buffer, BUFSIZE, 0) == SOCKET_ERROR) {
    wsprintf(p->text, "Receive error (%d)", WSAGetLastError());
    free(p->buffer);
	return FALSE;
  }

  
  // have we already got ping time? if no, get packet time
  if (strlen(p->ping) == 0) {
    if (QueryPerformanceFrequency(&freq) && QueryPerformanceCounter(&counter))
	  p->ticks = 1000*(counter.QuadPart - p->ticks) / freq.QuadPart;
	else
      p->ticks = GetTickCount() - p->ticks; 
  }

  //MessageBox(NULL,p->buffer,"",MB_OK);
	
  if (!T2_initBuffer(p)) {
    strcpy(p->text, "Invalid packet");
	free(p->buffer);
	return FALSE;
  }

   // set packet time and reset status message 
  strcpy(p->text, "");
  sprintf(p->ping,"%d",(int)p->ticks);

  // now we can free the buffer 
  free(p->buffer);
  return TRUE;
}

// Sends a status-request packet to destination server */
BOOL T2_sendPacket(PluginInstance *p) {
  struct sockaddr_in sa;
  LARGE_INTEGER t;
  HOSTENT *host;
  int err,err2;

  assert(p);

  // close socket if still open
  if (isOpen(p->sock))
    closesocket(p->sock);

  /* create new socket */
  p->sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (p->sock == INVALID_SOCKET) {
    wsprintf(p->text, "Socket error (%d)", WSAGetLastError());
    return FALSE;
  }
    
  /* set parameters */
  sa.sin_family = AF_INET;
  sa.sin_port = htons(atoi(p->port));
  sa.sin_addr.S_un.S_addr = inet_addr(p->server);

  if (sa.sin_addr.S_un.S_addr == -1) {
    host = gethostbyname(p->server);
    if (!host) {
      strcpy(p->text, "Invalid server name");
      return FALSE;
    }
    memcpy(&(sa.sin_addr.s_addr), host->h_addr, sizeof(int));
  }
    
  /* send it (finally) */
  err2= sendto(p->sock, T2_getPing, 3, 0, (sockaddr*) &sa, sizeof(sa));
  err= sendto(p->sock, T2_getStatus, 3, 0, (sockaddr*) &sa, sizeof(sa));
  if (err == SOCKET_ERROR || err2==SOCKET_ERROR){
    wsprintf(p->text, "Send error (%d)", WSAGetLastError());
    return FALSE;
  }

  // we use p->ping as a boolean flag to check if it is the first packet. so initialize it here
  strcpy(p->ping, "");

  if (QueryPerformanceCounter(&t))
    p->ticks = t.QuadPart;
  else
	p->ticks = GetTickCount();
 
  /* set socket to non-blocking mode */
  err=WSAAsyncSelect(p->sock, p->fhWnd, WM_SERVER_RESPONSE, FD_READ);
  if (err == SOCKET_ERROR) {
    wsprintf(p->text, "Select error (%d)", WSAGetLastError());
    return FALSE;
  }
  
  return TRUE;
}


// custom draw procedure for Q3 colored names and display of encoded names
// in case of OSP
BOOL T2_drawName(PluginInstance *This, HDC hdc, RECT win, char *name) {
	return FALSE;
}