/*
  q2.cpp
		
	Q3Plug 1.1b5
		
  Quake 2 server query

  Author:   Markus Baumgartner
  Compiler: Microsoft Visual C++ 6.0
  Last Mod: 31/12/2000
	Tab size: 2
*/


#include <assert.h>
#include <string.h>
#include <windows.h>
#include <stdio.h>

#include "npapi.h"
#include "commctrl.h"

#ifndef _Q2_H_
#include "q2.h"
#endif

#ifndef _Q3PLUG_H_
#include "q3plug.h"
#endif


// game-specific information
void Q2_getInfo(char* text[]) {
  text[0] = "Quake 2";
  text[1] = "Quake 2 server query code written by Markus Baumgartner\nmarkus.baumgartner@liwest.at";
  text[2] = "quake2.exe";
  text[3] = "+connect %s:%s";                        // connect string used in command line (hostname:port)
}

// column names
void Q2_getColumns(char* cols[]) {
  cols[0] = "Ping";
  cols[1] = "Score";
  cols[2] = "Player";
}

// removes any non-alphanumerical characters (for sorting purposes)
char* Q2_stripChars(char* name) {
  assert(name);
  
  if (strlen(name) > 255)
    return name;

	char tmp2[256];
	char *tmp = tmp2;
  char *savename = name;

  while (*name) {
   	if ((*name >= 'a' && *name <= 'z') || (*name >= 'A' && *name <= 'Z')  || 
			  (*name >= '0' && *name <= '9')) 
      *tmp++ = *name;
    name++;
  }
	*tmp='\0';
  return strcpy(savename, tmp2);
}

// custom compare function to compare columns correctly
int Q2_compareFunc(char *val1, char *val2, int sortCol, int sortDir) {
  switch (sortCol) {
	  case 0: return sortDir*(atoi(val1) - atoi(val2));
		case 1: return sortDir*(atoi(val1) - atoi(val2));
		case 2: return sortDir*stricmp(Q2_stripChars(val1),Q2_stripChars(val2));
    default: return 0;
  }
}

// extract rule semantics
void Q2_checkRule(PluginInstance *This, structRule r) {
  assert(This);
	
	if (0==strcmp(r.name, "hostname"))
    strncpy(This->hostname, r.value, 127);

	if (0==strcmp(r.name, "maxclients")) 
    strncpy(This->maxclients, r.value, 7);
}

// extract next token	and update position
char* Q2_nextToken(char **pos, char limit) {
	char *cur;
	char *tmp;

	assert(pos);
 	cur = *pos;
	
	if (!cur || !*cur)
	  return NULL;
	
	tmp = cur;

	while (*cur!='\0' && *cur!=limit)
		cur++;

	if (*cur==limit) {
		*pos=cur+1;
		*cur='\0';
	}
	else
		*pos=NULL;
		
	return tmp;
}


// do some initialization with data
BOOL Q2_initBuffer(PluginInstance *This) {

  assert(This);
	assert(This->buffer);


	// check if valid packet
	if (!strstr(This->buffer, "print")) {
    return FALSE;
  }

	// init pointers to data
	This->rulePos = strchr(This->buffer, '\n');
	if (! This->rulePos)
		return FALSE;
	This->rulePos+=2;
	This->playerPos = strchr(This->rulePos, '\n');
	if (!This->playerPos)
		return FALSE;
	*This->playerPos = '\0';
	This->playerPos++;
  	
	return TRUE;	 	
}


// this procedure is called when the plugin window is notified of the arrival
// of a packet on its socket
BOOL Q2_receivePacket(PluginInstance *p) {
 	char *cur;
  char *pos;
	LARGE_INTEGER counter, freq;
  int count = 0;

	structRule rule;
	structPlayer player;

  assert(p);
  assert(p->text);
 
	// get packet time
	if (QueryPerformanceFrequency(&freq) && QueryPerformanceCounter(&counter))
		p->ticks = 1000*(counter.QuadPart - p->ticks) / freq.QuadPart;
	else
    p->ticks = GetTickCount() - p->ticks; 
  
  p->buffer = (char*) malloc(BUFSIZE);
	assert(p->buffer);

	// clear buffer (don't remove this!)
	memset(p->buffer, 0, BUFSIZE);

	/* receive packet */
  if (recv(p->sock, p->buffer, BUFSIZE, 0) == SOCKET_ERROR) {
    wsprintf(p->text, "Receive error (%d)", WSAGetLastError());
    free(p->buffer);
		return FALSE;
  }

	if (!Q2_initBuffer(p)) {
		strcpy(p->text, "Invalid packet");
		free(p->buffer);
		return FALSE;
	 }

  strcpy(p->text, "");
  itoa((int) p->ticks, p->ping, 10);
  
	//parse players
  cur = Q2_nextToken(&p->playerPos, '\n' );
	while ( cur ) {
	 	count++;
    player.frags = cur;
		pos = strchr(cur, ' ');
		assert(pos);
		*pos = '\0';
		player.ping = ++pos;
		pos = strchr(pos, ' ');
		assert(pos);
		*pos = '\0';
		player.name = ++pos;
		UI_insertPlayer(p, player);
		cur = Q2_nextToken(&p->playerPos, '\n' );
	}		

  sprintf(p->numplayers, "%d", count);

	// parse rules
	cur = Q2_nextToken(&p->rulePos, '\\');
	while ( cur ) {
		rule.name = cur;
		cur = Q2_nextToken(&p->rulePos, '\\');
		rule.value = cur;
		Q2_checkRule(p, rule);
		UI_insertRule(p, rule);
		cur = Q2_nextToken(&p->rulePos, '\\');
	}
	
	// now we can free the buffer and close socket
	free(p->buffer);
  closesocket(p->sock);

	p->playerPos = NULL;
	p->rulePos = NULL;

  return TRUE;
}

// Sends a status-request packet to destination server */
BOOL Q2_sendPacket(PluginInstance *p) {
  struct sockaddr_in sa;
  LARGE_INTEGER t;
  HOSTENT *host;
  int err;

  assert(p);

  
  /* create new socket */
  p->sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (p->sock == INVALID_SOCKET) {
    wsprintf(p->text, "Socket error (%d)", WSAGetLastError());
    return FALSE;
  }
    
  /* set parameters */
  sa.sin_family = AF_INET;
  sa.sin_port = htons(atoi(p->port));
  sa.sin_addr.S_un.S_addr = inet_addr(p->server);

  if (sa.sin_addr.S_un.S_addr == -1) {
    host = gethostbyname(p->server);
    if (!host) {
      strcpy(p->text, "Invalid server name");
      return FALSE;
    }
    memcpy(&(sa.sin_addr.s_addr), host->h_addr, sizeof(int));
  }
    
  /* send it (finally) */
  err= sendto(p->sock, Q2_getStatus, sizeof(Q2_getStatus), 0, (sockaddr*) &sa, sizeof(sa));
  if (err == SOCKET_ERROR) {
    wsprintf(p->text, "Send error (%d)", WSAGetLastError());
    return FALSE;
  }

  if (QueryPerformanceCounter(&t))
		p->ticks = t.QuadPart;
	else
		p->ticks = GetTickCount();
 
  /* set socket to non-blocking mode */
  err=WSAAsyncSelect(p->sock, p->fhWnd, WM_SERVER_RESPONSE, FD_READ);
  if (err == SOCKET_ERROR) {
    wsprintf(p->text, "Select error (%d)", WSAGetLastError());
    return FALSE;
  }
  
  return TRUE;
}


// custom draw procedure (we only strip " characters here) 
BOOL Q2_drawName(PluginInstance *This, HDC hdc, RECT win, char *name) {
	HGDIOBJ object;
	int iWidth;

	object = GetStockObject(ANSI_VAR_FONT);
  
  if (!object)
    return FALSE;

  SelectObject(hdc, object);
	SetTextAlign(hdc, TA_LEFT|TA_TOP);
	SetTextColor(hdc,This->color);        // black is default

	while (*name) {
		if (*name != '"') {					// skip "
		  TextOut(hdc, win.left,win.top,name,1); 
		  GetCharWidth(hdc, *name, *name, &iWidth);
		  win.left+= iWidth; 
		}
		name++;
	}
  return TRUE;
}
