/*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
	char	*error;

	switch(WSAGetLastError()) {
		case 10004: error = "Interrupted system call"; break;
		case 10009: error = "Bad file number"; break;
		case 10013: error = "Permission denied"; break;
		case 10014: error = "Bad address"; break;
		case 10022: error = "Invalid argument (not bind)"; break;
		case 10024: error = "Too many open files"; break;
		case 10035: error = "Operation would block"; break;
		case 10036: error = "Operation now in progress"; break;
		case 10037: error = "Operation already in progress"; break;
		case 10038: error = "Socket operation on non-socket"; break;
		case 10039: error = "Destination address required"; break;
		case 10040: error = "Message too long"; break;
		case 10041: error = "Protocol wrong type for socket"; break;
		case 10042: error = "Bad protocol option"; break;
		case 10043: error = "Protocol not supported"; break;
		case 10044: error = "Socket type not supported"; break;
		case 10045: error = "Operation not supported on socket"; break;
		case 10046: error = "Protocol family not supported"; break;
		case 10047: error = "Address family not supported by protocol family"; break;
		case 10048: error = "Address already in use"; break;
		case 10049: error = "Can't assign requested address"; break;
		case 10050: error = "Network is down"; break;
		case 10051: error = "Network is unreachable"; break;
		case 10052: error = "Net dropped connection or reset"; break;
		case 10053: error = "Software caused connection abort"; break;
		case 10054: error = "Connection reset by peer"; break;
		case 10055: error = "No buffer space available"; break;
		case 10056: error = "Socket is already connected"; break;
		case 10057: error = "Socket is not connected"; break;
		case 10058: error = "Can't send after socket shutdown"; break;
		case 10059: error = "Too many references, can't splice"; break;
		case 10060: error = "Connection timed out"; break;
		case 10061: error = "Connection refused"; break;
		case 10062: error = "Too many levels of symbolic links"; break;
		case 10063: error = "File name too long"; break;
		case 10064: error = "Host is down"; break;
		case 10065: error = "No Route to Host"; break;
		case 10066: error = "Directory not empty"; break;
		case 10067: error = "Too many processes"; break;
		case 10068: error = "Too many users"; break;
		case 10069: error = "Disc Quota Exceeded"; break;
		case 10070: error = "Stale NFS file handle"; break;
		case 10091: error = "Network SubSystem is unavailable"; break;
		case 10092: error = "WINSOCK DLL Version out of range"; break;
		case 10093: error = "Successful WSASTARTUP not yet performed"; break;
		case 10071: error = "Too many levels of remote in path"; break;
		case 11001: error = "Host not found"; break;
		case 11002: error = "Non-Authoritative Host not found"; break;
		case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
		case 11004: error = "Valid name, no data record of requested type"; break;
		default: error = strerror(errno); break;
	}
	fprintf(stderr, "\nError: %s\n", error);
#ifdef WINTRAY
    MessageBox(0, error, "Gslist", MB_OK | MB_ICONERROR | MB_TASKMODAL);
#endif
	exit(1);
}

