/*
MEM.C
usage: mem [n]
tries to allocate n megabytes of memory
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dos.h>

void fail(char *s) { puts(s); exit(1); }

void help(void)
{
	puts("MEM [options] -- memory allocation stress test");
	puts("options:");
	puts("\t-blksize [n] -- change block size (default: 1024/10240 bytes)");
	puts("\t-meg [n] -- change maximum (default: 16 megabytes)");
	puts("\t-verbose -- turn on verbose mode (report every 500 allocs)");
	puts("\t-debug -- display all selectors");
	puts("\t-dos -- use INT 21h Func 48h (default: use malloc)");
	puts("\t-heapgrow n -- set heap grow increment");
	exit(1);
}

main(int argc, char *argv[])
{
	 char *p;
	 time_t t1, t2;
	 unsigned long allocs;
	 unsigned long maxallocs;
	 unsigned blksize;
	 unsigned long avail;
	 int verbose, debug, seg, dos;
	 int meg;
	 int i;
	 extern unsigned int _amblksiz;
	 
	 time(&t1);
	 
	 meg = 2;
	 blksize = -1;
	 verbose = debug = dos = 0;
	 seg = 0;
	 
	 for (i=1; i<argc; i++)
		 if (argv[i][0] == '-')
		 {
			 char *s = strupr(&argv[i][1]);
			 if (strcmp(s, "MEG") == 0)
				 meg = atoi(argv[++i]);
			 else if (strcmp(s, "BLKSIZE") == 0)
				 blksize = atoi(argv[++i]);
			 else if (strcmp(s, "VERBOSE") == 0)
				 verbose++;
			 else if (strcmp(s, "DEBUG") == 0)
				 debug++;
			 else if (strcmp(s, "DOS") == 0)
			 {
				 dos++;
				 if (blksize == -1) 
					 blksize = 10240;
			 }
			 else if (strcmp(s, "HEAPGROW") == 0)
			         _amblksiz = atoi(argv[++i]);
			 else if ((strcmp(s, "?") == 0) || (strcmp(s, "HELP") == 0))
				 help();
			 else
				 fail("unknown switch");
		 }
		
	 if (blksize == -1)
		 blksize = 1024;
	 if (blksize < 1) 
		 fail("blksize must be > 1");
		 
	 maxallocs = (((unsigned long) meg) * 1024L * 1024L) / blksize;

	 printf("Goal: %u megabytes\n", meg);
	 printf("Block size: %u bytes\n", blksize);
	 printf("Max blocks: %lu\n", maxallocs);
	 printf("Using %s\n", dos? "DOS Alloc" : "malloc");


     for (allocs = 0; allocs < maxallocs; allocs++)
     {
		if (p = malloc(blksize))
		{
			*p = 'x';
			p[blksize-1] = 'y';
		}
		else
			break;
		if (verbose && (! (allocs % 500)) && allocs)
			printf("%lu blocks, %lu bytes, %lu seconds\n",
				allocs,
				allocs * blksize,
				time(&t2) - t1);
	}

	if (debug) printf("\n");
        
	printf("<<%lu>> blocks, <<%lu>> bytes, <<%lu>> seconds\n",
		allocs,
		allocs * blksize,
		time(&t2) - t1);
	
	return 0;
}

