#include "g_local.h"
#if compileJACKBOT

	/************************************************************

		 Determin cost of moving from one node to another; should
		 take path length in consideration (multiply duck links by
		 2, ladder links by 1.5).

	************************************************************/
	int botNode_MoveCost(short int from, short int to)
		{
		short int curnode;
		int				cost = 1;
	
		// Invalid starting/ending node
		if ((from == -1) || (to == -1))
			return BOTNODE_INVALID;

		// You are there already
		if (from == to)
			return 0;

		// The path is broken
		if (jb_PathTable[from][to] == BOTNODE_INVALID)
			return BOTNODE_INVALID;

		curnode = jb_PathTable[from][to];
		while(curnode != to)
			{
			curnode = jb_PathTable[curnode][to];
			if (curnode == BOTNODE_INVALID)
				return BOTNODE_INVALID;
			cost++;
			if (cost > jb_NumNodes)
				{
				gi.dprintf("botNode_MoveCost: path from Node[%i] to Node[%i] loops endlessly!\n", from, to);
				return BOTNODE_INVALID;
				}
			}

		return cost;
		}



		

	//qboolean node_PerfectMatch(edict_t *self, short int nodeIndex)
	qboolean perfectMatch(vec3_t v1, vec3_t v2)
		{
		#if 1
		return ((abs(v1[0] - v2[0]) < 4) && (abs(v1[1] - v2[1]) < 4) && (abs(v1[2] - v2[2]) < 8));
		#else
			#if 1
			if (!ValidNode(nodeIndex))
				return false;

			aX = (int)self->s.origin[0];
			aY = (int)self->s.origin[1];
			aZ = (int)self->s.origin[2];

			bX = (int)jb_Node[nodeIndex].origin[0];
			bY = (int)jb_Node[nodeIndex].origin[1];
			bZ = (int)jb_Node[nodeIndex].origin[2];

			return ((abs(aX - bX) < 4) && (abs(aY - bY) < 4) && (abs(aZ - bZ) < 8));
			*/
			#else
			vec3_t v;
			double f, i;

			f = modf((double)self->s.origin[0], &i);
			if (abs(i) > .5)
				f += ((f > 0) - (f < 0));
			v[0] = f;

			f = modf((double)self->s.origin[1], &i);
			if (abs(i) > .5)
				f += ((f > 0) - (f < 0));
			v[1] = f;
		
			f = modf((double)self->s.origin[2], &i);
			if (abs(i) > .5)
				f += ((f > 0) - (f < 0));
			v[2] = f;
			#endif
		#endif
		}


	/************************************************************

		Get CLOSEST NEARCHABLE node. Called every time a bot gets
		lost, or when they need to know where they are (right after
		respawn, before setting up a new goal, or after they've
		been in a fight - in case they strayed too far).

	************************************************************/
	short int botMisc_CurrentNode(edict_t *self)
		{
		// Slow checks
		short int i;
		short int	node = BOTNODE_INVALID;
		float			distTx;
		float			bestTx = BOTNODE_DIST_MAX;
		trace_t		tr;

		// Quick check: maybe we reached our next node?
		if (ValidNode(self->botInfo->nodeNext))
			{
			if (perfectMatch(self->s.origin, jb_Node[self->botInfo->nodeNext].origin))
				return self->botInfo->nodeNext;
			}

		// Quick check: maybe we're still on the current node?
		if (ValidNode(self->botInfo->nodeCurrent))
			{
			if (perfectMatch(self->s.origin, jb_Node[self->botInfo->nodeCurrent].origin))
				return self->botInfo->nodeCurrent;
			}

		// Okay check: elevator? -- THIS CODE DOESN'T WORK, FIXME!
		if (self->groundentity)
			{
			if (!Q_stricmp(self->groundentity->classname, "func_plat"))
				{
				gi.dprintf("%s is on an elevator\n", self->client->pers.netname);
				for (i = 0; i < jb_NumItems; i++)
					{
					if (jb_ItemTable[i].ent != self->groundentity)
						continue;
					if (self->groundentity->moveinfo.state == STATE_TOP)
						{
						gi.dprintf("Plat is TOP\n");
						if (abs(jb_Node[jb_ItemTable[i].node].origin[2] - self->s.origin[2]) <= 8)
							return jb_ItemTable[i].node;
						}
					else
						{
						gi.dprintf("Plat is MOVING\n");
						if (jb_Node[jb_ItemTable[i].node].origin[2] < self->s.origin[2])
							return jb_ItemTable[i].node;
						}
					}
				}
			}

		// SMALL TEST // find closest node within the proper Z range
		for (i = 0; i < jb_NumNodes; i++)
			{
			// Ignore ladders & airbound
			if ((jb_Node[i].type->value == nLadder) || (jb_Node[i].type->value == nAirJump) || (jb_Node[i].type->value == nAirFall))
				continue;

			if (abs(jb_Node[i].origin[2] - self->s.origin[2]) > BOTMOVE_STEPSIZE)
				continue;
			distTx = (abs(jb_Node[i].origin[0] - self->s.origin[0]) + abs(jb_Node[i].origin[1] - self->s.origin[1]));
			if (distTx >= bestTx)
				continue;
			// Can we trace it?
			tr = gi.trace(self->s.origin, NULL, NULL, jb_Node[i].origin, self, MASK_BOTBLOCK);
			if (tr.fraction < 1.00)
				continue;
			// Here's one you can use.
			bestTx = distTx;
			node = i;
			}
		if (node != BOTNODE_INVALID)
			return node;

		// HEAVY TEST // trace closest nodes (same test as route building)
		for (i = 0; i < jb_NumNodes; i++)
			{
			distTx = VectorDistanceTaxicab(jb_Node[i].origin, self->s.origin);
			if (distTx >= bestTx)
				continue;
			if (!trace_EntityToNode(self, &jb_Node[i]))
				continue;
			// Here's one you can use.
			bestTx = distTx;
			node = i;
			}
		if (node != BOTNODE_INVALID)
			return node;
	
		// Pick whatever we find, no check at all. Godspeed.
		gi.dprintf("%s got completely lost at %s, consider adding more nodes\n", self->client->pers.netname, vtos(self->s.origin));
		node = botMisc_FindClosestNode(self->s.origin, -1, nAll); // Pick closest, no range limitation
		return node;
		}



	/************************************************************

		Get closest node, not necessarily reachable or visible.

	************************************************************/
	short int botMisc_FindClosestNode(vec3_t origin, float range, botNodeEnum_t type)
		{
		short int	i;
		short int	nodeIndex = BOTNODE_INVALID;
		int				txClosest = BOTNODE_DIST_MAX;
		int				txDist;

		// Parse each node, keep closest
		for (i = 0; i < jb_NumNodes; i++)
			{
			if ((jb_Node[i].type->value != type) && (type != nAll))
				continue;
			txDist = VectorDistanceTaxicab(jb_Node[i].origin, origin);
			if (txClosest < txDist)
				continue;
			nodeIndex = i;
			txClosest = txDist;
			}

		// No range specified, get absolute closest (or nodeIndex is INVALID)
		if ((range < 0) || (nodeIndex == BOTNODE_INVALID))
			return nodeIndex;

		// Range specified, check if the closest node is within it
		if (VectorDistance(jb_Node[nodeIndex].origin, origin) > range)
			return BOTNODE_INVALID;
		return nodeIndex;
		}



	/************************************************************
   
		 Set up the goal. Used by bots AI.

	************************************************************/
	void ACEND_SetGoal(edict_t *self, short int nodeCurrent, short int nodeGoal)
		{
		int i;

		// If nodeCurrent is unspecified, find it
		if (!ValidNode(nodeCurrent))
			nodeCurrent = botMisc_CurrentNode(self);
		
		// Failed to find nodeCurrent, or goal is nodeCurrent
		if ((!ValidNode(nodeCurrent)) || (nodeGoal == nodeCurrent))
			return;

		// Setup new goal
		self->botInfo->nodeGoal			= nodeGoal;
		self->botInfo->nodeCurrent	= nodeCurrent;
		self->botInfo->nodeNext			= nodeCurrent;
		if (self->botInfo->nodeNext != BOTNODE_INVALID)
			self->botInfo->nodeDistance = VectorDistance(self->s.origin, jb_Node[self->botInfo->nodeNext].origin);
		for (i = 0; i < jb_NumItems; i++)
			{
			if (jb_ItemTable[i].node != nodeGoal)
				continue;
			self->botInfo->goalEntity = jb_ItemTable[i].ent;
			}
		botprint(self, "Going from node[%i] to node[%i].\n", self->botInfo->nodeCurrent, self->botInfo->nodeGoal);
		}







	/************************************************************

		Parse all nodes and remove those that are undefined or
		unlinked. The removal is done by edit_NodeRemove().

	************************************************************/
	void node_removeExcessNodes()
		{
		int i;
		int j;
		int cnt;

		for (i = jb_NumNodes - 1; i >= 0; i--)
			{
			// if undefined
			if (!jb_Node[i].type)
				{
				edit_NodeRemove(i);
				gi.dprintf("Removed Node[%i], undefined.\n", i);
				continue;
				}
			// if doesn't reference/isn't referenced by any other node
			cnt = 0;
			for (j = 0; j < jb_NumNodes; j++)
				{
				if (jb_PathTable[i][j] == BOTNODE_INVALID)
					cnt ++;
				}
			if (cnt == jb_NumNodes)
				{
				edit_NodeRemove(i);
				gi.dprintf("Removed Node[%i], unlinked.\n", i);
				continue;
				}
			}
		}



  /************************************************************

		Reset node array and everything else related to paths or
		nodes. Note that the memory is allocated already (fixed
		arrays). This function is called on map load.

  ************************************************************/
  void ACEND_InitNodes()
		{
		jb_NumNodes = 0;
		jb_NumItems = 0;
		jb_NumJumps = 0;
		jb_NumDucks = 0;
		jb_NumLinks = 0;
		jb_NumRevs	= 0; // revisions
		memset(jb_Node, 0, sizeof(botnode_t) * BOTNODE_MAX);
		memset(jb_PathTable, BOTNODE_INVALID, sizeof(short int) * BOTNODE_MAX * BOTNODE_MAX);
		memset(jb_ItemTable, 0, sizeof(itemLink_t) * MAX_EDICTS);
		}



	/************************************************************

		Return pointer to a node type, using its Kraze Bot node type

	************************************************************/
	nodeType_t *getNodeTypeByKrazeValue(int value)
		{
		int i = 0;
		for (i = 0; i < jb_NumNodeTypes; i++)
			{
			if (jb_NodeType[i].krazeValue == value)
				return &jb_NodeType[i];
			}
		return NULL;
		}



	/************************************************************

		Return pointer to a node type, using its name

	************************************************************/
	nodeType_t *getNodeTypeByName(char *name)
		{
		int i = 0;

		if (!name)
			return NULL;
		for (i = 0; i < jb_NumNodeTypes; i++)
			{
			if (!Q_stricmp(jb_NodeType[i].name, name))
				return &jb_NodeType[i];
			}
		return NULL;
		}



	/************************************************************

		Return pointer to a node type, using its value

	************************************************************/
	nodeType_t *getNodeTypeByValue(int value)
		{
		int i = 0;
		for (i = 0; i < jb_NumNodeTypes; i++)
			{
			if (jb_NodeType[i].value == value)
				return &jb_NodeType[i];
			}
		return NULL;
		}

#endif