#include "g_local.h"
#if compileJACKBOT

  /**********************************************************

    [action] lateral dodge (pursue previous try)
  
	**********************************************************/
  void move_LateralDodge(edict_t *self)
		{
		// Pick a direction at random
		if ((self->botInfo->dodgeLastMove == 0) || (self->botInfo->dodgeTimeout < level.time))
			{
			self->botInfo->dodgeTimeout = level.time + 0.10 + (5.00 * (1.00 - self->botInfo->def.jittery));
			if (random() > .5)
				self->botInfo->dodgeLastMove = BOTMOVE_LEFT;
			else
				self->botInfo->dodgeLastMove = BOTMOVE_RIGHT;
			}

		// Last dodge was LEFT and it worked, try LEFT again!
		if (self->botInfo->dodgeLastMove == BOTMOVE_LEFT)
			{
			if (botAI_CanMove(self, BOTMOVE_LEFT))
				{
				self->botInfo->ucmd.sidemove -= BOTSPEED_RUN;
				return;
				}
			else if (botAI_CanMove(self, BOTMOVE_RIGHT))
				{
				self->botInfo->ucmd.sidemove += BOTSPEED_RUN;
				self->botInfo->dodgeLastMove = BOTMOVE_RIGHT;
				return;
				}
			}

		// Last dodge was RIGHT and it worked, try RIGHT again!
		else if (self->botInfo->dodgeLastMove == BOTMOVE_RIGHT)
			{
			if (botAI_CanMove(self, BOTMOVE_RIGHT))
				{
				self->botInfo->ucmd.sidemove += BOTSPEED_RUN;
				return;
				}
			else if (botAI_CanMove(self, BOTMOVE_LEFT))
				{
				self->botInfo->ucmd.sidemove -= BOTSPEED_RUN;
				self->botInfo->dodgeLastMove = BOTMOVE_LEFT;
				return;
				}
			}
			botprint(self, "Completely cornered! Flee you fool!\n");
			// TODO: cornered, flee you fool!
		}

  /**********************************************************
    
		[action] Ensure that the bot is standing between
		<distMin> and <distMax>, assuming it is facing whatever
		it tries to stay away from.

  **********************************************************/
  void botMove_keepDistance(edict_t *self, float dist, float distMin, float distMax)
		{
		// too close, back off
		if (distMin > dist)
			{
			// Move back?
			if (botAI_CanMove(self, BOTMOVE_BACK))
				self->botInfo->ucmd.forwardmove -= BOTSPEED_RUN;
			// Cannot move back, try a lateral dodge
			else
				move_LateralDodge(self);
			}

		// too far, get closer
		else if (dist > distMax)
			{
			if (botAI_CanMove(self, BOTMOVE_FORWARD))
				self->botInfo->ucmd.forwardmove += BOTSPEED_RUN;
			}
		}



  /**********************************************************
		
		Jump

  **********************************************************/
  void move_Jump(edict_t *self)
		{
		if (!(self->botInfo->extra & BOTEXTRA_ISJUMPING) && (self->botInfo->jumpTimeout < level.time))
			{
			self->botInfo->ucmd.upmove = 400;
			if ((self->groundentity) && (!self->waterlevel))
				self->botInfo->extra |= BOTEXTRA_ISJUMPING;
			}
		}



  /**********************************************************
		
		Crouch

  **********************************************************/
  void move_Crouch(edict_t *self)
		{
		if ((self->botInfo->ucmd.upmove == 0) && (!(self->botInfo->extra & BOTEXTRA_ISJUMPING)) && (self->groundentity) && (!self->waterlevel))
			self->botInfo->ucmd.upmove = -400;
		}



  /**********************************************************
    
		[think] Check move position (floor & walls)

  **********************************************************/
  qboolean botAI_CanMove(edict_t *self, int angle)
		{
		vec3_t	forward;
		vec3_t	right;
		vec3_t	offset;
		vec3_t	start;
		vec3_t	end;
		vec3_t	angles;
		trace_t	tr;

		// Now check to see if move will move us off an edge
		VectorCopy(self->s.angles, angles);
		angles[1] += angle;

		// Set up the vectors (floor)
		AngleVectors(angles, forward, right, NULL);
		VectorSet(offset, 36, 0, 24);
		G_ProjectSource(self->s.origin, offset, forward, right, start);
		VectorSet(offset, 36, 0, -400);
		G_ProjectSource(self->s.origin, offset, forward, right, end);
		tr = gi.trace(start, NULL, NULL, end, self, MASK_BOTNOGO);
		// TODO: also check for trigger_hurt.
		if (((tr.fraction > 0.3) && (tr.fraction != 1.00)) || (tr.contents & (CONTENTS_LAVA|CONTENTS_SLIME))) // edge!
			return false;

		// Cornered? (wall)
		AngleVectors (angles, forward, right, NULL);
		VectorSet(offset, 36, 0, 24);
		G_ProjectSource (self->s.origin, offset, forward, right, start);
		tr = gi.trace(start, NULL, NULL, start, self, MASK_BOTNOGO);
		if (tr.contents & CONTENTS_SOLID)
			return false;

		return true; // yup, can move
		}

		

/**********************************************************
   
	 Bot needs to look at <aimPoint>, change pitch (up-down)
	 and/or yaw (left-right) accordingly; returns TRUE if
	 pitch/yaw was changed.

**********************************************************/
qboolean bot_LookAt(edict_t *ent, vec3_t lookAt, int what)
	{
	float			current;
	float			ideal;
	float			delta;
	vec3_t		ideal_angle;
	vec3_t		tmp;
	vec3_t		aimPoint;
	qboolean	changed = false;
	float			yawspeed;

	// Cannot look at something else now.
	if (ent->botInfo->state & BOTSTATE_INVESTIGATE)
		return false;

	yawspeed = 16 + (96 * ent->botInfo->def.navigation);

	// Use bot's lookAt if none is specified
	if (!lookAt)
		VectorCopy(ent->botInfo->lookAt, aimPoint);
	else
		VectorCopy(lookAt, aimPoint);

	// AIMING DIRECTION //
	VectorSubtract(aimPoint, ent->s.origin, tmp);
	VectorNormalize(tmp);
	vectoangles(tmp, ideal_angle);

	// CHANGE YAW //
	if (what & doAimYaw)
		{
		// Get current and target
		current = anglemod(ent->s.angles[YAW]);
		ideal		= anglemod(ideal_angle[YAW]);
		delta		= ideal - current;
		// Need to adjust
		if ((int)delta)
			{
			// Get in range
			if ((ideal > current) && (delta >= 180))
				delta -= 360;
			else if ((ideal < current) && (delta <= -180))
				delta += 360;
			if ((delta > 0) && (delta > yawspeed))
				delta = yawspeed;
			else if ((delta < 0) && (delta < -yawspeed))
				delta = -yawspeed;
			// Adjust
			ent->s.angles[YAW] = anglemod(current + delta);	
			// Close enough?
			delta = anglemod(ent->s.angles[YAW]);
			if ((int)(delta - ideal))
				changed = true;
			}
		}

	// CHANGE PITCH //
	if (what & doAimPitch)
		{
		// Get current and target
		current	= anglemod(ent->s.angles[PITCH]);
		ideal		= anglemod(ideal_angle[PITCH]);
		delta		= (int)ideal - (int)current;
		// Need to adjust
		if ((int)delta)
			{
			// Get in range
			if ((ideal > current) && (delta >= 180))
				delta -= 360;
			else if ((ideal < current) && (delta <= -180))
				delta += 360;
			if ((delta > 0) && (delta > yawspeed))
				delta = yawspeed;
			else if ((delta < 0) && (delta < -yawspeed))
				delta = -yawspeed;
			// Adjust
			ent->s.angles[PITCH] = anglemod(current + delta);
			// Close enough?
			delta = (int)anglemod(ent->s.angles[YAW]);
			if ((int)(delta - ideal))
				changed = true;
			}
		}

	return changed;
	}


	/**********************************************************

		 Move toward <movePoint>, considers viewangle.

	**********************************************************/
	void bot_SetMotion(edict_t *self, vec3_t movePoint, float speed)
		{
		vec3_t	move;
		vec3_t	aim;
		float		angle;

		// Get move vector & aim
		VectorSubtract(movePoint, self->s.origin, move);
		AngleVectors(self->s.angles, aim, NULL, NULL);

		// Change forward & sidemove according to angle between aim and move, 
		angle = atan2(move[1], move[0]) - atan2(aim[1], aim[0]);
		self->botInfo->ucmd.forwardmove =  (cos(angle) * speed);
		self->botInfo->ucmd.sidemove		= -(sin(angle) * speed);
		}


	/**********************************************************************

		We reached the current check point, use next

	**********************************************************************/
	void move_CheckpointReached(edict_t *self)
		{
		// REACHED GOAL //
		if (self->botInfo->nodeNext == self->botInfo->nodeGoal)
			botAi_KillGoal(self);
		
		// MOVING TOWARD GOAL //
		else
			{
			self->botInfo->nodeCurrent = self->botInfo->nodeNext;
			self->botInfo->nodeNext = jb_PathTable[self->botInfo->nodeCurrent][self->botInfo->nodeGoal];
			self->botInfo->extra |= BOTEXTRA_DEFERRED_GOAL;
			if (self->botInfo->nodeNext != BOTNODE_INVALID)
				self->botInfo->nodeDistance = VectorDistance(self->s.origin, jb_Node[self->botInfo->nodeNext].origin);
			}
		}



	/********************************************************************

		Swimming?

	********************************************************************/
	qboolean move_WaterIn(edict_t *self, float dist)
		{
		if (jb_Node[self->botInfo->nodeCurrent].type->value != nWater)
			return false;

		// NODE REACHED //
		if (dist < 32)
			move_CheckpointReached(self);

		// NODE NOT REACHED //
		else
			self->botInfo->ucmd.forwardmove = BOTSPEED_WATER;

		bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch); // Force flee underwater
		return true;
		}



	/********************************************************************

		Leaving the water?

	********************************************************************/
	qboolean move_WaterOut(edict_t *self, float dist)
		{
		if (jb_Node[self->botInfo->nodeCurrent].type->value != nWater)
			return false;
	
		if (jb_Node[self->botInfo->nodeNext].type->value != nWater)
			return false;

		// NODE REACHED //
		if (dist < 32)
			move_CheckpointReached(self);

		// NODE NOT REACHED //
		else
			{
			self->botInfo->ucmd.upmove = 400;
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			}

		bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch); // Since we can't attack underwater, force flee
		return true;
		}

	/********************************************************************

		Do we have to jump? (feet: s.origin[2] - 24)

	********************************************************************/
	qboolean move_TestJump(edict_t *self)
		{
		int			i;
		vec3_t	v;
		vec3_t	vS;
		vec3_t	vE;
		trace_t tr;

		// Can't jump now
		if ((self->botInfo->extra & BOTEXTRA_ISJUMPING) || (self->botInfo->jumpTimeout > level.time))
			return false;

		// Test for linked nodes
		for (i = 0; i < jb_NumJumps; i++)
			{
			// Not proper link
			if ((jb_JumpTable[i].from != self->botInfo->nodeCurrent) || (jb_JumpTable[i].to != self->botInfo->nodeNext))
				continue;

			// Test floor 24 units ahead in moving direction
			VectorSubtract(jb_Node[self->botInfo->nodeNext].origin, self->s.origin, v);
			VectorNormalize(v);
			VectorMA(self->s.origin, 24, v, vS);
			// Start (ankles)
			vS[2] -= (24 - BOTMOVE_STEPSIZE);
			// End (floor)
			vE[0] = vS[0];
			vE[1] = vS[1];
			vE[2] = vS[2] - 12;

			// Gap in the way?
			tr = gi.trace(vS, self->mins, self->maxs, vE, self, MASK_BOTNOGO);
			if ((tr.fraction == 1.00) || (tr.contents & (CONTENTS_LAVA|CONTENTS_SLIME)) || (tr.startsolid))
				return true;

			break;
			}
		return false;
		}

qboolean move_TestHop(edict_t *self)
		{
		int			i;
		vec3_t	v;
		vec3_t	vS;
		vec3_t	vE;
		trace_t tr;

		gi.dprintf("Test hop\n");

		// Can't jump now
		if ((self->botInfo->extra & BOTEXTRA_ISJUMPING) || (self->botInfo->jumpTimeout > level.time))
			return false;

		// Test floor 24 units ahead in moving direction
		VectorSubtract(jb_Node[self->botInfo->nodeNext].origin, self->s.origin, v);
		VectorNormalize(v);
		VectorMA(self->s.origin, 24, v, vS);
		// End (floor)
		vE[0] = vS[0];
		vE[1] = vS[1];
		vE[2] = vS[2] - 24;
		// Start (ankles)
		vS[2] = vE[2]  + BOTMOVE_STEPSIZE;

		showTrace(vS, vE);

		// Obstacle in the way?
		tr = gi.trace(vS, self->mins, self->maxs, vE, self, MASK_BOTNOGO);
		return ((tr.fraction < 1.00) || (tr.startsolid));
		}

	/********************************************************************

		Do we have to duck?

	********************************************************************/
	qboolean move_TestDuck(edict_t *self)
		{
		int			i;
		vec3_t	v;
		vec3_t	vS;
		vec3_t	vE;
		trace_t tr;

		// Can't duck now
		if (self->botInfo->ucmd.upmove)
			return false;

		// Test for linked nodes
		for (i = 0; i < jb_NumDucks; i++)
			{
			// Not proper link
			if ((jb_DuckTable[i].from != self->botInfo->nodeCurrent) || (jb_DuckTable[i].to != self->botInfo->nodeNext))
				continue;

			// Test floor 24 units ahead in moving direction
			VectorSubtract(jb_Node[self->botInfo->nodeNext].origin, self->s.origin, v);
			VectorNormalize(v);
			VectorMA(self->s.origin, 24, v, vS);
			// Start (pelvis)
			vS[2] += 32;
			// End (slightly higher)
			vE[0] = vS[0];
			vE[1] = vS[1];
			vE[2] = vS[2] + 24;
			// Obstacle in the way?
			//showTrace(vS, vE);
			tr = gi.trace(vS, self->mins, self->maxs, vE, self, MASK_BOTNOGO);
			if ((tr.fraction < 1.00) || (tr.startsolid))
				return true;

			break;
			}
		return false;
		}


/*****************************************************

	Whether we reached a node is really up to the
	node... removing the generic code.

*****************************************************/
void moveGoToNextNode(edict_t *self)
	{
	float			dist;
	float			vel;
	int				travel = VEHICLE_WALK;

	if (!(self->botInfo->state & BOTSTATE_FOLLOWPATH) || self->botInfo->taskNow == TASK_NONE)
		return;

	// If current or next node is invalid, skip
	if (!ValidNode(self->botInfo->nodeCurrent) || !ValidNode(self->botInfo->nodeNext))
		{
		if (!(self->botInfo->def.flags & BOTFLAG_SLAVE))
			gi.dprintf("** WARNING ** %s is referencing outside boundaries (from %i to %i via %i)\n", self->client->pers.netname, self->botInfo->nodeCurrent, self->botInfo->nodeGoal, self->botInfo->nodeNext);
		return;
		}

	// Bot think
	if (self->botInfo->def.flags & BOTFLAG_THINK)
		{
		jb_ShowPathFrom = self->botInfo->nodeCurrent;
		jb_ShowPathTo		= self->botInfo->nodeGoal;
		edit_ShowPath();
		}

	// Distance to next node, I need it for plenty of things
	dist = VectorDistance(self->s.origin, jb_Node[self->botInfo->nodeNext].origin);

	// Lost?
	if (self->botInfo->nodeTimeout < level.time)
		{
		self->botInfo->nodeTimeout = level.time + 0.75; // check every 0.75 seconds
		if ((dist > self->botInfo->nodeDistance) && (!(self->botInfo->state & BOTSTATE_ELEVATOR_RIDE)))
			{
			botprint(self, "Node[%i] is %f units away, I'm %f...\n", self->botInfo->nodeNext, self->botInfo->nodeDistance, dist);
			ACEND_SetGoal(self, -1, self->botInfo->nodeGoal);
			return;
			}
		self->botInfo->nodeDistance = dist;
		}

	// ELEVATOR MOVE //
	if (move_ElevatorEnter(self, dist))
		return;
	else if (move_ElevatorRide(self, dist))
		return;

	#if 0
	// TRAVEL: JUMP //
	if (move_TestJump(self))
		travel = VEHICLE_JUMP;

	// TRAVEl: CROUCH //
	if (move_TestDuck(self))
		travel = VEHICLE_CROUCH;
	#else
	// TRAVEL: JUMP AND CROUCH (cannot jump-crouch like in Half-Life, pick one or the other)//
	if (move_TestJump(self))
		travel = VEHICLE_JUMP;
	else if (move_TestDuck(self))
		travel = VEHICLE_CROUCH;
	#endif

	// LADDER MOVES //
	if (move_LadderMount(self, dist))					// Mounting ladder?
		return;
	else if (move_LadderClimb(self, dist))		// Climbing up/down on ladder?
		return;
	else if (move_LadderDismount(self, dist)) // Getting off ladder?
		return;

	// WATER MOVES //
	else if (move_WaterIn(self, dist))	// Moving underwater
		return;
	else if (move_WaterOut(self, dist))	// Moving out of water
		return;

	// ANYTHING ELSE //
	if ((jb_Node[self->botInfo->nodeNext].type->value == nAirJump) || (jb_Node[self->botInfo->nodeNext].type->value == nAirFall))
		{
		if ((self->s.origin[2] + 8) < jb_Node[self->botInfo->nodeNext].origin[2])
			{
			move_CheckpointReached(self);
			travel = VEHICLE_WALK;
			}
		}
	else if ((jb_Node[self->botInfo->nodeNext].type->value == nCashSpawn) && (self->botInfo->nodeNext == self->botInfo->nodeGoal))
		{
		if ((abs(self->s.origin[2] - jb_Node[self->botInfo->nodeNext].origin[2]) <= 8) && (dist < 128))
			{
			move_CheckpointReached(self);
			travel = VEHICLE_WALK;
			}
		}
	else if ((jb_Node[self->botInfo->nodeNext].type->value == nItem) && (self->botInfo->nodeNext == self->botInfo->nodeGoal))
		{
		if (abs(self->s.origin[2] - jb_Node[self->botInfo->nodeNext].origin[2]) <= 8)
			{
			if (!Q_stricmp(self->botInfo->goalEntity->classname, "dm_cashbag"))
				{
				if (dist < 8)
					{
					if (self->botInfo->taskNow == TASK_MONEY_DEPOSITE) // All objectives end after cash deposite
						self->botInfo->taskNow = TASK_NONE;
					move_CheckpointReached(self);
					travel = VEHICLE_WALK;
					}
				}
			else
				{
				if (dist < 32)
					{
					move_CheckpointReached(self);
					travel = VEHICLE_WALK;
					}
				}
			}
		}
	else
		{

		if ((abs(self->s.origin[2] - jb_Node[self->botInfo->nodeNext].origin[2]) <= 8) && (dist < 32))
			{
			move_CheckpointReached(self);
			travel = VEHICLE_WALK;
			}
		}

	if (travel == VEHICLE_JUMP)
		move_Jump(self);
	else if (travel == VEHICLE_CROUCH)
		move_Crouch(self);
	bot_LookAt(self, NULL, doAimYaw | doAimPitch);
	bot_SetMotion(self, jb_Node[self->botInfo->nodeNext].origin, BOTSPEED_RUN);

	// REALLY DIRTY STUCK CHECK, USUALLY CAUSED BY ANOTHER CHARACTER GETTING IN THE WAY, WE SHOULD PREDICT MOVEMENT INSTEAD //
	if (self->botInfo->state & BOTSTATE_FOLLOWPATH)
		{
		vel = VectorLength(self->velocity);
		//botprint(self, "Velocity: %f\n", vel);
		if (vel < 10)
			{
			self->botInfo->stuckTimeOut++;
			if (self->botInfo->stuckTimeOut > 10)
				{
				if (move_TestHop(self))
					move_Jump(self);
				else if (move_TestDuck(self))
					move_Crouch(self);
				}
			}
		else if (vel < 70)
			{
			edict_t *seenClient;
			seenClient = sight_ClosestVisibleClient(self, &dist);
			//botprint(self, "Dist %f\n", dist);
			if ((seenClient) && (dist < 128))
				self->botInfo->ucmd.sidemove += BOTSPEED_RUN;
			}
		else
			self->botInfo->stuckTimeOut = 0;
		}
	}



	
	

	/*****************************************************************
		
		MOVE TOWARD NEXT NODE, BUT STILL AIM TOWARD THE ENEMY (OR
		LOOK AT NEXT NODE, DEPENDING ON HOW FAR APART WE ARE)

	*****************************************************************/
	void combatPassiveMove(edict_t *self, float dist)
		{
		float maxDist;

		// Regardless of what happens, move toward next node
		moveGoToNextNode(self);
		maxDist = (512 + (512 * self->botInfo->def.navigation)) + (128 * self->botInfo->def.spaceaware);

		// We're far enough, look toward next node
		
		if ((dist > maxDist) || (!self->enemy))
			{
			if (self->botInfo->nodeNext != BOTNODE_INVALID)
				VectorCopy(jb_Node[self->botInfo->nodeNext].origin, self->botInfo->lookAt);
			return;
			}

		// We're close enough to the enemy, we should attack
		VectorCopy(self->enemy->s.origin, self->botInfo->lookAt);
		combatAttackTarget(self);
		}



	/*****************************************************************

		KEEP YOUR EYES ON THE ENEMY AND SETUP DISTANCE ACCORDINGLY

	*****************************************************************/
	void combatActiveMove(edict_t *self, float dist)
		{
		int						weapIndex;
		float					distMin;
		float					distMax;
		float					distDanger;
		float					distTweak	= (0.10 * (1.00 - self->botInfo->def.spaceaware));
		float					ratio;
		qboolean			aimSafe	= true;

		// Check enemy's range
		weapIndex = botMisc_FindItemIndexByClassname(self->enemy->client->pers.weapon->classname);
		if (itemlist[weapIndex].botItemFlag & botItem_MeleeWeapon)
			distDanger = 110;
		else if (itemlist[weapIndex].botItemWeap == wFlamethrower)
			distDanger = 1024;
		else if (itemlist[weapIndex].botItemWeap == wShotgun)
			distDanger = 500;
		else
			distDanger = 0;

		// Check distance for attack
		weapIndex = botMisc_FindItemIndexByClassname(self->client->pers.weapon->classname);
		if (itemlist[weapIndex].botItemFlag & botItem_MeleeWeapon)
			{
			distMin	= 0;			// Right in your face idealy
			distMax = 60;			// Get in attack range
			}
  
		else if ((itemlist[weapIndex].botItemWeap == wPistol) || (itemlist[weapIndex].botItemWeap == wTommyGun) || (itemlist[weapIndex].botItemWeap == wHeavyMachineGun))
			{
			distMin = 200;
			distMax = 500;
			}

		else if (itemlist[weapIndex].botItemWeap == wShotgun)
			{
			distMin = 100;
			distMax = 300;
			}

		else if (itemlist[weapIndex].botItemWeap == wRocketLauncher)
			{
			distMin = 300; // stay far away that you don't blow yourself up
			distMax	= 2048;
			aimSafe = (dist < distMin)?false:(gi.trace(self->s.origin, tv(-8, -8, -8), tv(8, 8, 8), self->enemy->s.origin, self, MASK_BOTROCKET).fraction == 1.00);
			}

		else if (itemlist[weapIndex].botItemWeap == wGrenadeLauncher)
			{
			distMin	= 0;
			distMax	= 512;
			// Should also check if the target is located higher than us (in which case, DON'T use the grenade launcher)
			}

		else if (itemlist[weapIndex].botItemWeap == wFlamethrower)
			{
			distMin = 200;
			distMax = 700;
			}

		// Bot wants to stand in danger zone
		distDanger = (distDanger - (distDanger * distTweak));
		if (distDanger < 0)
			distDanger = 0;
		if (distMin <= distDanger)
			{
			ratio = ((distDanger - distMin) / distDanger);
			if (ratio < self->botInfo->def.preserve)
				distMin = distDanger; // will not enter the danger zone
			}

		// APPLY SPATIAL AWARENESS //
		distMin = (distMin - (distMin * distTweak));
		if (distMin < 0)
			distMin = 0;
		distMax = (distMax + (distMax * distTweak));
		if (distMax < 0)
			distMax = 0;


		// KEEP DISTANCE FOR COMBAT //
		if (distMin > dist)
			{
			if (botAI_CanMove(self, BOTMOVE_BACK))
				self->botInfo->ucmd.forwardmove -= BOTSPEED_RUN;
			else
				move_LateralDodge(self);
			}
		else if (dist > distMax)
			{
			if (botAI_CanMove(self, BOTMOVE_FORWARD))
				self->botInfo->ucmd.forwardmove += BOTSPEED_RUN;
			}

		// DEFENSIVE DODGE //
		if (sight_EnemyAimingAtMe(self, self->enemy))
			{
			if (random() <= self->botInfo->def.jumper)
				move_Jump(self);
			else if (random() <= self->botInfo->def.croucher)
				move_Crouch(self);
			move_LateralDodge(self);
			}

		// ATTACK IF WE CAN //
		if (aimSafe)
			combatAttackTarget(self);
		}
		
	/*****************************************************************
		
		AIM AND ATTACK IF POSSIBLE
		TODO: Aim should take into account both the velocity of the
		attacker and the velocity of the target.

	*****************************************************************/
	void combatAttackTarget(edict_t *self)
		{
		vec3_t	aimAt;
		float		aimSpread = (1.00 - self->botInfo->def.accuracy) * 256.00;

		if (self->onfiretime)
			aimSpread = aimSpread * 2;

		// Aim in the right direction
		VectorCopy(self->enemy->s.origin, aimAt);	// what the bot is aiming it
		aimAt[0] += aimSpread * (random() - 0.5);	// jitter
		aimAt[1] += aimSpread * (random() - 0.5); // jitter
		bot_LookAt(self, aimAt, doAimPitch | doAimYaw);	// It would be good to predict the other players' movement, thus increasing accuracy

		// If we can shoot, do it
		if (self->botInfo->def.flags & BOTFLAG_HOLSTER)
			return;

		// Check for ammunition
		self->botInfo->ucmd.buttons = BUTTON_ATTACK;
		self->botInfo->extra |= BOTEXTRA_DEFERRED_RELOAD;
		}

#endif