#include "g_local.h"
#if compileJACKBOT

	/********************************************************************

		About to mount a ladder? Return TRUE or FALSE.
		The function also handles the node reaching process.

	********************************************************************/
	qboolean move_LadderMount(edict_t *self, float dist)
		{
		short int	node;
		vec3_t		normal;

		// ALREADY on a ladder
		if (jb_Node[self->botInfo->nodeCurrent].type->value == nLadder)
			return false;

		// Next node is NOT a ladder
		if (jb_Node[self->botInfo->nodeNext].type->value != nLadder)
			return false;

		// The second-degree node is NOT a ladder (borrowing the node to go elsewhere)
		node = jb_PathTable[self->botInfo->nodeNext][self->botInfo->nodeGoal];
		if (node == BOTNODE_INVALID)
			return false;
		if (jb_Node[node].type->value != nLadder)
			return false;

		// BEWARE: if you need to mount the TOP of the ladder, you have to walk backward.

		// If we're investigating stuff, focus on the ladder instead! //
		if (self->botInfo->state & BOTSTATE_INVESTIGATE)
			reactSearchStop(self);

		// NODE REACHED //
		if (dist < 10)
			{
			if (getLadderNormal(self, jb_Node[self->botInfo->nodeNext].origin, normal))	// Get ladder surface normal
				self->s.angles[YAW] = anglemod(vectoyaw(normal) + 180.00);								// Force YAW -- keep YAW intact otherwise.
			VectorCopy(jb_Node[self->botInfo->nodeNext].origin, self->s.origin);				// Get to the node
			VectorSet(self->velocity, 0.00, 0.00, 0.00);																// Stop moving entirely
			self->client->ps.viewangles[PITCH] = 80;
			self->s.angles[PITCH] = 25;
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;															// Run forward
			move_CheckpointReached(self);																								// Moving toward next checkpoint on the road map
			botprint(self, "mounting ladder at node[%i] (facing: %i)\n", self->botInfo->nodeCurrent, (int)self->s.angles[YAW]);
			return true;
			}

		// NODE NOT REACHED //
		self->botInfo->ucmd.forwardmove = (dist < 96)?BOTSPEED_WALK:BOTSPEED_RUN;
		bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
		return true;
		}



	/********************************************************************

		Using a ladder? Return TRUE or FALSE. The function also
		handles the node reaching process.

	********************************************************************/
	qboolean move_LadderClimb(edict_t *self, float dist)
		{
		// We're NOT on a ladder
		if (jb_Node[self->botInfo->nodeCurrent].type->value != nLadder)
			return false;

		// Next node is NOT a ladder
		if (jb_Node[self->botInfo->nodeNext].type->value != nLadder)
			return false;

		// If we're investigating stuff, focus on the ladder instead! //
		if (self->botInfo->state & BOTSTATE_INVESTIGATE)
			reactSearchStop(self);

		// NODE REACHED //
		if (dist < 16)
			move_CheckpointReached(self);

		// REACHED OR NOT, WE'RE STILL ON A LADDER //
		if (jb_Node[self->botInfo->nodeNext].origin[2] > self->s.origin[2])
			{
			self->client->ps.viewangles[PITCH] = 80;
			self->s.angles[PITCH] = 25;
			self->botInfo->ucmd.upmove = 400;
			}
		else	// (going down)
			{
			self->client->ps.viewangles[PITCH] = -80;
			self->s.angles[PITCH] = -25;
			self->botInfo->ucmd.upmove = -400;
			}
	
		return true;
		}



	/********************************************************************

		Getting off a ladder? Return TRUE or FALSE. The function also
		handles the node reaching process.

	********************************************************************/
	qboolean move_LadderDismount(edict_t *self, float dist)
		{
		// We're NOT on a ladder
		if (jb_Node[self->botInfo->nodeCurrent].type->value != nLadder)
			return false;

		// Next node is a ladder
		if (jb_Node[self->botInfo->nodeNext].type->value == nLadder)
			return false;

		// If we're investigating stuff, focus on the ladder instead! //
		if (self->botInfo->state & BOTSTATE_INVESTIGATE)
			reactSearchStop(self);

		// NODE REACHED // ALWAYS REACH IF THE NODE IS BELOW OR SAME LEVEL //
		if (jb_Node[self->botInfo->nodeNext].origin[2] <= jb_Node[self->botInfo->nodeCurrent].origin[2])
			{
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			move_CheckpointReached(self);
			bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
			}
		else
			{

			// NODE REACHED -- there should be a timeout for ladder unmount to cancel velocity maybe?//
			if (((dist < 4) && (abs(jb_Node[self->botInfo->nodeNext].origin[2] - self->s.origin[2]) < 4)))
				{
				move_CheckpointReached(self);
				bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
				}

			// NODE NOT REACHED //
			else
				{
				self->client->ps.viewangles[PITCH] = 80;
				self->s.angles[PITCH] = 25;
				self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
				move_Jump(self);
				bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
				}
			}
		return true;
		}

#endif