///////////////////////////////////////////////////////////////////////
//
//  acebot_spawn.c - This file contains all of the 
//                   spawing support routines for the ACE bot.
//
///////////////////////////////////////////////////////////////////////

#include "g_local.h"
#include "m_player.h"
#if compileJACKBOT


	/******************************************************************************
   
		 99% of this code is PutClientInServer. The major difference being the
		 existence of *botInfo (it is NULL for human clients, but points to an
		 entry in a shared array for bots; I'm not sure how I could merge both
		 codes into one function yet)...

	******************************************************************************/
	void PutBotClientInServer (edict_t *bot, qboolean respawn, int team)
		{
		vec3_t	  mins = {-16, -16, -24};
		vec3_t	  maxs = {16, 16, 32};
		int				index;
		vec3_t	  spawn_origin;
		vec3_t	  spawn_angles;
		gclient_t *client;
		int				i;
		char			userinfo[MAX_INFO_STRING];
		char			*s;
		char			modeldir[MAX_QPATH];
		int				len;
		int				j;
		int				did_slash;
		char			modelname[MAX_QPATH];

		client_persistant_t	saved;
		client_respawn_t		resp;

		// Teamplay game, any
		if ((int)teamplay->value)
			bot->client->pers.team = team;
	
		// find a spawn point
		// do it before setting health back up, so farthest
		// ranging doesn't count this client
		SelectSpawnPoint (bot, spawn_origin, spawn_angles);
	
		index = bot-g_edicts - 1;
		client = bot->client;

		// deathmatch wipes most client data every spawn
		if (deathmatch->value)
			{
			resp = bot->client->resp;
			memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
			InitClientPersistant (client);
			ClientUserinfoChanged (bot, userinfo);
			}
		else
			memset (&resp, 0, sizeof(resp));

		//KP_ADD
		bot->name_index = -1;
		//KP_END

		// clear everything but the persistant data
		saved = client->pers;
		memset (client, 0, sizeof(*client));
		client->pers = saved;
		if (client->pers.health <= 0)
			InitClientPersistant( client);
		client->resp = resp;

		bot->botInfo->healthTrack = client->pers.health;
	
		// copy some data from the client to the entity
		FetchClientEntData (bot);
	
		// clear entity values
		bot->groundentity = NULL;
		bot->client = &game.clients[index];
		bot->takedamage = DAMAGE_AIM;
		bot->movetype = MOVETYPE_WALK;

		// RAFAEL
		bot->viewheight = 40;
		bot->inuse = true;

		bot->classname = "bot";
		bot->mass = 200;
		bot->solid = SOLID_BBOX;
		bot->deadflag = DEAD_NO;
		bot->air_finished = level.time + 12.00;
		bot->clipmask = MASK_PLAYERSOLID;
		// bot->model = "players/male/tris.md2";
		bot->pain = player_pain;
		bot->die = player_die;
		bot->waterlevel = 0;
		bot->watertype = 0;
		bot->flags &= ~FL_NO_KNOCKBACK;
		bot->svflags &= ~(SVF_DEADMONSTER|SVF_NOCLIENT);
	
		//KP_ADD
		bot->s.renderfx2 = 0;
		bot->onfiretime = 0;

		bot->cast_info.aiflags |= AI_GOAL_RUN;	// make AI run towards us if in pursuit
		//KP_END

		VectorCopy (mins, bot->mins);
		VectorCopy (maxs, bot->maxs);
		VectorClear (bot->velocity);

		//KP_ADD
		bot->cast_info.standing_max_z = bot->maxs[2];

		bot->cast_info.scale = MODEL_SCALE;
		bot->s.scale = bot->cast_info.scale - 1.0;
		//KP_END

		// clear playerstate values
		memset (&bot->client->ps, 0, sizeof(client->ps));
	
		client->ps.pmove.origin[0] = spawn_origin[0] * 8;
		client->ps.pmove.origin[1] = spawn_origin[1] * 8;
		client->ps.pmove.origin[2] = spawn_origin[2] * 8;

		if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
			client->ps.fov = 90;
		else
			{
			client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
			if (client->ps.fov < 1)
				client->ps.fov = 90;
			else if (client->ps.fov > 160)
				client->ps.fov = 160;
			}

		// RAFAEL
		// weapon mdx
			{
			memset(&(client->ps.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

			client->ps.num_parts++;
			// JOSEPH 22-JAN-99
			if (client->pers.weapon)
			client->ps.model_parts[PART_HEAD].modelindex = gi.modelindex(client->pers.weapon->view_model);
		
			for (j = 0; j < MAX_MODELPART_OBJECTS; j++)
				{
				client->ps.model_parts[PART_HEAD].skinnum[j] = 0; // will we have more than one skin???
				}
			}

		if (client->pers.weapon)
			client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);
		// END JOSEPH

		// clear entity state values
		bot->s.effects = 0;
		bot->s.skinnum = bot - g_edicts - 1;
		bot->s.modelindex = 255;		// will use the skin specified model
		bot->s.frame = 0;
		VectorCopy (spawn_origin, bot->s.origin);
		bot->s.origin[2] += 1;	// make sure off ground

		//KP_ADD
		VectorCopy (bot->s.origin, bot->s.old_origin);

		#if compileWHATISTHIS
		// bikestuff
		bot->biketime = 0;
		bot->bikestate = 0;

		// Ridah, Hovercars
		if (g_vehicle_test->value)
			{
			if (g_vehicle_test->value == 3)
			bot->s.modelindex = gi.modelindex ("models/props/moto/moto.mdx");
			else
			bot->s.modelindex = gi.modelindex ("models/vehicles/cars/viper/tris_test.md2");

			// ent->s.modelindex2 = 0;
			bot->s.skinnum = 0;
			bot->s.frame = 0;

			if ((int)g_vehicle_test->value == 1)
			bot->flags |= FL_HOVERCAR_GROUND;
			else if ((int)g_vehicle_test->value == 2)
			bot->flags |= FL_HOVERCAR;
			else if ((int)g_vehicle_test->value == 3)
			bot->flags |= FL_BIKE;
			else if ((int)g_vehicle_test->value == 4)
			bot->flags |= FL_CAR;
			}
	// done.
		else if (dm_locational_damage->value)	// deathmatch, note models must exist on server for client's to use them, but if the server has a model a client doesn't that client will see the default male model
		#else
		if (dm_locational_damage->value)	// deathmatch, note models must exist on server for client's to use them, but if the server has a model a client doesn't that client will see the default male model
		#endif
			{
			// NOTE: this is just here for collision detection, modelindex's aren't actually set
			bot->s.num_parts = 0;		// so the client's setup the model for viewing
			s = Info_ValueForKey (client->pers.userinfo, "skin");
			// converts some characters to NULL's
			len = strlen(s);
			did_slash = 0;
			for (i = 0; i < len; i++)
			{
			if (s[i] == '/')
				{
				s[i] = '\0';
				did_slash = true;
				}
			else if (s[i] == ' ' && did_slash)
				s[i] = '\0';
			}

			if (strlen(s) > MAX_QPATH - 1)
				s[MAX_QPATH - 1] = '\0';

			strcpy(modeldir, s);
		
			if (strlen(modeldir) < 1)
				strcpy( modeldir, "male_thug" );
		
			memset(&(bot->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		
			bot->s.num_parts++;
			strcpy( modelname, "players/" );
			strcat( modelname, modeldir );
			strcat( modelname, "/head.mdx" );
			bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
			gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
			if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
				gi.GetObjectBounds( "players/male_thug/head.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

			bot->s.num_parts++;
			strcpy( modelname, "players/" );
			strcat( modelname, modeldir );
			strcat( modelname, "/legs.mdx" );
			bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
			gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
			if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
				gi.GetObjectBounds( "players/male_thug/legs.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

			bot->s.num_parts++;
			strcpy( modelname, "players/" );
			strcat( modelname, modeldir );
			strcat( modelname, "/body.mdx" );
			bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
			gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
			if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
				gi.GetObjectBounds( "players/male_thug/body.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

			bot->s.num_parts++;
			bot->s.model_parts[PART_GUN].modelindex = 255;
			}
		else	// make sure we can see their weapon
			{
			memset(&(bot->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
			bot->s.model_parts[PART_GUN].modelindex = 255;
			bot->s.num_parts = PART_GUN + 1;	// make sure old clients receive the view weapon index
			}

		//KP_END


		// set the delta angle
		for (i = 0; i < 3; i++)
			client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);

		bot->s.angles[PITCH] = 0;
		bot->s.angles[YAW] = spawn_angles[YAW];
		bot->s.angles[ROLL] = 0;
		VectorCopy (bot->s.angles, client->ps.viewangles);
		VectorCopy (bot->s.angles, client->v_angle);
	
		// force the current weapon up
		client->newweapon = client->pers.weapon;
		ChangeWeapon (bot);

		bot->enemy									= NULL;
		bot->movetarget							= NULL; 
		bot->botInfo->state					= 0; // BOTSTATE_FOLLOWPATH
		bot->botInfo->extra					= 0;
		// Set the current node
		bot->botInfo->nodeCurrent		= BOTNODE_INVALID;
		bot->botInfo->nodeGoal			= BOTNODE_INVALID;
		bot->botInfo->nodeNext			= BOTNODE_INVALID;
		bot->botInfo->taskClass			= BOTROLE_LONEWOLF;
		bot->botInfo->taskNow				= TASK_NONE;

		// Kill anyone within spawn point
		KillBox(bot);
		gi.linkentity(bot);

		bot->think = ACEAI_Think;
		bot->nextthink = level.time + FRAMETIME;

		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (bot - g_edicts);
		gi.WriteByte (MZ_LOGIN);
		gi.multicast (bot->s.origin, MULTICAST_PVS);

		if (respawn)
			botChatInitiate(bot, bot->botInfo->def.c_respawn, false, false);
		else
			botChatInitiate(bot, bot->botInfo->def.c_gamejoin, false, false);
		}



	/******************************************************************************
   
		 Find a free client spot

	******************************************************************************/
	edict_t *findFreeClient ()
		{
		edict_t *entity;
		int			i;

		// Clients are registered at the end of the list
		for (i = maxclients->value; i > 0; i--)
			{
			entity = g_edicts + i + 1;
			if (!entity->inuse)
				return entity;
			}
		return NULL;
		}



	/******************************************************************************
   
		 Spawn bot

	******************************************************************************/
	void BotSpawn(botinfo_t *botinfo, int team)
		{
		edict_t	*bot;
		char		userinfo[MAX_INFO_STRING];

		// Check if this bot is already in
		#if (compileTEST)
		if (botMisc_CatchBot(getString(botinfo->def.ofsName), NULL))
			{
			gi.dprintf("%s is already connected.\n", getString(botinfo->def.ofsName));
			return;
			}
		#else
		if (botMisc_CatchBot(botinfo->def.name, NULL))
			{
			gi.dprintf("%s is already connected.\n", botinfo->def.name);
			return;
			}
		#endif
		// Check if there's room for another client
		bot = findFreeClient();
		if (!bot)
			{
			safe_bprintf(PRINT_MEDIUM, "Server is full, increase Maxclients.\n");
			return;
			}

		// Setup bot
		bot->inuse				= true;
		bot->botInfo			= botinfo;
		//bot->yaw_speed		= 48 + (64 * bot->botInfo->def.navigation); // yaw speed, used to be 127

		// Setup user info
		memset(userinfo, 0x00, sizeof(userinfo));
		#if (compileTEST)
		Info_SetValueForKey(userinfo, "name",		getString(bot->botInfo->def.ofsName));
		Info_SetValueForKey(userinfo, "skin",		getString(bot->botInfo->def.ofsSkin));
		Info_SetValueForKey(userinfo, "extras",	getString(bot->botInfo->def.ofsExtras));
		Info_SetValueForKey(userinfo, "hand",		getString(bot->botInfo->def.ofsHand));
		#else
		Info_SetValueForKey(userinfo, "name",		bot->botInfo->def.name);
		Info_SetValueForKey(userinfo, "skin",		bot->botInfo->def.skin);
		Info_SetValueForKey(userinfo, "extras",	bot->botInfo->def.extras);
		Info_SetValueForKey(userinfo, "hand",		bot->botInfo->def.hand);
		#endif

		// Spawn bot
		ClientConnect(bot, userinfo);

		// Link entity
		G_InitEdict(bot);
		InitClientResp(bot->client);

		// Move bot to a spawn point
		PutBotClientInServer(bot, false, team);

		ClientEndServerFrame(bot);
		jb_Player[jb_NumPlayers++] = bot;	// add bot to player pile

		bot->botInfo->nodeCurrent = botMisc_CurrentNode(bot);
		bot->botInfo->inUse = true;
		botAi_KillGoal(bot);
		}
 

	/******************************************************************************

	   Remove player from list

	******************************************************************************/
	void BotClientRemoved(edict_t *ent)
		{
		int i, j;

		// Watch for 0 players
		if (!jb_NumPlayers)
			return;

		// Crush player list
		if (jb_NumPlayers != 1)
			{
			for (i = 0; i < jb_NumPlayers; i++)
				{
				if (ent != jb_Player[i])
					continue;
				for (j = i; j < jb_NumPlayers - 1; j++)
					jb_Player[j] = jb_Player[j + 1];
				break;
				}
			}

		// Decrease player count
		jb_NumPlayers--;
		}

#endif