#include "g_local.h"
#if compileJACKBOT
	/******************************************************************************

		Inserted in
		void ShutdownGame (void) -- g_main.c

	******************************************************************************/
	void hook_Shutdown()
		{
		#if compileTEST
		// DESTROY STRING BANK //
		fs_stringBankDestroy(&jb_StringBank, &jb_StringBankSize);
		#endif
		}

	
	
	/******************************************************************************

		Inserted in
		void ClientBeginDeathmatch (void) -- p_client.c

		ClientBeginDeathmatch is loaded on map change; this hook manages map change,
		bot reload, etc. jb_NewMap is set in EndDMLevel();

	******************************************************************************/
	void hook_ClientBeginDeathmatch()
		{
		static char  currentMap[MAX_QPATH];

		if (jb_NewMap || strcmp(level.mapname, currentMap))
			{
			// RESET //
			strcpy(currentMap, level.mapname);
			jb_NewMap = false;

			#if (compileTEST)
			// INITIALIZE STRING BANK //
			fs_stringBankDestroy(&jb_StringBank, &jb_StringBankSize);
			fs_stringBankSetup(&jb_StringBank, &jb_StringBankSize, false);
			#endif

			// LOAD ROUTES AND BOTS //
			ACEND_InitNodes();
			fs_loadNodes();
			fs_loadBotList();
		
			// BAGMAN TERRITORY BORDER (store in WAY files instead?) //
			if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
				BagmanSplitTerritory();
			}
		}



	/******************************************************************************

		Inserted in
		void InitGame (void) -- g_save.c

	******************************************************************************/
	void hook_InitGame()
		{
		ACEND_InitNodes();
		
		// Node edit: view stuff
		bot_nodeviewdist		= gi.cvar ("bot_nodeviewdist",		"320",		CVAR_ARCHIVE);
		bot_nodeviewfade		= gi.cvar ("bot_nodeviewfade",		"192",		CVAR_ARCHIVE);
		bot_nodeviewupdate	= gi.cvar ("bot_nodeviewupdate",	"0.10",		CVAR_ARCHIVE);
		bot_nodeviewtest		= gi.cvar ("bot_nodeviewtest",		"1",			CVAR_ARCHIVE);
		bot_nodeviewlinks		= gi.cvar ("bot_nodeviewlinks",		"1",			CVAR_ARCHIVE);

		// Node edit: creation stuff
		bot_nodetrail				= gi.cvar ("bot_nodetrail",				"0",			CVAR_ARCHIVE);
		bot_nodeshrink			= gi.cvar ("bot_nodeshrink",			"3",			CVAR_ARCHIVE);
		bot_nodesound				= gi.cvar ("bot_nodesound",				"1",			CVAR_ARCHIVE);
		bot_nodeautosave		= gi.cvar ("bot_nodeautosave",		"60",			CVAR_ARCHIVE);

		bot_mute						= gi.cvar ("bot_mute",						"0",			CVAR_ARCHIVE);
		}



	/******************************************************************************

		Inserted in
		void ClientThink (edict_t *ent, usercmd_t *ucmd) -- p_client.c

	******************************************************************************/
	void hook_ClientThink(edict_t *ent)
		{
		if (jb_Debug & BOTDEBUG_ROUTE)
			{
			if (bot_nodetrail->value)			// Plant nodes
				edit_AutoNodeTrail(ent);
			if (bot_nodeviewlinks->value)	// Show nearby connections
				edit_ShowNearbyLinks(ent);
			if (jb_ShowPathTo != BOTNODE_INVALID) // Show path from node[jb_ShowPathFrom] to node[jb_ShowPathTo] (also used by bots)
				edit_ShowPath();
			if (jb_Debug & BOTDEBUG_NODEAREA)
				edit_AreaShow(ent);
			if ((bot_nodeautosave->value) && (jb_AutoSave < level.time))
				{
				if (bot_nodeautosave->value < 30)
					jb_AutoSave = level.time + 30.00;
				else
					jb_AutoSave = level.time + bot_nodeautosave->value;
				fs_saveNodes(true);
				}
			}
		}

#endif