

/*
	Routines to change text messages for weapons






*/

#include "g_local.h"

#define	INI_FILE	"hook.msg"

char	MsgCratered[51] = "cratered jam\x0";
char	MsgCrowbar[51] = "was severely dented by\x0";
char	MsgPistol[51] = "was busted by\x0";
char	MsgShotgun[51] = "accepted\x0";
char	MsgTommygun[51] = "bows to\x0";
char	MsgFlamethrower[51] = "roasted in\x0";
char	MsgGrenadeLauncher[51] = "was mortally wounded by\x0";
char	MsgRocket[51] = "was minced by\x0";
char	MsgRocketSplash[51] = "couldn't escape\x0";
char	MsgHMG[51] = "was maimed by\x0";

//
// Message file options
//
char	*option[] = 
	{ MsgCratered, MsgCrowbar, MsgPistol, MsgShotgun, MsgTommygun, MsgFlamethrower,
	  MsgGrenadeLauncher, MsgRocket, MsgRocketSplash, MsgHMG };

#define MAX_OPTIONS (sizeof(option)/sizeof(option[0]))

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void LoadDeathMessages( void )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	
	int		IniOption = 0, Processed = 0;

	char	Buffer[80], filename[256];
//	char	*VariableName = NULL, *VariableValue = NULL;

	static	qboolean	AlreadyRead = false;


	if (AlreadyRead)
		return;

	game_dir = gi.cvar ("game", "", 0);

    sprintf(filename, ".\\%s\\%s", game_dir->string, INI_FILE);

	// open the *.ini file

	if ((f = fopen (filename, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s Using defaults\n", INI_FILE);
		return;
		}

	gi.dprintf("\nProcessing %s \n", INI_FILE);

	// read 30 characters or until we get to the eof or a return for a newline.

	IniOption	= 0;

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{

		
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// copy this message over the existing one.
			strcpy( option[IniOption], Buffer );

			// This will remove the \n at the end of the line and change it to a NULL
			strtok(option[IniOption], "\n");

			IniOption++;
			Processed++;
			}
		}

	gi.dprintf("%d Death messages processed\n", Processed);
	fclose (f);
	AlreadyRead = true;	
	}
