

#include "g_local.h"


/**************************************************************************

Godfather enhancements prior to teamplay mods by J.Lucas

	12/03/00	Added enhanced MOTD and SHOWTABLE command so people can see
				in game what points get each level. Added the players level
				to the scoreboard and changed the length of the name so
				people can see your name better. Changed respawn invun so
				that its turned off when a weapon is picked up.

	13/03/00	Fixed a couple of things I'd left in by mistake. Added
				points to get to next level.
	
	14/03/00	Replaced respawn invun range checking after commenting out
				for testing. Ensured the scoreboard looks okay on 640x480
				screens as well as 800x600. Added "is the Godfather" onto
				the scoreboard when the game ends. Removed the points togo
				when there isn't anymore levels.

	01/04/00	Added GSlog support mainly so BC will run a Godfathers server.
				Next is to add the "showstats" command.

	14/05/00	Added resume feature as per Hitmen from the comp mod.

***************************************************************************
**************************************************************************

Godfather enhancements supplemental to Rat's updates - Thanks for good work

  Version 1.4
	1/10/00		Added Speed-cheat fix and spawn weapon cheat fix

  Version 1.5
		Will be adding personal tballs a la ROTM for first 3 levels
		Leader of game Glows (a la CTC) - but must be clear leader - optional
	
  ***************************************************************************/

void GF_LoadMOTD( void );
void ShowGFTable(edict_t *ent);

#define MOTD_lines		3

typedef struct   // Message of the Day
	{
	char textline[100];
	} MOTD_t;

	MOTD_t	MOTD[20];

//*************************************************************************


//***************************************************************************
//
//	Load the server changeable part of the MOTD into an array for use later.
//	

void GF_LoadMOTD( void )
	{

	FILE	*motd_file;
	char	line[80];
	int		i;

	// Open the motd file
	if (motd_file = fopen("godfather/motd.txt", "r"))
		{
		i = 0;

		// Read the lines now
		while ( fgets(line, 80, motd_file) )
			{
			// Once we've read a line copy it to the MOTD array.
			strcpy(MOTD[i].textline, line);
			i++;

			// We don't want more than 3 lines so lets piss off.
			if (i>3)
				break;
			}

		// be good now ! ... close the file
		fclose(motd_file);
		}
	}


//**********************************************************************
//
//	Function:	Displays a superb message of the day 
//
void MOTDScoreboardMessage (edict_t *ent)
	{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	char	*seperator = "++++++++++++++++++++++++++++++++";
	char	*bindhelp = "BIND A KEY TO SHOWTABLE FOR HELP";

	char	*selectheader[] =
			{
			"Atrophy Presents",
			"GODFATHERS v1.3b",
			"By Pigwhistler",
			"Extra code by Rat Instinct",
			"www.atrophy.co.uk",
			NULL
			};


	string[0] = 0;
	stringlength = 0;

	yofs = 80 - MOTD_lines * 10;
	if (yofs < 0 )
		yofs = 0;

	for (i=0; selectheader[i]; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 752 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 30;

	for (i=0; i< MOTD_lines; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 842 \"%s\" ",
			-5*strlen(MOTD[i].textline), yofs + (int)(-60.0+-3.5*14), MOTD[i].textline );

		j = strlen(entry);
		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}

		yofs += 20;
		}

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 999 \"%s\" ",
		-5*strlen(bindhelp), yofs + (int)(-60.0+-3.5*14), bindhelp );

	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}

//**********************************************************************
//
//	Function:	Displays the table from the website so people know
//				what weapons/points to aim for.
//

void ShowGFTable(edict_t *ent)
	{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	char	*seperator = "-----------------------------------------------------------";

	char	*selectheader[] =
			{
			"GODFATHERS POINTS TABLE",
			"=======================",
			"",
			"Level      Exp.  Weapon    Max Hlth  Killed  Armour",
			"--------------------------------------------------------",
			"Recruit    0     None         75       5     None",
			"Look-out   30    Magnum       100      10    None",
			"Thug       100   Shotgun      125      15    None",
			"Mobster    200   Tommy Gun    150      25    None",
			"Hitman     400   Tommy Gun    175      40    Full light",
			"Lieutenant 700   HMG          200      50    Full light",
			"CrimeLord  1000  HMG Cooled   200      75    Full light",
			"--------------------------------------------------------",
			"",
			"'Killed' is how many points you get for killing this level.",
			NULL
			};

	string[0] = 0;
	stringlength = 0;

	yofs = 30;

	if (yofs < 0 )
		yofs = 0;

	for (i=0; i<5; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 607 \"%s\" ", 30 , yofs + (int)(-60.0 + -3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	for (i=6; i<12; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 109 \"%s\" ", 30 , yofs + (int)(-60.0 + -3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	for (i=12; i<15; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 607 \"%s\" ", 30 , yofs + (int)(-60.0 + -3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	// End of the table
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 607 \"%s\" ", 30 , yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}


/***********************************************************************
/*
/*	Function:	Displays the current players stats compared to the
/*				leaders
/*
/**********************************************************************/
void ShowGodStats(edict_t *ent)
	{
	char	entry[1024];
	char	string[1400];
	int		stringlength, PlayerStats[7];
	int		i, j, stat, x, y, total;
	int		yofs, score;
	char	*seperator = "-----------------------------";
	edict_t	*cl_ent;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		temp;


	char	*selectheader[] =
			{
			"STATS FOR ",							//0
			"-----------------------------",		//1
			"Frags (Actual)      - ",				//2
			"Deaths by opponents - ",				//3
			"Suicides            - ",				//4
			"Kills per minute    - ",				//5
			"Longest time alive  - ",				//6
			"Current kill streak - ",				//7
			"Highest kill streak - ",				//8
			NULL
			};

	char	*selectheader2[] =
			{
			"LEADER STATS FOR ",					//0
			"-----------------------------",		//1
			"Frags (Actual)      - ",				//2
			"Deaths by opponents - ",				//3
			"Suicides            - ",				//4
			"Kills per minute    - ",				//5
			"Longest time alive  - ",				//6
			"Current kill streak - ",				//7
			"Highest kill streak - ",				//8
			NULL
			};

	PlayerStats[0] = ent->client->resp.score2;
	PlayerStats[1] = ent->client->resp.deaths;
	PlayerStats[2] = ent->client->resp.suicides;

	// Only do frags per minute if we have a positive score so we know we've actually
	// killed someone.
	if (ent->client->resp.score > 0)
		{
		temp = ((level.framenum - ent->client->resp.enterframe)/600);
		if (temp != 0)
			PlayerStats[3] = ent->client->resp.score2 / temp;
		else
			PlayerStats[3] = 0;			
		}
	else
		PlayerStats[3] = 0;

	PlayerStats[4] = ent->client->resp.timealive;
	PlayerStats[5] = ent->client->resp.killstreak;
	PlayerStats[6] = ent->client->resp.maxkillstreak;

	string[0] = 0;
	stringlength = 0;

	yofs = 10;

	if (yofs < 0 )
		yofs = 0;

	//
	// Write main heading with players names.
	//
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s%s\" ", 10 , yofs + (int)(-60.0 + -3.5*14), selectheader[0], ent->client->pers.netname);

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;

	//
	// Just the underline
	//
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s\" ", 10 , yofs + (int)(-60.0 + -3.5*14), selectheader[1]);

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;
	stat = 0;

	//
	// Now write the 7 lines of the actual stats
	//
	for (i=2; i<9; i++)
		{

		if (stat != 4)
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 999 \"%s%i\" ", 10 , yofs + (int)(-60.0 + -3.5*14), selectheader[i], PlayerStats[stat++] );
		else
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 999 \"%s%i%s\" ", 10 , yofs + (int)(-60.0 + -3.5*14), selectheader[i], PlayerStats[stat++], " Secs" );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	// End of the table
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s\" ", 10 , yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	// Sort the clients by score so we can display the leaders score
	// in the game

	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
		{
		cl_ent = g_edicts + 1 + i;

		if (!cl_ent->inuse)
			continue;

		score = game.clients[i].resp.score;

		for (x=0 ; x<total ; x++)
			{
			if (score > sortedscores[x])
				break;
			}

		for (y=total ; y>x ; y--)
			{
			sorted[y] = sorted[y-1];
			sortedscores[y] = sortedscores[y-1];
			}

		sorted[x] = i;
		sortedscores[x] = score;
		total++;
		}

	// Get the leaders edict structure.
	cl_ent = g_edicts + 1 + sorted[0];

	if (cl_ent->client->pers.netname == ent->client->pers.netname)
		goto skipleader;

	PlayerStats[0] = cl_ent->client->resp.score2;
	PlayerStats[1] = cl_ent->client->resp.deaths;
	PlayerStats[2] = cl_ent->client->resp.suicides;

	// Only do frags per minute if we have a positive score so we know we've actually
	// killed someone.
	if (cl_ent->client->resp.score > 0)
		{
		temp = ((level.framenum - ent->client->resp.enterframe)/600);
		if (temp != 0)
			PlayerStats[3] = ent->client->resp.score2 / temp;
		else
			PlayerStats[3] = 0;			
		}
	else
		PlayerStats[3] = 0;

	PlayerStats[4] = cl_ent->client->resp.timealive;
	PlayerStats[5] = cl_ent->client->resp.killstreak;
	PlayerStats[6] = cl_ent->client->resp.maxkillstreak;

	yofs = 10;

	//
	// Write main heading with player name
	//
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s%s\" ", 300 , yofs + (int)(-60.0 + -3.5*14), selectheader2[0], cl_ent->client->pers.netname);

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;

	//
	// Just the underline
	//
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s\" ", 300 , yofs + (int)(-60.0 + -3.5*14), selectheader2[1]);

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;
	stat = 0;

	//
	// Now write the 7 lines of the actual stats
	//
	for (i=2; i<9; i++)
		{

		if (stat != 4)
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 999 \"%s%i\" ", 300 , yofs + (int)(-60.0 + -3.5*14), selectheader2[i], PlayerStats[stat++] );
		else
		Com_sprintf (entry, sizeof(entry),
			"xl %i yv %i dmstr 999 \"%s%i%s\" ", 300 , yofs + (int)(-60.0 + -3.5*14), selectheader2[i], PlayerStats[stat++], " Secs" );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	// End of the table
	Com_sprintf (entry, sizeof(entry),
		"xl %i yv %i dmstr 960 \"%s\" ", 300 , yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;


skipleader:
	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}

/////////////////////////////////////////////////////////////////////////////////
//===================================================================


void RejoinScoreboardMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	char	*seperator = "==================================";
	char	*selectheader[] =
		{
			"Atrophy Presents Godfathers v1.3b",
			"By pigwhistler",
			"Send comments to : pigwhistler@atrophy.co.uk",
			"Respect goes to the Comp Mod lads for this code.",
			NULL
		};

	char	*rejoinheader[] =
		{
			"You were just playing on this server.",
			"Would you like to continue where you left off?",
			"Select the corresponding number or "
			"use [ ] and enter to make your selection.",
			NULL
		};
	char	*choices[] =
		{
			"1 - Yes",
			"2 - No",
			NULL
		};


	string[0] = 0;
	stringlength = 0;
	
	yofs = 0;

	for (i=0; selectheader[i]; i++)
	{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 752 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
	}
	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;
	yofs += 30;

	for (i=0; rejoinheader[i]; i++)
	{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 842 \"%s\" ",
			-5*strlen(rejoinheader[i]), yofs + (int)(-60.0+-3.5*14), rejoinheader[i] );

		j = strlen(entry);
		if (stringlength + j > 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
	}
	yofs += 30;
	for (i=0; choices[i]; i++)
	{
		if (ent->vote == i)
			Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 999 \"--> %s\" ",
					-5*40, yofs + (int)(-60.0+-3.5*14), choices[i]);
		else
			Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 777 \"    %s\" ",
					-5*40, yofs + (int)(-60.0+-3.5*14), choices[i]);

		j = strlen(entry);
		if (stringlength + j < 1024)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		yofs += 20;

	}


	gi.WriteByte (svc_layout);
	gi.WriteString (string);

}


/////////////////////////////////////////////////////////////////////////////////


