//CTF_main.c - core control routines

#include "g_local.h"

char* Address_URL = "www.captaindeath.com";
char* Address_Download = "www.captaindeath.com/kingpin/";
cvar_t *capture_limit;
cvar_t *URL1;
cvar_t* spawn_ratio;

CTF_Game_Struct CTF_Game;
char CTF_Version_Command[8];
char CTF_Pain_Skins_Command[8];	//Check the value of r_painskins

char* CTF_Flag_Model_Array[2] = {
	"models/props/flag/dragon_flag.mdx",
	"models/props/flag/nikki_flag.mdx"
};


void CTF_Version_Check(edict_t *ent)
{//Called when client connects for the first time
	char buf[64];

	sprintf(buf, "%s $ctfxmasver\n", CTF_Version_Command);
	gi.WriteByte(svc_stufftext);
	gi.WriteString(buf);
	gi.unicast(ent, true);

//Remove the CTF_Pain_Skins_Check() and replace the sprintf line above with this one if only checking when player connects
//	sprintf(buf, "%s $ctfxmasver\n%s $r_painskins\n", CTF_Version_Command, CTF_Pain_Skins_Command);
}

void CTF_Pain_Skins_Check(edict_t *ent)
{//Called at every map change
	char buf[64];

	sprintf(buf, "%s $r_painskins\n", CTF_Pain_Skins_Command);
	gi.WriteByte(svc_stufftext);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

//On level end, do not just drop the flags from players. Respawn back at their bases or dont bother. who cares...?

void CTF_Version_Check_Fail(edict_t *ent, Version_Check_State Reason)
{
	char buf[256];
	
	switch(Reason)
	{
		default:
		{
			sprintf(buf, "Error \"CTF Xmas client file check error\"\n");
			break;
		}
		case CLIENT_FILES_NONE:
		{
			sprintf(buf, "Error \"You must have the CTF Xmas client files to play. Download from: %s\"\n", Address_Download);
			break;
		}
		case CLIENT_FILES_OLD:
		{
			sprintf(buf, "Error \"CTF Xmas has been updated. Download the latest version from: %s\"\n", Address_Download);
			break;
		}
	}
	gi.WriteByte(svc_stufftext);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void CTF_Precache_Items(gclient_t *client)
{
	gitem_t *item;
	
//Give player a harpoon
	if ((int)harpoon_enable->value == 0)
		return;
//Check if map has harpoon override
	if (CTF_Game.Harpoon_Enable_Override == true)
		return;
	item = FindItem("Harpoon");
	client->pers.inventory[ITEM_INDEX(item)] = 1;
	PrecacheItem(item);
}

void CTF_Initialise_Level(void)
{//Called each map load and match start
//Reset the game data
	CTF_Game.team_score[0] = 0;
	CTF_Game.team_score[1] = 0;
	CTF_Game.capture_time[0] = 0;
	CTF_Game.capture_time[1] = 0;
}

void CTF_Initialise_Game(void)
{//Called at each map load prior to entity spawn

	CTF_Game.Harpoon_Enable_Override = false;	//Do not override harpoon auto-allocate

	CTF_Game.team_score[0] = 0;
	CTF_Game.team_score[1] = 0;
	CTF_Game.capture_time[0] = 0;
	CTF_Game.capture_time[1] = 0;
	CTF_Game.CrashedPlayerCheckTime = CTF_CRASHED_PLAYER_CHECK_DELAY;

//NOTE!! Since manually precaching sounds here, not adding in the ctf_flag_dummy item (Flag holster)
//Precache flag models
	CTF_Game.Flag_Model_Index[0] = gi.modelindex(CTF_Flag_Model_Array[0]);
	CTF_Game.Flag_Model_Index[1] = gi.modelindex(CTF_Flag_Model_Array[1]);
//Capture sound
	CTF_Game.Flag_Steal_Sound = gi.soundindex("flag/itschristmas.wav");
	CTF_Game.Flag_Capture_Sound = gi.soundindex("flag/hallelujah.wav");
	CTF_Game.Flag_Return_Sound = gi.soundindex("flag/raspberry.wav");

//Initialise the harpoon parameters
	Harpoon_Initialise();
//Initialise the spawn arrays
	CTF_Spawn_Initialise();
//Reset the flags
	CTF_Flag_Initialise();
}

void CTF_Player_Data_Reset(edict_t* ent)
{//Called when a player connects or at map change

//Reset the harpoon if it is active
//	CTF_Player_Harpoon_Reset(ent);

//Reset the CTF specific data
	ent->client->resp.score = 0;			//Frags + flags + bonus
	ent->client->resp.deposited = 0;		//Deaths
	ent->client->resp.PlayerData.Frags = 0;	//Frags
	ent->client->resp.PlayerData.Flag_State = CTF_DATA_FLAG_STATE_NULL;
	ent->client->resp.PlayerData.Enemy_Flag_Stolen = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Stolen_Captures = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Pickup_Captures = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Pickups = 0;
	ent->client->resp.PlayerData.Team_Flag_Rescued = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Total_Captures = 0;
}

void CTF_Effects(edict_t *ent)
{
	ent->s.renderfx2 &= ~RF2_MONEYBAG;
	if (ent->health > 0)
	{
		if (ent->client->resp.PlayerData.Flag_State != CTF_DATA_FLAG_STATE_NULL)
		{
			ent->s.renderfx2 |= RF2_MONEYBAG;
		}
	}
}

void Cmd_SetCaptureLimit_f(edict_t *ent, char *value)
{
	if (ent->client->pers.admin > NOT_ADMIN)
	{
//Check that a value was actually entered
		if (*value == 0x00)
		{
			cprintf(ent, PRINT_HIGH, "Usage: setcapturelimit <value>\n");
			return;
		}
		int i = atoi(value);
		if (i < 0)
		{
			cprintf(ent, PRINT_HIGH, "Please choose a positive capturelimit\n");
			return;
		}
		gi.bprintf(PRINT_HIGH, "The capturelimit has been changed to %d\n", i);
		gi.cvar_set("capturelimit", value);
	}
	else
		cprintf(ent, PRINT_HIGH, "You do not have admin\n");
}

void SP_CTF_Dummy(edict_t *self)
{
	//Just delete the entity
	G_FreeEdict(self);
}
/*
Bugs:
No flag icons showing when a flag is picked up - STAT offsets conflict with HUD team icon - FIXED

Player HUD frags is showing score / captures instead of score / frags - This will be changed to show score / frags.

Harpoon sounds and some models missing (requires new pak installed) - OK when new pak used

When going to NO_SCOREBOARD state, overlay is not being cleared.This should probably be handled by the overlay 0, 1, 2 logic (what power2 needed to change)
Skin code has still to be done. Remember this requires the CTF skin names entered into the relevant skinset arrays.
Remember to note the runt leg skins - these appear to be thug legs 4 & 5. Check the code has these correctly.
CTF_Crashed_Player_Check() not being called - add in the call.
Check for any other important routines not having their calls added yet.

Also:
Check the logic for the team score and how this relates to end game rules.
At the moment there is no check for team reaching a score, so is the team score really required?
It probably has no meaning.Probably total team frags, captures, timelimit only.
Could leave at total frags as now, and have capture limit ending game.
So, total frags and total captures would end the game as well as timelimit. Team score would have no effect (ie, none of the points awarded for captures would matter)

Remove teamcompound-ctf.bsp from the client pack, map list, levelshot, etc - Done

When a bonus is awarded, say it is a bonus. It only says bonus when defending a flag.

Also look into the points system here. The team points are mostly irrelevant. The player stats are just that - stats.

Possibly change the scoring so that only the player is awarded points, but this accumulates in the team points to be used with the fraglimit.

So, a player gets a frag by killing someone. Player gets a frag, and so does the team frag count.
Player kills himself, player loses a frag. Team loses a frag also.
The team frags are the accumulation of all the players in that team.

CTF bonuses should be set as follows:
Steal flag from base - 2 points
Pickup stray flag - 0 or 1 point.
Rescue team flag - 1 point.
Capture enemy flag (ie return to base) - 2 points for home run, 1 for pickup.

These get added to the player frag total, and also added to the team total.

This total is used for the fraglimit parameter, and should be set at a decent amount.

Note that usually timelimit and capturelimit will be used together.

So, player score will be frags + bonus
Player stats will continue to have separate frags column
*/
