//CTF_main.c - core control routines

#include "g_local.h"

char* Address_URL = "www.captaindeath.com";
char* Address_Download = "www.captaindeath.com/kingpin/";
cvar_t *capture_limit;
cvar_t *URL1;
cvar_t* spawn_ratio;

CTF_Game_Struct CTF_Game;
char CTF_Version_Command[8];

char* CTF_Flag_Model_Array[2] = {
	"models/props/flag/dragon_flag.mdx",
	"models/props/flag/nikki_flag.mdx"
};


void CTF_Version_Check(edict_t *ent)
{
	char buf[32];
	sprintf(buf, "%s $ctfver\n", CTF_Version_Command);
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void CTF_Version_Check_Fail(edict_t *ent, Version_Check_State Reason)
{
	char buf[256];
	
	switch(Reason)
	{
		default:
		{
			sprintf(buf, "Error \"Colors - CTF client file check error\"\n");
			break;
		}
		case CLIENT_FILES_NONE:
		{
			sprintf(buf, "Error \"You must have the Colors - CTF client files to play. Download from: %s\"\n", Address_Download);
			break;
		}
		case CLIENT_FILES_OLD:
		{
			sprintf(buf, "Error \"Colors - CTF has been updated. Download the latest version from: %s\"\n", Address_Download);
			break;
		}
	}
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void CTF_Precache_Items(gclient_t *client)
{
	gitem_t *item;
	
//Give player a harpoon
	if ((int)harpoon_enable->value == 0)
		return;
//Check if map has harpoon override
	if (CTF_Game.Harpoon_Enable_Override == true)
		return;
	item = FindItem("Harpoon");
	client->pers.inventory[ITEM_INDEX(item)] = 1;
	PrecacheItem(item);
}

void CTF_Initialise_Level(void)
{//Called each map load and match start
//Reset the game data
	CTF_Game.team_score[0] = 0;
	CTF_Game.team_score[1] = 0;
	CTF_Game.capture_time[0] = 0;
	CTF_Game.capture_time[1] = 0;
}

void CTF_Initialise_Game(void)
{//Called at each map load prior to entity spawn

	CTF_Game.Harpoon_Enable_Override = false;	//Do not override harpoon auto-allocate

	CTF_Game.team_score[0] = 0;
	CTF_Game.team_score[1] = 0;
	CTF_Game.capture_time[0] = 0;
	CTF_Game.capture_time[1] = 0;
	CTF_Game.CrashedPlayerCheckTime = CTF_CRASHED_PLAYER_CHECK_DELAY;

//NOTE!! Since manually precaching sounds here, not adding in the ctf_flag_dummy item (Flag holster)
//Precache flag models
	CTF_Game.Flag_Model_Index[0] = gi.modelindex(CTF_Flag_Model_Array[0]);
	CTF_Game.Flag_Model_Index[1] = gi.modelindex(CTF_Flag_Model_Array[1]);
//Capture sound
	CTF_Game.Flag_Steal_Sound = gi.soundindex("world/alarm.wav");	//gi.soundindex("flag/flagtk.wav"); Does this sound exist?
	CTF_Game.Flag_Capture_Sound = gi.soundindex("world/trainhorn.wav");	//gi.soundindex("flag/flagcap.wav"); Does this sound exist?
	CTF_Game.Flag_Return_Sound = gi.soundindex("flag/flagret.wav");

//Initialise the harpoon parameters
	Harpoon_Initialise();
//Reset the flags
	CTF_Flag_Initialise();
}

void CTF_Player_Data_Reset(edict_t* ent)
{//Called when a player connects or at map change

//Reset the harpoon if it is active
//	CTF_Player_Harpoon_Reset(ent);

//Reset the CTF specific data
	ent->client->resp.score = 0;			//Frags + flags + bonus
	ent->client->resp.deposited = 0;		//Deaths
	ent->client->resp.PlayerData.Frags = 0;	//Frags
	ent->client->resp.PlayerData.Flag_State = CTF_DATA_FLAG_STATE_NULL;
	ent->client->resp.PlayerData.Enemy_Flag_Stolen = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Stolen_Captures = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Pickup_Captures = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Pickups = 0;
	ent->client->resp.PlayerData.Team_Flag_Rescued = 0;
	ent->client->resp.PlayerData.Enemy_Flag_Total_Captures = 0;
}

void CTF_Effects(edict_t *ent)
{
	ent->s.renderfx2 &= ~RF2_MONEYBAG;
	if (ent->health > 0)
	{
		if (ent->client->resp.PlayerData.Flag_State != CTF_DATA_FLAG_STATE_NULL)
		{
			ent->s.renderfx2 |= RF2_MONEYBAG;
		}
	}
}

void Cmd_SetCaptureLimit_f(edict_t *ent, char *value)
{
	if (ent->client->pers.admin > NOT_ADMIN)
	{
//Check that a value was actually entered
		if (*value == 0x00)
		{
			cprintf(ent, PRINT_HIGH, "Usage: setcapturelimit <value>\n");
			return;
		}
		int i = atoi(value);
		if (i < 0)
		{
			cprintf(ent, PRINT_HIGH, "Please choose a positive capturelimit\n");
			return;
		}
		gi.bprintf(PRINT_HIGH, "The capturelimit has been changed to %d\n", i);
		gi.cvar_set("capturelimit", value);
	}
	else
		cprintf(ent, PRINT_HIGH, "You do not have admin\n");
}

void SP_CTF_Dummy(edict_t *self)
{
	//Just delete the entity
	G_FreeEdict(self);
}
