#include <stdio.h>

#include <stdlib.h>

#include <string.h>

#include <stdarg.h>



//

// key / value info strings

//

#define	MAX_INFO_KEY		64

#define	MAX_INFO_VALUE		64

#define	MAX_INFO_STRING		512



/*

============================================================================



					SOME OF ID'S QUAKE2 DLL FUNCTIONS



============================================================================

*/



#ifndef GAME_HARD_LINKED

void Com_Printf (char *msg, ...)

{

	va_list	argptr;

	char	text[1024];



	va_start (argptr, msg);

	vsprintf (text, msg, argptr);

	va_end (argptr);



	fprintf (stderr,"%s", text);

}

#endif



// FIXME: replace all Q_stricmp with Q_strcasecmp

int Q_stricmp (char *s1, char *s2)

{

#if defined(WIN32)

	return _stricmp (s1, s2);

#else

	return strcasecmp (s1, s2);

#endif

}



int Q_strncasecmp (char *s1, char *s2, int n)

{

	int c1, c2;



	do

	{

		c1 = *s1++;

		c2 = *s2++;



		if (!n--) return 0;		// strings are equal until end point



		if (c1 != c2)

		{

			if (c1 >= 'a' && c1 <= 'z')

				c1 -= ('a' - 'A');

			if (c2 >= 'a' && c2 <= 'z')

				c2 -= ('a' - 'A');

			if (c1 != c2)

				return -1;	// strings not equal

		}

	} while (c1);



	return 0;		// strings are equal

}



int Q_strcasecmp (char *s1, char *s2)

{

	return Q_strncasecmp (s1, s2, 99999);

}



/*

===============

Info_ValueForKey



Searches the string for the given

key and returns the associated value, or an empty string.

===============

*/



char *Info_ValueForKey (char *s, char *key)

{

	char	pkey[512];

	static	char value[2][512];	// use two buffers so compares

								// work without stomping on each other

	static	int	valueindex;

	char	*o;

	

	valueindex ^= 1;

	if (*s == '\\') s++;



	while (1)

	{

		o = pkey;

		while (*s != '\\')

		{

			if (!*s) return "";

			*o++ = *s++;

		}

		*o = 0;

		s++;



		o = value[valueindex];



		while (*s != '\\' && *s) *o++ = *s++;

		*o = 0;



		if (!strcmp (key, pkey) )

			return value[valueindex];



		if (!*s) return "";

		s++;

	}

}



void Info_RemoveKey (char *s, char *key)

{

	char	*start;

	char	pkey[512];

	char	value[512];

	char	*o;



	if (strstr (key, "\\"))

	{

//		Com_Printf ("Can't use a key with a \\\n");

		return;

	}



	while (1)

	{

		start = s;

		if (*s == '\\') s++;

		o = pkey;

		while (*s != '\\')

		{

			if (!*s) return;

			*o++ = *s++;

		}

		*o = 0;

		s++;



		o = value;

		while (*s != '\\' && *s) *o++ = *s++;

		*o = 0;



		if (!strcmp (key, pkey) )

		{

			strcpy (start, s);	// remove this part

			return;

		}



		if (!*s) return;

	}



}



void Info_SetValueForKey (char *s, char *key, char *value)

{

	char newi[MAX_INFO_STRING], *v;

	unsigned maxsize = MAX_INFO_STRING;



	if (strstr (key, "\\") || strstr (value, "\\") )

	{

		Com_Printf ("Can't use keys or values with a \\\n");

		return;

	}



	if (strstr (key, ";") )

	{

		Com_Printf ("Can't use keys or values with a semicolon\n");

		return;

	}



	if (strstr (key, "\"") || strstr (value, "\"") )

	{

		Com_Printf ("Can't use keys or values with a \"\n");

		return;

	}



	if (strlen(key) > MAX_INFO_KEY-1 || strlen(value) > MAX_INFO_KEY-1)

	{

		Com_Printf ("Keys and values must be < 64 characters.\n");

		return;

	}

	Info_RemoveKey (s, key);

	if (!value || !strlen(value))

		return;



	sprintf(newi, "\\%s\\%s", key, value);



	if (strlen(newi) + strlen(s) > maxsize)

	{

		Com_Printf ("Info string length exceeded\n");

		return;

	}



	// only copy ascii values

	s += strlen(s);



	// Zarjazz++

	if ( *(s-1) == '\\' ) s--;

	// --Zarjazz



	v = newi;

	while (*v)

	{

		char c;



		c = *v++;

		c &= 127;		// strip high bits

		if (c >= 32 && c < 127)

			*s++ = c;

	}

	*s = 0;

}

