

#include "shared.h"



/*

==============================================================



COLLISION DETECTION



==============================================================

*/



// plane_t structure

// !!! if this is changed, it must be changed in asm code too !!!

typedef struct q2_cplane_s

{

	vec3_t	normal;

	float	dist;

	byte	type;			// for fast side tests

	byte	signbits;		// signx + (signy<<1) + (signz<<1)

	byte	pad[2];

} q2_cplane_t;



// a trace is returned when a box is swept through the world

typedef struct

{

	qboolean	allsolid;	// if true, plane is not valid

	qboolean	startsolid;	// if true, the initial point was in a solid area

	float		fraction;	// time completed, 1.0 = didn't hit anything

	vec3_t		endpos;		// final position

	q2_cplane_t	plane;		// surface normal at impact

	csurface_t	*surface;	// surface hit

	int			contents;	// contents on other side of surface hit

	struct edict_s	*ent;	// not set by CM_*() functions

} q2_trace_t;



// this structure needs to be communicated bit-accurate

// from the server to the client to guarantee that

// prediction stays in sync, so no floats are used.

// if any part of the game code modifies this struct, it

// will result in a prediction error of some degree.

typedef struct

{

	pmtype_t	pm_type;



	short		origin[3];		// 12.3

	short		velocity[3];	// 12.3

	byte		pm_flags;		// ducked, jump_held, etc

	byte		pm_time;		// each unit = 8 ms

	short		gravity;

	short		delta_angles[3];	// add to command angles to get view direction

									// changed by spawns, rotating objects, and teleporters

} q2_pmove_state_t;



typedef struct

{

	// state (in / out)

	q2_pmove_state_t	s;



	// command (in)

	usercmd_t		cmd;

	qboolean		snapinitial;	// if s has been changed outside pmove



	// results (out)

	int			numtouch;

	struct q2_edict_s	*touchents[MAXTOUCH];



	vec3_t		viewangles;			// clamped

	float		viewheight;



	vec3_t		mins, maxs;			// bounding box size



	struct q2_edict_s	*groundentity;

	int			watertype;

	int			waterlevel;



	// callbacks to test the world

	q2_trace_t		(*trace) (vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end);

	int			(*pointcontents) (vec3_t point);

} q2_pmove_t;



/*

==========================================================



  ELEMENTS COMMUNICATED ACROSS THE NET



==========================================================

*/



// q2_entity_state_t is the information conveyed from the server

// in an update message about entities that the client will

// need to render in some way

typedef struct q2_entity_state_s

{

	int		number;			// edict index



	vec3_t	origin;

	vec3_t	angles;

	vec3_t	old_origin;		// for lerping

	int		modelindex;

	int		modelindex2, modelindex3, modelindex4;	// weapons, CTF flags, etc

	int		frame;

	int		skinnum;

	int		effects;

	int		renderfx;

	int		solid;			// for client side prediction, 8*(bits 0-4) is x/y radius

							// 8*(bits 5-9) is z down distance, 8(bits10-15) is z up

							// gi.linkentity sets this properly

	int		sound;			// for looping sounds, to guarantee shutoff

	int		event;			// impulse events -- muzzle flashes, footsteps, etc

							// events only go out for a single frame, they

							// are automatically cleared each frame

} q2_entity_state_t;



//==============================================



// player_state_t is the information needed in addition to q2_pmove_state_t

// to rendered a view.  There will only be 10 player_state_t sent each second,

// but the number of q2_pmove_state_t changes will be reletive to client

// frame rates

typedef struct

{

	q2_pmove_state_t	pmove;		// for prediction



	// these fields do not need to be communicated bit-precise



	vec3_t		viewangles;		// for fixed views

	vec3_t		viewoffset;		// add to pmovestate->origin

	vec3_t		kick_angles;	// add to view direction to get render angles

								// set by weapon kicks, pain effects, etc



	vec3_t		gunangles;

	vec3_t		gunoffset;

	int			gunindex;

	int			gunframe;



	float		blend[4];		// rgba full screen effect

	

	float		fov;			// horizontal field of view



	int			rdflags;		// refdef flags



	short		stats[MAX_STATS];		// fast status bar updates

} q2_player_state_t;





