///////////////////////////////////////////////////////////////////////
//
//  KOOGLE - A Quake II Bot Base Code Modified By {GT}TheGhost AKA Ernest Buffington
//  and Also Chief_SoChaToa AKA Frank Petersen for Blood Money and other mods.
//
//  Version 2.0b
//
//  ACE Bot is Copyright(c), Steve Yeager 1998, All Rights Reserved
//  
//  KOOGLE Bot is Copyright(c), Ernest Buffington & Frank Petersen 2001, 
//  All Rights Reserved
//
//	All other files are Copyright(c) Id Software, Inc.
//
//	Please see liscense.txt in the source directory for the copyright
//	information regarding those files belonging to Id Software, Inc.
//	
//	Should you decide to release a modified version of KOOGLE, you MUST
//	include the following text (minus the BEGIN and END lines) in the 
//	documentation for your modification.
//
//	--- BEGIN ---
//
//	The ACE Bot is a product of Steve Yeager, and is available from
//	the ACE Bot homepage, at http://www.axionfx.com/ace.
//
//	The KOOGLE Bot is a product of Ernest Buffington & Frank Petersen, 
//
//	This program is a modification of the ACE Bot, and is therefore
//	in NO WAY supported by Steve Yeager.

//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington or Frank Petersen
//
//	--- END ---
//
//	I, Ernest Buffington & Frank Petersen, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
//
//  I also wish to thank and acknowledge the great work of others
//  that has helped me to develop this code.
//
//  John Cricket    - For ideas and swapping code with steve yeager.
//  Ryan Feltrin    - For ideas and swapping code with steve yeager.
//  SABIN           - For showing how to do true client based movement
//  to steve yeager.
//  BotEpidemic     - For keeping steve yeager up to date.
//  Telefragged.com - For giving ACE Bot a home.
//  Microsoft       - For giving us such a wonderful crash free OS.
//  id              - Need I say more.
//  
//  And to all the other testers, pathers, and players and people
//  who I can't remember who the heck they were, but helped out.
//
///////////////////////////////////////////////////////////////////////
	
///////////////////////////////////////////////////////////////////////
//
//  kooglebot_ai.c -      This file contains all of the 
//                        AI routines for the KOOGLE bot.
//
//
// NOTE: Steve Yeager went back and pulled out most of the brains from
//       a number of these functions. They have been expanded on 
//       to provide a "higher" level of AI. 
//       "Thanks Steve for leaving out the best part!" DICK
////////////////////////////////////////////////////////////////////////

#include "g_local.h"
#include "m_player.h"

#include "kooglebot.h"

///////////////////////////////////////////////////////////////////////
// Main Think function for bot
///////////////////////////////////////////////////////////////////////
int cached_bot_state=0;

void KOOGLEAI_Think (edict_t *self)
{
	usercmd_t	ucmd;
    char *s;
	int i;

    s = Info_ValueForKey (self->client->pers.userinfo, "skin");

	// Set up client movement
	VectorCopy(self->client->ps.viewangles,self->s.angles);
	VectorSet (self->client->ps.pmove.delta_angles, 0, 0, 0);
	memset (&ucmd, 0, sizeof (ucmd));
	self->enemy = NULL;
	self->movetarget = NULL;

	
	// Force respawn 
	if (self->deadflag && self->is_bot)
	{
		self->client->buttons = 0;
		ucmd.buttons = BUTTON_ATTACK;
	}
	
	if(self->state == BOTSTATE_WANDER && self->wander_timeout < level.time)
	  KOOGLEAI_PickLongRangeGoal(self); // pick a new long range goal

	// Kill the bot if completely stuck somewhere
	if(VectorLength(self->velocity) > 37) //
		self->suicide_timeout = level.time + 10.0;

	if(self->suicide_timeout < level.time)
	{
		self->health = 0;
		meansOfDeath = MOD_SUICIDE;
		player_die (self, self, self, 1, vec3_origin,0,0);
	}
	
	// Find any short range goal
	KOOGLEAI_PickShortRangeGoal(self);


	// Look for enemies
	if(KOOGLEAI_FindEnemy(self))
	{	

        if (strstr(s,"qmale_goblin"))
		KOOGLEAI_ChooseWeaponGoblin(self);
        else
		KOOGLEAI_ChooseWeapon(self);
		
		KOOGLEMV_Attack (self, &ucmd);

	}
	else
	{

		// Execute the move, or wander
		if(self->state == BOTSTATE_WANDER)
			KOOGLEMV_Wander(self,&ucmd);
		else if(self->state == BOTSTATE_MOVE)
			KOOGLEMV_Move(self,&ucmd);
	}
	
	if (debug_state)
	{

       i = self->state;
	
	   if (i == cached_bot_state)
	   goto makemonkeybabies;

       cached_bot_state = self->state;

       switch(self->state)
	   {
	   case 0:
		debug_printf("\n%s Is Standing - ( State = %d )\n",self->client->pers.netname,self->state); 
		break;

	   case 1:
		debug_printf("\n%s Is Moving - ( State = %d )\n",self->client->pers.netname,self->state); 
		break;

	   case 2:
		debug_printf("\n%s Is Attacking - ( State = %d )\n",self->client->pers.netname,self->state); 
		break;

	   case 3:
		debug_printf("\n%s Is Wandering - ( State = %d )\n",self->client->pers.netname,self->state); 
		break;

	   case 4:
		debug_printf("\n%s Is Fleeing - ( State = %d )\n",self->client->pers.netname,self->state); 
		break;
	   }

	

	   

makemonkeybabies:

;	}

    if (self->is_bot){
	// set approximate ping
	ucmd.msec = 75 + floor (random () * 25) + 1;
	// show random ping values in scoreboard
	self->client->ping = ucmd.msec;
	}
	
	
	// set bot's view angle
	ucmd.angles[PITCH] = ANGLE2SHORT(self->s.angles[PITCH]);
	ucmd.angles[YAW] = ANGLE2SHORT(self->s.angles[YAW]);
	ucmd.angles[ROLL] = ANGLE2SHORT(self->s.angles[ROLL]);
	
	// send command through id's code
	ClientThink (self, &ucmd);
	
	self->nextthink = level.time + FRAMETIME;
}

///////////////////////////////////////////////////////////////////////
// Evaluate the best long range goal and send the bot on
// its way. This is a good time waster, so use it sparingly. 
// Do not call it for every think cycle.
///////////////////////////////////////////////////////////////////////
void KOOGLEAI_PickLongRangeGoal(edict_t *self)
{

	int i;
	int node;
	float weight,best_weight=0.0;
	int current_node,goal_node;
	edict_t *goal_ent;
	float cost;
	
	// look for a target 
	current_node = KOOGLEND_FindClosestReachableNode(self,BOTNODE_DENSITY,BOTNODE_ALL);

	self->current_node = current_node;
	
	if(current_node == -1)
	{
		self->state = BOTSTATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		self->goal_node = -1;
		return;
	}

	///////////////////////////////////////////////////////
	// Items
	///////////////////////////////////////////////////////
	for(i=0;i<num_items;i++)
	{
		if(item_table[i].ent == NULL || item_table[i].ent->solid == SOLID_NOT) // ignore items that are not there.
			continue;
		
		cost = KOOGLEND_FindCost(current_node,item_table[i].node);
		
		if(cost == INVALID || cost < 2) // ignore invalid and very short hops
			continue;
	
		weight = KOOGLEIT_ItemNeed(self, item_table[i].item);
/*
		// If I am on team one and I have the flag for the other team....return it
		if(ctf->value && (item_table[i].item == ITEMLIST_FLAG2 || item_table[i].item == ITEMLIST_FLAG1) &&
		  (self->client->resp.ctf_team == CTF_TEAM1 && self->client->pers.inventory[ITEMLIST_FLAG2] ||
		   self->client->resp.ctf_team == CTF_TEAM2 && self->client->pers.inventory[ITEMLIST_FLAG1]))
			weight = 10.0;
*/
		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
				
		if(weight > best_weight)
		{
			best_weight = weight;
			goal_node = item_table[i].node;
			goal_ent = item_table[i].ent;
		}
	}

	///////////////////////////////////////////////////////
	// Players
	///////////////////////////////////////////////////////
	// This should be its own function and is for now just
	// finds a player to set as the goal.
	for(i=0;i<num_players;i++)
	{
		if(players[i] == self)
			continue;

		node = KOOGLEND_FindClosestReachableNode(players[i],BOTNODE_DENSITY,BOTNODE_ALL);
		cost = KOOGLEND_FindCost(current_node, node);

		if(cost == INVALID || cost < 3) // ignore invalid and very short hops
			continue;
/*
		// Player carrying the flag?
		if(ctf->value && (players[i]->client->pers.inventory[ITEMLIST_FLAG2] || players[i]->client->pers.inventory[ITEMLIST_FLAG1]))
		  weight = 2.0;
		else*/
		  weight = 0.3; 
		
		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
		
		if(weight > best_weight)
		{		
			best_weight = weight;
			goal_node = node;
			goal_ent = players[i];
		}	
	}

	// If do not find a goal, go wandering....
	if(best_weight == 0.0 || goal_node == INVALID)
	{
		self->goal_node = INVALID;
		self->state = BOTSTATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		if(debug_mode)
			debug_printf("%s did not find a LR goal, wandering.\n",self->client->pers.netname);
		return; // no path? 
	}
	
	// OK, everything valid, let's start moving to our goal.
	self->state = BOTSTATE_MOVE;
	self->tries = 0; // Reset the count of how many times we tried this goal
	 
	if(goal_ent != NULL && debug_mode)
		debug_printf("%s selected a %s at node %d for LR goal.\n",self->client->pers.netname, goal_ent->classname, goal_node);

	KOOGLEND_SetGoal(self,goal_node);

}

///////////////////////////////////////////////////////////////////////
// Pick best goal based on importance and range. This function
// overrides the long range goal selection for items that
// are very close to the bot and are reachable.
///////////////////////////////////////////////////////////////////////
void KOOGLEAI_PickShortRangeGoal(edict_t *self)
{
	edict_t *target;
	float weight,best_weight=0.0;
	edict_t *best;
	int index;
	
	// look for a target (should make more efficent later)
	target = findradius(NULL, self->s.origin, 200);
	
	while(target)
	{
		if(target->classname == NULL)
			return;
		
		// Missle avoidance code
		// Set our movetarget to be the rocket or grenade fired at us. 
		if(strcmp(target->classname,"rocket")==0 || strcmp(target->classname,"grenade")==0)
		{
			if(debug_mode) 
				debug_printf("ROCKET ALERT!\n");

			self->movetarget = target;
			return;
		}
	
		if (KOOGLEIT_IsReachable(self,target->s.origin))
		{
			if (infront(self, target))
			{
				index = KOOGLEIT_ClassnameToIndex(target->classname);
				weight = KOOGLEIT_ItemNeed(self, index);
				
				if(weight > best_weight)
				{
					best_weight = weight;
					best = target;
				}
			}
		}

		// next target
		target = findradius(target, self->s.origin, 200);
	}

	if(best_weight)
	{
		self->movetarget = best;
		
		if(debug_mode && self->goalentity != self->movetarget)
			debug_printf("%s selected a %s for SR goal.\n",self->client->pers.netname, self->movetarget->classname);
		
		self->goalentity = best;

	}

}

///////////////////////////////////////////////////////////////////////
// Scan for enemy (simplifed for now to just pick any visible enemy)
///////////////////////////////////////////////////////////////////////


qboolean KOOGLEAI_FindEnemy(edict_t *self)
{
	int i;

	for(i=0;i<=num_players;i++)
	{

		//TheGhost added FL_NOTARGET for node setup
		//type notargetme in the console to keep bots from attacking me...
		if(players[i] == NULL 
			|| players[i] == self 
			|| players[i]->solid == SOLID_NOT
			|| players[i]->flags & FL_NOTARGET)
		   continue;

 //      if ( (!strcmp(self->client->pers.netname, "{GT}TheGh0st")) && (teamplay->value) )
 //      self->client->pers.team = 1;
//	   else if ( (!strcmp(self->client->pers.netname, "{GT}Deeg")) && (teamplay->value) )
//       self->client->pers.team = 2;
//	   else if ( (!strcmp(self->client->pers.netname, "{GT}PitBullet")) && (teamplay->value) )
//       self->client->pers.team = 2;
//	   else if ( (!strcmp(self->client->pers.netname, "{GT}Freak")) && (teamplay->value) )
//       self->client->pers.team = 1;

	   if(teamplay->value && self->client->pers.team == players[i]->client->pers.team)
	   continue;
//----------------------------------------------------------------------------------------
//GHOST_START
//added this so you can make the bots not kill each other in team mode
		if(CustBotStyle == 1)
		{
		   if(teamplay->value && self->client->pers.colorteam == players[i]->client->pers.colorteam)
		   continue;
		}
//GHOST_END

        // Ghost Add - Keeps bots from spinning while we are watching them from a spectators view
        if (players[i]->client->pers.spectator == SPECTATING)
        continue;

        if (debug_mode)
        continue;
		
		//----------------------------------------------------------------------------------------		
		if(!players[i]->deadflag && visible(self, players[i]) && gi.inPVS (self->s.origin, players[i]->s.origin))
		{
			self->enemy = players[i];
			return true;
		}
	}

	return false;
  
}

///////////////////////////////////////////////////////////////////////
// Hold fire with RL/BFG?
///////////////////////////////////////////////////////////////////////
qboolean KOOGLEAI_CheckShot(edict_t *self)
{
	trace_t tr;

	tr = gi.trace (self->s.origin, tv(-8,-8,-8), tv(8,8,8), self->enemy->s.origin, self, MASK_OPAQUE);
	
	// Blocked, do not shoot
	//keep the bots from shooting in debug mode
//	if (debug_mode)
//	{
//       return false; 
//	}
//	else
	if (tr.fraction != 1.0)
	{
		return false; 
	}
	
	return true;
}

///////////////////////////////////////////////////////////////////////
// Choose the best weapon for bot (simplified)
///////////////////////////////////////////////////////////////////////
void KOOGLEAI_ChooseWeapon(edict_t *self)
{	
	float range;
	vec3_t v;
	
	// if no enemy, then what are we doing here?
	if(!self->enemy)
	return;
	
	// Base selection on distance.
	VectorSubtract (self->s.origin, self->enemy->s.origin, v);
	
    range = VectorLength(v);

		
	// Longer range 
	if(range > 300)
	{
        //choose bazooka if enough ammo
        if(self->client->pers.inventory[ITEMLIST_ROCKETS] >= 4)
		if(KOOGLEAI_CheckShot(self) && KOOGLEIT_ChangeWeapon(self,FindItem("bazooka"))) return;
	}

//=======================================================================================================	
	// Only use GL in certain ranges and only on targets at or below our level
	else if(range > 100 && range < 500 && self->enemy->s.origin[2] - 20 < self->s.origin[2])
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Grenade Launcher"))) return;
    }

	// Only use FT at short range and only on targets at or below our level
//	else if(range < 128 && self->enemy->s.origin[2] - 20 < self->s.origin[2])
  //  {
	//if(KOOGLEIT_ChangeWeapon(self,FindItem("Grenade Launcher"))) return;
    //}
//=======================================================================================================


	// only use regular shotgun when you have 10 shotgun shells or less
	else if(self->client->pers.inventory[ITEMLIST_SHELLS] <= 10)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("shotgun"))) return;
    }


	// only use super shotgun when you have 11 shotgun shells or more
	else if(self->client->pers.inventory[ITEMLIST_SHELLS] >= 11)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Super Shotgun"))) return;
    }

//=======================================================================================================
	// Only use HMG when ammo you have 30 308 rounds or more
	else if(self->client->pers.inventory[ITEMLIST_AMMO308] >= 30)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Heavy machinegun"))) return;
    }
//=======================================================================================================

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 48) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 50))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("SPistol"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 50) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 100))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Tommygun"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 100) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 200))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("chaingun"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 200) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 300))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("machinegun"))) return;
    }


//=======================================================================================================

//    else if(self->client->pers.inventory[ITEMLIST_SLUGS] >= 1)
//    {
//	if(KOOGLEIT_ChangeWeapon(self,FindItem("Railgun"))) return;
//    }
//=======================================================================================================	
    else
    {

	if(KOOGLEIT_ChangeWeapon(self,FindItem("Crowbar"))) return;
	
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Pipe"))) return;
    }
	
	return;

}


void KOOGLEAI_ChooseWeaponGoblin(edict_t *self)
{	
	// if no enemy, then what are we doing here?
	if(!self->enemy)
	return;
	
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Pipe"))) 
    return;

}

void Cmd_botweapons_f (edict_t *ent)
{

	int rnd;

    char *s;

    s = ent->client->pers.userinfo, "skin";

    if (strstr(s,"qmale_goblin") && (ent->is_bot) )
    {
       if (ent->client->resp.botkills >= 1000)
	   {
         ent->client->pers.currentcash = 1000;
         ent->client->resp.botkills = 1000;
         ent->GoblinCash = 1000;
	   }
    
	   ent->health = 500;
       return;
    }
    else
    {
        ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] = 1;	
		
		rnd = rand()%4;

		switch (rnd)
		{
          case 0:
          ent->client->pers.inventory[ITEM_INDEX(FindItem("shotgun"))] += 1;	
          ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] += 50;	
          break;
		  case 1:
          ent->client->pers.inventory[ITEM_INDEX(FindItem("bazooka"))] += 1;	
          ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] += 50;	
          break;
		  case 2:
          ent->client->pers.inventory[ITEM_INDEX(FindItem("grenade launcher"))] += 1;	
          ent->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] += 50;	
          break;
		  case 3:
          ent->client->pers.inventory[ITEM_INDEX(FindItem("super shotgun"))] += 1;	
          ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] += 100;	
          break;
		}

       return;
	}
} 

