#ifndef _KOOGLEBOT_H
#define _KOOGLEBOT_H

// Only 100 allowed for now (probably never be enough edicts for 'em
#define MAX_BOTS 100

// Platform states
#define	STATE_TOP			0
#define	STATE_BOTTOM		1
#define STATE_UP			2
#define STATE_DOWN			3

// Maximum nodes
#define MAX_BOTNODES 1000

// Link types
#define INVALID -1

// Node types
#define BOTNODE_MOVE 0
#define BOTNODE_LADDER 1
#define BOTNODE_PLATFORM 2
#define BOTNODE_TELEPORTER 3
#define BOTNODE_ITEM 4
#define BOTNODE_WATER 5
#define BOTNODE_GRAPPLE 6
#define BOTNODE_JUMP 7

#define BOTNODE_ALL 99 // For selecting all nodes

// Density setting for nodes
#define BOTNODE_DENSITY 128

// Bot state types
#define BOTSTATE_STAND 0
#define BOTSTATE_MOVE 1
#define BOTSTATE_ATTACK 2
#define BOTSTATE_WANDER 3
#define BOTSTATE_FLEE 4

#define MOVE_LEFT 0
#define MOVE_RIGHT 1
#define MOVE_FORWARD 2
#define MOVE_BACK 3

// KingPin Item defines 
#define ITEMLIST_NULL				0

#define ITEMLIST_CASH				1
	
#define ITEMLIST_ARMORHELMET		2
#define ITEMLIST_ARMORJACKET		3
#define ITEMLIST_ARMORLEGS			4
#define ITEMLIST_ARMORHELMETHEAVY	5
#define ITEMLIST_ARMORJACKETHEAVY	6
#define ITEMLIST_ARMORLEGSHEAVY		7

#define ITEMLIST_BLACKJACK          8
#define ITEMLIST_CROWBAR			9
#define ITEMLIST_PISTOL				10
#define ITEMLIST_SPISTOL			11
#define ITEMLIST_SHOTGUN			12
#define ITEMLIST_TOMMYGUN			13
#define ITEMLIST_HEAVYMACHINEGUN	14
#define ITEMLIST_GRENADELAUNCHER	15
#define ITEMLIST_BAZOOKA			16
#define ITEMLIST_FLAMETHROWER		17
#define ITEMLIST_SHOTGUN_E			18
#define ITEMLIST_HEAVYMACHINEGUN_E	19
#define ITEMLIST_BAZOOKA_E			20
#define ITEMLIST_FLAMETHROWER_E		21
#define ITEMLIST_GRENADELAUNCHER_E	22
#define ITEMLIST_PISTOL_E			23
#define ITEMLIST_TOMMYGUN_E			24

#define ITEMLIST_GRENADES			25

#define ITEMLIST_SHELLS				26
#define ITEMLIST_BULLETS			27
#define ITEMLIST_ROCKETS			28
#define ITEMLIST_AMMO308			29
#define ITEMLIST_CYLINDER			30
#define ITEMLIST_FLAMETANK			31

// #define ITEMLIST_COIL				32
// #define ITEMLIST_LIZZYHEAD			33
// #define ITEMLIST_CASHROLL			34
// #define ITEMLIST_CASHBAGLARGE		35
// #define ITEMLIST_CASHBAGSMALL		36
// #define ITEMLIST_BATTERY			37
// #define ITEMLIST_JETPACK			38

#define ITEMLIST_HEALTH_SMALL		39
#define ITEMLIST_HEALTH_LARGE		40
// #define ITEMLIST_FLASHLIGHT			41
// #define ITEMLIST_WATCH				42
// #define ITEMLIST_WHISKEY			43
#define ITEMLIST_PACK				44
#define ITEMLIST_ADRENALINE			45
// #define ITEMLIST_KEYFUSE			46
// #define ITEMLIST_SAFEDOCS			47
// #define ITEMLIST_VALVE				48
// #define ITEMLIST_OILCAN				49
// #define ITEMLIST_KEY1				50
// #define ITEMLIST_KEY2				51
// #define ITEMLIST_KEY3				52
// #define ITEMLIST_KEY4				53
// #define ITEMLIST_KEY5				54
// #define ITEMLIST_KEY6				55
// #define ITEMLIST_KEY7				56
// #define ITEMLIST_KEY8				57
// #define ITEMLIST_KEY9				58
// #define ITEMLIST_KEY10				59

#define ITEMLIST_PISTOLMODS			60

#define ITEMLIST_BOT				61
#define ITEMLIST_PLAYER				62
#define ITEMLIST_DEADMAN            63



//bot state
typedef struct bot_state_s
{
	vec3_t eye;				//eye coordinates of the bot
	vec3_t enemyorigin;		//enemy origin 0.5 secs ago during battle
	vec3_t viewangles;		//current view angles

} bot_state_t;



// Node structure
typedef struct botnode_s
{
/*
	vec3_t origin; // Using Id's representation
	int type;   // type of node
*/
	vec3_t origin; // Using Id's representation
	float type;   // type of node

} botnode_t;

typedef struct item_table_s
{
/*
	int item;
	float weight;
	edict_t *ent;
	int node;
*/
	int item;
	float weight;
	edict_t *ent;
	float node;


} item_table_t;

extern int num_players;
extern edict_t *players[MAX_CLIENTS];		// pointers to all players in the game

// extern decs
extern botnode_t nodes[MAX_BOTNODES]; 
extern item_table_t item_table[MAX_EDICTS];
extern qboolean debug_mode;
extern qboolean debug_state;
extern qboolean show_nodes;
extern qboolean echo_nodes;
extern qboolean echo_targetnodes;
extern qboolean speakersloaded;
extern int numnodes;
extern int num_items;

void KOOGLESP_SetBotNameTeaBagger  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotNameKidKoogle  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotNameNickleBag  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotNameScabTata  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotNameHomer  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName6  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName7  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName8  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName9  (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName10 (edict_t *bot, char *name, char *skin, char *team);

void KOOGLESP_SetBotName11 (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName12 (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName13 (edict_t *bot, char *name, char *skin, char *team);


void KOOGLESP_SetBotName14 (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName15 (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SetBotName16 (edict_t *bot, char *name, char *skin, char *team);

void KOOGLESP_SetBotName17 (edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SpawnGoblin(edict_t *bot, char *name, char *skin, char *team);


///////////////////////////////////////////////////////////////////////////////////////////
void botload0_think (edict_t *self);
void botload1_think (edict_t *self);
void botload2_think (edict_t *self);

void spawnchastity(edict_t *ent);
void spawnhomer(edict_t *ent);
void spawnmarvin(edict_t *ent);
void spawnbandit(edict_t *ent);
void spawnfreak(edict_t *ent);
void spawnmessia(edict_t *ent);

void botload3_think (edict_t *self);
void botload4_think (edict_t *self);
void botload5_think (edict_t *self);
void botload6_think (edict_t *self);
void botload7_think (edict_t *self);
void botload8_think (edict_t *self);
void Ghost_Think (edict_t *self);
void botload(edict_t *ent);


// id Function Protos I need
void     LookAtKiller (edict_t *self, edict_t *inflictor, edict_t *attacker);
void     ClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker);
void     TossClientWeapon (edict_t *self);
void     ClientThink (edict_t *ent, usercmd_t *ucmd);
void     SelectSpawnPoint (edict_t *ent, vec3_t origin, vec3_t angles);
void     ClientUserinfoChanged (edict_t *ent, char *userinfo);
void     CopyToBodyQue (edict_t *ent);
qboolean ClientConnect (edict_t *ent, char *userinfo);
void     Use_Plat (edict_t *ent, edict_t *other, edict_t *activator);

// kooglebot_ai.c protos
void     KOOGLEAI_Think (edict_t *self);
void     KOOGLEAI_PickLongRangeGoal(edict_t *self);
void     KOOGLEAI_PickShortRangeGoal(edict_t *self);
qboolean KOOGLEAI_FindEnemy(edict_t *self);
void     KOOGLEAI_ChooseWeapon(edict_t *self);

// kooglebot_ai_test.c protos
void     K00GLEAI_Think (edict_t *self);
void     K00GLEAI_PickLongRangeGoal(edict_t *self);
void     K00GLEAI_PickShortRangeGoal(edict_t *self);
qboolean K00GLEAI_FindEnemy(edict_t *self);
void     K00GLEAI_ChooseWeapon(edict_t *self);


// kooglebot_cmds.c protos
qboolean KOOGLECM_Commands(edict_t *ent);
void     KOOGLECM_Store();

// kooglebot_items.c protos
void     KOOGLEIT_PlayerAdded(edict_t *ent);
void     KOOGLEIT_PlayerRemoved(edict_t *ent);
qboolean KOOGLEIT_IsVisible(edict_t *self, vec3_t goal);
qboolean KOOGLEIT_IsReachable(edict_t *self,vec3_t goal);
qboolean KOOGLEIT_ChangeWeapon (edict_t *ent, gitem_t *item);
qboolean KOOGLEIT_CanUseArmor (gitem_t *item, edict_t *other);
float	 KOOGLEIT_ItemNeed(edict_t *self, int item);
int		 KOOGLEIT_ClassnameToIndex(char *classname);
void     KOOGLEIT_BuildItemNodeTable (qboolean rebuild);

// kooglebot_movement.c protos
qboolean KOOGLEMV_SpecialMove(edict_t *self,usercmd_t *ucmd);
void     KOOGLEMV_Move(edict_t *self, usercmd_t *ucmd);
void     KOOGLEMV_Attack (edict_t *self, usercmd_t *ucmd);
void     KOOGLEMV_Wander (edict_t *self, usercmd_t *ucmd);

// kooglebot_nodes.c protos
int      KOOGLEND_FindCost(int from, int to);
int      KOOGLEND_FindCloseReachableNode(edict_t *self, int dist, int type);
int      KOOGLEND_FindClosestReachableNode(edict_t *self, int range, int type);
void     KOOGLEND_SetGoal(edict_t *self, int goal_node);
qboolean KOOGLEND_FollowPath(edict_t *self);
void     KOOGLEND_GrapFired(edict_t *self);
qboolean KOOGLEND_CheckForLadder(edict_t *self);

void     KOOGLEND_PathMap(edict_t *self);
void     KOOGLEND_InitNodes(void);
void     KOOGLEND_ShowNode(int node);
void     KOOGLEND_DrawPath();
void     KOOGLEND_ShowPath(edict_t *self, int goal_node);
int      KOOGLEND_AddNode(edict_t *self, int type);
void     KOOGLEND_UpdateNodeEdge(int from, int to);
void     KOOGLEND_RemoveNodeEdge(edict_t *self, int from, int to);
void     KOOGLEND_ResolveAllPaths();
void     KOOGLEND_SaveNodes();
void     KOOGLEND_LoadNodes();

// kooglebot_spawn.c protos
void	 KOOGLESP_SaveBots();
void	 KOOGLESP_LoadBots();
void     KOOGLESP_HoldSpawn(edict_t *self);
void     KOOGLESP_PutClientInServer (edict_t *bot, qboolean respawn, int team);

//written by TheGhost
void PutBotInServer (edict_t *ent);
void PutBotInServerTest (edict_t *ent);

void     KOOGLESP_Respawn (edict_t *self);
edict_t *KOOGLESP_FindFreeClient (void);
void     KOOGLESP_SetName(edict_t *bot, char *name, char *skin, char *team);
void     KOOGLESP_SpawnBot (char *team, char *name, char *skin, char *userinfo);
//void     KOOGLESP_ReAddBots();
void     KOOGLESP_RemoveBot(char *name);

//this was added so that when the server becomes empty all the bots are removed
void KOOGLESP_RemoveBotServerIsEmpty(edict_t *bot);

void	 safe_cprintf (edict_t *ent, int printlevel, char *fmt, ...);
void     safe_centerprintf (edict_t *ent, char *fmt, ...);
void     safe_bprintf (int printlevel, char *fmt, ...);
void     debug_printf (char *fmt, ...);

void KOOGLESP_SpawnGoblin(edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SpawnHomer(edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SpawnBitchka(edict_t *bot, char *name, char *skin, char *team);
void KOOGLESP_SpawnVita(edict_t *ent, char *name, char *skin, char *team);
void KOOGLESP_SpawnFreak(edict_t *ent, char *name, char *skin, char *team);
void KOOGLESP_SpawnPit(edict_t *ent, char *name, char *skin, char *team);
void KOOGLESP_SpawnGhost(edict_t *ent, char *name, char *skin, char *team);
void KOOGLESP_SpawnDeeg(edict_t *ent, char *name, char *skin, char *team);

void KOOGLEAI_ChooseWeaponGoblin(edict_t *self);

//used to keep players from adding more than one of each bot type
int    countgoblin;
int    countfreak;
int    countpit;
int    countghost;
int    countbitchka;
int    countvita;
int    countdeeg;
int    counthomer;
int	   countteabagger;
int	   countscabtata;
int	   countnicklebag;
int	   countkidkoogle;
int	   countchastity;


void Cmd_botweapons_f (edict_t *ent);
#endif