/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington

//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"

newitem_t   *newitem_head;
qboolean    erasing;
qboolean is_real;


qboolean savelevel2data(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[MAX_QPATH];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\level2\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/mapconfig/level2/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW LEVEL 2 ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED LEVEL 2 DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}


int GetLineFromLevel2File(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}




qboolean load_map_config_for_level2(void)
{
    FILE        *fp;
    char        filename[MAX_QPATH],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\level2\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    if (!fp){
	gi.dprintf ("No Level 2 mapconfig file found\n");	
        return 0;
}
    
    line=0;
    while (!feof(fp))
    {
        line++;
	GetLineFromLevel2File(fp,buffer);        // modification in this codeblock to not use trimstring
        if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;

            		ent->classname=classname;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
   
                  	ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Level 2 Item Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}


void Cmd_Savelevel2data_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new Level 2 data for this level... ");
    if (savelevel2data(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new Level 2 data?!?\n");
}


qboolean saveitemdata(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[MAX_QPATH];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/mapconfig/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED ITEMS DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}



qboolean spawnitembyclassname(vec3_t spot, char *classname, qboolean real)
{
    edict_t     *ent;
    gitem_t     *item;
    vec3_t      angles;
    newitem_t   *old_newitem_head;

	item = FindItemByClassname(classname);

    if (!item)
    {

         if (!real)
         {

	        ent = G_Spawn();
        	ent->is_real = true;

	        ent->classname=classname;

            VectorCopy (spot, ent->s.origin);
            ent->s.origin[2] += 16;
					
	        ent->item = item;
   	
	        gi.linkentity (ent);

	        ED_CallSpawn(ent);

	        gi.dprintf("Not Real -> %s at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);

            old_newitem_head = newitem_head;
            newitem_head = gi.TagMalloc(sizeof(newitem_t), TAG_LEVEL);
            memset(newitem_head, 0, sizeof(newitem_t));
            newitem_head->next = old_newitem_head;
            newitem_head->ent = ent;

	}
	
	return 1;
}	

	else

	{
	
	ent = G_Spawn();

    ent->classname=gi.TagMalloc(64*sizeof(char), TAG_LEVEL);
	
    if (!classname)
	{
		gi.dprintf ("ED_CallSpawn: NULL classname\n");
		return 0;
	}

//===============================================================
    if (!Q_stricmp( ent->classname, "weapon_railgun" ))
    {
    if((convertq2weapons == 1) && (railgun == 1))
    ent->classname = G_CopyString( "weapon_heavymachinegun" );
    }
//===============================================================
    if (!Q_stricmp( ent->classname, "ammo_slugs" ))
    {
    if(convertq2weapons == 1)
    ent->classname = G_CopyString( "ammo_308" );
    }
//===============================================================
    if (!Q_stricmp( ent->classname, "weapon_chaingun" ))
    {
    if((convertq2weapons == 1) && (chaingun == 1))
    ent->classname = G_CopyString( "weapon_tommygun" );
    }
//===============================================================
    if (!Q_stricmp( ent->classname, "weapon_supershotgun" ))
    {
    if((convertq2weapons == 1) && (supershotgun == 1))
    ent->classname = G_CopyString( "weapon_shotgun" );
    }

	//===============================================================
    if (!Q_stricmp( ent->classname, "weapon_hyperblaster" ))
    {
    if((convertq2weapons == 1) && (hyperblaster == 1))
    ent->classname = G_CopyString( "weapon_flamethrower" );
    }
//===============================================================
    if (!Q_stricmp( ent->classname, "ammo_cells" ))
    {
    if(convertq2weapons == 1)
    ent->classname = G_CopyString( "ammo_flametank" );
    }
//===============================================================
    if (!Q_stricmp( ent->classname, "weapon_machinegun" ))
    {
    if((convertq2weapons == 1) && (machinegun == 1))
    ent->classname = G_CopyString( "weapon_tommygun" );
    }
//===============================================================


//****************************************************************
//================================================================
    if ((tommygun != 1) || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_tommygun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
	    }
    }
//===============================================================
    if ((heavymachinegun != 1)  || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_heavymachinegun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_308" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    }
//================================================================
   if ((railgun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_railgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    	if (!Q_stricmp(classname, "ammo_slugs" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ((bfg != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_bfg" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ((machinegun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_machinegun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ( (supershotgun != 1) && (shotgun != 1)  || (gamemode->value == 9)) 
   {
    	if (!Q_stricmp(classname, "ammo_shells" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }

   }
//=================================================================
   if ((supershotgun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_supershotgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//=================================================================
   if ( (chaingun != 1) && (tommygun != 1)  || (gamemode->value == 9) )
   {
    	if (!Q_stricmp(classname, "ammo_cylinder" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//=================================================================
   if ((chaingun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_chaingun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
     	}
   }
//=================================================================
   if ( (hyperblaster != 1) && (bfg != 1)  || (gamemode->value == 9) )
   {
    	if (!Q_stricmp(classname, "ammo_cells" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//=================================================================
   if ((hyperblaster != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_hyperblaster" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//==================================================================
   if ((grenadelauncher != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_grenadelauncher" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_grenades" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }

   }
//===================================================================
   if ((shard != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_shard" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((combatarmor != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_combat" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((bodyarmor != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_body" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((bazooka != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_bazooka" ))
        {
    	gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_rockets" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//=====================================================================
   if ((flamethrower != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_flamethrower" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_flametank" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
}
//======================================================================
    if ((crowbar != 1)  || (gamemode->value == 9))
    {
	    if (!Q_stricmp(classname, "weapon_crowbar" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }
//======================================================================
    if ( (pistol != 1) && (machinegun != 1)  || (gamemode->value == 9) )
    {
    	if (!Q_stricmp(classname, "ammo_bullets" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

    }
//======================================================================
    if ((pistol != 1)  || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_pistol" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }
//======================================================================
    if ((shotgun != 1)  || (gamemode->value == 9))
    {
	    if (!Q_stricmp(classname, "weapon_shotgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }

    if (gamemode->value == 9)
	{
	    if (!Q_stricmp(classname, "item_health_lg" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health_sm" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health_large" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}


	    if (!Q_stricmp(classname, "item_health_small" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	}              
//======================================================================
	strcpy(ent->classname,classname);

	ent->item = item;
	 
	 if (real)
    {
        ent->s.effects = ent->item->world_model_flags;
        ent->s.renderfx = RF_GLOW;
        ent->touch = Touch_Item;
    }
    else
    {
        ent->s.effects = ent->item->world_model_flags|EF_COLOR_SHELL;
        ent->s.renderfx = RF_GLOW|RF_SHELL_RED;
        ent->touch = Touch_NewItem;
    }
    
	
	VectorSet (ent->mins, -15, -15, -15);
    VectorSet (ent->maxs, 15, 15, 15);

    gi.setmodel (ent, ent->item->world_model);

    ent->solid = SOLID_TRIGGER;

    if (!strcmp(ent->classname, "dm_cashspawn"))
    ent->movetype = MOVETYPE_NONE;
    else
    ent->movetype = MOVETYPE_BOUNCE;  
    ent->owner = ent;
    
    angles[0] = 0;
    angles[1] = rand() % 360;
    angles[2] = 0;
    
    VectorCopy (spot, ent->s.origin);

    ent->s.origin[2] += 16;

    gi.linkentity (ent);

    if (!strcmp(ent->classname, "dm_G_Free"))
    G_FreeEdict(ent);


    if (!real)
    {
        old_newitem_head = newitem_head;
        newitem_head = gi.TagMalloc(sizeof(newitem_t), TAG_LEVEL);
        memset(newitem_head, 0, sizeof(newitem_t));
        newitem_head->next = old_newitem_head;
        newitem_head->ent = ent;
    }

    return 1;

	}
}


void Cmd_Clearitems_f(edict_t *ent)
{
    newitem_t   *old_newitem_head;
    
    if (newitem_head)
    {
        while (newitem_head)
        {
            G_FreeEdict(newitem_head->ent);
            old_newitem_head=newitem_head;
            newitem_head=newitem_head->next;
            gi.TagFree(old_newitem_head);
        }
        
        safe_cprintf(ent, PRINT_HIGH, "All new item data cleared\n");
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}


void Cmd_Undoitem_f(edict_t *ent)
{
    newitem_t   *old_newitem_head;
    
    if (newitem_head)
    {
        safe_cprintf(ent, PRINT_HIGH, "%s was removed\n",newitem_head->ent->classname);
        G_FreeEdict(newitem_head->ent);
        old_newitem_head=newitem_head;
        newitem_head=newitem_head->next;
        gi.TagFree(old_newitem_head);
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}


void Touch_NewItem(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
    newitem_t   *old_newitem_head;
    newitem_t   *old_old_newitem_head;
    
    if (!erasing)
        return;

    if (!other->client)
        return;

    if (other->health<=0)
        return;

    // flash the screen
    other->client->bonus_alpha = 0.25;  
    
    old_newitem_head=newitem_head;
    old_old_newitem_head=old_newitem_head;
    
    while (old_newitem_head)
    {
        if (old_newitem_head->ent==ent)
        {
            if (old_newitem_head==newitem_head)
                newitem_head=newitem_head->next;
            
            old_old_newitem_head->next=old_newitem_head->next;
            
            safe_cprintf(other, PRINT_HIGH, "%s was removed\n",old_newitem_head->ent->classname);
            G_FreeEdict(old_newitem_head->ent);
            gi.TagFree(old_newitem_head);
            return;
        }
        else
        {
            old_old_newitem_head=old_newitem_head;
            old_newitem_head=old_newitem_head->next;
        }
    }
}


void Cmd_Listitems_f(edict_t *ent)
{
    newitem_t   *other_newitem_head;
    
    if (newitem_head)
    {
        safe_cprintf(ent, PRINT_HIGH, "New item list, starting with the most recent...\n");
        
        other_newitem_head=newitem_head;
        
        while (other_newitem_head)
        {
            safe_cprintf(ent, PRINT_HIGH, "(%d,%d,%d): %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
            other_newitem_head=other_newitem_head->next;
        }
        
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}

void Cmd_Saveitems_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new item data for this level... ");
    if (saveitemdata(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new items?\n");
}





int GetLineFromFile(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}

////////////////////////////////////////////////////////////////////////////////////////
qboolean loaditemdata(void)
{
    FILE        *fp;
    char        filename[MAX_QPATH],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    if (!fp){
		if (gamemode->value == 9)
	    gi.dprintf ("[%s.ent] File Not found! (No External Weapons To Remove)\n",level.mapname);
		else
	    gi.dprintf ("[%s.ent] File Not found! (No External Weapons To Load)\n",level.mapname);

        return 0;
}
    
    line=0;
    while (!feof(fp))
    {
        line++;
	GetLineFromFile(fp,buffer);        // modification in this codeblock to not use trimstring
        if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;
                    ent->is_entload = true;

            		ent->classname=classname;

//					if (!strcmp(ent->classname, "junior"))
//                    ent->is_junior = true;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
		
					ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Entity Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}
////////////////////////////////////////////////////////////////////////////////////////
//THEGHOST END - 1 added for item placement on the fly


void PlaceItemCommands (edict_t *ent)
{
	char	*cmd;

    cmd = gi.argv(0);

	//These were added for speaker placement on the fly
	if (Q_stricmp (cmd, "stopmusic") == 0){ gi.WriteByte( svc_stufftext ); gi.WriteString("stopsound"); gi.multicast (vec3_origin, MULTICAST_ALL);return;}
	else if (Q_stricmp (cmd, "stopspeakers") == 0){ removespeakers(ent);return;}
	else if (Q_stricmp (cmd, "removespeakers") == 0){ removespeakers(ent);return;}
    else if (Q_stricmp (cmd, "loadspeakers") == 0){if (ent->client->pers.admin > NOT_ADMIN ){if (level.num_speakers <= 1)load_speaker_data();else safe_cprintf(ent,PRINT_HIGH,"Speakers already loaded!\n");}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin!\n");}
    else if (Q_stricmp (cmd, "startspeakers") == 0){if (ent->client->pers.admin > NOT_ADMIN ){if (level.num_speakers <= 1)load_speaker_data();else safe_cprintf(ent,PRINT_HIGH,"Speakers already loaded!\n");}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin!\n");}
	else if (Q_stricmp (cmd, "pspeaker") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "target_music";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    
	else if (Q_stricmp (cmd, "testpeakers") == 0)
	{
		if (ent->client->pers.admin > NOT_ADMIN )
		{
			load_speaker_data();
		}
		else safe_cprintf(ent,PRINT_HIGH,"You do not have admin!\n");
	}
	
   else if (Q_stricmp (cmd, "music") == 0)
   {
	    if (ent->client->pers.admin > NOT_ADMIN )
		{  
			if (speakersloaded == false)
			{
			  if (level.num_speakers == 0)
			  {
			    load_speaker_data();

				//defined in g_speaker.c in the speaker load function
				//speakersloaded = true;
				
				safe_cprintf(ent,PRINT_HIGH,"The Speakers Were Loaded And The Music Was Started!\n");
				return;
			  }
			  else 
			  safe_cprintf(ent,PRINT_HIGH,"There are no speakers in this map Sorry!\n");
			  
			}

			if (speakersloaded == true)
			{
              removespeakers(ent);
			  level.num_speakers = 0;
			  safe_cprintf(ent,PRINT_HIGH,"The Music Has Been Stopped And The Speakers Were Unloaded!\n");
              //defined in g_speaker.c in the speaker remove function
			  //speakersloaded = false;
              return;
			}


		}
		else 
			safe_cprintf(ent,PRINT_HIGH,"You do not have admin!\n");
   }
 

	//TheGhost added this so you could change various custom settings on the fly
	//to change the song type cust_song & song number
	else if (strstr (cmd, "cust_"))	Cmd_CustomShit (ent, cmd, gi.argv(1));

	// Song Selections
	// Song 6  some weird ballad
	// Song 7  Awake - godsmack
	// Song 8  glisterine - Homebrew
	// Song 9  cop killer - 
	// Song 10 demons - NIN
	// Song 11 kill me - NIN
	// Song 12 you leave me cold - danzig
	// Song 13 if there is a hell - NIN
	// Song 14 you could have it all - NIN
	// Song 15 Here she comes - danzig
	// Song 16 respect - pantara
	// Song 17 physical NIN
	// Song 18 the crow theme song
	// Song 19 david bowie and NIN - reptile
	// Song 20 wacked NIN
	// Song 21 didnt you NIN
	// Song 22 Satans child - danzig
	// Song 23 I am NIN
	// Song 24 I wear my sunglasses at night
	// Song 25 everything is blue in this world NIN
	// Song 26 down in the belly of the beast i lie - danzig
	// Song 27 soul of misery - danzig
	// Song 28 kryptonite
	// Song 29 were in this together now NIN
	// Song 30 how does it feel NIN
	// Song 31 crazy train - ozzy
	// Song 32 sod - megadeth
	// Song 33 enter the sandman


	else if (Q_stricmp (cmd, "pbfg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_bfg";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]); else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "prg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_railgun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pmg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_machinegun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pssg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_supershotgun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else	safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pcg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_chaingun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "phb") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_hyperblaster";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "ptg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_tommygun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "phmg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_heavymachinegun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pdmc") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "dm_cashspawn";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "ft1") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "dm_fixtarget";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else	safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "ft3") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "dm_fixtarget2";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "ft2") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "dm_fixtargetname";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "ft4") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "dm_fixtargetname2";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pgl") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_grenadelauncher";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pb") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_bazooka";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pft") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_flamethrower";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pcb") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_crowbar";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pp") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_pistol";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else	safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "psg") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "weapon_shotgun";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pslugs") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_slugs";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
    else if (Q_stricmp (cmd, "pcells") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_cells";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pbullets") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_bullets";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pcylinder") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_cylinder";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "p308") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_308";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pgrenades") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_grenades";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "prockets") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_rockets";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pflametank") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_flametank";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pshells") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "ammo_shells";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pias") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_shard";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piac") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_combat";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piab") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_body";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else	safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pipshield") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_power_shield";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piahh") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_helmet_heavy";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piah") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_helmet";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piajh") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_jacket_heavy";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "piaj") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_jacket";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pialh") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_legs_heavy";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pial") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_armor_legs";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pihs") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_health_sm";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}
	else if (Q_stricmp (cmd, "pihl") == 0){if (ent->client->pers.admin > NOT_ADMIN ){cmd = "item_health_lg";if (spawnitembyclassname(ent->s.origin,cmd,0)) safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);else safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);return;}else safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");}

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "piw") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_whiskey";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pik") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_pack";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pia") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_adrenaline";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "piqf") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_quadfire";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pii") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_invulnerability";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pis") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_silencer";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pib") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_breather";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pies") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_inviro";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pah") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_ancient_head";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }


	else if (Q_stricmp (cmd, "plh") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_lizzy_head";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pban") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_bandolier";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pihm") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_health_mega";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "piqd") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_quad";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pic") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_coil";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }



	else if (Q_stricmp (cmd, "pipscreen") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "item_power_screen";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pbitch") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_bitchz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pdog") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_dogz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunksg") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punkz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunkfg") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punkfg";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunkgl") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punkgl";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunkhmg") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punkhmg";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunkrl") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punkrl";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ppunktg") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_punktg";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "prunt") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_runtz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pshorty") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_shortyz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pspider") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_spiderz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pthug") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_thugz";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pwhore") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "cast_whorez";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "safebag1") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "dm_safebag1";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "safebag2") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "dm_safebag2";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ipt1") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "info_player_team1";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ipt2") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "info_player_team2";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "pipdm") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "info_player_deathmatch";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }
///////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "mb1") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "misc_banner";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }

///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "mb2") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "misc_banner2";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }
	else 
		if (Q_stricmp (cmd, "mb1") == 0)
	{
		
		if (ent->client->pers.admin > NOT_ADMIN )
		{
		  
		cmd = "misc_banner";

        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
        return;
	
		}
	
		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");

    }
///////////////////////////////////////////////////////////////////////////////////
		else if (Q_stricmp (cmd, "give") == 0) { safe_cprintf(ent,PRINT_HIGH,"There are no cheats on this server  sorry!\n"); }	
		else if (Q_stricmp (cmd, "god") == 0) { safe_cprintf(ent,PRINT_HIGH,"There are no cheats on this server  sorry!\n"); }
		else if (Q_stricmp (cmd, "noclip") == 0) { safe_cprintf(ent,PRINT_HIGH,"There are no cheats on this server  sorry!\n"); }
		else if (Q_stricmp (cmd, "notarget") == 0) { safe_cprintf(ent,PRINT_HIGH,"There are no cheats on this server  sorry!\n"); }
////////////////////////////////////////////////////////////////////////////////////////////
	else if (Q_stricmp (cmd, "ghostitem") == 0)
    {

		if (ent->client->pers.admin > NOT_ADMIN )
        
		{
        
		cmd = gi.argv(1);
        if (strlen(cmd) == 0)
        {
            safe_cprintf(ent, PRINT_HIGH, "You must specify a classname\n");
            return;
        }
        
        if (spawnitembyclassname(ent->s.origin,cmd,0))      
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);
        else
            safe_cprintf(ent, PRINT_HIGH, "%s placed at (%d,%d,%d)\n", cmd, (int)ent->s.origin[0], (int)ent->s.origin[1], (int)ent->s.origin[2]);     
		    //safe_cprintf(ent, PRINT_HIGH, "Could not place %s - item classname unrecognised\n",cmd);			
        return;
		
		}

		else

		safe_cprintf(ent,PRINT_HIGH,"You do not have admin\n");
	
	}
//////////////////////////////////////////////////////////////////////////////////////////////


}