/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//  and is available over at The Scorpion Network, at http://www.und3rgr0und.com
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington
//  immediately, via The Scorpion Network Homepage http://www.und3rgr0und.com
//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//TEST FILE
	
///////////////////////////////////////////////////////////////////////
//
//  kooglebot_ai.c -      This file contains all of the 
//                        AI routines for the K00GLE bot.
//
//
// NOTE: Steve Yeager went back and pulled out most of the brains from
//       a number of these functions. They have been expanded on 
//       to provide a "higher" level of AI. 
//       "Thanks Steve for leaving out the best part!" DICK
////////////////////////////////////////////////////////////////////////

#include "..\g_local.h"
#include "..\m_player.h"

#include "kooglebot.h"

///////////////////////////////////////////////////////////////////////
// Main Think function for bot
///////////////////////////////////////////////////////////////////////
void K00GLEAI_Think (edict_t *self)
{
	usercmd_t	ucmd;
    char *s;

    s = Info_ValueForKey (self->client->pers.userinfo, "skin");

	// Set up client movement
	VectorCopy(self->client->ps.viewangles,self->s.angles);
	VectorSet (self->client->ps.pmove.delta_angles, 0, 0, 0);
	memset (&ucmd, 0, sizeof (ucmd));
	self->enemy = NULL;
	self->movetarget = NULL;

	
	// Force respawn 
	if (self->deadflag && self->is_bot)
	{
		self->client->buttons = 0;
		ucmd.buttons = BUTTON_ATTACK;
	}
	
	if(self->state == BOTSTATE_WANDER && self->wander_timeout < level.time)
	  K00GLEAI_PickLongRangeGoal(self); // pick a new long range goal

	// Kill the bot if completely stuck somewhere
	if(VectorLength(self->velocity) > 37) //
		self->suicide_timeout = level.time + 10.0;

	if(self->suicide_timeout < level.time)
	{
		self->health = 0;
		meansOfDeath = MOD_SUICIDE;
		player_die (self, self, self, 1, vec3_origin,0,0);
	}
	
	// Find any short range goal
	K00GLEAI_PickShortRangeGoal(self);
	
	// Look for enemies
	if(K00GLEAI_FindEnemy(self))
	{	
		
		K00GLEAI_ChooseWeapon(self);
		KOOGLEMV_Attack (self, &ucmd);
	}
	else
	{
		// Execute the move, or wander
		if(self->state == BOTSTATE_WANDER)
			KOOGLEMV_Wander(self,&ucmd);
		else if(self->state == BOTSTATE_MOVE)
			KOOGLEMV_Move(self,&ucmd);
	}
	
	//debug_printf("State: %d\n",self->state);

    if (self->is_bot){
	// set approximate ping
	ucmd.msec = 75 + floor (random () * 25) + 1;
	// show random ping values in scoreboard
	self->client->ping = ucmd.msec;
	}
	
	
	// set bot's view angle
	ucmd.angles[PITCH] = ANGLE2SHORT(self->s.angles[PITCH]);
	ucmd.angles[YAW] = ANGLE2SHORT(self->s.angles[YAW]);
	ucmd.angles[ROLL] = ANGLE2SHORT(self->s.angles[ROLL]);
	
	// send command through id's code
	ClientThink (self, &ucmd);
	
	self->nextthink = level.time + FRAMETIME;
}

///////////////////////////////////////////////////////////////////////
// Evaluate the best long range goal and send the bot on
// its way. This is a good time waster, so use it sparingly. 
// Do not call it for every think cycle.
///////////////////////////////////////////////////////////////////////
void K00GLEAI_PickLongRangeGoal(edict_t *self)
{

	int i;
	int node;
	float weight,best_weight=0.0;
	int current_node,goal_node;
	edict_t *goal_ent;
	float cost;
	
	// look for a target 
	current_node = KOOGLEND_FindClosestReachableNode(self,BOTNODE_DENSITY,BOTNODE_ALL);

	self->current_node = current_node;
	
	if(current_node == -1)
	{
		self->state = BOTSTATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		self->goal_node = -1;
		return;
	}

	///////////////////////////////////////////////////////
	// Items
	///////////////////////////////////////////////////////
	for(i=0;i<num_items;i++)
	{
		if(item_table[i].ent == NULL || item_table[i].ent->solid == SOLID_NOT) // ignore items that are not there.
			continue;
		
		cost = KOOGLEND_FindCost(current_node,item_table[i].node);
		
		if(cost == INVALID || cost < 2) // ignore invalid and very short hops
			continue;
	
		weight = KOOGLEIT_ItemNeed(self, item_table[i].item);
/*
		// If I am on team one and I have the flag for the other team....return it
		if(ctf->value && (item_table[i].item == ITEMLIST_FLAG2 || item_table[i].item == ITEMLIST_FLAG1) &&
		  (self->client->resp.ctf_team == CTF_TEAM1 && self->client->pers.inventory[ITEMLIST_FLAG2] ||
		   self->client->resp.ctf_team == CTF_TEAM2 && self->client->pers.inventory[ITEMLIST_FLAG1]))
			weight = 10.0;
*/
		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
				
		if(weight > best_weight)
		{
			best_weight = weight;
			goal_node = item_table[i].node;
			goal_ent = item_table[i].ent;
		}
	}

	///////////////////////////////////////////////////////
	// Players
	///////////////////////////////////////////////////////
	// This should be its own function and is for now just
	// finds a player to set as the goal.
	for(i=0;i<num_players;i++)
	{
		if(players[i] == self)
			continue;

		node = KOOGLEND_FindClosestReachableNode(players[i],BOTNODE_DENSITY,BOTNODE_ALL);
		cost = KOOGLEND_FindCost(current_node, node);

		if(cost == INVALID || cost < 3) // ignore invalid and very short hops
			continue;
/*
		// Player carrying the flag?
		if(ctf->value && (players[i]->client->pers.inventory[ITEMLIST_FLAG2] || players[i]->client->pers.inventory[ITEMLIST_FLAG1]))
		  weight = 2.0;
		else*/
		  weight = 0.3; 
		
		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
		
		if(weight > best_weight)
		{		
			best_weight = weight;
			goal_node = node;
			goal_ent = players[i];
		}	
	}

	// If do not find a goal, go wandering....
	if(best_weight == 0.0 || goal_node == INVALID)
	{
		self->goal_node = INVALID;
		self->state = BOTSTATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		if(debug_mode)
			debug_printf("%s did not find a LR goal, wandering.\n",self->client->pers.netname);
		return; // no path? 
	}
	
	// OK, everything valid, let's start moving to our goal.
	self->state = BOTSTATE_MOVE;
	self->tries = 0; // Reset the count of how many times we tried this goal
	 
	if(goal_ent != NULL && debug_mode)
		debug_printf("%s selected a %s at node %d for LR goal.\n",self->client->pers.netname, goal_ent->classname, goal_node);

	KOOGLEND_SetGoal(self,goal_node);

}

///////////////////////////////////////////////////////////////////////
// Pick best goal based on importance and range. This function
// overrides the long range goal selection for items that
// are very close to the bot and are reachable.
///////////////////////////////////////////////////////////////////////
void K00GLEAI_PickShortRangeGoal(edict_t *self)
{
	edict_t *target;
	float weight,best_weight=0.0;
	edict_t *best;
	int index;
	
	// look for a target (should make more efficent later)
	target = findradius(NULL, self->s.origin, 200);
	
	while(target)
	{
		if(target->classname == NULL)
			return;
		
		// Missle avoidance code
		// Set our movetarget to be the rocket or grenade fired at us. 
		if(strcmp(target->classname,"rocket")==0 || strcmp(target->classname,"grenade")==0)
		{
			if(debug_mode) 
				debug_printf("ROCKET ALERT!\n");

			self->movetarget = target;
			return;
		}
	
		if (KOOGLEIT_IsReachable(self,target->s.origin))
		{
			if (infront(self, target))
			{
				index = KOOGLEIT_ClassnameToIndex(target->classname);
				weight = KOOGLEIT_ItemNeed(self, index);
				
				if(weight > best_weight)
				{
					best_weight = weight;
					best = target;
				}
			}
		}

		// next target
		target = findradius(target, self->s.origin, 200);
	}

	if(best_weight)
	{
		self->movetarget = best;
		
		if(debug_mode && self->goalentity != self->movetarget)
			debug_printf("%s selected a %s for SR goal.\n",self->client->pers.netname, self->movetarget->classname);
		
		self->goalentity = best;

	}

}

///////////////////////////////////////////////////////////////////////
// Scan for enemy (simplifed for now to just pick any visible enemy)
///////////////////////////////////////////////////////////////////////


qboolean K00GLEAI_FindEnemy(edict_t *self)
{
	int i;

	for(i=0;i<=num_players;i++)
	{
		if(players[i] == NULL || players[i] == self || 
		   players[i]->solid == SOLID_NOT)
		   continue;

       if ( (!strcmp(self->client->pers.netname, "BOT TheGhost")) && (gamemode->value == 4) )
       self->client->pers.team = 1;
	   else if ( (!strcmp(self->client->pers.netname, "BOT Deeg")) && (gamemode->value == 4) )
       self->client->pers.team = 2;
	   else if ( (!strcmp(self->client->pers.netname, "BOT PITBULLET")) && (gamemode->value == 4) )
       self->client->pers.team = 2;
	   else if ( (!strcmp(self->client->pers.netname, "BOT Freak")) && (gamemode->value == 4) )
       self->client->pers.team = 1;

	   if(teamplay->value && self->client->pers.team == players[i]->client->pers.team)
		   continue;

        // Ghost Add - Keeps bots from spinning while we are watching them from a spectators view
        if (players[i]->client->pers.spectator == SPECTATING)
        continue;


		if(!players[i]->deadflag && visible(self, players[i]) && gi.inPVS (self->s.origin, players[i]->s.origin))
		{
			self->enemy = players[i];
			return true;
		}
	}

	return false;
  
}

///////////////////////////////////////////////////////////////////////
// Hold fire with RL/BFG?
///////////////////////////////////////////////////////////////////////
qboolean K00GLEAI_CheckShot(edict_t *self)
{
	trace_t tr;

	tr = gi.trace (self->s.origin, tv(-8,-8,-8), tv(8,8,8), self->enemy->s.origin, self, MASK_OPAQUE);
	
	// Blocked, do not shoot
	if (tr.fraction != 1.0)
		return false; 
	
	return true;
}

///////////////////////////////////////////////////////////////////////
// Choose the best weapon for bot (simplified)
///////////////////////////////////////////////////////////////////////
void K00GLEAI_ChooseWeapon(edict_t *self)
{	
	float range;
	vec3_t v;
	
	// if no enemy, then what are we doing here?
	if(!self->enemy)
	return;
	
	// Base selection on distance.
	VectorSubtract (self->s.origin, self->enemy->s.origin, v);
	
    range = VectorLength(v);

		
	// Longer range 
	if(range > 300)
	{
        //choose bazooka if enough ammo
        if(self->client->pers.inventory[ITEMLIST_ROCKETS] >= 4)
		if(K00GLEAI_CheckShot(self) && KOOGLEIT_ChangeWeapon(self,FindItem("bazooka"))) return;
	}

//=======================================================================================================	
	// Only use GL in certain ranges and only on targets at or below our level
	else if(range > 100 && range < 500 && self->enemy->s.origin[2] - 20 < self->s.origin[2])
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Grenade Launcher"))) return;
    }

	// Only use FT at short range and only on targets at or below our level
//	else if(range < 128 && self->enemy->s.origin[2] - 20 < self->s.origin[2])
  //  {
	//if(KOOGLEIT_ChangeWeapon(self,FindItem("Grenade Launcher"))) return;
    //}
//=======================================================================================================


	// only use regular shotgun when you have 10 shotgun shells or less
	else if(self->client->pers.inventory[ITEMLIST_SHELLS] <= 10)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("shotgun"))) return;
    }


	// only use super shotgun when you have 11 shotgun shells or more
	else if(self->client->pers.inventory[ITEMLIST_SHELLS] >= 11)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Super Shotgun"))) return;
    }

//=======================================================================================================
	// Only use HMG when ammo you have 30 308 rounds or more
	else if(self->client->pers.inventory[ITEMLIST_AMMO308] >= 30)
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Heavy machinegun"))) return;
    }
//=======================================================================================================

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 48) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 50))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("SPistol"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 50) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 100))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Tommygun"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 100) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 200))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("chaingun"))) return;
    }

    else if((self->client->pers.inventory[ITEMLIST_BULLETS] > 200) && (self->client->pers.inventory[ITEMLIST_BULLETS] <= 300))
    {
	if(KOOGLEIT_ChangeWeapon(self,FindItem("machinegun"))) return;
    }


//=======================================================================================================

//    else if(self->client->pers.inventory[ITEMLIST_SLUGS] >= 1)
//    {
//	if(KOOGLEIT_ChangeWeapon(self,FindItem("Railgun"))) return;
//    }
//=======================================================================================================	
    else
    {

	if(KOOGLEIT_ChangeWeapon(self,FindItem("Crowbar"))) return;
	
	if(KOOGLEIT_ChangeWeapon(self,FindItem("Pipe"))) return;
    }
	
	return;

}


