/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//  and is available over at The Scorpion Network, at http://www.und3rgr0und.com
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington
//  immediately, via The Scorpion Network Homepage http://www.und3rgr0und.com
//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"
#include "q2m_player.h"
#include "m_player.h"

int CustJetpack;
int CustTeleport;
int CustHook;
int NodeSetup;

void safebag_think(edict_t *self);

char *make_white (char *s){
unsigned char *p;
p = (unsigned char *) s;
while (*p){
if ((*p >= 0x1b && *p <= 0x7f) || (*p >= 0x0a && *p <= 0x11))
*p += (char) 0x80;
p++;}
return s;}


void SP_info_player_team1(edict_t *self){
self->classname="info_player_team1";
VectorSet (self->mins, -16, -16, -24);
VectorSet (self->maxs,  16,  16,  48);
if (self->is_real) gi.setmodel (self, "models/objects/dmspot/tris.md2");
else gi.setmodel (self, "");
self->style = 1;
if (self->is_real == false) SP_info_player_deathmatch(self);}


void SP_info_player_team2(edict_t *self){
self->classname="info_player_team2";
VectorSet (self->mins, -16, -16, -24);
VectorSet (self->maxs,  16,  16,  48);
if (self->is_real) gi.setmodel (self, "models/objects/dmspot/tris.md2");
else gi.setmodel (self, "");
self->style = 2;
if (self->is_real == false) SP_info_player_deathmatch(self);}


void SP_dm_G_Free(edict_t *self)
{
		G_FreeEdict (self);
		return;
}

void safebag_touch1( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0, rnd;

	if (!other->client)
		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))
	{
		return;
	}
	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > (int)(50.0 * (1.0 + (0.5*(other->client->pers.team == self->style)))))
		{
			// let them go away on their own terms
			T_Damage( other, other, other, vec3_origin, other->s.origin, vec3_origin, 9999, 0, 0, MOD_SAFECAMPER );
			last_touch_count = 0;
		}
	}

	last_touch_ent = other;

	if (self->timestamp > (level.time - 1.0))
		return;

	self->timestamp = level.time;

	// depositing, or withdrawing?

	if (other->client->pers.team == self->style)
	{	// deposit
		
		if (other->client->pers.currentcash > 0 || other->client->pers.bagcash > 0)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] += other->client->pers.currentcash;
			team_cash[self->style] += other->client->pers.bagcash;
			UPDATESCORE

			other->client->resp.deposited += other->client->pers.currentcash;
			other->client->resp.deposited += other->client->pers.bagcash;

			other->client->pers.currentcash = 0;
			other->client->pers.bagcash = 0;

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

               rnd = (rnd + 1) % 12;

               switch(rnd)
               {
				case 0:
			    // make a droping sound
			    gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/hiredguy/fingers2.wav"), 1, 1, 0);
			    break;
				case 1:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/weapon7.wav"), 1, 1, 0);
				break;
                case 2:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/great.wav"), 1, 1, 0);
				break;
         
				case 3:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle4.wav"), 1, 1, 0);
			    break;
                
				case 4:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/actors/male/lenny/thanks2.wav"), 1, 1, 0);
			    break;

                case 5:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/scalper/yes1.wav"), 1, 1, 0);
			    break;

                case 6:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle2.wav"), 1, 1, 0);
			    break;
                
				case 7:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                
				case 8:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/iamback.wav"), 1, 1, 0);
			    break;
                case 9:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, 1, 0);
			    break;
                case 10:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle5.wav"), 1, 1, 0);
			    break;
                case 11:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/sold2.wav"), 1, 1, 0);
			    break;
				default:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
				}
			
			// let everyone know how much was deposited
    		amount = team_cash[self->style] - precash;
			safe_bprintf( PRINT_MEDIUM, "%s deposited $%i\n", other->client->pers.netname, amount );
			last_safe_deposit[self->style] = level.time;
		}

	}
	else if (team_cash[self->style] > 0)
	{	// withdrawal

		if (other->client->pers.bagcash < MAX_BAGCASH_PLAYER)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] -= (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);
			other->client->pers.bagcash += (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);

			if (team_cash[self->style] < 0)
			{	// don't take more than they have
				other->client->pers.bagcash += team_cash[self->style];
				team_cash[self->style] = 0;
			}
			UPDATESCORE

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

			// alarm!
			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("misc/cashmatch_alarm.wav"), 1, 1, 0);
//			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, snd_fry1 , 1, 1, 0);

			// let everyone know how much was stolen
			amount = precash - team_cash[self->style];
			safe_bprintf( PRINT_MEDIUM, "%s stole $%i from %s's safe!\n", other->client->pers.netname, amount, team_names[self->style] );
			last_safe_withdrawal[self->style] = level.time;

			other->client->resp.acchit+=amount;
		}

	}
}


void safebag_touch2( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0, rnd;
	
	if (!other->client)
		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))
	{
		return;
	}
	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > (int)(50.0 * (1.0 + (0.5*(other->client->pers.team == self->style)))))
		{
			// let them go away on their own terms
			T_Damage( other, other, other, vec3_origin, other->s.origin, vec3_origin, 9999, 0, 0, MOD_SAFECAMPER );
			last_touch_count = 0;
		}
	}

	last_touch_ent = other;

	if (self->timestamp > (level.time - 1.0))
		return;

	self->timestamp = level.time;

	// depositing, or withdrawing?

	if (other->client->pers.team == self->style)
	{	// deposit
		
		if (other->client->pers.currentcash > 0 || other->client->pers.bagcash > 0)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] += other->client->pers.currentcash;
			team_cash[self->style] += other->client->pers.bagcash;
			UPDATESCORE

			other->client->resp.deposited += other->client->pers.currentcash;
			other->client->resp.deposited += other->client->pers.bagcash;

			other->client->pers.currentcash = 0;
			other->client->pers.bagcash = 0;

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

	    		
               rnd = (rnd + 1) % 12;

               switch(rnd)
               {
				case 0:
			    // make a droping sound
			    gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/hiredguy/fingers2.wav"), 1, 1, 0);
			    break;
				
				case 1:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/weapon7.wav"), 1, 1, 0);
				break;

                case 2:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/great.wav"), 1, 1, 0);
				break;
                
				case 3:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle4.wav"), 1, 1, 0);
			    break;
                
				case 4:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/actors/male/lenny/thanks2.wav"), 1, 1, 0);
			    break;

                case 5:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/scalper/yes1.wav"), 1, 1, 0);
			    break;

                case 6:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle2.wav"), 1, 1, 0);
			    break;
                
				case 7:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                
				case 8:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/iamback.wav"), 1, 1, 0);
			    break;
                case 9:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, 1, 0);
			    break;
                case 10:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle5.wav"), 1, 1, 0);
			    break;
                case 11:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/sold2.wav"), 1, 1, 0);
			    break;
				default:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                }


			// let everyone know how much was deposited
			amount = team_cash[self->style] - precash;
			safe_bprintf( PRINT_MEDIUM, "%s deposited $%i\n", other->client->pers.netname, amount );
			last_safe_deposit[self->style] = level.time;
		}

	}
	else if (team_cash[self->style] > 0)
	{	// withdrawal

		if (other->client->pers.bagcash < MAX_BAGCASH_PLAYER)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] -= (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);
			other->client->pers.bagcash += (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);

			if (team_cash[self->style] < 0)
			{	// don't take more than they have
				other->client->pers.bagcash += team_cash[self->style];
				team_cash[self->style] = 0;
			}
			UPDATESCORE

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

			// alarm!
//			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("misc/cashmatch_alarm.wav"), 1, 1, 0);
			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, snd_fry2 , 1, 1, 0);
            //EF_IONRIPPER; //EF_ROCKET; //EF_TRAP; //EF_FLAMETHROWER; //EF_FLIES; //EF_QUAD; //EF_BFG; //EF_HYPERBLASTER; // I changed this to make it look better //ghost
			// let everyone know how much was stolen
			amount = precash - team_cash[self->style];
			safe_bprintf( PRINT_MEDIUM, "%s stole $%i from %s's safe!\n", other->client->pers.netname, amount, team_names[self->style] );

			last_safe_withdrawal[self->style] = level.time;

			other->client->resp.acchit+=amount;
		}

	}
}



void SP_dm_safebag1(edict_t *ent)
{

   if (teamplay->value != 1)
   {
		G_FreeEdict (ent);
		return;
   }

    ent->classname = "dm_safebag1";
	ent->takedamage = DAMAGE_NO;


    ent->s.effects = EF_FLAG1;	
	
	ent->s.renderfx2 = RF2_NOSHADOW;
	ent->s.renderfx = RF_GLOW;

	
	if (!ent->style)
     ent->style = 1;

	if (ent->style < 1 || ent->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(ent->s.origin));
		G_FreeEdict(ent);
		return;
	}

	ent->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( ent->mins, -12, -12, -16 );
	VectorSet( ent->maxs,  12,  12,  12 );

    ent->movetype = MOVETYPE_BOUNCE;  
	ent->solid = SOLID_TRIGGER;

	gi.linkentity(ent);

	ent->touch = safebag_touch1;
	ent->currentcash = 0;	// start with no cash

	ent->think = safebag_think;
	ent->nextthink = level.time + 2;
}


void SP_dm_safebag2(edict_t *ent)
{

   if (teamplay->value != 1)
   {
		G_FreeEdict (ent);
		return;
   }

    ent->classname = "dm_safebag2";
    ent->takedamage = DAMAGE_NO;    

    ent->s.effects = EF_FLAG2;	
	

	ent->s.renderfx2 = RF2_NOSHADOW;
	ent->s.renderfx = RF_GLOW;

	
	if (!ent->style)
     ent->style = 2;

	if (ent->style < 1 || ent->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(ent->s.origin));
		G_FreeEdict(ent);
		return;
	}

	ent->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( ent->mins, -12, -12, -16 );
	VectorSet( ent->maxs,  12,  12,  12 );

    ent->movetype = MOVETYPE_BOUNCE;  
	ent->solid = SOLID_TRIGGER;

	gi.linkentity(ent);

	ent->touch = safebag_touch2;
	ent->currentcash = 0;	// start with no cash

	ent->think = safebag_think;
	ent->nextthink = level.time + 2;
}


/*-----------------------------------------------------------------------*/
/*QUAKED misc_ctf_banner (1 .5 0) (-4 -64 0) (4 64 248) TEAM2
The origin is the bottom of the banner.
The banner is 248 tall.
*/
static void misc_ctf_banner_think (edict_t *ent)
{
	ent->s.frame = (ent->s.frame + 1) % 16;
	ent->nextthink = level.time + FRAMETIME;
}

void SP_misc_ctf_banner (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/ctf/banner/tris.md2");
	if (ent->spawnflags & 1) // team2
		ent->s.skinnum = 1;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}


/*QUAKED misc_ctf_small_banner (1 .5 0) (-4 -32 0) (4 32 124) TEAM2
The origin is the bottom of the banner.
The banner is 124 tall.
*/

void SP_misc_ctf_small_banner (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/ctf/banner/small.md2");
	if (ent->spawnflags & 1) // team2
		ent->s.skinnum = 1;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}





/*
=================
Cmd_Cloak_f
=================
*/


void Cmd_Cloak_f (edict_t *ent)
{
        
	if (ent->solid != SOLID_NOT){
	{	
	   	if (ent->svflags & SVF_NOCLIENT){
			safe_cprintf (ent, PRINT_HIGH, "You are nowvisible!\n");
            ent->svflags -= SVF_NOCLIENT;
			return;
		}
          else {
            safe_cprintf (ent, PRINT_HIGH, "Poof!\n");
            ent->svflags |= SVF_NOCLIENT;
		    return;
		  }
		}
	
	}
	
}





void Cmd_Shit_f (edict_t *ent)
{
        
	
	if (ent->client->anim_priority == ANIM_FAKE)
		{	
 
		    ent->client->anim_priority = ANIM_BASIC;
			return;
		}
          
    if (ent->client->anim_priority != ANIM_FAKE){
	
	ent->client->anim_priority = ANIM_FAKE;
	gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/242.wav"), 1, ATTN_NORM, 0);
   	gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/241.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/240.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/242.wav"), 1, ATTN_NORM, 0);
	safe_cprintf (ent, PRINT_HIGH, "Fart\n");
	ent->s.frame = FRAME_death3_01;
	ent->client->anim_end = FRAME_death3_28;
    return;

	}
	
}



void Cmd_fart_f (edict_t *ent)
	{
	
	int cocksucker;

	cocksucker = rand()%3;
	
	switch (cocksucker)
	{
	case 0:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/240.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/237.wav"), 1, ATTN_NORM, 0);

		break;
	case 1:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/241.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/238.wav"), 1, ATTN_NORM, 0);
		break;
	case 2:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/242.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/241.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/240.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/menuamb.wav"), 1, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/242.wav"), 1, ATTN_NORM, 0);
		break;
	
	}

}


void Cmd_fucku_f (edict_t *ent)
	{
	
	int shitmonkey;

	shitmonkey = rand()%7;
	
	switch (shitmonkey)
	{
	case 0:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fucker.wav"), 1, ATTN_NORM, 0);
		break;
	case 1:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou1.wav"), 1, ATTN_NORM, 0);
		break;
	case 2:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou2.wav"), 1, ATTN_NORM, 0);
		break;
	case 3:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile3.wav"), 1, ATTN_NORM, 0);
		break;
	case 4:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0);
		break;
	case 5:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;
	case 6:
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec2.wav"), 1, ATTN_NORM, 0);
		break;
	
	}
}



void Cmd_Store_Teleport_f (edict_t *ent)
{
	if (CustTeleport != 1){
	    safe_centerprintf (ent, "Admin Has Teleports Disabled!!!\n");
	}

	if (CustTeleport == 1){

	if (ent->solid == SOLID_NOT){
       safe_centerprintf (ent, "You are not in the game yet!!!\n");
	   return;
	}
	
	VectorCopy (ent->s.origin, ent->client->teleport_origin);
	VectorCopy (ent->s.angles, ent->client->teleport_angles);

	ent->client->teleport_stored = true;

	safe_centerprintf (ent, "Invisible Teleport in place!\n");

 }	
	
}


//This procedure just copies the current view angles, and current position into the teleport variables defined earlier in this tutorial. It then prints a message in the center of the screen telling you that the teleport location is stored, and sets a variable saying that it has been stored. This is used to stop crashes if a location hasn't been stored. There is probably an easier and more space / memory efficient way of doing this by setting 'teleport_origin' to NULL, or something, but I am sticking with something I KNOW works. 


/*
==================
Cmd_Load_Teleport_f
==================
*/

void Cmd_Load_Teleport_f (edict_t *ent)
{
	int		i;

	if (CustTeleport != 1){
	    safe_centerprintf (ent, "Admin Has Teleports Disabled!!!\n");
	}


	if (ent->solid == SOLID_NOT){
       safe_centerprintf (ent, "You are not in the game yet!!!\n");
	   return;
	}

if (CustTeleport == 1){
	
	if (!ent->deadflag)
	{
		if (ent->client->teleport_stored)
		{


	if (ent->client->pers.currentcash > 0){
		safe_centerprintf (ent, "teleporting not allowed while holding cash!\n");
        return;
	}

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SFXSMOKE);
			gi.WritePosition (ent->s.origin);
			gi.WriteByte (34);
			gi.WriteByte (0);
            gi.multicast (ent->s.origin, MULTICAST_PVS);

					
//GHOSTZOID - START HOOK
             KPQ2PlayerResetGrapple(ent);
//GHOSTZOID - END HOOK

			// unlink to make sure it can't possibly interfere with KillBox

			gi.unlinkentity (ent);

			VectorCopy (ent->client->teleport_origin, ent->s.origin);
			VectorCopy (ent->client->teleport_origin, ent->s.old_origin);
			ent->s.origin[2] += 10;

			// clear the velocity and hold them in place briefly
			VectorClear (ent->velocity);
			ent->client->ps.pmove.pm_time = 160>>3;		// hold time
			ent->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

			// draw the teleport splash on the player
			ent->s.event = EV_PLAYER_TELEPORT;

					// set angles
			for (i=0 ; i<3 ; i++)
			ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(ent->client->teleport_angles[i] - ent->client->resp.cmd_angles[i]);

			VectorClear (ent->s.angles);
			VectorClear (ent->client->ps.viewangles);
			VectorClear (ent->client->v_angle);

					// kill anything at the destination
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SFXSMOKE);
			gi.WritePosition (ent->s.origin);
			gi.WriteByte (34);
			gi.WriteByte (0);
            gi.multicast (ent->s.origin, MULTICAST_PVS);

					
					
			KillBox (ent);

			gi.linkentity (ent);

		}

		else
			safe_centerprintf (ent, "You don't be have a location stored\n");
	}
	
	else
		safe_centerprintf (ent, "Sorry. Can't be teleported when dead.\n");

	}	
 }



void Cmd_damages (edict_t *ent)
{

    safe_cprintf(ent, PRINT_HIGH, "Allied Assault 2 Settings\n\n");
	safe_cprintf(ent, PRINT_HIGH, "custdmg_bomber = %i\n\n", CustBomberDmg);
	safe_cprintf(ent, PRINT_HIGH, "Kingpin Damage Settings\n\n");
	safe_cprintf(ent, PRINT_HIGH, "\ncustdmg_kppistol = %i\n", CustPistolDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kpblakjak = %i\n", CustBlakjakDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kpshotgun = %i\n", CustShotgunDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kptommy = %i\n", CustTommyDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kphmg = %i\n", CustHMGDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kpgrenades = %i\n", CustGrenadeDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kprocket = %i\n", CustRocketDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_kpflame = %i\n\n", CustFlameDmg);
	safe_cprintf(ent, PRINT_HIGH, "Quake II Damage Settings\n\n");
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2machinegun = %i\n", CustMachinegunDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2rail = %i\n", CustRailDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2chain = %i\n", CustChainDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2hyper = %i\n", CustHyperDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2bfg = %i\n", CustBFGDmg);
	safe_cprintf(ent, PRINT_HIGH, "custdmg_q2super = %i\n", CustSuperDmg);

}


void Cmd_CommandList_fb (edict_t *ent)
{

		safe_cprintf(ent, PRINT_HIGH, make_white("________________-[     Current Binds     ]-_________________\n\n\n\n"));
		safe_cprintf(ent, PRINT_HIGH,"\n");
		safe_cprintf(ent, PRINT_HIGH, "\n\nListed Below are the Enabled Binds and Vars\n\n");
        if (CustJetpack == 1)
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use jet pack\"\n\n");
		if (CustHook == 1){
		safe_cprintf(ent, PRINT_HIGH, " [BLOODMONEY GRAPPLE]\n\n");
		safe_cprintf(ent, PRINT_HIGH, "Edit your autoexec.cfg file, found in your bloodmoney dir.\n");
		safe_cprintf(ent, PRINT_HIGH, "\n");
		safe_cprintf(ent, PRINT_HIGH, " [HITMEN HOOK]\n\n");
		safe_cprintf(ent, PRINT_HIGH, "Edit your autoexec.cfg file, found in your bloodmoney dir.\n");
		safe_cprintf(ent, PRINT_HIGH, "\n");
		}
		if (CustTeleport == 1){
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"storeteleport\"     <- places a teleport in map\n");
	    safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"loadteleport\"      <- teleport to your teleport\n\n");
        }
        if((convertq2powerups != 1) && (quad == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use quad damage\"\n");
		if((convertq2powerups != 1) && (quadfire == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use quadfire damage\"\n");
		if((convertq2armor != 1) && (invulnerability == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use invulnerability\"\n");
		if((convertq2weapons != 1) && (railgun == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use railgun\"\n");
		if((convertq2weapons != 1) && (bfg == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use bfg10k\"\n");
		if((convertq2weapons != 1) && (machinegun == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use machinegun\"\n");
		if((convertq2weapons != 1) && (supershotgun == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use super shotgun\"\n");
		if((convertq2weapons != 1) && (chaingun == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use chaingun\"\n");
		if((convertq2weapons != 1) && (hyperblaster == 1))
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"use hyperblaster\"\n");
		safe_cprintf(ent, PRINT_HIGH, "bind \"key\" \"1 thru 288 for taunts\"\n\n");
		safe_cprintf(ent, PRINT_HIGH, make_white("________________-[     Client  Files     ]-_________________\n\n\n\n"));
        safe_cprintf(ent, PRINT_HIGH,"\n");
		safe_cprintf(ent, PRINT_HIGH,"\n");
	    safe_cprintf(ent, PRINT_HIGH, "You need the BLOOD MONEY MOD CLIENT FILES to play!\n");
	    safe_cprintf(ent, PRINT_HIGH, "goto this website ->http://www.und3rgr0und.com\n");
		safe_cprintf(ent, PRINT_HIGH, make_white("____________________________________________________________ \n\n\n\n\n"));

}



void Cmd_CommandList_fc (edict_t *ent)
{


        safe_cprintf(ent, PRINT_HIGH, "Type \"pipdm\"     to add info_player_deathmatch\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"ipt1\"      to add info_player_deathmatch <-style 1\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"ipt2\"      to add info_player_deathmatch <-style 2\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"safebag1\"  to add team 1 Safebag\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"safebag2\"  to add team 2 Safebag\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"piqd\"      to add item_quad\n");
		safe_cprintf(ent, PRINT_HIGH, "Type \"pii\"       to add item_invulnerabilty\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pipscreen\" to add item_power_screen\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pipshield\" to add item_power_shield\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pib\"       to add item_breather\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pies\"      to add item_enviro\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pihs\"      to add item_health_sm\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pihl\"      to add item_health_lg\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pihm\"      to add item_health_mega\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pia\"       to add item_adrenaline\n");

}


void Cmd_CommandList_armor (edict_t *ent)
{
		safe_cprintf(ent, PRINT_HIGH, "Type \"pias\"  to add item_armor_shard\n");
     	safe_cprintf(ent, PRINT_HIGH, "Type \"piac\"  to add item_armor_combat\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"piab\"  to add item_armor_body\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"piajh\" to add item_armor_jacket_heavy\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"piahh\" to add item_armor_helmet_heavy\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pialh\" to add item_armor_legs_heavy\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"piaj\"  to add item_armor_jacket\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"piah\"  to add item_armor_helmet\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pial\"  to add item_armor_legs\n");

}





void Cmd_CommandList_fd (edict_t *ent)
{
		safe_cprintf(ent, PRINT_HIGH, "Type \"prg\"  to add weapon_railgun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pbfg\" to add weapon_bfg\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pmg\"  to add weapon_machinegun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pssg\" to add weapon_supershotgun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pcg\"  to add weapon_chaingun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"phb\"  to add weapon_hyperblaster\n");
		safe_cprintf(ent, PRINT_HIGH, "Type \"ptg\"  to add weapon_tommygun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"phmg\" to add weapon_heavymachinegun\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pgl\"  to add weapon_grenadelauncher\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pb\"   to add weapon_bazooka\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pft\"  to add weapon_flamethrower\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pcb\"  to add weapon_crowbar\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pp\"   to add weapon_pistol\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"psg\"  to add weapon_shotgun\n");
}




void Cmd_CommandList_fe (edict_t *ent)
{
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pcells\"     to add ammo_cells\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pslugs\"     to add ammo_slugs\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"prockets\"   to add ammo_rockets\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pcylinder\"  to add ammo_cylinder\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pshells\"    to add ammo_shells\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pflametank\" to add ammo_flametank\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pgrenades\"  to add ammo_grenades\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pbullets\"   to add ammo_bullets\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"p308\"       to add ammo_308\n");
        safe_cprintf(ent, PRINT_HIGH, "Type \"pik\"        to add item_pack\"\n");
    	safe_cprintf(ent, PRINT_HIGH, "Type \"pban\"       to add item_bandolier\n");

}




void Use_Target_Music (edict_t *ent, edict_t *other, edict_t *activator)
{

	ent->s.sound = ent->noise_index;	// start it
			
	gi.positioned_sound (ent->s.origin, ent, CHAN_VOICE, ent->noise_index, 1, 1, 0);


}

void SP_target_music (edict_t *ent)
{

    snd_fry1  = gi.soundindex(""); //
    snd_fry2  = gi.soundindex(""); //
    snd_fry3  = gi.soundindex(""); //
    snd_fry4  = gi.soundindex(""); // 
    snd_fry5  = gi.soundindex(""); //
    snd_fry6  = gi.soundindex("ambient/a1.wav"); //some weird ballad
    snd_fry7  = gi.soundindex("ambient/a2.wav"); //Awake - godsmack
    snd_fry8  = gi.soundindex("ambient/a3.wav"); //glisterine - Homebrew
    snd_fry9  = gi.soundindex("ambient/a4.wav");  //cop killer - 
    snd_fry10 = gi.soundindex("ambient/a5.wav"); //demons - NIN
    snd_fry11 = gi.soundindex("ambient/a6.wav"); //kill me - NIN
    snd_fry12 = gi.soundindex("ambient/a7.wav"); //you leave me cold - danzig
    snd_fry13 = gi.soundindex("ambient/a8.wav"); //if there is a hell - NIN
    snd_fry14 = gi.soundindex("ambient/a9.wav"); //you could have it all - NIN
    snd_fry15 = gi.soundindex("ambient/b1.wav"); //Here she comes - danzig
    snd_fry16 = gi.soundindex("ambient/b2.wav"); //respect - pantara
    snd_fry17 = gi.soundindex("ambient/b3.wav"); //physical NIN
    snd_fry18 = gi.soundindex("ambient/b4.wav"); //the crow theme song
    snd_fry19 = gi.soundindex("ambient/b5.wav"); //david bowie and NIN - reptile
    snd_fry20 = gi.soundindex("ambient/b6.wav"); //wacked NIN
    snd_fry21 = gi.soundindex("ambient/b7.wav"); //didnt you NIN
    snd_fry22 = gi.soundindex("ambient/b8.wav"); //Satans child - danzig
    snd_fry23 = gi.soundindex("ambient/b9.wav"); //I am NIN
    snd_fry24 = gi.soundindex("ambient/c1.wav"); //I wear my sunglasses at night
    snd_fry25 = gi.soundindex("ambient/c2.wav"); //everything is blue in this world NIN
    snd_fry26 = gi.soundindex("ambient/c3.wav"); // down in the belly of the beast i lie - danzig
    snd_fry27 = gi.soundindex("ambient/c4.wav"); //soul of misery - danzig
    snd_fry28 = gi.soundindex("ambient/c5.wav"); // kryptonite
    snd_fry29 = gi.soundindex("ambient/c6.wav"); // were in this together now NIN
    snd_fry30 = gi.soundindex("ambient/c7.wav"); //how does it feel NIN
    snd_fry31 = gi.soundindex("gtpitbullet/ozzy_crazytrain.wav"); // crazy train - ozzy
    snd_fry32 = gi.soundindex("gtpitbullet/megadeth_sod.wav"); // sod - megadeth
    snd_fry33 = gi.soundindex("gtpitbullet/sandman.wav"); // sandman
	
	ent->classname="target_music";

	if (CustSong == 0)  ent->s.sound = 0;
	if (CustSong == 1)  ent->s.sound = snd_fry1;
	if (CustSong == 2)  ent->s.sound = snd_fry2;
	if (CustSong == 3)  ent->s.sound = snd_fry3;
	if (CustSong == 4)  ent->s.sound = snd_fry4;
	if (CustSong == 5)  ent->s.sound = snd_fry5;
	if (CustSong == 6)  ent->s.sound = snd_fry6;
	if (CustSong == 7)  ent->s.sound = snd_fry7;
	if (CustSong == 8)  ent->s.sound = snd_fry8;
	if (CustSong == 9)  ent->s.sound = snd_fry9;
	if (CustSong == 10) ent->s.sound = snd_fry10;
	if (CustSong == 11) ent->s.sound = snd_fry11;
	if (CustSong == 12)	ent->s.sound = snd_fry12;
	if (CustSong == 13)	ent->s.sound = snd_fry13;
	if (CustSong == 14)	ent->s.sound = snd_fry14;
	if (CustSong == 15)	ent->s.sound = snd_fry15;
	if (CustSong == 16)	ent->s.sound = snd_fry16;
	if (CustSong == 17)	ent->s.sound = snd_fry17;
	if (CustSong == 18)	ent->s.sound = snd_fry18;
	if (CustSong == 19)	ent->s.sound = snd_fry19;
	if (CustSong == 20)	ent->s.sound = snd_fry20;
	if (CustSong == 21)	ent->s.sound = snd_fry21;
	if (CustSong == 22)	ent->s.sound = snd_fry22;
	if (CustSong == 23)	ent->s.sound = snd_fry23;
	if (CustSong == 24)	ent->s.sound = snd_fry24;
	if (CustSong == 25)	ent->s.sound = snd_fry25;
	if (CustSong == 26)	ent->s.sound = snd_fry26;
	if (CustSong == 27)	ent->s.sound = snd_fry27;
	if (CustSong == 28)	ent->s.sound = snd_fry28;
	if (CustSong == 29)	ent->s.sound = snd_fry29;
	if (CustSong == 30)	ent->s.sound = snd_fry30;
	if (CustSong == 31)	ent->s.sound = snd_fry31;
	if (CustSong == 32)	ent->s.sound = snd_fry32;
	if (CustSong == 33)	ent->s.sound = snd_fry33;
	
	ent->use = Use_Target_Music;
	// must link the entity so we get areas and clusters so
	// the server can determine who to send updates to
	gi.linkentity (ent);

    level.num_speakers++;

    if (!disable_bloodmoney_debug)
	gi.dprintf("[Speaker %i]\n",level.num_speakers);
}



/////////////////////
/*--------------------------------------------------------------------------
 * just here to help old map conversions
 *--------------------------------------------------------------------------*/

static void old_teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;
	vec3_t		forward;

	if (!other->client)
		return;

	dest = G_Find (NULL, FOFS(targetname), self->target);

	if (!dest)
	{
		gi.dprintf ("Couldn't find destination %s\n",self->target);
		return;
	}


//GHOSTZOID - START HOOK

	KPQ2PlayerResetGrapple(other);

//GHOSTZOID - - END HOOK

	
	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
//	other->s.origin[2] += 10;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_EXPLOSION);
	gi.WritePosition (other->s.origin);
	gi.multicast (other->s.origin, MULTICAST_PHS);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SFXSMOKE);
	gi.WritePosition (other->s.origin);
	gi.WriteByte (54);
	gi.WriteByte (0);
    gi.multicast (other->s.origin, MULTICAST_PVS);


	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
    gi.sound(other, CHAN_AUTO, snd_fry34, 1, ATTN_NORM, 0);

    //gi.positioned_sound(other->s.origin, other, CHAN_AUTO, snd_fry34 , 1, 1, 0);

//	self->enemy->s.event = EV_PLAYER_TELEPORT;
//	other->s.event = EV_OTHER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];
	other->s.angles[ROLL] = 0;
	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// give a little forward velocity
	AngleVectors (other->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 200, other->velocity);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	gi.linkentity (other);
}



//=================================================================================



/*QUAKED trigger_teleport (0.5 0.5 0.5) ?
Players touching this will be teleported
*/
void SP_trigger_teleport (edict_t *ent)
{
	edict_t *s;
	int i;

	if (!ent->target)
	{
		gi.dprintf ("there is a q3 teleport without a targetname.\n");
		G_FreeEdict (ent);
		return;
	}

	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	ent->touch = old_teleporter_touch;
	gi.setmodel (ent, ent->model);
    gi.linkentity (ent);


	// noise maker and splash effect dude
	s = G_Spawn();

	ent->enemy = s;

	s->movetype = MOVETYPE_NONE;
	s->solid = SOLID_NOT;
	VectorSet (s->mins, -16, -16, -24);
	VectorSet (s->maxs,  16,  16,  48);

    for (i = 0; i < 3; i++)
		s->s.origin[i] = ent->mins[i] + (ent->maxs[i] - ent->mins[i])/2;

	s->s.sound = gi.soundindex ("elechum.wav");
	gi.linkentity(s);
	
}


/*QUAKED info_teleport_destination (0.5 0.5 0.5) (-16 -16 -24) (16 16 32)
Point trigger_teleports at these.
*/
void SP_info_teleport_destination (edict_t *ent)
{
	ent->s.origin[2] += 16;
}




/*QUAKED elements_raincloud (0 .5 .8) ?
Snow falls from this invisable cloud at random points   

center of cloud to ground trace determines the drop fall distance

cloud can be any recatangle size
  
fxdensity - total number of drops in the sky 1 - 1000 (default 400) 

firetype - type of drops, 0 = rain 1 = drip
*/
// snap - new raincloud code

// called each time a client enters a map that has raincloud ents
void think_raincloud (edict_t *ent)
{
	int number;

	for(number = 1; number <= level.raincloud_number; number++){
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_RAIN);
		gi.WritePosition (level.raincloud[number].neworigin);
		gi.WriteShort (level.raincloud[number].fxdensity);
		gi.WriteShort (level.raincloud[number].effectsizex);
		gi.WriteShort (level.raincloud[number].effectsizey);
		gi.WriteShort (level.raincloud[number].effectsizez);	
		gi.WriteShort (level.raincloud[number].firetype);
		gi.unicast (ent, true);	
		//gi.dprintf ("raincloud %d info given to client: %s\n", number, ent->client->pers.netname);
	}

}

// called on initial map spawnign of ents
void SP_elements_raincloud (edict_t *self)
{
	vec3_t	minmaxsize;

	self->solid = SOLID_BSP;
	self->movetype = MOVETYPE_NONE;
	gi.setmodel (self, self->model);
	gi.linkentity (self);

	self->svflags |= SVF_NOCLIENT;

	level.raincloud_number++;

	// Find cloud size
	VectorSubtract(self->mins, self->maxs, minmaxsize);
	level.raincloud[level.raincloud_number].effectsizex = abs(minmaxsize[0])-2;
	level.raincloud[level.raincloud_number].effectsizey = abs(minmaxsize[1])-2;
	level.raincloud[level.raincloud_number].effectsizez = abs(minmaxsize[2])-2;

	// Find cloud center
	VectorCopy(self->mins, level.raincloud[level.raincloud_number].neworigin);
	level.raincloud[level.raincloud_number].neworigin[0] += (level.raincloud[level.raincloud_number].effectsizex >> 1);
	level.raincloud[level.raincloud_number].neworigin[1] += (level.raincloud[level.raincloud_number].effectsizey >> 1);
	level.raincloud[level.raincloud_number].neworigin[2] += (level.raincloud[level.raincloud_number].effectsizez >> 1);

	// Adjust rain density
	if (!self->fxdensity)
		self->fxdensity = 400;		 
	else if (self->fxdensity > 1000)
		self->fxdensity = 1000;	

	level.raincloud[level.raincloud_number].fxdensity = self->fxdensity;
	level.raincloud[level.raincloud_number].firetype = self->firetype;

//	gi.dprintf ("raincloud # %d initialized\n", level.raincloud_number);

}


/*QUAKED elements_snowcloud (0 .5 .8) ?
Snow falls from this invisable cloud at random points   

center of cloud to ground trace determines the flake fall distance

cloud can be any recatangle size
  
fxdensity - total number of flakes in the sky 1 - 1000 (default 400) 
*/

void think_new_first_snowcloud (edict_t *self)
{
	vec3_t	neworigin, minmaxsize;
	int		effectsizex, effectsizey, effectsizez;

	// Find cloud size
	VectorSubtract(self->mins, self->maxs, minmaxsize);
	effectsizex = abs(minmaxsize[0])-2;
	effectsizey = abs(minmaxsize[1])-2;
	effectsizez = abs(minmaxsize[2])-2;

	// Find cloud center
	VectorCopy(self->mins, neworigin);
	neworigin[0] += (effectsizex >> 1);
	neworigin[1] += (effectsizey >> 1);
	neworigin[2] += (effectsizez >> 1);

	// Adjust snow density
	if (!self->fxdensity)
		self->fxdensity = 400;		 
	else if (self->fxdensity > 1000)
		self->fxdensity = 1000;	
	
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SNOW);
	gi.WritePosition (neworigin);
	gi.WriteShort (self->fxdensity);
	gi.WriteShort (effectsizex);
	gi.WriteShort (effectsizey);
	gi.WriteShort (effectsizez);	
	gi.multicast (neworigin, MULTICAST_ALL_R);	
}

void SP_elements_snowcloud (edict_t *self)
{
	//snap, enabled this prop
	/*
	if (deathmatch->value)
	{	// auto-remove for deathmatch
		G_FreeEdict (self);
		return;
	}
	*/
	
	self->solid = SOLID_BSP;
	self->movetype = MOVETYPE_NONE;
	gi.setmodel (self, self->model);
	gi.linkentity (self);
	self->nextthink = level.time + (10 * FRAMETIME);
	self->think = think_new_first_snowcloud;
	self->svflags |= SVF_NOCLIENT;
}
