/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//  and is available over at The Scorpion Network, at http://www.und3rgr0und.com
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington
//  immediately, via The Scorpion Network Homepage http://www.und3rgr0und.com
//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"
#include "m_player.h"

qboolean Hogie_Filter(edict_t *ent);
void Cmd_Barcode_f (edict_t *ent);
void Cmd_Jaxon_f (edict_t *ent);
void Cmd_Sephi_f (edict_t *ent);
void Cmd_Hydro_f (edict_t *ent);
void Cmd_Cuts_f (edict_t *ent);
void Cmd_Cypress_f (edict_t *ent);
void Cmd_Hogie_f (edict_t *ent);
qboolean Curse_Filter(edict_t *ent , qboolean gender);
void Cmd_Kingpin_f (edict_t *ent);
void Cmd_Leroy_f (edict_t *ent);
void Cmd_Lamont_f (edict_t *ent);
void Cmd_Nikki_f (edict_t *ent);
void Cmd_Momo_f (edict_t *ent);
void Cmd_Jesus_f (edict_t *ent);
void Cmd_Tyrone_f (edict_t *ent);
void Cmd_Willy_f (edict_t *ent);
void Cmd_Moker_f (edict_t *ent);
void Cmd_Popeye_f (edict_t *ent);
void Cmd_Fem_f (edict_t *ent);
void Cmd_Honey_f (edict_t *ent);
void Cmd_Blunt_f (edict_t *ent);
void Cmd_Curse_f (edict_t *ent);


qboolean Hogie_Filter(edict_t *ent)
{
	int		i;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;
	
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
//		safe_cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return false;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return false;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;
	return true;
}

//FRANK Feb21,00
/*
==================
Cmd_Barcode_f //private fucntion for server admin: Barcode
==================
*/


void Cmd_Barcode_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fucker.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/pieceshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/takesome.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

    
	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}

//FRANK June26,00
/*
==================
Cmd_Jaxon_f
==================
*/



void Cmd_Jaxon_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 16;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/larry.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/armor_head2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	default:
	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/fuckshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Jaxon_Curse


//FRANK 9/12/00
/*
==================
Cmd_Sephi_f
==================
*/



void Cmd_Sephi_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/david/david3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killme2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/leave.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/morgue.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk13.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/moe1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar3.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;
	default:
	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Sephi_Curse



//FRANK June26,00
/*
==================
Cmd_Hydro_f
==================
*/




void Cmd_Hydro_f (edict_t *ent)
{
	int i;
	static int rnd;

    if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/amb1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/buyticket1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/yes2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/getout.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny6.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Hydro_Curse


//FRANK June26,00
/*
==================
Cmd_Cuts_f
==================
*/



void Cmd_Cuts_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 30 seconds ago.
	if (ent->client->last_wave > (level.time - 30) && (ent->client->last_wave <= level.time))
    return;

	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//			(int)flood_waitdelay->value);
	      return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}

	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv1.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv2.wav"), 1, ATTN_NORM, 0);     break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2_1.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut3_2.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut2.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut3.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut4.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut5.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut7.wav"), 1, ATTN_NORM, 0);     break;

	case 11:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/sycut.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CutScenes


//FRANK June26,00
/*
==================
Cmd_Cypress f
==================
*/


void Cmd_Cypress_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 15 seconds ago.
	if (ent->client->last_wave > (level.time - 15) && (ent->client->last_wave <= level.time))
    return;
	
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
	//		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 4;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress2.wav"), 1, ATTN_NORM, 0);		break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress3.wav"), 1, ATTN_NORM, 0);		break;

	default:
	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress4.wav"), 1, ATTN_NORM, 0);		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CypressHill

//FRANK Jan25,00
/*
==================
Cmd_Hogie_f
==================
*/



void Cmd_Hogie_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 23;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/getme2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/bum.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/pain.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/death.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/sit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/shuffle.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/worked2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/holdbuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;
	}

	if(rand()%2==0)
	{
		//pick a taunt wave.
		i = rand() % 3;
		switch(i)
		{
		case 0: ent->s.frame = FRAME_tg_bird_01-1;
				ent->client->anim_end = FRAME_tg_bird_10;
				break;
		case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
				ent->client->anim_end = FRAME_tg_crch_grab_16;
				break;
		case 2:
		default: ent->s.frame = FRAME_tg_chin_flip_01-1;
				 ent->client->anim_end = FRAME_tg_chin_flip_15;
		}
	}

}





qboolean Curse_Filter(edict_t *ent , qboolean gender)
{
	int i;
	gclient_t *cl;

	char *cmd;
	cmd = gi.argv(0);
	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;

	//kingpin has to be male.
	if ((!(ent->gender == GENDER_MALE)) && (gender))
	{
		safe_cprintf(ent, PRINT_CHAT, ">> %s is a MALE taunt!\n>> %s is female.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}	

	else if ((!(ent->gender == GENDER_FEMALE)) && (!gender) )
	{
		safe_cprintf(ent, PRINT_CHAT, ">> %s is a FEMALE taunt!\n>> %s is male.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}

	//cant talk if your dying.
	if (ent->health <= 10)
	{
		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		safe_cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) return false;
	if (ent->client->anim_priority > ANIM_WAVE)	return false;

    ent->client->anim_priority = ANIM_WAVE;

	//mark the last time that you talked.
	ent->client->last_wave = level.time;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0) i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;

	  if (cl->flood_when[i] && level.time - cl->flood_when[i] < flood_persecond->value) 
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
	  if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
	  }

	  cl->flood_whenhead = (cl->flood_whenhead + 1) %	(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
	  cl->flood_when[cl->flood_whenhead] = level.time;
	}

	return true;
}

//FRANK Jan28,00
/*
==================
Cmd_Kingpin_f
==================
*/




void Cmd_Kingpin_f (edict_t *ent)
{	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny7.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 13 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}



//FRANK Jan28,00
/*
==================
Cmd_Leroy_f
==================
*/


void Cmd_Leroy_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0); break;

	case 9: 
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0); break;
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}


//FRANK Jan28,00
/*
==================
Cmd_Lamont_f
==================
*/



void Cmd_Lamont_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny1.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny2.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/mfcomeout.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/offstreet2.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Lamont_f



//FRANK Mar19,00
/*
==================
Cmd_Nikki_f
==================
*/



void Cmd_Nikki_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny4.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Nikki_f

//FRANK Jan28,00
/*
==================
Cmd_Momo_f
==================
*/


void Cmd_Momo_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 21;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0); break;
	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0); break;
	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0); break;
	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0); break;
	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0); break;
	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0); break;
	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0); break;
	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0); break;
	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-6.wav"), 1, ATTN_NORM, 0); break;
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0); break;
	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile1.wav"), 1, ATTN_NORM, 0); break;
	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle4.wav"), 1, ATTN_NORM, 0); break;
	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_typhoon.wav"), 1, ATTN_NORM, 0); break;
	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile2.wav"), 1, ATTN_NORM, 0); break;
	case 14: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/scram.wav"), 1, ATTN_NORM, 0); break;
	case 15: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/comeback2.wav"), 1, ATTN_NORM, 0); break;
	case 16: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle3.wav"), 1, ATTN_NORM, 0); break;
	case 17: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_saltydog.wav"), 1, ATTN_NORM, 0); break;
	default:
    case 18: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0); break;
	case 19: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle2.wav"), 1, ATTN_NORM, 0); break;
	case 20: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_boilerroom.wav"), 1, ATTN_NORM, 0); break;
	}
	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 15 waves
	     i = rand() % 3;
	     switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Momo_f




//FRANK Jan28,00
/*
==================
Cmd_Jesus_f
==================
*/



void Cmd_Jesus_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/battery.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny6.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain1.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Jesus_f


//FRANK Jan28,00
/*
==================
Cmd_Tyrone_f
==================
*/


void Cmd_Tyrone_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Tyrone_f


//FRANK Jan28,00
/*
==================
Cmd_Willy_f
==================
*/



void Cmd_Willy_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 8;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/onfloor5.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/lizzy1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 8 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Willy_f



//FRANK Jan28,00
/*
==================
Cmd_Moker_f
==================
*/



void Cmd_Moker_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Moker_f


/*
==================
Cmd_Popeye_f       Frank 12/14/00
==================
*/



void Cmd_Popeye_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 11;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/whistle.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/burp.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/tackle.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile2.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile3.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/wharfshrimp.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/barney.wav"), 1, ATTN_NORM, 0); break;
	}

	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 10 waves
		 i = rand() % 3;
		 switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Popeye_f

//FRANK June26,00
/*
==================
Cmd_Fem_f
==================
*/



void Cmd_Fem_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,false))
		return;
    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);	break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);    break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/neutral/seennothing.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_backoff.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die2.wav"), 1, ATTN_NORM, 0);     break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die3.wav"), 1, ATTN_NORM, 0);     break;

	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_takethat.wav"), 1, ATTN_NORM, 0);     break;

	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/infacemf.wav"), 1, ATTN_NORM, 0);     break;

	case 14:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Fem

//FRANK Nov24,00
/*
==================
Cmd_Honey_f
==================
*/


void Cmd_Honey_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

//	gi.WriteByte( svc_stufftext );
//	gi.WriteString( va("play glad/rock/honey.wav"));
//	gi.unicast (ent, true);

	gi.sound(ent, CHAN_AUTO, gi.soundindex("kpl/honey.wav"), 1, ATTN_NORM, 0); 

	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
			ent->client->anim_end = FRAME_tg_crch_grab_16;
			break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
			 ent->client->anim_end = FRAME_tg_chin_flip_15;
	}
}//end Cmd_Honey_f



//FRANK Jan28,00
/*
==================
Cmd_Blunt_f
==================
*/



void Cmd_Blunt_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,false))
		return;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight5.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Blunt_f


//FRANK Jan24,00
/*
==================
Cmd_Curse f
==================
*/


void Cmd_Curse_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 87;

	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/brittany/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/10bucks2.wav"), 1, ATTN_NORM, 0);
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/party.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/piece.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/coverme.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shakin.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 23:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 24:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 25:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 26:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-5.wav"), 1, ATTN_NORM, 0);
		break;

	case 27:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 28:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 29:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 30:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 31:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 32:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 33:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 34:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/shitbaby.wav"), 1, ATTN_NORM, 0);
		break;

	case 35:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/yeah2.wav"), 1, ATTN_NORM, 0);
		break;

	case 36:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry1.wav"), 1, ATTN_NORM, 0);
		break;

	case 37:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry2.wav"), 1, ATTN_NORM, 0);
		break;

	case 38:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry3.wav"), 1, ATTN_NORM, 0);
		break;

	case 39:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry4.wav"), 1, ATTN_NORM, 0);
		break;

	case 40:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry5.wav"), 1, ATTN_NORM, 0);
		break;

	case 41:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/nobar1.wav"), 1, ATTN_NORM, 0);
		break;

	case 42:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 43:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse2.wav"), 1, ATTN_NORM, 0);
		break;

	case 44:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 45:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lisa_specific/findpiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 46:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/orders/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 47:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 48:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0);
		break;

	case 49:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 50:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0);
		break;

	case 51:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight5.wav"), 1, ATTN_NORM, 0);
		break;

	case 52:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 53:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 54:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/pullshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 55:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 56:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 57:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 58:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 59:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 60:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 61:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 62:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 63:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 64:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 65:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 66:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/sal/shotguns.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 67:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 68:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 69:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 70:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 71:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 72:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 73:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 74:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 75:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 76:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 77:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 78:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 79:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 80:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 81:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 82:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 83:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 84:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 85:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 86:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}












