// Note to self: for whatever reason EVERY custom DLL so far lacks the talking icons... should try to make it work again
// I found out STAT_HUD_SELF_TALK was buggy -- I don't know how to fix it, the HUD is coded in g_spawn.c but I'm not sure
// if 'talk' section is engine-hard-coded or just incomplete (but then, how come ENEMY_TALK works?)

/******************************************************************************

  DEFAULT Episode settings, where the magic happens

*******************************************************************************/
#include "g_local.h"

	//------------------------------------- Lockpicking skills
	#include "ai_spawnflags.h"
	#include "voice_punk.h"
	#include "voice_bitch.h"

	//------------------------------------- Animations set (dog)
	extern mmove_t dog_move_pant;
	extern mmove_t dog_move_sniff;
	extern mmove_t dog_move_bark;
	extern mmove_t dog_move_growl;
	extern mmove_t enemy_dog_move_pee;
	extern mmove_t dog_move_low_atk;
	extern mmove_t dog_move_med_atk;
	extern mmove_t dog_move_upr_atk;

	//------------------------------------- Animations set (bitch)
	extern mmove_t bitch_move_leanlook;
	extern mmove_t bitch_move_leanwave;
	extern mmove_t bitch_move_whatsup;
	extern mmove_t bitch_move_talkme;
	extern mmove_t bitch_move_nonono;
	extern mmove_t bitch_move_comeon;
	extern mmove_t bitch_move_getdown;
	extern mmove_t bitch_move_whomw;
	extern mmove_t bitch_move_lookself;
	extern mmove_t bitch_move_flirt;
	extern mmove_t bitch_move_evd_amb;
	extern mmove_t bitch_move_pull_gun;
	extern mmove_t bitch_move_shoot_stand;

	//------------------------------------- Animations set (whore)
	extern mmove_t whore_move_talk1;
	extern mmove_t whore_move_talk2;
	extern mmove_t whore_move_talk3;
	extern mmove_t whore_move_talk4;
	extern mmove_t whore_move_talk5;
	extern mmove_t whore_move_sg_stand;
	extern mmove_t whore_move_sg_talk1;
	extern mmove_t whore_move_sg_talk2;
	extern mmove_t whore_move_sg_talk3;
	extern mmove_t whore_move_sg_talk5;
	extern mmove_t whore_move_sg_talk6;
	extern mmove_t whore_move_sg_talk7;
	extern mmove_t whore_move_sg_talk8;

	//------------------------------------- Animations set (punk)
	extern mmove_t punk_move_talk1;
	extern mmove_t punk_move_talk2;
	extern mmove_t punk_move_talk3;
	extern mmove_t punk_move_talk4;
	extern mmove_t punk_move_talk5;
	extern mmove_t punk_move_talk6;
	extern mmove_t punk_move_head_wipe;
	extern mmove_t punk_move_sg_talk1;
	extern mmove_t punk_move_sg_talk2;
	extern mmove_t punk_move_sg_talk3;
	extern mmove_t punk_move_sg_talk4;
	extern mmove_t punk_move_sg_talk5;
	extern mmove_t punk_move_sg_talk6;

	//------------------------------------- Animations set (thug)
	extern mmove_t thug_move_talk1;
	extern mmove_t thug_move_handwave;
	extern mmove_t thug_move_nod_yes;
	extern mmove_t thug_move_whoa;
	extern mmove_t thug_move_crch_grab;
	extern mmove_t thug_move_up_yours;
	extern mmove_t thug_move_nod_no;
	extern mmove_t thug_move_pull_guns;
	extern mmove_t thug_move_cold_cock;

	//------------------------------------- Animations set (runt)
	extern mmove_t runt_move_talk1;
	extern mmove_t runt_move_talk2;
	extern mmove_t runt_move_talk3;
	extern mmove_t runt_move_talk4;
	extern mmove_t runt_move_talk5;
	extern mmove_t runt_move_talk6;
	extern mmove_t runt_move_talk7;
	extern mmove_t runt_move_talk8;
	extern mmove_t runt_move_pull_guns;

	//------------------------------------- Animations set (shorty)
	extern mmove_t shorty_move_talk1;
	extern mmove_t shorty_move_talk2;
	extern mmove_t shorty_move_talk3;
	extern mmove_t shorty_move_talk4;
	extern mmove_t shorty_move_talk5;
	extern mmove_t shorty_move_talk6;
	extern mmove_t shorty_move_talk7;


void DebugSpawnMarker_Die ( edict_t *self)
{
	G_FreeEdict(self);
	return;
}

void DebugSpawnMarker ( vec3_t origin )
{
	edict_t		*ent;
	ent = G_Spawn();
	VectorCopy (origin, ent->s.origin);
	ent->think = DebugSpawnMarker_Die;
	ent->nextthink = level.time + 10;
	ent->s.modelindex = gi.modelindex("models/weapons/sshell_md2/tris.md2");
	gi.linkentity (ent);
}

void Wherever_HiredGuysRegisterFlags (edict_t *ent, edict_t *other) { }
void Wherever_CheckMomo (edict_t *ent, cast_memory_t *mem) { }
int	Wherever_HiredGuysFlags (edict_t *player, edict_t *self) { return (1); }

// Called whenever a character (player or AI) is sighted by an AI character
qboolean Wherever_CastSight (edict_t *self,	edict_t *other,	cast_memory_t *mem)
{
	if (!strcmp(self->classname, "cast_bum_sit") && (self->spawnflags & SPMOD_BUM_TOTAL))	// Bum
		{
		if (other->client && (mem->memory_type == MEMORY_TYPE_ENEMY))	// Cast saw client, client is hostile right now
			{
			self->enemy = NULL;	// give them a chance to make friends if they holster
			AI_RemoveFromMemory( self, mem );	// make them a neutral instead of enemy
			AI_AddToMemory( self, mem, MEMORY_TYPE_NEUTRAL );
			mem->flags &= ~MEMORY_HOSTILE_ENEMY;
			}
		return true;	// ignore them
		}

	return false;
}
	

// Called when ever a character is "used" (like when someone dies that has a ->deathtarget set)
//qboolean Wherever_CastUse (edict_t *self, edict_t *other, edict_t *activator)
qboolean Wherever_CastUse (edict_t *self, edict_t *other, edict_t *activator) { return false; }

// Called on speech occasions
qboolean Wherever_EventSpeech (edict_t *self, edict_t *other, int saywhat)
{
	cast_memory_t	*mem;
	mem = level.global_cast_memory[ self->character_index ][ other->character_index ];

	switch (saywhat)
	{
	case say_neutral:
		{
		if ((!strcmp(self->classname, "cast_bum_sit") && (self->spawnflags & SPMOD_BUM_TOTAL)) && other->client)	// Bum talking to player
			{
			Voice_Random (self, other, steeltown_pete, 4);	// using Pete for this
			return true;
			}
		return false;
		}
	case say_hostile:
		{
		if ((!strcmp(self->classname, "cast_bum_sit") && (self->spawnflags & SPMOD_BUM_TOTAL)) && other->client)	// Bum talking to player
			{
			Voice_Random (self, other, &steeltown_pete[4], 4);	// that good old Pete is mad at us!
			return true;
			}
		return false;
		}
	}
	return false;
}

// Called whenever an item is picked up, we could use a flag system here too (and custom pick ups, like pick the model and such?)
void Wherever_ItemPickup (edict_t *self, edict_t *other) { }

void Wherever_Flags (edict_t *self) { }

void Wherever_SpecialEventDeath (edict_t *self) { }

// Return TRUE if current episode is none of the original game (used to prevent special entities to mess with the original game)
//qboolean Wherever_Valid ( void )
//qboolean Wherever_Valid ( void )
qboolean Wherever_Valid ()
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		return false;
	case EP_POISONVILLE:
		return false;
	case EP_SHIPYARDS:
		return false;
	case EP_STEELTOWN:
		return false;
	case EP_TRAINYARD:
		return false;
	case EP_RADIOCITY:
		return false;
	default:
		return true;
	}
}

// This routine is called when a cast reaches a path_corner_cast that has a "scriptname" set
// Ugly as hell, let's try and find another way (custom anims anyone?)
void Wherever_Script(edict_t *ent, char *scriptname)
{
	if (!strcmp(ent->classname, "cast_dog"))
	{
		if (!strcmp(scriptname, "dog_pant"))
		{
			ent->cast_info.currentmove = &dog_move_pant;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_sniff"))
		{
			ent->cast_info.currentmove = &dog_move_sniff;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_bark"))
		{
			ent->cast_info.currentmove = &dog_move_bark;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_growl"))
		{
			ent->cast_info.currentmove = &dog_move_growl;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_pee"))
		{
			ent->cast_info.currentmove = &enemy_dog_move_pee;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_low_atk"))
		{
			ent->cast_info.currentmove = &dog_move_low_atk;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_med_atk"))
		{
			ent->cast_info.currentmove = &dog_move_med_atk;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "dog_upr_atk"))
		{
			ent->cast_info.currentmove = &dog_move_upr_atk;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_bitch"))
	{
		if (!strcmp(scriptname, "bitch_leanlook"))
		{
			ent->cast_info.currentmove = &bitch_move_leanlook;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_leanwave"))
		{
			ent->cast_info.currentmove = &bitch_move_leanwave;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_whatsup"))
		{
			ent->cast_info.currentmove = &bitch_move_whatsup;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_talkme"))
		{
			ent->cast_info.currentmove = &bitch_move_talkme;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_nonono"))
		{
			ent->cast_info.currentmove = &bitch_move_nonono;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_comeon"))
		{
			ent->cast_info.currentmove = &bitch_move_comeon;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_getdown"))
		{
			ent->cast_info.currentmove = &bitch_move_getdown;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_whomw"))
		{
			ent->cast_info.currentmove = &bitch_move_whomw;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_lookself"))
		{
			ent->cast_info.currentmove = &bitch_move_lookself;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_flirt"))
		{
			ent->cast_info.currentmove = &bitch_move_flirt;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_evd_amb"))
		{
			ent->cast_info.currentmove = &bitch_move_evd_amb;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_pull_gun"))
		{
			ent->cast_info.currentmove = &bitch_move_pull_gun;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "bitch_stand_shoot"))
		{
			ent->cast_info.currentmove = &bitch_move_shoot_stand;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_whore"))
	{
		if (!strcmp(scriptname, "whore_talk1"))
		{
			ent->cast_info.currentmove = &whore_move_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_talk2"))
		{
			ent->cast_info.currentmove = &whore_move_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_talk3"))
		{
			ent->cast_info.currentmove = &whore_move_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_talk4"))
		{
			ent->cast_info.currentmove = &whore_move_talk4;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_talk5"))
		{
			ent->cast_info.currentmove = &whore_move_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_stand"))
		{
			ent->cast_info.currentmove = &whore_move_sg_stand;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk1"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk2"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk3"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		} // yep, there's no talk4
		else if (!strcmp(scriptname, "whore_sg_talk5"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk6"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk6;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk7"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk7;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "whore_sg_talk8"))
		{
			ent->cast_info.currentmove = &whore_move_sg_talk8;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_punk"))
	{
		if (!strcmp(scriptname, "punk_talk1"))
		{
			ent->cast_info.currentmove = &punk_move_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_talk2"))
		{
			ent->cast_info.currentmove = &punk_move_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_talk3"))
		{
			ent->cast_info.currentmove = &punk_move_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_talk4"))
		{
			ent->cast_info.currentmove = &punk_move_talk4;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_talk5"))
		{
			ent->cast_info.currentmove = &punk_move_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_talk6"))
		{
			ent->cast_info.currentmove = &punk_move_talk6;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_head_wipe"))
		{
			ent->cast_info.currentmove = &punk_move_head_wipe;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_sg_talk1"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_sg_talk2"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_sg_talk3"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_sg_talk4"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk4;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "punk_sg_talk5"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;		
		}
		else if (!strcmp(scriptname, "punk_sg_talk6"))
		{
			ent->cast_info.currentmove = &punk_move_sg_talk6;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_thug"))
	{
		if (!strcmp(scriptname, "thug_talk1"))
		{
			ent->cast_info.currentmove = &thug_move_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_handwave"))
		{
			ent->cast_info.currentmove = &thug_move_handwave;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_nod_yes"))
		{
			ent->cast_info.currentmove = &thug_move_nod_yes;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_whoa"))
		{
			ent->cast_info.currentmove = &thug_move_whoa;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_crch_grab"))
		{
			ent->cast_info.currentmove = &thug_move_crch_grab;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_up_yours"))
		{
			ent->cast_info.currentmove = &thug_move_up_yours;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_nod_no"))
		{
			ent->cast_info.currentmove = &thug_move_nod_no;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_pull_guns"))
		{
			ent->cast_info.currentmove = &thug_move_pull_guns;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "thug_cold_cock"))
		{
			ent->cast_info.currentmove = &thug_move_cold_cock;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_runt"))
	{
		if (!strcmp(scriptname, "runt_talk1"))
		{
			ent->cast_info.currentmove = &runt_move_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk2"))
		{
			ent->cast_info.currentmove = &runt_move_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk3"))
		{
			ent->cast_info.currentmove = &runt_move_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk4"))
		{
			ent->cast_info.currentmove = &runt_move_talk4;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk5"))
		{
			ent->cast_info.currentmove = &runt_move_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk6"))
		{
			ent->cast_info.currentmove = &runt_move_talk6;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk7"))
		{
			ent->cast_info.currentmove = &runt_move_talk7;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_talk8"))
		{
			ent->cast_info.currentmove = &runt_move_talk8;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "runt_pull_guns"))
		{
			ent->cast_info.currentmove = &runt_move_pull_guns;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
	else if (!strcmp(ent->classname, "cast_shorty"))
	{
		if (!strcmp(scriptname, "shorty_talk1"))
		{
			ent->cast_info.currentmove = &shorty_move_talk1;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk2"))
		{
			ent->cast_info.currentmove = &shorty_move_talk2;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk3"))
		{
			ent->cast_info.currentmove = &shorty_move_talk3;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk4"))
		{
			ent->cast_info.currentmove = &shorty_move_talk4;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk5"))
		{
			ent->cast_info.currentmove = &shorty_move_talk5;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk6"))
		{
			ent->cast_info.currentmove = &shorty_move_talk6;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
		else if (!strcmp(scriptname, "shorty_talk7"))
		{
			ent->cast_info.currentmove = &shorty_move_talk7;
			ent->s.frame = ent->cast_info.currentmove->firstframe;
		}
	}
}

/*********************************************************************
		LOCKSMITH -- July, 28th 2010

		Next: DoKey functions and routines. Those are called whenever
		you ask your sidekicks to unlock a door.
		Set the spawnflag "1" with "cast_bitch", "cast_thug" or
		"cast_runt" to make him/her a lock picking king!
*********************************************************************/

extern mmove_t	runt_move_crch_dokey;
extern mmove_t	bitch_move_crch_dokey;
extern mmove_t	thug_move_crch_dokey;

extern mmove_t  runt_move_walk_dokey;
extern mmove_t	shorty_move_walk_dokey;
extern mmove_t	bitch_move_hotspot;
extern mmove_t	whore_move_hotspot;
extern mmove_t	thug_move_hotspot;
extern mmove_t	punk_move_walk_dokey;

void		unlock_sound			(edict_t *self);	// defined in "g_trigger.c"

// You know how to pick a lock, right? (DONE)
qboolean Wherever_DoKey (edict_t *self, edict_t *other)
{
	int i;

	// Step one: remove DOKEY for every fellow gang member.
	for (i=0; i<level.num_characters; i++)
	{
	if (level.characters[i])											// This character is part of the level
		if (level.characters[i]->cast_info.aiflags & AI_DOKEY)			// Received special order
			if (level.characters[i]->cast_group == 1)					// Is friendly
				if (level.characters[i]->svflags & SVF_MONSTER)			// Is a human AI
					if (level.characters[i]->health > 0)				// it's ALIIIIIVE!
						if (level.characters[i]->inuse)					// Currently used
							{
							self->cast_info.aiflags &= ~AI_DOKEY;
							level.characters[i]->cast_info.aiflags &= ~AI_DOKEY;
							}
	}
	// Step two: return true, because we can use special order to picklock AND guide any gang member to a hot zone
	return true;
	/*
	if (!strcmp(other->classname, "cast_bitch") || !strcmp(other->classname, "cast_thug") || !strcmp(other->classname, "cast_runt"))
	{
		if ((other->spawnflags & AI_SPAWNFLAG_LOCKSMITH) && self->client)
			return true;
	}
	return false;*/
}

// Like EVERY OTHER FUCKING "unlockdoorflag", we're return FALSE without checking anything at all. (DONE)
qboolean Wherever_UnlockDoorFlag (edict_t *ent)
{
	return false;
}

// We're done with the lock, back to usual business (DONE)
void Wherever_EndDoKey (edict_t *self)
{
	edict_t		*player;
	edict_t		*door;
	player = &g_edicts[1];

	// This should return the door, but it's quite unsafe I guess...
	door = G_Find(NULL, FOFS(target2), self->goal_ent->targetname);	// replaced "target" with "target2"
	door->key = 0;
	door->targetname = NULL;	// kill the name, so we're sure a trigger_unlock won't mess the stuff up

	// ACC, let's make a sound:
	gi.positioned_sound(door->s.origin, door, CHAN_VOICE, gi.soundindex("scenaric/fingers_open1.wav"), 1, 2, 0);

	// Okay, no more goal for you, back to the usual stuff:
	self->goal_ent = NULL;									// Forget previous goal
	self->cast_info.currentmove = self->cast_info.move_run;	// Done with lock picking animation
	if (self->gender == GENDER_MALE)
		Voice_Specific (self, player, hiredguy_ask, 17);		// Male: "there you go, easy money!"
	else
		Voice_Specific (self, player, f_response, 0);		// Female: "yeah, let's go!"
	player->client->ps.stats[STAT_HUD_ENEMY_TALK] = TT_POSITIVE;
	player->client->hud_enemy_talk_time = level.time + 2.0;

	self->s.model_parts[PART_GUN].invisible_objects = 0;	// Show the guns
	self->s.model_parts[PART_GUN2].invisible_objects = 0;	// Show the guns
}

#define ORDER_SPECIAL_GOTO			1
#define	ORDER_SPECIAL_PICKTHELOCK	2
#define	ORDER_SPECIAL_GETITEM		3

// We're not using names, so let's find ANYONE in the gang that can pick the lock AND has received the order to do it

edict_t *Wherever_GetChar (int ordertype)
{
	int i;
	for (i=0; i<level.num_characters; i++)
	{
		if (level.characters[i])											// This character is part of the level
			if (level.characters[i]->cast_info.aiflags & AI_DOKEY)			// Received special order
				if (level.characters[i]->cast_group == 1)					// Is friendly
					if (level.characters[i]->svflags & SVF_MONSTER)			// Is a human AI
						if (level.characters[i]->health > 0)				// it's ALIIIIIVE!
							if (level.characters[i]->inuse)					// Currently used					
								if (ordertype == ORDER_SPECIAL_GOTO)		// __Ordertype: go to
									return level.characters[i];				//    __You'll do, no matter who you are
								else										// __Ordertype: unlock door
									{
									if (!strcmp(level.characters[i]->classname, "cast_bitch") ||
										!strcmp(level.characters[i]->classname, "cast_thug") ||
										!strcmp(level.characters[i]->classname, "cast_runt"))	// Must be A ONE-HANDED WEAPON CHARACTER!
										if (level.characters[i]->spawnflags & AI_SPAWNFLAG_LOCKSMITH)	//    __Can unlock? (if it's a two-handed weapon character, this flag is "flashlight")
											return level.characters[i];									//    __bitch, thug or runt only!
									}
	}
	return NULL;
}

void AI_Destination_Ptr_Done(edict_t *self, int success)
{
	edict_t *AiChar;
	AiChar = self->goal_ent;										// Goal's character
	self->cast_info.aiflags &= ~AI_GOAL_RUN;						// This entity is no longer a place to go to
	if (!AiChar)
		{
		G_FreeEdict (self);
		return;
		}
	else if (AiChar->health > 0) // the character didn't die while trying to reach the goal
		{
		AiChar->cast_info.currentmove = AiChar->cast_info.move_stand;	// Just stand, come back
		if (success)
			{
			AiChar->cast_info.aiflags |= AI_NOWALK_FACE;					// Do not move
			AiChar->cast_info.aiflags |= AI_HOLD_POSITION;					// Hold this position
			if (!AiChar->holdpos_ent) {	AiChar->holdpos_ent = G_Spawn(); }	// Hold position
			VectorCopy( AiChar->s.origin, AiChar->holdpos_ent->s.origin );
			}
		}
	G_FreeEdict (self);												// Kill meeting point
}

void AI_Destination_Ptr_Expired(edict_t *self)
{
	if (spmod_debug->value) { gi.dprintf("%s (%s) couldn't reach %s (expired)!\n", self->goal_ent->name, self->goal_ent->classname, self->classname); }
	AI_Destination_Ptr_Done(self, false);
}

void AI_Destination_Ptr_Reached(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other != self->goal_ent) { return; }
	if (spmod_debug->value) { gi.dprintf("%s (%s) reached %s!\n", self->goal_ent->name, self->goal_ent->classname, self->classname); }
	AI_Destination_Ptr_Done(self, true);
}

edict_t *AI_Destination_Ptr (edict_t *player, edict_t *other)
	{
	edict_t *ent;
	vec3_t	start, end, dir;
	trace_t	tr2;

	// Check for existing AI_DESTINATION_PTR, kill everything that belongs to current AI
	// THEN create the new one.

	ent = G_Spawn();
	ent->classname = "ai_destination_ptr";
	ent->owner = player;
	ent->goal_ent = other;
	VectorSet (ent->mins, -16, -16, -16);
	VectorSet (ent->maxs,  16,  16,  16);

	AngleVectors (player->client->ps.viewangles, dir, NULL, NULL);
	VectorCopy (player->s.origin, start);
	start[2] += player->viewheight;
	VectorMA (start, 2048, dir, end);
	tr2 = gi.trace (start, ent->mins, ent->maxs, end, player, MASK_SOLID);

	ent->s.origin[0] = tr2.endpos[0];
	ent->s.origin[1] = tr2.endpos[1];
	ent->s.origin[2] = tr2.endpos[2];
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_NONE;
	ent->touch = AI_Destination_Ptr_Reached;
	ent->think = AI_Destination_Ptr_Expired;
	ent->nextthink = level.time + 15;	// Ten seconds to reach the point should be WAAAAAAY enough
	AI_Ent_droptofloor(ent);
	ent->cast_info.aiflags |= AI_GOAL_RUN; // used to be AI_GOAL_RUN
	if (spmod_debug->value) { gi.dprintf("%s at %s for %s (%s).\n", ent->classname, vtos(ent->s.origin), other->name, other->classname); }
	gi.linkentity (ent);
	return ent;
	}

// The player gave a "special order" (uh huuuunnn) and pointed to a locked door
// UPDATE: I'd like everyone to handle special orders (so we can ask 'em to move somewhere else or pick a weapon up)
// however, we also would like to keep that good old locksmith system.
void Wherever_CheckDoKey (edict_t *self, edict_t *ent)
{
	edict_t *sidekick;
	edict_t *dest;
	trace_t	tr;			// this stuff is used to check if the locksmith is on the right side of the door (vector)
	vec3_t	vec;
	float	dist;
	// --
	// CASE ONE: No entity found, move there
	// --
	if (!ent || !(ent->target2) || !strcmp(ent->classname, "worldspawn"))
		{
		sidekick = Wherever_GetChar(ORDER_SPECIAL_GOTO);
		if (!sidekick) { return; }	// No sidekick found, leave
		dest = AI_Destination_Ptr(self, sidekick);

		if (!(sidekick->goal_ent) || !(sidekick->enemy))
			{
			//sidekick->cast_info.aiflags &= ~AI_NOWALK_FACE;		// Remove "hold" (ai)
			//sidekick->cast_info.aiflags &= ~AI_HOLD_POSITION;	// Remove "hold" (ai)
			sidekick->goal_ent = dest;
			if (!strcmp(sidekick->classname, "cast_bitch"))
				sidekick->cast_info.currentmove = &bitch_move_hotspot;
			else if (!strcmp(sidekick->classname, "cast_whore"))
				sidekick->cast_info.currentmove = &whore_move_hotspot;
			else if (!strcmp(sidekick->classname, "cast_thug"))
				sidekick->cast_info.currentmove = &thug_move_hotspot;
			else if (!strcmp(sidekick->classname, "cast_punk"))
				sidekick->cast_info.currentmove = &punk_move_walk_dokey;
			else if (!strcmp(sidekick->classname, "cast_runt"))
				sidekick->cast_info.currentmove = &runt_move_walk_dokey;
			else if (!strcmp(sidekick->classname, "cast_shorty"))
				sidekick->cast_info.currentmove = &shorty_move_walk_dokey;
			}
		return;
		}
	// -- 
	// CASE TWO: Found an entity, can we unlock it?
	// --
	else
		{
		if (spmod_debug->value) { gi.dprintf("Pointed to: %s -- UNLOCK!\n", ent->classname); }
		sidekick = Wherever_GetChar(ORDER_SPECIAL_PICKTHELOCK);
		if (!sidekick) { return; }	// No sidekick found, leave
		if (ent->key == -1)	// The targeted entity has a Key =-1? Let's check for a tied ai_safespot
			{
			dest = G_Find (NULL, FOFS (targetname), ent->target2); // We're searching for an ai_safespot entity with the corresponding "target2"
			if (!dest) // Okay, no ai_safespot...
				{
				gi.dprintf ("No positioning target set for %s.\n", ent->classname);
				self->cast_info.aiflags &= ~AI_DOKEY;		// Cancel order
				sidekick->cast_info.aiflags &= ~AI_DOKEY;
				return;
				}
			// Let's make sure we're on the right side of the door (trace a vector between the locksmith and ai_safespot, if the door is in the way, cancel)
			tr = gi.trace(sidekick->s.origin, sidekick->mins, sidekick->maxs, dest->s.origin, sidekick, MASK_SOLID);
			if (tr.ent == ent) // the locked entity is between the locksmith and the ai_safepoint, we cannot unlock it from this side.
				{
				gi.dprintf("%s can't pick the lock from this side!\n", sidekick->name);
				self->cast_info.aiflags &= ~AI_DOKEY;;		// Cancel order
				sidekick->cast_info.aiflags &= ~AI_DOKEY;
				return;
				}
			if (!(sidekick->goal_ent) || !(sidekick->enemy))
				{
				if (visible (sidekick, dest))
					{
					VectorSubtract (sidekick->s.origin, dest->s.origin, vec);
					dist = VectorLength (vec);
					if (dist < 384)	// We're close enough!
						{
						sidekick->goal_ent = dest;
						self->cast_info.aiflags &= ~AI_DOKEY;
						sidekick->cast_info.aiflags &= ~AI_DOKEY;	// Remove "special order" flag
						if (!strcmp(sidekick->classname, "cast_bitch"))
							sidekick->cast_info.currentmove = &bitch_move_hotspot;
						else if (!strcmp(sidekick->classname, "cast_thug"))
							sidekick->cast_info.currentmove = &thug_move_hotspot;
						else if (!strcmp(sidekick->classname, "cast_runt"))
							sidekick->cast_info.currentmove = &runt_move_walk_dokey;
						sidekick->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
						sidekick->s.model_parts[PART_GUN2].invisible_objects = (1<<0 | 1<<1);
						}
					}
				}
			}
		}

	

}

// We reached the ai_safespot next to the door, let's start the unlock animation (DONE)
// DEBUG we might have a problem here for two-handed weapon characters (whore, punk & shorty)
void Wherever_ReachedDoKey (edict_t *self)
{
	vec3_t			vec;
	float			dist;
	VectorSubtract (self->s.origin, self->goal_ent->s.origin, vec);
	dist = VectorLength (vec);
	if (dist < 20)	// Are we close enough?
	{
		if (self->spawnflags & AI_SPAWNFLAG_LOCKSMITH)	// Checking that stuff AGAIN (for whatever reason, it was in Xatrix code -- that would be enough for me to get rid of it, but... oh well)
		{
			self->s.angles[YAW] = self->goal_ent->s.angles[YAW];	// Dirty, but M_ChangeYaw is killing me
			if (!strcmp(self->classname, "cast_bitch"))				// Show anim, at the end (coded in the animation itself), call Wherever_EndDoKey (via EP_DoKey)
				self->cast_info.currentmove = &bitch_move_crch_dokey;	// added in "ai_bitch_tables.h"
			else if (!strcmp(self->classname, "cast_thug"))
				self->cast_info.currentmove = &thug_move_crch_dokey;
			else if (!strcmp(self->classname, "cast_runt"))
				self->cast_info.currentmove = &runt_move_crch_dokey;
		}
	}
}

/*********************************************************************
		HINT AND CLUES -- Jan, 16th 2011

		New point entity: "target_register_epflag", allows you to
		add new entries to the log, within your map.
		Trigger the entity with your favourite trigger
		(door, buttons, touchplates, whatever).

		"noise"			Sound effect to play (opt.)
		"message"		Flagname as defined in EPLOGS.KPL

		Check EP_ALL.C, EP_ALL.H, G_SPAWNS.C for more info
*********************************************************************/

void Wherever_Player_Log (edict_t *self, int page)	// This sub is called when player displays the road book
{
	char		page_dsp[32];
	int			i, maxpages=0, nosound=0, ReadablePage[33];	// because there are 32 messages + default message

	Com_sprintf (game.helpmessage1, sizeof(game.helpmessage1), "");		//Reset helpmessage1
	Com_sprintf (game.helpmessage2, sizeof(game.helpmessage2), "");		//Reset helpmessage2

	if (NUM_WHEREVER_PLAYER_LOG)	// If we cannot find eplog.kpl, the game may crash trying to display non-existing logs.
	{
		// SEARCH FOR READABLE PAGES
		for (i=0; i<NUM_WHEREVER_PLAYER_LOG; i++)		// Browse ALL messages (both hidden and readable)
		{
			if ((self->client->pers.episode_flags & wherever_player_log[i].ep_flag) || wherever_player_log[i].ep_flag == 0)	// This message is readable
				{
				if (wherever_player_log[i].ep_text != "")	// just to make sure the text exists
					{
					ReadablePage[maxpages] = i;		// Every message that can be read is stored in this array
					maxpages++;						// Increasing maxpages counter by 1
					}
				}
		}

		the_log_page += page;	// "the_log_page" is the currently displayed message, "page" is -1, 0 or 1 (previous message, opening book, next message)
		if (the_log_page > maxpages-1) {the_log_page = maxpages-1; nosound=1;}	// upper bound of "ReadablePage" is maxpages-1 (because we start at 0), so the_log_page cannot excess maxpages-1
		if (the_log_page < 0) {the_log_page = 0; nosound=1;}

		if (page == 0) // we just opened the notebook, let's show last message written
		{
			for (i=0; i<=maxpages; i++)			// Search ALL entries
			{
				//gi.dprintf("Page#%i is %i\n",ReadablePage[i], wherever_player_log[ReadablePage[i]].new_clue);
				if (wherever_player_log[ReadablePage[i]].new_clue == true)	// Amongst all the readable messages, it's the first (and only) "new_clue" we have
					{
						the_log_page = i;	// Auto-select the_log_page: last clue we have
						break;				// Move on
					}
			}
		}
	
		strcpy (game.helpmessage1, " ");	// Reset helpmessage1 to " "
	
		if (wherever_player_log[ReadablePage[the_log_page]].new_clue)
			sprintf(page_dsp, "Page %i of %i\n New entry", the_log_page+1, maxpages);
		else
			sprintf(page_dsp, "Page %i of %i", the_log_page+1, maxpages);
		strcat (game.helpmessage1, page_dsp);
		strcat (game.helpmessage2, wherever_player_log[ReadablePage[the_log_page]].ep_text);
	}
	else	// There's no logs...
	{
		if (page) { nosound=1; }	// There's no page, unless we just opened the stuff, there should never be any "pageturn" sound
		strcpy (game.helpmessage1, " ");
		sprintf(page_dsp, "");
		strcat (game.helpmessage1, page_dsp);
		strcat (game.helpmessage2, " ");
	}

	if (!nosound)	// We're allowed to play the "page turn" sound since we actually moved a page
		gi.sound(self, CHAN_VOICE, gi.soundindex("world/pageturn.wav"), 1, ATTN_NONE, 0);
}

// This routine parse all log entries and replace every "new_clue" flag to FALSE, except for the asked log (identified with ep_flag)
// This way, we know if the previously added episode flag is a log entry or not.
// called by EP_Flash_Newflag, in EP_ALL.C
qboolean Wherever_Flash_Newflag (edict_t *self, int ep_flag)
{
	int i;
	qboolean gotone = false;

	for (i=0; i<=(NUM_WHEREVER_PLAYER_LOG); i++)
	{
		if (wherever_player_log[i].ep_flag == ep_flag)	// This entry use the flag we just added
		{
			wherever_player_log[i].new_clue = true;		// So this entry is brand new!
			gotone = true;								// Yep, we got a new entry
		}
		else
			wherever_player_log[i].new_clue = false;	// This entry is old news.
	}
	return (gotone);
}

// Add episode flag
void Use_target_register_epflag (edict_t *self, edict_t *other, edict_t *activator)
{
	int			i, k;
	edict_t		*player;
	player = &g_edicts[1];
	
	if (!(activator))		// must be activated
		return;

	for (i=0; i<=33; i++)		// Browse ALL flags
	{
		if (i == 33)
			{	gi.dprintf("%s: Flag %s undefined!\n", self->classname, self->name); break;	}
		else
			{
			if ((wherever_flags[i].flagval) && (!strcmp(wherever_flags[i].flagname,self->message)))	// Flag is not NULL and it's name match self->message
				{
				if (!(player->episode_flags & wherever_flags[i].flagval))									// If the flag is not yet part of the episode_flags...
					{																						// ...add it -- client_flags is used to know what pages of the log we can read.
					//gi.dprintf ("Registered EPFLAG %i\n", wherever_flags[i].flagval);
					player->episode_flags = player->client->pers.episode_flags |= wherever_flags[i].flagval;// -- episode_flags represent all the flags sets for the episode.
					if (self->noise_index)																	// If there's a precached sound,...
						gi.sound(player, CHAN_VOICE, self->noise_index, 1, ATTN_NORM, 0);					// ...Play it
					for (k=0; k<=33; k++)		// Browse ALL pages (wherever_flags and wherever_player_log are NOT the same thing)
						{
						if (wherever_player_log[k].ep_flag == wherever_flags[i].flagval)						// This page should do the trick let's make it new_clue
							{
							EP_Flash_Newflag (player, wherever_player_log[k].ep_flag);								// Let's display the road book icon
							break;
							}
						}
					}
				break;
				}
			}
	}
}


// target_register_epflag initialization
void SP_target_register_epflag (edict_t *ent)
{
	if (Wherever_Valid() == false)
		{
		gi.dprintf ("target_register_epflag cannot be used in episode %i!\n", level.episode);
		return; 
		}
	if (!ent->message)
		{
		gi.dprintf ("target_register_epflag without flag name at %s!\n", vtos(ent->s.origin));
		return;
		}
	if (st.noise != "")	// There's a sound, let's precache it
		ent->noise_index = gi.soundindex(st.noise);
	ent->use = Use_target_register_epflag;
	gi.linkentity (ent);
}


/*********************************************************************
		TRIGGER_OBSERVER
		Trigger this entity to start observing the player's actions.
		This entity will then fire all its targets if a condition is
		met, pretty much like rc_initiation_observer
		
		"Health_threshold"		Health threshold, use with spawnflag 4
		"Health_threshold2"		Health threshold, use with spawnflag 8
		"Style"					0=one of them is true, 1=all of them are true
		"Delay"					Wait between two checks

		Spawnflags:
		1		Made noise (using a gun without silencer)
		2		Has more (or equal) than health_threshold
		4		Has less (or equal) than health_threshold2
		8		Holding a weapon
		16		Weapon's holstered
		32		Reloads
		64		Holding a gun (non melee)
		128		Never auto-off
		256		Not in easy
		512		Not in normal
		1024	Not in hard
		2048	Not in deathmatch
		4096	Not in coop
*********************************************************************/


void trigger_observer_idle (edict_t *self)
{
	int		CountTrue=0, PerfectFlag;
	edict_t *player;
	player = &g_edicts[1];

	self->nextthink = level.time + self->delay;
	
	if ((self->spawnflags & 1)  && (player->client->gun_noise))
		{ CountTrue += 1; }
	if ((self->spawnflags & 2) && (player->health >= self->health_threshold))
		{ CountTrue += 2; }
	if ((self->spawnflags & 4) && (player->health <= self->health_threshold2))
		{ CountTrue += 4; }
	if ((self->spawnflags & 8) && (!(player->client->pers.holsteredweapon)))
		{ CountTrue += 8; }
	if ((self->spawnflags & 16) && (player->client->pers.holsteredweapon))
		{ CountTrue += 16; }
	if ((self->spawnflags & 32) && (player->client->reload_weapon))
		{ CountTrue += 32; }
	if (self->spawnflags & 64)
		{
		if (!strcmp(player->client->pers.weapon->pickup_name, "Pipe") || !strcmp(player->client->pers.weapon->pickup_name, "Crowbar"))
			{} // Do nothing
		else
			{ CountTrue += 64; }
		}
	
	if (CountTrue)
		{
		if (self->style == 1)
			{
			if (self->spawnflags & 128)
				PerfectFlag = self->spawnflags - 128;
			if (CountTrue == PerfectFlag)
				{ 
					if (!(self->spawnflags & 128))	{ self->nextthink = 0; }
				if (self->target) { G_UseTargets (self, player); }
				}
			}
		else
			{
			if (!(self->spawnflags & 128))	{ self->nextthink = 0; }
			if (self->target) { G_UseTargets (self, player); }
			}
		}
}

void trigger_observer_use (edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->nextthink)	// turn it off
		self->nextthink = 0;
	else					// turn it on
		trigger_observer_idle (self);
}

void SP_trigger_observer (edict_t *self)
{
	if (deathmatch->value)
		{ G_FreeEdict(self); return; }

	if (!(self->target))
		{ gi.dprintf("%s without targets at %s\n", self->classname, vtos(self->s.origin)); G_FreeEdict(self); return; }

	if (!(self->targetname))
		{ gi.dprintf("%s without targetname at %s\n", self->classname, vtos(self->s.origin)); G_FreeEdict(self); return; }
	
	if (!(self->delay))
		self->delay = 0.1;

	if (self->targetname)
		self->use = trigger_observer_use;

	self->think = trigger_observer_idle;

	//if (self->spawnflags & 128)
	//	self->nextthink = level.time + 1;	// long delay before first test: let's make sure everything is loaded already.

	gi.linkentity (self);
}

int SurfaceIs(edict_t *self, int SurfType)
{
	vec3_t		point;
	trace_t		trace2;
	
	point[0] =	self->s.origin[0];
	point[1] =	self->s.origin[1];
	point[2] =	self->s.origin[2]-1;
	trace2 =	gi.trace (self->s.origin, self->mins, self->maxs, point, self, MASK_PLAYERSOLID | MASK_MONSTERSOLID);	// Point to floor
	if (trace2.surface->flags & SurfType)	// Floor type is snow?
		return true;
	else
		return false;
}

/*
void FootPrint_Think(edict_t *self)
{
	self->s.effects += 5;
	if (self->s.effects >= 255)
		G_FreeEdict(self);
	else
		{
		self->nextthink = level.time + 0.01;
		self->think = FootPrint_Think;
		}
}

void FootPrint(vec3_t org, vec3_t dir)
{
	static vec3_t	mins = {-4, -4, 0};
	static vec3_t	maxs = { 4,  4, 4};
	vec3_t			end;
	trace_t			tr;
	edict_t			*ent;

	// Set entity
	ent = G_Spawn();
	ent->model = "models/props/misc/footprint.md2";
	gi.setmodel (ent, ent->model);
	VectorCopy (org, ent->s.origin);
	VectorCopy (dir, ent->s.angles);
	VectorSet (ent->mins, -4, -8, -1);
	VectorSet (ent->maxs,  4,  8,  1);
	ent->think = FootPrint_Think;
	ent->nextthink = level.time + 3;
	ent->movetype = MOVETYPE_NONE;

	ent->solid = SOLID_NOT;
	ent->s.renderfx2 = RF2_NOSHADOW | RF2_SURF_ALPHA | RF2_PASSALPHA;
	ent->s.effects = 1;

	tr = gi.trace(ent->s.origin, ent->mins, ent->maxs, end, ent, MASK_PLAYERSOLID | MASK_MONSTERSOLID );
	//VectorCopy (tr.endpos, ent->s.origin);
	VectorCopy (tr.plane.normal, ent->s.angles);


	// Adjust pitch
	AngleVectors(ent->s.angles, fwd, NULL, NULL);
	VectorMA(ent->s.origin, ent->maxs[0]-maxs[0], fwd, start );
	VectorCopy(start, end);
	end[2] += ent->mins[2] - 32;
	tr = gi.trace(start, mins, maxs, end, ent, MASK_PLAYERSOLID | MASK_MONSTERSOLID );
	VectorCopy(tr.endpos, p1);
	VectorMA(ent->s.origin, -(ent->maxs[0]-maxs[0]), fwd, start);
	VectorCopy( start, end );
	end[2] += ent->mins[2] - 32;

	tr = gi.trace( start, mins, maxs, end, ent, MASK_PLAYERSOLID | MASK_MONSTERSOLID );
	VectorCopy( tr.endpos, p2 );
	VectorSubtract( p1, p2, fwd );
	VectorNormalize( fwd );
	fwd[2] *= 0.25;
	vectoangles( fwd, angles );
	pitch_diff = AngleDiff( ent->s.angles[PITCH], angles[PITCH] );
	if (fabs(pitch_diff) > 180*FRAMETIME)
		if (pitch_diff > 0) { pitch_diff =  -180*FRAMETIME; } else { pitch_diff = 180*FRAMETIME; }
	ent->s.angles[PITCH] += pitch_diff;
	
	gi.linkentity(ent);
}*/

/*********************************************************************
		Footsteps, kinda dirty, but this fucker left me no choice!
*********************************************************************/
void ACC_FootSteps(edict_t *ent, char *usage, int maxval)
{
	char		Temp[128];
	char		Temp2[4];
	//vec3_t	FeetOrg;
	//vec3_t	FeetAng;
	trace_t		tr;
	vec3_t		start;

	ent->footsteptype = -1;	// Cancel footsteptype (it's an event number, see q_shared.h)
	ent->s.event = EV_NONE;	// Cancel s.event

	strcpy ((char*)Temp, "actors/player/step ");	// Base directory
	strcat ((char*)&Temp[0], (char*)usage);			// Include usage (for instance "snow/step")
	itoa(floor(random()*maxval)+1,Temp2, 10);			// Random number (1 to 4)
	strcat((char*)&Temp[0], (char*)Temp2);			// Add Temp2 to Temp
	strcat((char*)&Temp[0], (char*)".wav");		// Add ".wav" to Temp

	gi.positioned_sound (ent->s.origin, ent, CHAN_VOICE|CHAN_RELIABLE, gi.soundindex(Temp), 1.0, ATTN_NORM, 0);

	VectorCopy (ent->s.origin, start);
	start[2] += 128;

	tr = gi.trace (start, NULL, NULL, ent->s.origin, ent, MASK_PLAYERSOLID | MASK_MONSTERSOLID);
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SPLASH);
	gi.WriteByte (8);
	gi.WritePosition (tr.endpos);
	gi.WriteDir (tr.plane.normal);
	gi.WriteByte (SPLASH_BLUE_WATER);
	gi.multicast (tr.endpos, MULTICAST_PVS);
}
