#include "g_local.h"
#include "g_pawn.h"

qboolean Pickup_Pack (edict_t *ent, edict_t *other);

struct	PAWN_O_MATIC
	{
	edict_t		*item;
	char			*name;
	int				num_frames;
	} pawn_menu[MAX_MENU_ITEMS] = {
		// left piece
		{ NULL, "models/props/menu_mdx/select.mdx",			0 },
		{ NULL, "models/props/menu_mdx/selections.mdx",	0 },
		{ NULL, "models/props/menu_mdx/light2.mdx",			8 }, 
			
		// right piece
		{ NULL, "models/props/menu_mdx/frame.mdx",			0  },
		{ NULL, "models/props/menu_mdx/menu.mdx",				32 },
		{ NULL, "models/props/menu_mdx/light.mdx",			8  }, 
			
		{ NULL, "models/props/menu_mdx/number1.mdx",		39 },
		{ NULL, "models/props/menu_mdx/number2.mdx",		39 },
		{ NULL, "models/props/menu_mdx/number3.mdx",		39 },

		{ NULL, "models/props/menu_mdx/slot1.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot2.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot3.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot4.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot5.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot6.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot7.mdx",			32 },
		{ NULL, "models/props/menu_mdx/slot8.mdx",			32 }
	};

pawnshop_t pawnshop[8] =
	{
	{PAWN_WEAPONS,	{{ 50, 40,9, "Pistol"},				{150, 40,9, "Shotgun"},							{250, 40,9, "Tommygun"},			{750, 40,9, "Heavy machinegun"},		{200, 40,9, "Grenade Launcher"},	{350, 40,9, "Bazooka"},						{500, 40,9, "FlameThrower"},	{  0,  0,0, ""}}},
	{PAWN_MODS,			{{ 10,  0,2, "SPistol"},			{ 25,  2,2, "Pistol_Mods"},					{ 50,  4,2, "Pistol_Mods"},		{ 25,  6,2, "Pistol_Mods"},					{ 60, 40,9, "Pistol_Mods"},				{200, 10,2, "AShotgun"},					{ 50,  8,2, "Pistol_Mods"},		{300, 40,9, "Pistol_Mods"}}},
	{PAWN_AMMO,			{{  5, 12,2, "Bullets"},			{ 25, 14,2, "Shells"},							{ 70, 24,2, "Acid Shells"},		{ 20, 16,2, "308cal"},							{100, 18,2, "Grenades"},					{100, 20,2, "Rockets"},						{ 25, 22,2, "Gas"},						{400, 40,5, "Ammo Pack"}}},
	{PAWN_HEALTH,		{{ 25, 38,1, "Small Health"},	{ 50, 39,1, "Large Health"},				{150, 39,1, "Adrenaline"},		{  0,  0,0, ""},										{  0,  0,0, ""},									{  0,  0,0, ""},									{  0,  0,0, ""},							{  0,  0,0, ""}}},
	{PAWN_ARMOR,		{{100, 26,2, "Helmet Armor"},	{200, 28,2, "Helmet Armor Heavy"},	{150, 30,2, "Jacket Armor"},	{300, 32,2, "Jacket Armor Heavy"},	{100, 34,2, "Legs Armor"},				{200, 36,2, "Legs Armor Heavy"},	{  0,  0,0, ""},							{  0,  0,0, ""}}},
	{PAWN_BLANK,		{{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},									{  0,  0,0, ""},									{  0,  0,0, ""},							{  0,  0,0, ""}}},
	{PAWN_BLANK,		{{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},									{  0,  0,0, ""},									{  0,  0,0, ""},							{  0,  0,0, ""}}},
	{PAWN_EXIT,			{{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},							{  0,  0,0, ""},										{  0,  0,0, ""},									{  0,  0,0, ""},									{  0,  0,0, ""},							{  0,  0,0, ""}}},
	};

voice_table_t pawnomatic_alert[] = 
	{
	// Agreed (0, 1, 2 -- 3)
	{NULL, "It's all yours",  "It's all yours", "world/pawnomatic/sold1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "Here ya go",      "Here ya go",     "world/pawnomatic/sold2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "Sold",            "Sold",           "world/pawnomatic/sold3.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Canceled purchase (3, 4, 5 -- 3)
	{NULL, "Nah? How bout somethin else?",      "Nah? How bout somethin else?",       "world/pawnomatic/nothanks1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "Okay, find somethin else you like", "Okay, find somethin else you like",  "world/pawnomatic/nothanks2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "Nah?",                              "Nah?",                               "world/pawnomatic/nothanks3.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Can't use that mod (6, 7 -- 2)
	{NULL, "that mod ain't gonna do you any good unless you've got the gun to go with it", "that mod ain't gonna do you any good unless you've got the gun to go with it",  "world/pawnomatic/mod_nowork1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE},
	{NULL, "you gotta have the right piece for that thing... otherwise it's worthless",    "you gotta have the right piece for that thing... otherwise it's worthless",     "world/pawnomatic/mod_nowork2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	// Can't use that ammo (8, 9 -- 2)
	{NULL, "you can't use that kinda ammo...",                    "you can't use that kinda ammo...",                   "world/pawnomatic/stock_cantuse1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	{NULL, "that kinda ammo ain't gonna work for you right now",  "that kinda ammo ain't gonna work for you right now", "world/pawnomatic/stock_cantuse2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	// Don't have the cash (10, 11 -- 2)
	{NULL, "hey, you don't have enough cash...",  "hey, you don't have enough cash...", "world/pawnomatic/stock_cash1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	{NULL, "you ain't got enough money",          "you ain't got enough money",         "world/pawnomatic/stock_cash2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	// Out of stocks (12, 13 -- 2)
	{NULL, "I'm outta that",          "I'm outta that",           "world/pawnomatic/stock_out1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	{NULL, "sorry, we ain't got any", "sorry, we ain't got any",  "world/pawnomatic/stock_out2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	// Already got that (14, 15 -- 2)
	{NULL, "you already got that",                              "you already got that",                             "world/pawnomatic/alreadyhave1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE}, 
	{NULL, "hey, you don't need two... you already got one",    "hey, you don't need two... you already got one",   "world/pawnomatic/alreadyhave2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE},
	// Can't carry any more (16 -- 1)
	{NULL, "you're all full up... you can't hold any more",     "you're all full up... you can't hold any more",    "world/pawnomatic/fullup1.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE},
	// All patched up (17 -- 1)
	{NULL, "you don't need any more health... you're full up",  "you don't need any more health... you're full up", "world/pawnomatic/fullup2.wav", 0, {0,0,0,0,0},0, 0, TT_NEGATIVE},
	};

voice_table_t pawnomatic_in_and_out[] = {
	// Goodbye (0, 1 -- 2)
	{NULL, "come back anytime... thanks for shopping pawn-o-matic", "come back anytime... thanks for shopping pawn-o-matic",  "world/pawnomatic/leave1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "hey, Very nice to do business with you",                "hey, Very nice to do business with you",                 "world/pawnomatic/leave2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Funny (2, 6 -- 5)
	{NULL, "hey you're bleedin all over my floor",  "hey you're bleedin all over my floor", "world/pawnomatic/funny1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "hey we sell weapons, not body bags",    "hey we sell weapons, not body bags",   "world/pawnomatic/funny2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "man, who beat the shit outta you?",     "man, who beat the @*%$#! outta you?",  "world/pawnomatic/funny3.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "hey sorry we don't sell coffins",       "hey sorry we don't sell coffins",      "world/pawnomatic/funny4.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "hey, welcome to pawn-o-matic",          "hey, welcome to pawn-o-matic",         "world/pawnomatic/funny5.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE} ,
	// Request coil (7 -- 1)
	{NULL, "welcome to pawn-o-matic. I see you ain't got any heat. there's a condenser coil in the wearhouse around the corner... bring it to me and I'll give ya a pistol.", "welcome to pawn-o-matic. I see you ain't got any heat. there's a condenser coil in the wearhouse around the corner... bring it to me and I'll give ya a pistol.", "world/pawnomatic/coil1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Still no coil (8, 9 -- 2)
	{NULL, "what, you didn't bring me the coil?", "what, you didn't bring me the coil?",  "world/pawnomatic/coilno1.wav", 0, {0,0,0,0,0},0, 0, TT_QUESTION}, 
	{NULL, "Hey, you come back with no coil...",  "Hey, you come back with no coil...",   "world/pawnomatic/coilno2.wav", 0, {0,0,0,0,0},0, 0, TT_QUESTION}, 
	// Got coil (10, 11 -- 2)
	{NULL, "Alright, you brought me the coil! here ya go, one pistol and a clip... have fun killer",  "Alright, you brought me the coil! here ya go, one pistol and a clip... have fun killer", "world/pawnomatic/coilyes1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "Hey hey hey, da coil! one pistol and one clip... thank you very much",                    "Hey hey hey, da coil! one pistol and one clip... thank you very much",                   "world/pawnomatic/coilyes2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Notice coil (12 -- 1)
	{NULL, "whoa! a coil. tell you what... I'll trade you a pistol for it", "whoa! a coil. tell you what... I'll trade you a pistol for it", "world/pawnomatic/coil3.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Check on Louie (13, 14 -- 2)
	{NULL, "welcome to pawn-o-matic... Louie the warehouse boss is waitin to talk to ya", "welcome to pawn-o-matic... Louie the warehouse boss is waitin to talk to ya",  "world/pawnomatic/louie1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "so... you get the job from Louie in the warehouse?",                          "so... you get the job from Louie in the warehouse?",                           "world/pawnomatic/louie2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	};

voice_table_t pawnomatic_info[] = 
	{
	// Mod silencer (0, 1 -- 2)
	{NULL, "ahh silencer... very good when you're sneaking up on somebody", "ahh silencer... very good when you're sneaking up on somebody",  "world/pawnomatic/mod_silence1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "that'll quiet your pistol down a little bit",                   "that'll quiet your pistol down a little bit",                    "world/pawnomatic/mod_silence2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Mod rate of fire (2, 3 -- 2)
	{NULL, "the ROF, very nice mod... increase your rate of fire", "the ROF, very nice mod... increase your rate of fire",	"world/pawnomatic/mod_rof1.wav",			0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "that that ROF, you can Spit bullets out",	"that that ROF, you can Spit bullets out",	"world/pawnomatic/mod_rof2.wav",			0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Mod magnum (4, 5 -- 2)
	{NULL, "magnum mod, one of my favorites",	"magnum mod, one of my favorites",	"world/pawnomatic/mod_magnum1.wav",		0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "magnum mod, very good choice... great stoppin power",	"magnum mod, very good choice... great stoppin power",	"world/pawnomatic/mod_magnum2.wav",		0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Mod reload (6, 7 -- 2)
	{NULL, "pistol reload mod, very good choice... none of that fumblin around with a clip", "pistol reload mod, very good choice... none of that fumblin around with a clip",	"world/pawnomatic/mod_reload1.wav",		0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "the pistol reload mod... that would decrease your reloading time", "the pistol reload mod... that would decrease your reloading time",	"world/pawnomatic/mod_reload2.wav",		0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Mod cooling sleeves (8, 9 -- 2)
	{NULL, "Ooo hmg cooling mod very good option Boom Boom Boom", "Ooo hmg cooling mod very good option Boom Boom Boom",	"world/pawnomatic/mod_hmg1.wav",			0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "Ooo hmg cooling mod now thats a very nice number turn that baby nearly automatic for ya",	"Ooo hmg cooling mod now thats a very nice number turn that baby nearly automatic for ya",	"world/pawnomatic/mod_hmg2.wav",			0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Mod acid shotgun (10, 11 -- 2)
	{NULL, "oh very good mod, that'll let your shotgun accept the acid rounds",	"oh very good mod, that'll let your shotgun accept the acid rounds", "world/pawnomatic/mod_shotgun1.wav",	0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "this mod'll let you fire the acid rounds from your shotgun", "this mod'll let you fire the acid rounds from your shotgun", "world/pawnomatic/mod_shotgun2.wav",	0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Ammo bullets (12, 13 -- 2)
	{NULL, "alright, you wanna buy one box of bullets", "alright, you wanna buy one box of bullets", "world/pawnomatic/ammo_bullets1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "you wanna purchase one box of bullets... that it?", "you wanna purchase one box of bullets... that it?", "world/pawnomatic/ammo_bullets2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Ammo shells (14, 15 -- 2)
	{NULL, "you wanna buy a box of shells eh?", "you wanna buy a box of shells eh?", "world/pawnomatic/ammo_shotgun1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "shotgun shells... one box",  "shotgun shells... one box", "world/pawnomatic/ammo_shotgun2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Ammo 308 (16, 17 -- 2)
	{NULL, "308 ammo for that heavy machine gun... very deadly", "308 ammo for that heavy machine gun... very deadly", "world/pawnomatic/ammo_3081.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "with that 308 ammo you could stop an elephant", "with that 308 ammo you could stop an elephant", "world/pawnomatic/ammo_3082.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Ammo grenades (18, 19 -- 2)
	{NULL, "fragmentation grenades. very nasty and sold in groups of 5. you wanna buy em?", "fragmentation grenades. very nasty and sold in groups of 5. you wanna buy em?", "world/pawnomatic/ammo_frag1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "group of 5 fragmentation grenades... you want em?", "group of 5 fragmentation grenades... you want em?", "world/pawnomatic/ammo_frag2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Ammo rockets (20, 21 -- 2)
	{NULL, "rockets, 5 to a clip... what you expected an army?", "rockets, 5 to a clip... what you expected an army?", "world/pawnomatic/ammo_rockets1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "oooh rockets... very nasty",  "oooh rockets... very nasty", "world/pawnomatic/ammo_rockets2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Ammo gas (22, 23 -- 2)
	{NULL, "heh, you need gas? I got gas",  "heh, you need gas? I got gas", "world/pawnomatic/ammo_gas1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "gonna do a little touch up work eh? gas canisters", "gonna do a little touch up work eh? gas canisters", "world/pawnomatic/ammo_gas2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Ammo acid shells (24, 25 -- 2)
	{NULL, "a box of acid shells", "a box of acid shells", "world/pawnomatic/ammo_acid1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "acid shells, nasty...  You want a box?", "acid shells, nasty...  You want a box?", "world/pawnomatic/ammo_acid2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor head (26, 27 -- 2)
	{NULL, "head armor. very good idea... protect the old noggin eh?", "head armor. very good idea... protect the old noggin eh?", "world/pawnomatic/armor_head1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "head armor. very good for keeping your brain Inside your skull", "head armor. very good for keeping your brain Inside your skull", "world/pawnomatic/armor_head2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor head heavy (28, 29 -- 2)
	{NULL, "oooh, heavy head armor... expensive, but worth the price", "oooh, heavy head armor... expensive, but worth the price", "world/pawnomatic/armor_headh1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "heavy head armor... expensive, but worth every penny", "heavy head armor... expensive, but worth every penny", "world/pawnomatic/armor_headh2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor body (30, 31 -- 2)
	{NULL, "body armor. form fitting... very stylish", "body armor. form fitting... very stylish", "world/pawnomatic/armor_body1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "body armor... very stylish", "body armor... very stylish", "world/pawnomatic/armor_body2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor body heavy (32, 33 -- 2)
	{NULL, "hey, heavy body armor. maximum stopping power", "hey, heavy body armor. maximum stopping power", "world/pawnomatic/armor_bodyh1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "heavy body armor... that'll offer you maximum protection", "heavy body armor... that'll offer you maximum protection", "world/pawnomatic/armor_bodyh2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor lower body (34, 35 -- 2)
	{NULL, "lower body armor. very good for protecting the legs eh?", "lower body armor. very good for protecting the legs eh?", "world/pawnomatic/armor_leg1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "hey you wanna keep your kneecaps from gettin wacked... leg armor'll do the trick", "hey you wanna keep your kneecaps from gettin wacked... leg armor'll do the trick", "world/pawnomatic/armor_leg2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	// Armor lower body heavy (36, 37 -- 2)
	{NULL, "oh, heavy lower body armor. very tight fitting, but it'll protect those schnuts", "oh, heavy lower body armor. very tight fitting, but it'll protect those schnuts", "world/pawnomatic/armor_legh1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "heavy lower body armor... very stylish", "heavy lower body armor... very stylish", "world/pawnomatic/armor_legh2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Medkits (38, 39 -- 2)
	{NULL, "those medkits'll get you through some scrapes...", "those medkits'll get you through some scrapes...",	"world/pawnomatic/medkit1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "if you're really hurtin, that thing'll do you some good...", "if you're really hurtin, that thing'll do you some good...",	"world/pawnomatic/medkit2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	// Non-specific (40, 48 -- 9)
	{NULL, "very good choice", "very good choice", "world/pawnomatic/weapon1.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "nice selection", "nice selection", "world/pawnomatic/weapon5.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "that'll work", "that'll work", "world/pawnomatic/weapon6.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "awright", "awright", "world/pawnomatic/weapon9.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE},
	{NULL, "very good choice", "very good choice", "world/pawnomatic/weapon4.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "heh, my personal favorite", "heh, my personal favorite", "world/pawnomatic/weapon2.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "so you're gonna take this one...", "so you're gonna take this one...", "world/pawnomatic/weapon8.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "oh I like that one a lot", "oh I like that one a lot", "world/pawnomatic/weapon3.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	{NULL, "Boom! heh heh heh", "Boom! heh heh heh", "world/pawnomatic/weapon7.wav", 0, {0,0,0,0,0},0, 0, TT_POSITIVE}, 
	};

// Availability for each category. If an item (on the right) is available, then its bit flag is set.
// For instance, if the first value (weapon in the left menu) is 1 then the pistol is available,
// if it is 5 then both the pistol (1) and tommygun (4) are available.
void EP_PawnStocks (int store_id)
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			if (store_id == 1)
				PawnStockPredef(1, 22, 65, 7, 1);
			else
				PawnStockPredef(3, 31, 3, 7, 5);
			break;
		case EP_POISONVILLE:
			PawnStockPredef(3, 31, 35, 7, 21);
			break;
		case EP_SHIPYARDS:
			PawnStockPredef(71, 223, 11, 7, 21);
			break;
		case EP_STEELTOWN:
			PawnStockPredef(87, 191, 175, 7, 23);
			break;
		case EP_RADIOCITY:
		case EP_BARRENMEADOW:
			PawnStockPredef(127, 255, 255, 7, 63);
			break;
		default:
			PawnStockPredef(255, 255, 255, 255, 255);
			break;
		}
	}

/*QUAKED pawn_o_matic (1 .5 0) (-16 -64 -32) (16 64 32) 
*/

void Generic_Pawn_Think (edict_t *self)
	{
	int		i;

	for (i = 0; i < MAX_MENU_ITEMS; i++)
		{
		if (!pawn_menu[i].num_frames)
			continue;

		if (i == LEFT_LIGHT)
			{
			if (left_side)
				pawn_menu[i].item->s.frame = left_light_cnt;
			else 
				pawn_menu[i].item->s.frame = 0;
			}
		else if (i == RIGHT_LIGHT)
			{
			if (right_side)
				pawn_menu[i].item->s.frame = right_light_cnt;
			else
				pawn_menu[i].item->s.frame = 0;
			}
		else if (i == LOGO)
			{
			if (right_side)
				pawn_menu[i].item->s.frame = (left_light_cnt * 4);
			else
				pawn_menu[i].item->s.frame = 0;
			}
		else if (i >= SLOTS)
			{
			if (left_side)
				{
				pawn_menu[i].item->s.frame = 0;
				continue;
				}
			else if (!animate_right)
				continue;

			// Animate right pannel
			if (pawn_menu[i].item->s.frame == (left_light_cnt * 4))
				animate_right = false;
			else
				{
				pawn_menu[i].item->s.frame++;
				if (pawn_menu[i].item->s.frame > pawn_menu[i].num_frames)
					pawn_menu[i].item->s.frame = 0;
				gi.sound(pawn_menu[i].item, CHAN_VOICE, gi.soundindex("world/pawnomatic/counter.wav"), 1, ATTN_NORM, 0);
				}
			}

		else if (i >= NUM_START && i <= NUM_END && animate_numbers)
			{
			if (animate_hundreds || animate_tens || animate_ones)
				animate_numbers = true;
			else
				{
				animate_numbers = false;
				continue;
				}

			{
			int hundred, tens, ones;
			qboolean num_delay;

			hundred = item_price / 100;
			tens = (item_price - (hundred * 100)) / 10;
			ones = item_price - ((hundred * 100) + (tens * 10));

			num_delay = false;

				if (i == NUM_START)
					{
					if ( pawn_menu[i].item->s.frame == hundred * 4)
						{
						animate_hundreds = false;
						continue;
						}
					else
						{
						animate_hundreds = true;
						pawn_menu[i].item->s.frame = hundred * 4;
						if (pawn_menu[i].item->s.frame > pawn_menu[i].num_frames)
							pawn_menu[i].item->s.frame = 0;

						gi.sound(pawn_menu[i].item, CHAN_VOICE, gi.soundindex("world/pawnomatic/counter.wav"), 1, ATTN_NORM, 0);
						num_delay = true;
						}
					}
				else if (i == NUM_END)
					{
					if ( pawn_menu[i].item->s.frame == ones * 4)
						{
						qboolean animate_ones = false;
						continue;
						}
					else
						{
						animate_tens = true;
						pawn_menu[i].item->s.frame = ones * 4;
						if (pawn_menu[i].item->s.frame > pawn_menu[i].num_frames)
							pawn_menu[i].item->s.frame = 0;
						gi.sound(pawn_menu[i].item, CHAN_VOICE, gi.soundindex("world/pawnomatic/counter.wav"), 1, ATTN_NORM, 0);
						num_delay = true;
						}
					}
				else
					{
					if ( pawn_menu[i].item->s.frame == tens * 4)
						{
						animate_tens = false;
						continue;
						}
					else
						{
						animate_tens = true;
						pawn_menu[i].item->s.frame = tens * 4;
						if (pawn_menu[i].item->s.frame > pawn_menu[i].num_frames)
							pawn_menu[i].item->s.frame = 0;

						gi.sound(pawn_menu[i].item, CHAN_VOICE, gi.soundindex("world/pawnomatic/counter.wav"), 1, ATTN_NORM, 0);
						num_delay = true;
						}
					}

				if (num_delay)
					PawnSetTimeDelay (0.2);
				}
			}
		pawn_menu[0].item->nextthink = level.time + 0.1;
		}
	}

// Greetings. This replaces the original "Pawn_Greetings_Funny" and
// the standard greeting so Sharky's snark is back in all pawn-o-matics
// through the game. A tiny change has been made as of the frequency in
// which the funny lines are used over standard greeting (hearing the
// standard greeting every visit isn't bothering, but hearing health
// comments every time is a bit grindy).
void Pawn_Greetings()
	{
	int health, line;

	// standard welcome by default
	line = 4;
	health = g_edicts[1].health;

	// comment on health (more bruised = more likely to get a reaction)
	if ((random() * 100) < (100 - health))
		{
		if (health < 5)
			line = 3; // we don't sell coffins
		else if (health < 25)
			line = 1; // we sell weapons, not body bags
		else if (health < 50)
			line = 0; // you're bleedin' all over my floor
		else if (health < 75)
			line = 2; // who beat the shit outta you?
		}

	// say the line
	PawnSay (&pawnomatic_in_and_out[2 + line], 0);
	PawnSetTimeDelay (2);
	}

void Pawn_Greetings_Mission_PV (edict_t *ent)
	{
	edict_t	*player;

	ent->nextthink = level.time + 0.1;

	if (coil_think)
		return;

	if (!client_connected)
		return;

	player = &g_edicts[1];

	if (!(player->client->pers.episode_flags & EP_PV_PAWNOMATIC_FIRST_TIME))
		EP_Shared_Register_EPFLAG (player, EP_PV_PAWNOMATIC_FIRST_TIME);

	Pawn_Greetings();
	coil_think = true;
	PawnSetTimeDelay (2);
	}

//
// Trade condenser coil for a pistol (Skidrow)
//
void Pawn_Trade_Coil_For_Gun()
	{
	int			index;
	gitem_t	*item;
	edict_t	*player;
	edict_t	*GunIcon;

	// Get player
	player = &g_edicts[1];

	// Take away the coil
	player->client->pers.inventory[ITEM_INDEX(FindItem("Coil"))] = 0;

	// Give a gun if necessary
	item = FindItem("Pistol");
	index = ITEM_INDEX(item);
	if (!player->client->pers.inventory[index])
		{
		player->client->pers.inventory[index] = 1;
		player->client->newweapon = item;
		}

	// Always give 10 bullets
	index = ITEM_INDEX(FindItem("Bullets"));
	player->client->pers.inventory[index] += 10;
	if (player->client->pers.inventory[index] > player->client->pers.max_bullets)
		player->client->pers.inventory[index] = player->client->pers.max_bullets;

	// Delayed gun icon, appears after the shopkeeper says "here's your pistol"
	GunIcon = G_Spawn();
	if (GunIcon)
		{
		VectorCopy(player->s.origin, GunIcon->s.origin);
		gi.linkentity(GunIcon);
		GunIcon->think = Think_GunIcon;
		GunIcon->nextthink = level.time + 5.0;
		}
	}

//
// Ask for coil in Skidrow
//
void Pawn_Greetings_Mission_Skidrow (edict_t *ent)
	{
	edict_t	*player;
	int			indexCoil;

	ent->nextthink = level.time + 0.1;

	if (coil_think)
		return;

	if (!client_connected)
		return;

	player = &g_edicts[1];

	indexCoil = ITEM_INDEX(FindItem("Coil"));

	// If player has a gun, or is in the wrong shop
	if ((player->client->pers.inventory[ITEM_INDEX(FindItem("Pistol"))]) || (store_id != 1))
		{
		coil_think = true;

		// if the player got the coil anyway, we should do something here
		if (player->client->pers.inventory[indexCoil])
			{
			PawnSay(&pawnomatic_in_and_out[12], 0);
			PawnSetTimeDelay (6);
			Pawn_Trade_Coil_For_Gun();
			}

		// standard introduction
		else
			Pawn_Greetings();
		return;
		}

	// First time in pawn-o-matic
	if (!(player->client->pers.episode_flags & EP_SR_PAWNOMATIC_FIRST_TIME))
		{
		// Remember we've been there
		EP_Shared_Register_EPFLAG(player, EP_SR_PAWNOMATIC_FIRST_TIME);
		coil_think = true;

		// Player has the coil
		if (player->client->pers.inventory[indexCoil])
			{
			PawnSay(&pawnomatic_in_and_out[12], 0);
			PawnSetTimeDelay(6);
			Pawn_Trade_Coil_For_Gun();
			}

		// Player has no coil
		else
			{
			PawnSay (&pawnomatic_in_and_out[7], 0);
			PawnSetTimeDelay (9);
			}
		}

	// Return visit
	else 
		{
		coil_think = true;

		// Player has the coil
		if (player->client->pers.inventory[indexCoil])
			{
			PawnSay (&pawnomatic_in_and_out[10], 2);
			PawnSetTimeDelay(4);
			Pawn_Trade_Coil_For_Gun();
			}

		// Player has no coil
		else 
			{
			if (rand() % 2)
				{
				PawnSetTimeDelay(2.0);
				PawnSay (&pawnomatic_in_and_out[9], 0);
				}
			else
				{
				PawnSetTimeDelay(1.3);
				PawnSay (&pawnomatic_in_and_out[8], 0);
				}
			}
		}
	}

void generic_coil_think (edict_t *self)
	{
	edict_t *player;

	self->nextthink = level.time + 0.1;

	if (coil_think)
		return;

	if (!client_connected)
		return;

	player = &g_edicts[1];

	switch (level.episode)
		{
		case EP_SHIPYARDS:
			EP_Shared_Register_EPFLAG (player, EP_SY_PAWNOMATIC_FIRST_TIME);
			break;
		case EP_STEELTOWN:
			EP_Shared_Register_EPFLAG (player, EP_ST_PAWNOMATIC_FIRST_TIME);
			break;
		case EP_TRAINYARD:
			EP_Shared_Register_EPFLAG (player, EP_TY_PAWNOMATIC_FIRST_TIME);
			break;
		case EP_RADIOCITY:
			EP_Shared_Register_EPFLAG (player, EP_RC_PAWNOMATIC_FIRST_TIME);
			break;
		}

	// Fun fact: pawn keeper will always greet the player, even on returning visits. I don't know
	// if it was intended or not since each pawn has a "FIRST_TIME" episode flag associated... 
	// Xatrix also always used "PawnSay(pawnomatic_specific, 21)" to greet the player while they
	// should have been using Pawn_Greetings_Funny instead, since it branches toward a standard
	// greeting if the player is in good shape. There's also one instance where they used
	// "PawnSay(pawnomatic_funny, 4)", which is also the standard greeting... I guess they were
	// in a hurry and never cleaned up the code.
	Pawn_Greetings();
	PawnSetTimeDelay (2);
	coil_think = true;
	}

void EP_PawnMission  ()
	{
	edict_t *ent;

	ent = G_Spawn ();
	switch (level.episode)
		{
		case EP_SKIDROW:
			ent->think = Pawn_Greetings_Mission_Skidrow;
			break;
		case EP_POISONVILLE:
			ent->think = Pawn_Greetings_Mission_PV;
			break;
		default:
			ent->think = generic_coil_think;
			break;
		}

	ent->nextthink = level.time + 1.2;
	PawnSetTimeDelay (1.2);
	gi.linkentity (ent);
	}

void SP_pawn_o_matic (edict_t *self)
	{
	int		i, j;

	// Initialize pawn_o_matic interface
	for (i = 0; i < MAX_MENU_ITEMS; i++)
		{
		pawn_menu[i].item = G_Spawn();
		pawn_menu[i].item->classname = "pawn_o_matic";

		memset(&(pawn_menu[i].item->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

		pawn_menu[i].item->s.num_parts++;
		pawn_menu[i].item->s.model_parts[PART_HEAD].modelindex = gi.modelindex(pawn_menu[i].name);
		
		for (j = 0; j < MAX_MODELPART_OBJECTS; j++)
			pawn_menu[i].item->s.model_parts[PART_HEAD].skinnum[j] = pawn_menu[i].item->s.skinnum;
		
		gi.GetObjectBounds( pawn_menu[i].name, &pawn_menu[i].item->s.model_parts[PART_HEAD] );

		pawn_menu[i].item->movetype = MOVETYPE_NONE;

		VectorCopy (self->s.origin, pawn_menu[i].item->s.origin);
		VectorCopy (self->s.angles, pawn_menu[i].item->s.angles);

		if (!i)
			{
			pawn_menu[i].item->nextthink = level.time + 0.1;
			pawn_menu[i].item->think = Generic_Pawn_Think;
			}
		
		pawn_menu[i].item->s.renderfx2 |= RF2_NOSHADOW;
		
		pawn_menu[i].item->s.renderfx |= RF_FULLBRIGHT;

		gi.linkentity (pawn_menu[i].item);
		}

	// Reset global pawn vars
	left_side					= true;
	right_side				= false;
	left_light_cnt		= 1;
	right_light_cnt		= 0;
	animate_right			= false;
	animate_numbers		= false;
	level.pawn_time		= 1;
	VectorCopy (pawn_menu[0].item->s.origin, level.pawn_origin);
	animate_hundreds	= false;
	animate_tens			= false;
	animate_ones			= false;
	transaction				= false;
	current_pawn_item	= PAWN_WEAPONS;
	exit_the_level		= false;
	coil_think				= false;

	// Get pawn index (for Skidrow)
	if (!self->count)
		self->count = 1;
	store_id = self->count;

	PawnSetTimeDelay (0.5);

	EP_PawnStocks(store_id);

	EP_PawnMission();
	//SP_coil_Skidrow ();
	}	

// Display pickup icon on HUD
void PawnDisplayOnHud (char *name, float stay)
	{
	int     index;
	gitem_t *item;
	edict_t *player;

	// Catch player
	player = &g_edicts[1];

	// Catch item
	item = FindItem(name);
	index = ITEM_INDEX(item);

	// show icon and name on status bar			
	player->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
	player->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS + index;
	player->client->pickup_msg_time = level.time + stay;
	}

// Delayed gun icon
void Think_GunIcon (edict_t *self)
	{
	PawnDisplayOnHud("Pistol", 5.5);
	self->nextthink = level.time + 6.0;
	self->think = G_FreeEdict;
	}

void PawnGiveItem (edict_t *ent)
	{
	int			index;
	int			pawn_item_index;
	int			giveCnt;
	int			giveMax;
	gitem_t	*item;
	pawnstocks_t *stock;

	pawn_item_index = right_light_cnt - 1;
	stock = &pawnshop[current_pawn_item].stock[pawn_item_index];

	switch (current_pawn_item)
		{

		/*** Buying a weapon ***/
		case PAWN_WEAPONS:
			item = FindItem(stock->name);
			index = ITEM_INDEX(item);
			ent->client->pers.inventory[index] = 1;
			ent->client->newweapon = item;
			PawnDisplayOnHud(item->pickup_name, 2.0);
			item = FindItem(item->ammo);
			index = ITEM_INDEX(item);

			// give ammo for selected weapon
			switch (pawn_item_index)
				{
				case 0: // pistol
					giveCnt = 10;
					giveMax = ent->client->pers.max_bullets;
					break;
				case 1: // shotgun
					giveCnt = 10;
					giveMax = ent->client->pers.max_shells;
					break;
				case 2: // tommygun
					giveCnt = 50;
					giveMax = ent->client->pers.max_bullets;
					break;
				case 3: // hmg
					giveCnt = 30;
					giveMax = ent->client->pers.max_308cal;
					break;
				case 4: // grenade launcher
					giveCnt = 3;
					giveMax = ent->client->pers.max_grenades;
					break;
				case 5: // rocket launcher
					giveCnt = 5;
					giveMax = ent->client->pers.max_rockets;
					break;
				case 6: // flamethrower
					giveCnt = 100;
					giveMax = ent->client->pers.max_gas;
					break;
				}

			//Add_Ammo(ent, item, giveCnt /*item->quantity*/);

			ent->client->pers.inventory[index] += giveCnt;
			if (ent->client->pers.inventory[index] > giveMax)
				ent->client->pers.inventory[index] = giveMax;
			break;

		/*** Buying a weapon modification ***/
		case PAWN_MODS:
			item = FindItem(stock->name);
			index = ITEM_INDEX(item);
			switch (pawn_item_index)
				{
				case 0: // silencer
					ent->client->pers.inventory[index] = 1;
					ent->client->newweapon = item;
					ent->client->pers.silencer_shots = NUM_SILENCER_SHOTS;
					break;
				case 1: // rate of fire
					ent->client->pers.pistol_mods |= WEAPON_MOD_ROF;
					item->icon = "/pics/h_pistol_rof.tga";
					break;
				case 2: // magnum
					ent->client->pers.pistol_mods |= WEAPON_MOD_DAMAGE;
					item->icon = "/pics/h_pistol_mag.tga";
					break;
				case 3: // reload
					ent->client->pers.pistol_mods |= WEAPON_MOD_RELOAD;
					item->icon = "/pics/h_pistol_rl.tga";
					break;
				case 4: // ACC, new: accuracy for pistol
					ent->client->pers.pistol_mods |= WEAPON_MOD_ACCURACY;
					item->icon = "/pics/h_pistol_acc.tga";
					break;
				case 5: // python
					ent->client->pers.inventory[index] = 1;
					ent->client->newweapon = item;
					break;
				case 6: // cooling jacket
					ent->client->pers.pistol_mods |= WEAPON_MOD_COOLING_JACKET;
					item->icon = "/pics/h_heavymachinegun_cooling.tga";
					break;
				case 7: // slowburn
					ent->client->pers.pistol_mods |= WEAPON_MOD_SLOWBURN;
					item->icon = "/pics/h_flamet_sburn.tga";
					break;
				}
			PawnDisplayOnHud(item->pickup_name, 2.0);
			break;

		/*** Buying ammunition ***/
		case PAWN_AMMO:
			item = FindItem(stock->name);
			index = ITEM_INDEX(item);
			PawnDisplayOnHud(item->pickup_name, 2.0);
			if (pawn_item_index == 7)      // Backpack
				{
				edict_t *pack;

				pack = G_Spawn();
				pack->count = 1; // only increase pocket size
				gi.linkentity(pack);
				Pickup_Pack(pack, ent);
				G_FreeEdict(ent);
				}
			else // all slots are used, so if it's not 7, it's 0 thru 6
				{
				switch (pawn_item_index)
					{
					case 0: // bullets
						giveCnt = item->quantity / 2;
						giveMax = ent->client->pers.max_bullets;
						break;
					case 1: // Shells
						giveCnt = item->quantity / 2;
						giveMax = ent->client->pers.max_shells;
						break;
					case 2: // Acid Shells
						giveCnt = item->quantity;
						giveMax = ent->client->pers.max_acidshells;
						break;
					case 3: // 308cal
						giveCnt = item->quantity;
						giveMax = ent->client->pers.max_308cal;
						break;
					case 4: // Grenades
						giveCnt = item->quantity;
						giveMax = ent->client->pers.max_grenades;
						break;
					case 5: // Rockets
						giveCnt = item->quantity;
						giveMax = ent->client->pers.max_rockets;
						break;
					case 6: // Gas
						giveCnt = item->quantity * 2;
						giveMax = ent->client->pers.max_gas;
						break;
					}
				ent->client->pers.inventory[index] += giveCnt;
				if (ent->client->pers.inventory[index] > giveMax)
					ent->client->pers.inventory[index] = giveMax;
				}
			break;

		/*** Buying health ***/
		case PAWN_HEALTH:
			switch (pawn_item_index)
				{
				case 0:
					ent->health += 10;
					break;
				case 1:
					ent->health += 25;
					break;
				case 2:
					ent->health += 100;
					break;
				}
			if (ent->health > ent->max_health)
				ent->health = ent->max_health;
			PawnDisplayOnHud(stock->name, 5.5);
			break;

		/*** Buying armor ***/
		case PAWN_ARMOR:
			Check_Buy_Armor(ent, false);
			item = FindItem(stock->name);
			index = ITEM_INDEX(item);

			PawnDisplayOnHud(item->pickup_name, 2.0);
			break;
		}
	}

void PawnItemPrice (int item)
	{
	current_pawn_item = item - 1;
	item_price = pawnshop[current_pawn_item].stock[right_light_cnt - 1].price;
	}

void PawnStockPredef(int fWeapon, int fMods, int fAmmo, int fHealth, int fArmor/*, int fImplants*/)
	{
	pawnshop[PAWN_WEAPONS].availability = fWeapon;
	pawnshop[PAWN_MODS].availability = fMods;
	pawnshop[PAWN_AMMO].availability = fAmmo;
	pawnshop[PAWN_HEALTH].availability = fHealth;
	pawnshop[PAWN_ARMOR].availability = fArmor;
	}

void PawnSay(voice_table_t *voice_table, int numEntries)
	{
	edict_t *dude = NULL;
	edict_t *player;
	int i, oldest = 0;

	// get vendor and player
	dude = G_Find (NULL, FOFS (classname), "cast_runt");
	if (!dude)
		gi.dprintf ("this pawnomatic does not have a correct vendor\n");
	player = &g_edicts[1];

	// ACC, pick a random sentence from the list. If no line has been used yet,
	// we'll keep that one. If there's another line available that hasn't
	// been used as recently, pick that one instead.
	if (numEntries)
		{
		oldest = rand() % numEntries;
		for (i = 0; i < numEntries; i++)
			{
			if (voice_table[i].last_played < voice_table[oldest].last_played)
				oldest = i;
			}
		}
	gi.sound(dude, CHAN_VOICE, gi.soundindex (voice_table[oldest].filename), 1, ATTN_NORM, 0);
	
	// ACC, profanity filters weren't enabled for pawn-o-matics
	if (cl_captions->value)
		{
		if ( (cl_parental_lock->value) && (!cl_parental_override->value) && (voice_table[oldest].text2) )
			gi.dprintf ("Sharky: %s\n", voice_table[oldest].text2);
		else
			gi.dprintf ("Sharky: %s\n", voice_table[oldest].text);
		}

	// display head icon, keep track of the last time we used that line
	player->client->ps.stats[STAT_HUD_ENEMY_TALK] = voice_table[oldest].type;
	player->client->hud_enemy_talk_time = level.time + 2.0;
	voice_table[oldest].last_played = level.time;
	}

//
// Player is interested in an item, check if it makes sense to buy it, provide description
//
qboolean PawnItemPriceSay()
	{
	edict_t		*player;
	int				pawn_item_index;
	int				id;
	gitem_t		*it;
	int				maxCarry;
	int				canUse;
	pawnstocks_t *stock;

	pawn_item_index = right_light_cnt - 1;
	player = &g_edicts[1];
	stock = &pawnshop[current_pawn_item].stock[pawn_item_index];

	// Cancel if the item has no price
	if (!stock->price)
		return false;

	// Check if the item is available
	if (((!(pawnshop[current_pawn_item].availability & (1 << pawn_item_index)))) /*&& (!(player->flags & FL_PAWNFREAK))*/) // If FL_PAWNFREAK is on, allow all items to be purchased
		{
		PawnSay (&pawnomatic_alert[12], 2); // out of stock
		return false;
		}

	switch (current_pawn_item)
		{

		/*** Attempts to buy weapon modification ***/
		case PAWN_MODS:
			// Warning: must own the proper weapon
			if (
				(((pawn_item_index >= 0) && (pawn_item_index <= 4)) && (!player->client->pers.inventory[ITEM_INDEX(FindItem("Pistol"))])) ||
				((pawn_item_index == 5) && (!player->client->pers.inventory[ITEM_INDEX(FindItem("Shotgun"))])) ||
				((pawn_item_index == 6) && (!player->client->pers.inventory[ITEM_INDEX(FindItem("Heavy machinegun"))])) ||
				((pawn_item_index == 7) && (!player->client->pers.inventory[ITEM_INDEX(FindItem("FlameThrower"))]))
				)
				{
					PawnSay (&pawnomatic_alert[6], 2); // can't use that mod yet
					return false;
				}
			// Warning: mustn't own the mod already
			if (((pawn_item_index == 0) && (player->client->pers.inventory[ITEM_INDEX(FindItem("SPistol"))]))
				|| ((pawn_item_index == 1) && (player->client->pers.pistol_mods & WEAPON_MOD_ROF))
				|| ((pawn_item_index == 2) && (player->client->pers.pistol_mods & WEAPON_MOD_DAMAGE))
				|| ((pawn_item_index == 3) && (player->client->pers.pistol_mods & WEAPON_MOD_RELOAD))
				|| ((pawn_item_index == 4) && (player->client->pers.pistol_mods & WEAPON_MOD_ACCURACY))
				|| ((pawn_item_index == 5) && (player->client->pers.inventory[ITEM_INDEX(FindItem("AShotgun"))]))
				|| ((pawn_item_index == 6) && (player->client->pers.pistol_mods & WEAPON_MOD_COOLING_JACKET))
				|| ((pawn_item_index == 7) && (player->client->pers.pistol_mods & WEAPON_MOD_SLOWBURN))
				)
				{
				PawnSay (&pawnomatic_alert[14], 2); // already got that
				return false;
				}
			break;

		/*** Attempts to buy ammo ***/
		case PAWN_AMMO:
			// Warning: already have a backpack
			if (pawn_item_index == 7)
				{
				if (player->client->pers.max_bullets >= 300) // don't test it all
				/*if (player->client->pers.max_bullets >= 300 && player->client->pers.max_shells == 200 && player->client->pers.max_rockets == 100 &&
					player->client->pers.max_grenades == 15 && player->client->pers.max_gas == 300 && player->client->pers.max_308cal == 120 && player->client->pers.max_acidshells == 40)*/
					{
					PawnSay (&pawnomatic_alert[14], 2); // already got that
					return false;
					}
				}
			else
				{
				it = FindItem(stock->name);
				id = ITEM_INDEX(it);
				if (pawn_item_index == 0)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("Pistol"))] || player->client->pers.inventory[ITEM_INDEX(FindItem("Tommygun"))];
					maxCarry = player->client->pers.max_bullets;
					}
				else if (pawn_item_index == 1)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("Shotgun"))];
					maxCarry = player->client->pers.max_shells;
					}
				else if (pawn_item_index == 2)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("AShotgun"))];
					maxCarry = player->client->pers.max_acidshells;
					}
				else if (pawn_item_index == 3)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("Heavy machinegun"))];
					maxCarry = player->client->pers.max_308cal;
					}
				else if (pawn_item_index == 4)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("Grenade Launcher"))];
					maxCarry = player->client->pers.max_grenades;
					}
				else if (pawn_item_index == 5)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("Bazooka"))];
					maxCarry = player->client->pers.max_rockets;
					}
				else if (pawn_item_index == 6)
					{
					canUse = player->client->pers.inventory[ITEM_INDEX(FindItem("FlameThrower"))];
					maxCarry = player->client->pers.max_gas;
					}
				if (!canUse)
					{
					PawnSay (&pawnomatic_alert[8], 2); // can't use that kind of ammo
					return false;
					}
				if (player->client->pers.inventory[id] >= maxCarry)
					{
					PawnSay (&pawnomatic_alert[16], 0); // can't carry any more
					return false;
					}
				}
			break;

		/*** Attempts to buy weapons ***/
		case PAWN_WEAPONS:
			it = FindItem(stock->name);
			id = ITEM_INDEX(it);

			// Warning: musn't be owned already
			if (player->client->pers.inventory [id])
				{
				PawnSay (&pawnomatic_alert[14], 2); // already got that
				return false;
				}
			break;

		/*** Attempts to buy health ***/
		case PAWN_HEALTH:
			// Warning: must be wounded
			if (player->health == player->max_health)
				{
				PawnSay(&pawnomatic_alert[17], 0); // you don't need health
				return false;
				}
			break;

		/*** Attempts to buy armor ***/
		case PAWN_ARMOR:
			// Warning: musn't be maxed out
			if (!Check_Buy_Armor (player, true))
				{
				PawnSay (&pawnomatic_alert[14], 0);  // I only play the first "don't have it" because the second implies you don't need two.  with armor, you might
				return false;
				}
			break;
		}
	// Give description
	PawnSay (&pawnomatic_info[stock->comment], stock->numComments);
	return true;
	}

//
// Move up and down in any menu (see g_cmds.c)
//
void PawnCycle (edict_t *ent, int dir)
	{
	int old_right_light_cnt;

	if (!PawnGetTime())
		return;

	PawnSetTimeDelay (0.2);
	gi.sound(ent, CHAN_VOICE, gi.soundindex("world/pawnomatic/menu.wav"), 1, ATTN_NORM, 0);
	old_right_light_cnt = right_light_cnt;

	if (left_side)
		{
		left_light_cnt += dir;
		if (left_light_cnt > pawn_menu[LEFT_LIGHT].num_frames)
			left_light_cnt = 1;
		else if (left_light_cnt < 1)
			left_light_cnt = pawn_menu[LEFT_LIGHT].num_frames;
		}
	else
		{
		right_light_cnt += dir;
		if (right_light_cnt > pawn_menu[RIGHT_LIGHT].num_frames)
			right_light_cnt = 1;
		else if (right_light_cnt < 1)
			right_light_cnt = pawn_menu[RIGHT_LIGHT].num_frames;
		}

	if (old_right_light_cnt != right_light_cnt)
		{
		animate_hundreds = animate_tens = animate_ones = animate_numbers = true;
		PawnItemPrice (left_light_cnt);
		}

	if (transaction)
		{
		transaction = false;
		PawnSay (&pawnomatic_alert[3], 3); // nah
		}
	}

// ACC, commit to exit pawn-o-matic, no last-ditch cancel
void ThinkerPawnLevelPrevious (edict_t *ent)
	{
	edict_t *owner;

	owner = ent->owner;
	G_FreeEdict( ent );

	PawnLevelPrevious (owner);
	}

void PawnBuy (edict_t *ent)
	{
	if (!PawnGetTime())
		return;

	if (!exit_the_level)
		PawnSetTimeDelay (0.2);

	// Skip blanks
	if (left_side && (pawnshop[left_light_cnt - 1].availability == PAWN_BLANK))
		return;

	gi.sound(ent, CHAN_VOICE, gi.soundindex("world/pawnomatic/menu.wav"), 1, ATTN_NORM, 0);

	if (pawnshop[left_light_cnt - 1].availability == PAWN_EXIT)
		{
		if (exit_the_level) // We already said we were going to exit, "fast" exit if you press it again
			PawnLevelPrevious (ent);
		else // Shop keeper goodbye
			{
			edict_t *thinker;

			PawnSetTimeDelay (2.0);
			PawnSay (&pawnomatic_in_and_out[0], 0); // there's a secondary exit line, but it's not great
			exit_the_level = true;

			thinker = G_Spawn();
			thinker->owner = ent;
			thinker->nextthink = level.time + 3.5;
			thinker->think = ThinkerPawnLevelPrevious;
			}
		return;
		}

	// We may purchase something
	if (right_side && !transaction)
		{
		PawnItemPrice (left_light_cnt);
		transaction = PawnItemPriceSay();
		if (transaction)
			gi.dprintf ("So do we have a deal?\n");
		}

	// Switch to RIGHT pannel (items)
	else if (left_side && !exit_the_level)
		{
		right_side = true;
		left_side = false;
		right_light_cnt = 1;
		animate_right = true;
		animate_hundreds = animate_tens = animate_ones = animate_numbers = true;
		PawnItemPrice (left_light_cnt);
		}

	// Do transaction
	else if (transaction)
		PawnAgree (ent);
	}

// Move to right pannel (see g_cmds.c)
void PawnRight (edict_t *ent)
	{
	if (!PawnGetTime())
		return;

	PawnSetTimeDelay (0.2);

	// Skip blanks
	if (left_side && ((pawnshop[left_light_cnt - 1].availability == PAWN_BLANK) || (pawnshop[left_light_cnt - 1].availability == PAWN_EXIT)))
		return;

	// Already on the right side
	if (right_side)
		return;

	gi.sound(ent, CHAN_VOICE, gi.soundindex("world/pawnomatic/menu.wav"), 1, ATTN_NORM, 0);

	right_side = true;
	left_side = false;
	right_light_cnt = 1;
	animate_right = true;
	animate_hundreds = animate_tens = animate_ones = animate_numbers = true;
	PawnItemPrice (left_light_cnt);

	if (transaction)
		{
		transaction = false;
		PawnSay (&pawnomatic_alert[3], 3); // nah
		}
	}

// Move to left pannel (see g_cmds.c)
void PawnLeft (edict_t *ent)
	{
	if (!PawnGetTime())
		return;

	PawnSetTimeDelay (0.2);

	gi.sound(ent, CHAN_VOICE, gi.soundindex("world/pawnomatic/menu.wav"), 1, ATTN_NORM, 0);

	right_side = false;
	left_side = true;

	if (transaction)
		{
		transaction = false;
		PawnSay (&pawnomatic_alert[3], 3); // nah
		}
	}

// Confirm purchase
void PawnAgree (edict_t *ent)
	{
	if (!PawnGetTime() && !transaction)
		return;

	PawnSetTimeDelay (0.2);

	if (transaction)
		transaction = false;
	else
		{
		gi.dprintf ("yo select something first\n");
		return;
		}

	if (ent->client->pers.currentcash >= item_price)
		{
		PawnSay (&pawnomatic_alert[0], 3); // it's all yours
		ent->client->pers.currentcash -= item_price;
		PawnGiveItem (ent);
		}
	else
		PawnSay (&pawnomatic_alert[10], 2); // no enough cash
	}

// Cancel purchase (see g_cmds.c)
void PawnDisagree (edict_t *ent)
	{
	if (!PawnGetTime())
		return;

	PawnSetTimeDelay (0.2);

	transaction = false;
	PawnSay (&pawnomatic_alert[3], 3); // nah
	}

void PawnSetTimeDelay (float delay)
	{
	generic_time = level.time + delay;
	exit_the_level = false;
	}

qboolean PawnGetTime (void)
	{
	return (generic_time < level.time);
	}

// Exit pawn-o-matic
void PawnLevelPrevious (edict_t *ent)
	{
	edict_t *lvl;
	edict_t *player;

	player = &g_edicts[1];

	lvl = G_Find (ent, FOFS (classname), "trigger_multiple");

	if (lvl)
		lvl->touch( lvl, player, NULL, NULL );
	else
		gi.dprintf ("error\n");

	level.pawn_time = 0;
	}


qboolean Check_Buy_Armor (edict_t *player, qboolean check)
	{
	int			pawn_item_index;
	gitem_t *iteml, *itemlh;

	pawn_item_index = right_light_cnt - 1;

	if (!(pawn_item_index & 1)) // 0, 2, 4
		{
		if (pawn_item_index == 0)
			{
			iteml = FindItem("Helmet Armor");
			itemlh = FindItem("Helmet Armor Heavy");
			}
		else if (pawn_item_index == 2)
			{
			iteml = FindItem("Jacket Armor");
			itemlh = FindItem("Jacket Armor Heavy");
			}
		else if (pawn_item_index == 4)
			{
			iteml = FindItem("Legs Armor");
			itemlh = FindItem("Legs Armor Heavy");	
			}

		if ((player->client->pers.inventory[ITEM_INDEX(iteml)] == 100) || (player->client->pers.inventory[ITEM_INDEX(itemlh)] == 100))
			return false;
		else if (check)
			return true;

		if (player->client->pers.inventory[ITEM_INDEX(itemlh)])
			{
			player->client->pers.inventory[ITEM_INDEX(itemlh)] += 25;
			if (player->client->pers.inventory[ITEM_INDEX(itemlh)] > 100)
				player->client->pers.inventory[ITEM_INDEX(itemlh)] = 100;
			}
		else
			{
			player->client->pers.inventory[ITEM_INDEX(iteml)] += 50;
			if (player->client->pers.inventory[ITEM_INDEX(iteml)] > 100)
				player->client->pers.inventory[ITEM_INDEX(iteml)] = 100;
			}
		}
	else // 1, 3, 5
		{
		if (pawn_item_index == 1)
			{
			iteml = FindItem("Helmet Armor");
			itemlh = FindItem("Helmet Armor Heavy");
			}
		else if (pawn_item_index == 3)
			{
			iteml = FindItem("Jacket Armor");
			itemlh = FindItem("Jacket Armor Heavy");
			}
		else if (pawn_item_index == 5)
			{
			iteml = FindItem("Legs Armor");
			itemlh = FindItem("Legs Armor Heavy");	
			}

		if (player->client->pers.inventory[ITEM_INDEX(itemlh)] == 100)
			return false;
		else if (check)
			return true;
		
		if (player->client->pers.inventory[ITEM_INDEX(iteml)])
			player->client->pers.inventory[ITEM_INDEX(iteml)] = 0;

		player->client->pers.inventory[ITEM_INDEX(itemlh)] = 100;
		}

	return true;
	}