//.pcx -> .wal converter by Trey Harrison
//NOTE THE FOLLOWING!!
//after you compile this, copy q2pal.dat to the end of the
//executable file (thats where the palette is read from)
//ex.  copy /b pcx2wal.exe+q2pal.dat pcx2wal.exe
//trey@crack.com


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

unsigned char pcx_pal[768];
unsigned char quake2_pal[768];
int adapt = 0; //adapt to the quake 2 palette?
int argc;
char **argv;

void load_quake_palette();
void remove_extention(char *string);
void write_mip(FILE *f,unsigned char *base_mip, int base_width, int base_height, int miplevel);
unsigned char average_pixels(unsigned char *src, int miplevel,int bytesperline);

int main(int arg_count, char **arg_strings)
{
  argc = arg_count;
  argv = arg_strings;

  FILE *f;
  int   i,j;

  char  walname[32];
  int   mip1_offs,mip2_offs,mip3_offs,mip4_offs;  
  int   width,height;
  short w,h;
  int   mipsize;
  int   fname_num=1;
  int   dont_adapt=0;

  unsigned char *mip=0;
  unsigned char cur_byte;
  int run_len;
  
  if (argc<2)
  {
    printf("Must specify the .pcx file\n");
    exit(-1);
  }  
  
  if (argc==3)
  {
    if (!stricmp(argv[2],"-noadapt"))
    {
      dont_adapt=1;
      fname_num=1;
    }

    if (!stricmp(argv[1],"-noadapt"))
    {
      dont_adapt=1;
      fname_num=2;
    }
  }

  f = fopen(argv[fname_num],"rb");
  if (!f)
  {
    printf("Invalid .pcx name\n");
    exit(-1);
  }

  remove_extention(argv[fname_num]);

	fseek(f,8,SEEK_SET);        
	fread(&w,sizeof(short),1,f);
	fread(&h,sizeof(short),1,f);
  width  = w+1;
  height = h+1;
    
  mipsize = width*height;
	
  mip = new unsigned char[mipsize];
	
	fseek(f,128,SEEK_SET);
	j = 0;
  //decoding loop type thing
	
	while(j < mipsize)
  {
		cur_byte = fgetc(f);
		if((cur_byte & 0xC0) == 0xC0)
    {
			run_len = cur_byte & 0x3F;
			cur_byte = fgetc(f);
			for( ;(run_len>0) && (j<mipsize); run_len--, j++)
      {
				mip[j] = cur_byte;
			}
		}
    else
    {
			mip[j] = cur_byte;
			j++;
		}
	}
	
	fseek(f,-768,SEEK_END);
  fread(pcx_pal,768,1,f);

  fclose(f);
  
  if (!dont_adapt)
    load_quake_palette();

  strcpy(walname,argv[fname_num]);
  strcat(walname,".wal");

  f = fopen(walname,"wb");
  if (!f)
  {
    printf("Invalid .wal name: %s\n",walname);
    exit(-1);
  }

  mip1_offs = 100;
  mip2_offs = mip1_offs + mipsize;
  mip3_offs = mip2_offs + mipsize/4;
  mip4_offs = mip3_offs + mipsize/16;

  remove_extention(walname);
  fwrite(walname,32,1,f);

  fwrite(&width,1,sizeof(int),f);
  fwrite(&height,1,sizeof(int),f);

  fwrite(&mip1_offs,1,sizeof(int),f);
  fwrite(&mip2_offs,1,sizeof(int),f);
  fwrite(&mip3_offs,1,sizeof(int),f);
  fwrite(&mip4_offs,1,sizeof(int),f);

  //44 bytes of 0's
  for (i=0;i<44;i++)
    fputc(0,f);

  write_mip(f,mip,width,height,0);
  write_mip(f,mip,width,height,1);
  write_mip(f,mip,width,height,2);
  write_mip(f,mip,width,height,3);  
  
  printf("%s.wal completed.\n",walname);
  fclose(f);
  return 0;
}

#define ABS(x) (x)>(0)?(x):(-(x))

__inline unsigned char remap_pixel(int ir, int ig, int ib)
{
  int i;
  int diff,min_diff=99999;
  unsigned char match=0;    

  unsigned char *pal;

  if (adapt)
    pal = quake2_pal;
  else
    pal = pcx_pal;

  for (i=0;i<256;i++,pal+=3)
  {
    diff = 0;
    
    diff += ABS(pal[0]-ir);
    diff += ABS(pal[1]-ig);
    diff += ABS(pal[2]-ib);
    
    if (diff<min_diff)
    {
      min_diff = diff;
      match = i;
    }
  }
  
  return match;
}

void write_mip(FILE *f,unsigned char *base_mip,int base_width, int base_height, int miplevel)
{
  int mipsize = base_width/(1<<miplevel) * base_height/(1<<miplevel);
  int i,j;
  int w,h;
  
  unsigned char *new_mip=0;
  unsigned char *dst=0;

  int s,t,mipstep;

  printf("Writing mip %d...\n",miplevel+1);

  //simpler case
  if (miplevel==0)
  {
    //simple case, no palette adaptation, 1x1 pixel ratio
    if (!adapt)
    {      
      fwrite(base_mip,mipsize,1,f);      
      return;    
    }
    else
    {
      new_mip = new unsigned char [mipsize];
      dst     = new_mip;

      for (j=0; j<base_height; j++) 
      for (i=0; i<base_width;  i++,base_mip++)
      {    
        *dst = remap_pixel(pcx_pal[(*base_mip)*3+0],
                           pcx_pal[(*base_mip)*3+1],
                           pcx_pal[(*base_mip)*3+2]);                
        dst++;
      }
      
      fwrite(new_mip,mipsize,1,f);
      delete [mipsize] new_mip;
      return;
    }
  }
  
  w = base_width  >> miplevel;
  h = base_height >> miplevel;
  
  mipstep = 1<<miplevel;

  new_mip = new unsigned char [mipsize];
  dst     = new_mip;

  for (j=0,t=0; j<h; j++,t += mipstep) 
  for (i=0,s=0; i<w; i++,s += mipstep)
  {
    *dst = average_pixels(&base_mip[t*base_width+s],mipstep,base_width);
    dst++;
  }
  
  fwrite(new_mip,mipsize,1,f);
  delete [mipsize] new_mip;
}

unsigned char average_pixels(unsigned char *src, int miplevel, int bytesperline)
{
  unsigned char ir,ig,ib;
  double r=0,g=0,b=0;  
  int    i,j;
  int    total_pixels=0;  
  
  double oot;
  
  unsigned char *texel=src;
  int texeloffs;
  
  for (j=0;j<miplevel;j++,texel += (bytesperline-miplevel))
  for (i=0;i<miplevel;i++)
  {    
    texeloffs = (*texel) * 3;
  
    r += (double)pcx_pal[texeloffs+0];
    g += (double)pcx_pal[texeloffs+1];
    b += (double)pcx_pal[texeloffs+2];
    
    total_pixels++;
    texel++;
  }
  
  oot = 1.0 / (double)(total_pixels);
  r *= oot;
  g *= oot;
  b *= oot;
  
  ir = (unsigned char)r;
  ig = (unsigned char)g;
  ib = (unsigned char)b;

  return remap_pixel(ir,ig,ib);
}

void remove_extention(char *name)
{
  int i;
  for (i=strlen(name)-1;i;i--)
  {
    if (name[i]=='.') name[i]=0;
  }
}

void load_quake_palette()
{
  //reads the pallete from the end of the executable file.
  //kinda hacky.

  FILE *f;
  f = fopen(argv[0],"rb");
  fseek(f,-768,SEEK_END);
  
  if (!f)
  {
    printf("Couldnt read the quake 2 palette from the executable\n");
    exit(-1);
  }

  fread(quake2_pal,768,1,f);
  fclose(f);

  //if the palettes are different we'll have to adapt to
  //the quake palette
  int i;

  for (i=0;i<768;i++)
  {
    if (quake2_pal[i] != pcx_pal[i])
    {
      adapt = 1;
      break;
    }
  }  
}
