unit msLib;
(*********************************************
 *
 * MilkShape 3D Model Import/Export API
 *
 * May 10 2000, Mete Ciragan, chUmbaLum sOft
 *
 * Delphi port by fig 07/2006
 *********************************************)

interface
//Constants
const
    DLL = 'msModelLib.dll';
    MS_MAX_NAME = 32;
    MS_MAX_PATH = 256;

//Types
type
    PmsVec4 = ^TmsVec4;
    TmsVec4 = array[0..3] of single;
    PmsVec3 = ^TmsVec3;
    TmsVec3 = array[0..2] of single;
    PmsVec2 = ^TmsVec2;
    TmsVec2 = array[0..1] of single;

    TWordArray = array of word;


    //Delphi 5 Support- Thanks Ivan to Ivan Lee Herring 12/07/2006
const
      msSelected = 1;
      mselected2 = 2;
      msHidden = 4;
      msDirty = 8;
      msAveraged = 16;
      msKeepVertex = 32;
      msSphereMap = $80;
      msHasAlpha = $40;

type
//TmsVertex
    PmsVertex = ^TmsVertex;
    TmsVertex = record
        nFlags: byte;
        Vertex: TmsVec3;
        u, v: single;
        nBoneIndex: Shortint;
    end;

//TmsVertexEx
    PmsVertexEx = ^TmsVertexEx;
    TmsVertexEx = record
        nBoneIndices: array[0..2] of shortint;
        nBoneWeights: array[0..2] of byte;
    end;

//TmsTriangle
    PmsTriangle = ^TmsTriangle;
    TmsTriangle = record
        nFlags: word;
        nVertexIndices: array[0..2] of word;
        nNormalIndices: array[0..2] of word;
        Normal: TmsVec3;
        nSmoothingGroup: byte;
    end;

//TmsTriangleEx
    PmsTriangleEx = ^TmsTriangleEx;
    TmsTriangleEx = record
        Normals: array[0..2] of TmsVec3;
        TexCoords: array[0..2] of TmsVec2;
    end;

//TmsMesh
    PmsMesh = ^TmsMesh;
    TmsMesh = record
        nFlags: byte;
        szName: array[0..MS_MAX_NAME-1] of char;
        nMaterialIndex: smallint;

        nNumVertices: word;
        nNumAllocedVertices: word;
        pVertices: PmsVertex;

        nNumNormals: word;
        nNumAllocedNormals: word;
        pNormals: PmsVec3;

        nNumTriangles: word;
        nNumAllocedTriangles: word;
        pTriangles: PmsTriangle;

        pszComment: pchar;
        pVertexExs: PmsVertexEx;
        pTriangleExs: PmsTriangleEx;
    end;

//TmsMaterial
    PmsMaterial = ^TmsMaterial;
    TmsMaterial = record
        nFlags: integer;
        szName: array[0..MS_MAX_NAME-1] of char;
        Ambient: TmsVec4;
        Diffuse: TmsVec4;
        Specular: TmsVec4;
        Emissive: TmsVec4;
        fShininess: single;
        fTransparency: single;
        szDiffuseTexture: array[0..MS_MAX_PATH-1] of char;
        szAlphaTexture: array[0..MS_MAX_PATH-1] of char;
        nName: integer;
        pszComment: pchar;
    end;

//TmsPositionKey
    PmsPositionKey = ^TmsPositionKey;
    TmsPositionKey = record
        fTime: single;
        Position: TmsVec3;
    end;

//TmsRotationKey
    PmsRotationKey = ^TmsRotationKey;
    TmsRotationKey = record
        fTime: single;
        Rotation: TmsVec3;
    end;

//TmsBone
    PmsBone = ^TmsBone;
    TmsBone = record
        nFlags: integer;
        szName: array[0..MS_MAX_NAME-1] of char;
        szParentName: array[0..MS_MAX_NAME-1] of char;
        PositionTmsVec3: TmsVec3;
        RotationTmsVec3: TmsVec3;

        nNumPositionKeys: integer;
        nNumAllocedPositionKeys: integer;
        pPositionKeys: PmsPositionKey;

        nNumRotationKeys: integer;
        nNumAllocedRotationKeys: integer;
        pRotationKeys: PmsRotationKey;
        pszComment: pchar;
    end;

//TmsModel
    PmsModel = ^TmsModel;
    TmsModel = record
        nNumMeshes: integer;
        nNumAllocedMeshes: integer;
        pMeshes: PmsMesh;

        nNumMaterials: integer;
        nNumAllocedMaterials: integer;
        pMaterials: PmsMaterial;

        nNumBones: integer;
        nNumAllocedBones: integer;
        pBones: PmsBone;

        nFrame: integer;
        nTotalFrames: integer;

        Position: TmsVec3;
        Rotation: TmsVec3;

        CameraPosition: TmsVec3;
        CameraRotationXY: TmsVec2;

        pszComment: pchar;
    end;

//MilkShape 3D Interface

//msModel
procedure msModel_Destroy(pModel: Pmsmodel); cdecl; external DLL;
function msModel_GetMeshCount(pModel: PmsModel): integer; cdecl; external DLL;
function msModel_AddMesh(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_GetMeshAt(pModel: Pmsmodel; nIndex: integer): PmsMesh; cdecl; external DLL;
function msModel_FindMeshByName(pModel: Pmsmodel; const szName: pchar): integer; cdecl; external DLL;
function msModel_GetMaterialCount(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_AddMaterial(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_GetMaterialAt(pModel: Pmsmodel; nIndex: integer): PmsMaterial; cdecl; external DLL;
function msModel_FindMaterialByName(pModel: Pmsmodel; const szName: pchar): integer; cdecl; external DLL;
function msModel_GetBoneCount(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_AddBone(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_GetBoneAt(pModel: Pmsmodel; nIndex: integer): PmsBone; cdecl; external DLL;
function msModel_FindBoneByName(pModel: Pmsmodel; szName: pchar): integer; cdecl; external DLL;
function msModel_SetFrame(pModel: Pmsmodel; nFrame: integer): integer; cdecl; external DLL;
function msModel_GetFrame(pModel: Pmsmodel): integer; cdecl; external DLL;
function msModel_SetTotalFrames(pModel: Pmsmodel; nTotalFrames: integer): integer; cdecl; external DLL;
function msModel_GetTotalFrames(pModel: Pmsmodel): integer; cdecl; external DLL;
procedure msModel_SetPosition(pModel: Pmsmodel; Rotation: TmsVec3); cdecl; external DLL;
procedure msModel_GetPosition(pModel: Pmsmodel; Position: TmsVec3); cdecl; external DLL;
procedure msModel_SetRotation(pModel: Pmsmodel; Rotation: TmsVec3); cdecl; external DLL;
procedure msModel_GetRotation(pModel: Pmsmodel; Rotation: TmsVec3); cdecl; external DLL;
procedure msModel_SetCamera(pModel: Pmsmodel; Position: TmsVec3; RotationXY: TmsVec2); cdecl; external DLL;
procedure msModel_GetCamera(pModel: Pmsmodel; Position: TmsVec3; RotationXY: TmsVec2); cdecl; external DLL;
procedure msModel_SetComment(pModel: Pmsmodel; pszComment: pchar); cdecl; external DLL;
function msModel_GetComment(pModel: Pmsmodel; pszComment: pchar; nMaxCommentLength: integer): integer; cdecl; external DLL;

//msMesh
procedure msMesh_Destroy(pMesh: PmsMesh); cdecl; external DLL;
procedure msMesh_SetFlags(pMesh: PmsMesh; nFlags: byte); cdecl; external DLL;
function msMesh_GetFlags(pMesh: PmsMesh): byte; cdecl; external DLL;
procedure msMesh_SetName(pMesh: PmsMesh; const szName: pchar); cdecl; external DLL;
procedure msMesh_GetName(pMesh: PmsMesh; szName: pchar; nMaxLength: integer); cdecl; external DLL;
procedure msMesh_SetMaterialIndex(pMesh: PmsMesh; nIndex: integer); cdecl; external DLL;
function msMesh_GetMaterialIndex(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_GetVertexCount(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_AddVertex(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_GetVertexAt(pMesh: PmsMesh; nIndex: integer): PmsVertex; cdecl; external DLL;
function msMesh_GetVertexExAt(pMesh: PmsMesh; nIndex: integer): PmsVertexEx; cdecl; external DLL;
function msMesh_GetInterpolatedVertexAt(pMesh: PmsMesh; nIndex: integer): PmsVertex; cdecl; external DLL; // NOT YET IMPLEMENTED
function msMesh_GetTriangleCount(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_AddTriangle(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_GetTriangleAt(pMesh: PmsMesh; nIndex: integer): PmsTriangle; cdecl; external DLL;
function msMesh_GetTriangleExAt(pMesh: PmsMesh; nIndex: integer): PmsTriangleEx; cdecl; external DLL;
function msMesh_GetVertexNormalCount(pMesh: PmsMesh): integer; cdecl; external DLL;
function msMesh_AddVertexNormal(pMesh: PmsMesh): integer; cdecl; external DLL;
procedure msMesh_SetVertexNormalAt(pMesh: PmsMesh; nIndex: integer; Normal: TmsVec3); cdecl; external DLL;
procedure msMesh_GetVertexNormalAt(pMesh: PmsMesh; nIndex: integer; Normal: TmsVec3); cdecl; external DLL;
procedure msMesh_GetInterpolatedVertexNormalAt(pMesh: PmsMesh; nIndex: integer; Normal: TmsVec3); cdecl; external DLL; // NOT YET IMPLEMENTED
procedure msMesh_SetComment(pMesh: PmsMesh; const pszComment: pchar); cdecl; external DLL;
function msMesh_GetComment(pMesh: PmsMesh; pszComment: pchar; nMaxCommentLength: integer): integer; cdecl; external DLL;

//msTriangle
procedure msTriangle_SetFlags(pTriangle: PmsTriangle; nFlags: word); cdecl; external DLL;
function msTriangle_GetFlags(pTriangle: PmsTriangle): word; cdecl; external DLL;
procedure msTriangle_SetVertexIndices(pTriangle: PmsTriangle; nIndices: TWordArray); cdecl; external DLL;
procedure msTriangle_GetVertexIndices(pTriangle: PmsTriangle; nIndices: TWordArray); cdecl; external DLL;
procedure msTriangle_SetNormalIndices(pTriangle: PmsTriangle; nNormalIndices: TWordArray); cdecl; external DLL;
procedure msTriangle_GetNormalIndices(pTriangle: PmsTriangle; nNormalIndices: TWordArray); cdecl; external DLL;
procedure msTriangle_SetSmoothingGroup(pTriangle: PmsTriangle; nSmoothingGroup: byte); cdecl; external DLL;
function msTriangle_GetSmoothingGroup(pTriangle: PmsTriangle): byte; cdecl; external DLL;

//msTriangleEx
procedure msTriangleEx_SetNormal(pTriangle: PmsTriangleEx; nIndex: integer; Normal: TmsVec3); cdecl; external DLL;
procedure msTriangleEx_GetNormal(pTriangle: PmsTriangleEx; nIndex: integer; Normal: TmsVec3); cdecl; external DLL;
procedure msTriangleEx_SetTexCoord(pTriangle: PmsTriangleEx; nIndex: integer; TexCoord: TmsVec2); cdecl; external DLL;
procedure msTriangleEx_GetTexCoord(pTriangle: PmsTriangleEx; nIndex: integer; TexCoord: TmsVec2); cdecl; external DLL;

//msVertex
procedure msVertex_SetFlags(pVertex: PmsVertex; nFlags: byte); cdecl; external DLL;
function msVertex_GetFlags(pVertex: PmsVertex): byte; cdecl; external DLL;
procedure msVertex_SetVertex(pVertex: PmsVertex; Vertex: TmsVec3); cdecl; external DLL;
procedure msVertex_GetVertex(pVertex: PmsVertex; Vertex: TmsVec3); cdecl; external DLL;
procedure msVertex_SetTexCoords(pVertex: PmsVertex; st: TmsVec2); cdecl; external DLL;
procedure msVertex_GetTexCoords(pVertex: PmsVertex; st: TmsVec2); cdecl; external DLL;
function msVertex_SetBoneIndex(pVertex: PmsVertex; nBoneIndex: integer): integer; cdecl; external DLL;
function msVertex_GetBoneIndex(pVertex: PmsVertex): integer; cdecl; external DLL;

//msVertexEx
function msVertexEx_SetBoneIndices(pVertex: PmsVertexEx; nIndex: integer; nBoneIndex: integer): integer; cdecl; external DLL;
function msVertexEx_GetBoneIndices(pVertex: PmsVertexEx; nIndex: integer): integer; cdecl; external DLL;
function msVertexEx_SetBoneWeights(pVertex: PmsVertexEx; nIndex: integer; nWeight: integer): integer; cdecl; external DLL;
function msVertexEx_GetBoneWeights(pVertex: PmsVertexEx; nIndex: integer): integer; cdecl; external DLL;

//msMaterial
procedure msMaterial_SetFlags(pMaterial: PmsMaterial; nFlags: integer);cdecl; external DLL;
function msMaterial_GetFlags(pMaterial: PmsMaterial): integer;  cdecl; external DLL;
procedure msMaterial_SetName(pMaterial: PmsMaterial; const szName: pchar);cdecl; external DLL;
procedure msMaterial_GetName(pMaterial: PmsMaterial; szName: pchar; nMaxLength: integer);   cdecl; external DLL;
procedure msMaterial_SetAmbient(pMaterial: PmsMaterial; Ambient: TmsVec4);  cdecl; external DLL;
procedure msMaterial_GetAmbient(pMaterial: PmsMaterial; Ambient: TmsVec4); cdecl; external DLL;
procedure msMaterial_SetDiffuse(pMaterial: PmsMaterial; Diffuse: TmsVec4); cdecl; external DLL;
procedure msMaterial_GetDiffuse(pMaterial: PmsMaterial; Diffuse: TmsVec4); cdecl; external DLL;
procedure msMaterial_SetSpecular(pMaterial: PmsMaterial; Specular: TmsVec4);cdecl; external DLL;
procedure msMaterial_GetSpecular(pMaterial: PmsMaterial; Specular: TmsVec4); cdecl; external DLL;
procedure msMaterial_SetEmissive(pMaterial: PmsMaterial; Emissive: TmsVec4); cdecl; external DLL;
procedure msMaterial_GetEmissive(pMaterial: PmsMaterial; Emissive: TmsVec4); cdecl; external DLL;
procedure msMaterial_SetShininess(pMaterial: PmsMaterial; fShininess: single);  cdecl; external DLL;
function msMaterial_GetShininess(pMaterial: PmsMaterial): single; cdecl; external DLL;
procedure msMaterial_SetTransparency(pMaterial: PmsMaterial; fTransparency: single); cdecl; external DLL;
function msMaterial_GetTransparency(pMaterial: PmsMaterial): single;   cdecl; external DLL;
procedure msMaterial_SetDiffuseTexture(pMaterial: PmsMaterial; const szDiffuseTexture: pchar);  cdecl; external DLL;
procedure msMaterial_GetDiffuseTexture(pMaterial: PmsMaterial; szDiffuseTexture: pchar; nMaxLength: integer);cdecl; external DLL;
procedure msMaterial_SetAlphaTexture(pMaterial: PmsMaterial; const szAlphaTexture: pchar); cdecl; external DLL;
procedure msMaterial_GetAlphaTexture(pMaterial: PmsMaterial; szAlphaTexture: pchar; nMaxLength: integer);  cdecl; external DLL;
procedure msMaterial_SetComment(pMaterial: PmsMaterial; const pszComment: pchar);                     cdecl; external DLL;
function msMaterial_GetComment(pMaterial: PmsMaterial; pszComment: pchar; nMaxCommentLength: integer): integer;  cdecl; external DLL;

//msBone
procedure msBone_Destroy(pBone: PmsBone);  cdecl; external DLL;
procedure msBone_SetFlags(pBone: PmsBone; nFlags: integer);  cdecl; external DLL;
function msBone_GetFlags(pBone: PmsBone): integer;  cdecl; external DLL;
procedure msBone_SetName(pBone: PmsBone; const szName: pchar); cdecl; external DLL;
procedure msBone_GetName(pBone: PmsBone; szName: pchar; nMaxLength: integer);cdecl; external DLL;
procedure msBone_SetParentName(pBone: PmsBone; const szParentName: pchar);   cdecl; external DLL;
procedure msBone_GetParentName(pBone: PmsBone; szParentName: pchar; nMaxLength: integer); cdecl; external DLL;
procedure msBone_SetPosition(pBone: PmsBone; Position: TmsVec3);    cdecl; external DLL;
procedure msBone_GetPosition(pBone: PmsBone; Position: TmsVec3);   cdecl; external DLL;
procedure msBone_GetInterpolatedPosition(pBone: PmsBone; Position: TmsVec3);cdecl; external DLL; // NOT YET IMPLEMENTED
procedure msBone_SetRotation(pBone: PmsBone; Rotation: TmsVec3);cdecl; external DLL;
procedure msBone_GetRotation(pBone: PmsBone; Rotation: TmsVec3); cdecl; external DLL;
procedure msBone_GetInterpolatedRotation(pBone: PmsBone; Rotation: TmsVec3); cdecl; external DLL;// NOT YET IMPLEMENTED

function msBone_GetPositionKeyCount(pBone: PmsBone): integer; cdecl; external DLL;
function msBone_AddPositionKey(pBone: PmsBone; fTime: single; Position: TmsVec3): integer; cdecl; external DLL;
function msBone_GetPositionKeyAt(pBone: PmsBone; nIndex: integer): PmsPositionKey; cdecl; external DLL;

function msBone_GetRotationKeyCount(pBone: PmsBone): integer;cdecl; external DLL;
function msBone_AddRotationKey(pBone: PmsBone; fTime: single; Rotation: TmsVec3): integer;  cdecl; external DLL;
function msBone_GetRotationKeyAt(pBone: PmsBone; nIndex: integer): PmsRotationKey;cdecl; external DLL;
procedure msBone_SetComment(pBone: PmsBone; const pszComment: pchar);cdecl; external DLL;
function msBone_GetComment(pBone: PmsBone; pszComment: pchar; nMaxCommentLength: integer): integer; cdecl; external DLL;

implementation
end.

