#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msPlugInImpl.h"
#include "msLib.h"
#include "DlgOptions.h"

#include <dotXSIDefines.h>

#include "C3DVectorCompressor.h"

#define MAX_VERTICES	8192
#define MAX_TRIANGLES	16384

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef std::vector<int>		tIndexList;
typedef tIndexList::iterator	tIndexListIter;

typedef std::vector<CSIBCMatrix4x4*>		tMatrixList;
typedef tMatrixList::iterator			tMatrixListIter;

typedef std::vector<tNullBone*>			tBoneList;
typedef tBoneList::iterator				tBoneListIter;


msVec3	g_vCurrentPosition;
msVec3	g_vCurrentRotation;

msVec3	g_vCurrentBPPosition;
msVec3	g_vCurrentBPRotation;

char	g_szLastBoneName [ 256 ];
char	g_szParentName [ 256 ];

tMatrixList	g_MatrixList;
tBoneList	g_BoneList;
CdotXSITemplates   *g_pEnvelopeCollection = NULL;

/////////////////////////////////////////////////////////////////////////////
// CMsPlugInApp

BEGIN_MESSAGE_MAP(CMsPlugInApp, CWinApp)
	//{{AFX_MSG_MAP(CMsPlugInApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp::CMsPlugInApp()
{
}

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp theApp;



cMsPlugIn*
CreatePlugIn ()
{
    return new cPlugIn ();
}



cPlugIn::cPlugIn () : 
m_pParser ( NULL )
{
    strcpy (szTitle, "SOFTIMAGE|XSI...");
}



cPlugIn::~cPlugIn ()
{
}



int
cPlugIn::GetType ()
{
    return cMsPlugIn::eTypeImport;
}



const char*
cPlugIn::GetTitle ()
{
    return szTitle;
}


int 
cPlugIn::PrintError ( char *msg )
{
	::AfxMessageBox (msg);
	
	return (int) 0;
}

int cPlugIn::ConvertXSITemplate ( CdotXSITemplate *in_pTmp )
{
	int tmp = GetMap ( in_pTmp );

	if ( tmp != -1 )
	{
		g_Maps[tmp].m_pHandler ( m_pModel, in_pTmp );
	}

	CdotXSITemplates	*l_pChildren = &in_pTmp->Children();

	bool	l_bTransformed = false;

	if ( l_pChildren != NULL )
	{
		for (int c=0;c<l_pChildren->GetCount();c++)
		{
			if ( !strcmp(l_pChildren->Item ( c )->Name().GetText(), "SI_Transform" ) )
			{
				l_bTransformed = true;
			}

			ConvertXSITemplate ( l_pChildren->Item ( c )  );

		}
	}

	//
	// Check if this template affected the matrix stack. If it did, we need to pop the matrix 
	// to keep it current
	//

	if ( l_bTransformed )
	{

		g_MatrixList.pop_back ();

	}

	return 0;

}

int
cPlugIn::Execute (msModel *pModel)
{
	
    if (!pModel)
        return -1;

	m_pModel = pModel;

	g_BoneList.clear();
	g_MatrixList.clear();

	g_pEnvelopeCollection = NULL;

    //
    // switch the module state for MFC Dlls
    //
    AFX_MANAGE_STATE(AfxGetStaticModuleState());

    //
    // options dialog
    //
    cDlgOptions dlgOptions (NULL);
    if (dlgOptions.DoModal () != IDOK)
        return 0;

    CString sPath = dlgOptions.GetPathName ();
    if (sPath.IsEmpty ())
        return 0;

    int nOptionFlags = dlgOptions.GetOptionFlags ();

	m_pParser = new CXSIParser();

	m_pParser->SetOpenMode ( OPEN_READ );
	
	m_pParser->Open ( CSIBCString ( sPath ) );
	m_pParser->Read	();

	CdotXSITemplates   *l_pRootTemplate = m_pParser->dotXSITemplate();

	//
	// Lets find the SI_EnvelopeList template
	//

	g_pEnvelopeCollection = FindTemplateRecursively ( l_pRootTemplate, "SI_EnvelopeList" );

	//
	// Enter recursive function
	//

	for (int c=0;c<l_pRootTemplate->GetCount();c++)
	{
		ConvertXSITemplate ( l_pRootTemplate->Item ( c ) );
	}

	delete m_pParser;

    return 0;
}

int GetMap ( CdotXSITemplate *in_pTmp )
{
	int i = 0;

	while ( g_Maps[i].m_szTemplateName != NULL )
	{
		if ( !strcmp ( g_Maps[i].m_szTemplateName, in_pTmp->Name().GetText() ) )
		{

			return i;
		}
		
		i++;
	}

	return -1;
}

int	SIScene ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{

	return 0;
}

int	SIMaterial ( msModel *in_pModel , CdotXSITemplate *in_pTmp )
{
	msVec4 vec4;

	int nMaterial = msModel_AddMaterial (in_pModel);
	msMaterial *pMaterial = msModel_GetMaterialAt (in_pModel, nMaterial);

	char *bla = in_pTmp->InstanceName().GetText();

	msMaterial_SetName (pMaterial, bla);


	GetFloatFromTemplate ( in_pTmp, SI_MAT_AMBIENT_R, vec4[0] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_AMBIENT_G, vec4[1] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_AMBIENT_B, vec4[2] );
	vec4[3] = 1.0f;

	msMaterial_SetAmbient (pMaterial, vec4);

	GetFloatFromTemplate ( in_pTmp, SI_MAT_FACE_R, vec4[0] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_FACE_G, vec4[1] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_FACE_B, vec4[2] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_FACE_A, vec4[3] );

	msMaterial_SetTransparency (pMaterial, vec4[3]);

	vec4[3] = 1.0f;
	msMaterial_SetDiffuse (pMaterial, vec4);

	GetFloatFromTemplate ( in_pTmp, SI_MAT_SPECULAR_R, vec4[0] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_SPECULAR_G, vec4[1] );
	GetFloatFromTemplate ( in_pTmp, SI_MAT_SPECULAR_B, vec4[2] );
	
	vec4[3] = 1.0f;
	msMaterial_SetSpecular (pMaterial, vec4);

	float l_fShininess;

	GetFloatFromTemplate ( in_pTmp, SI_MAT_POWER, l_fShininess );
	
	msMaterial_SetShininess (pMaterial, l_fShininess);

	//
	// Look for a texture
	//

	CdotXSITemplates*	l_pChildren = &in_pTmp->Children();

	if ( l_pChildren != NULL )
	{
		for (int c=0;c<l_pChildren->GetCount();c++)
		{
			CdotXSITemplate* children = l_pChildren->Item ( c );

			if ( !strcmp ( children->Name().GetText(), "SI_Texture2D" ) )
			{
				//
				// Found a texture!
				//

				msMaterial_SetDiffuseTexture (pMaterial, GetStringFromTemplate ( children, SI_TXT2D_IMAGENAME ) );


			}

		}
	}

	//msMaterial_SetDiffuseTexture (pMaterial, mat->texture.map.name);
	return 0;
}

int SITransform ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{
	if ( strstr(in_pTmp->InstanceName().GetText(), "SRT") )
	{
		GetFloatFromTemplate ( in_pTmp, 3, g_vCurrentRotation[0] );
		GetFloatFromTemplate ( in_pTmp, 4, g_vCurrentRotation[1] );
		GetFloatFromTemplate ( in_pTmp, 5, g_vCurrentRotation[2] );

		GetFloatFromTemplate ( in_pTmp, 6, g_vCurrentPosition[0] );
		GetFloatFromTemplate ( in_pTmp, 7, g_vCurrentPosition[1] );
		GetFloatFromTemplate ( in_pTmp, 8, g_vCurrentPosition[2] );

		//
		// Save onto the matrix stack
		//
	
		CSIBCMatrix4x4	*l_mLocal = new CSIBCMatrix4x4;
		BuildLocalMatrix ( in_pTmp, l_mLocal );
		g_MatrixList.push_back ( l_mLocal );

	}

	if ( strstr(in_pTmp->InstanceName().GetText(), "BASEPOSE") )
	{
		GetFloatFromTemplate ( in_pTmp, 3, g_vCurrentBPRotation[0] );
		GetFloatFromTemplate ( in_pTmp, 4, g_vCurrentBPRotation[1] );
		GetFloatFromTemplate ( in_pTmp, 5, g_vCurrentBPRotation[2] );

		GetFloatFromTemplate ( in_pTmp, 6, g_vCurrentBPPosition[0] );
		GetFloatFromTemplate ( in_pTmp, 7, g_vCurrentBPPosition[1] );
		GetFloatFromTemplate ( in_pTmp, 8, g_vCurrentBPPosition[2] );
	}


	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////
// XSI Squeleton / Envelope support
//
// @warning Currently disabled until I can figure out how the Half-Life
int SINull ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{
	//
	// We found a NULL... we must look into the envelope list
	// to see if this NULL is used as a bone. If it is not, 
	// we skip it... cause it's useless
	//

	if ( IsBone ( in_pTmp->InstanceName().GetText() ) )
	{

		tNullBone	*l_pBone = new tNullBone;

		strncpy (l_pBone->m_szName , in_pTmp->InstanceName().GetText(), 256 );

		CdotXSITemplate *l_pParent = in_pTmp->Parent();

		if ( l_pParent != NULL )
		{
			l_pParent = l_pParent->Parent();
		}
		
		if ( l_pParent == NULL )
		{
			l_pBone->m_szParentName[0] = 0;
		} else {

			char* l_pParentName = l_pParent->InstanceName().GetText();
			l_pParentName+=4;

			strncpy (l_pBone->m_szParentName , l_pParentName, 256 );
		}

		BuildLocalMatrix ( in_pTmp, &l_pBone->m_mSRT );
		BuildGlobalMatrix ( l_pBone->m_mGlobalSRT );
		
		g_BoneList.push_back ( l_pBone );

		return 1;
	}

	return 0;

}

int SIIKRoot ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{

	return 0;
}

int SIIKJoint ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{


	return 0;
}

int SIIKEffector ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{

	return 0;
}


int	SIEnvelope ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{
	/*
	CdotXSITemplates*	l_pChildren = &in_pTmp->Children();
	bool msgshown = false;

	if ( l_pChildren != NULL )
	{
		for (int c=0;c<l_pChildren->GetCount();c++)
		{
			CdotXSITemplate* children = l_pChildren->Item ( c );

			if ( !strcmp ( children->Name().GetText(), "SI_Envelope" ) )
			{
				//
				// Found a new bone definition
				//

				char *l_szBoneName = GetStringFromTemplate ( children, 1 );

				if ( l_szBoneName == NULL )
					continue;	//???

				l_szBoneName+=4;	// get rid of MDL-

				//
				// Look for this bone in the bone list
				//

				tNullBone	*l_pBone = GetBone ( l_szBoneName );

				if (( l_pBone == NULL ) && ( !msgshown))
				{
					::AfxMessageBox  ( "A mesh in envelopped with something else than a NULL. This is not currently supported." );
					msgshown = true;
					continue;
				}

				//
				// Check if the bone's parent is another bone...
				//
				
				char l_szParentName[256];
				l_szParentName[0] = 0;

				tNullBone	*l_pParentBone = GetBone( l_pBone->m_szParentName );

				if ( l_pParentBone != NULL )
				{
					strncpy ( l_szParentName, l_pParentBone->m_szName , 256);
				}

				int	nBone = msModel_AddBone (in_pModel);
				msBone* pBone = msModel_GetBoneAt (in_pModel, nBone);

				msBone_SetName ( pBone, l_pBone->m_szName );
				msBone_SetParentName ( pBone, l_szParentName );
				
				CSIBCVector3D s,r,t;
	
				if ( l_pParentBone != NULL )
				{
					l_pBone->m_mSRT.GetTransforms( s,r,t );
				} else {

					l_pBone->m_mGlobalSRT.GetTransforms( s,r,t );
				}


				msVec3	pos,rot;

				pos[0] = t.m_fX;
				pos[1] = t.m_fY;
				pos[2] = t.m_fZ;
				rot[0] = r.m_fX;
				rot[1] = r.m_fY;
				rot[2] = r.m_fZ;

				msBone_SetPosition ( pBone, pos );
				msBone_SetRotation ( pBone, rot );

			}

		}
	}
	*/
	return 0;
}

int	SIMesh ( msModel *in_pModel, CdotXSITemplate *in_pTmp )
{
	
	//
	// Look for a Shape info
	//

	CdotXSITemplate *	l_pShape = NULL;
	CdotXSITemplate *	l_pTriList = NULL;

	CdotXSITemplates*	l_pChildren = &in_pTmp->Children();
	
	int type =0;

	if ( l_pChildren != NULL )
	{
		for (int c=0;c<l_pChildren->GetCount();c++)
		{
			CdotXSITemplate* children = l_pChildren->Item ( c );

			if ( !strcmp ( children->Name().GetText(), "SI_Shape" ) )
			{
				l_pShape = children;
				break;
			}

		}
	}

	
	if ( l_pChildren != NULL )
	{
		for (int c=0;c<l_pChildren->GetCount();c++)
		{
			CdotXSITemplate* children = l_pChildren->Item ( c );

			if ((!strcmp ( children->Name().GetText(), "SI_TriangleList" )) ||
				(!strcmp ( children->Name().GetText(), "SI_PolygonList" )))
			{
				if ( strcmp ( children->Name().GetText(), "SI_TriangleList" ) )
				{
					type = 1;
				}


				if ( type )
				{
					//
					// Ensure that all faces are made up of no more than 3 vertices
					//
					int	nf = GetIntFromTemplate ( children, 0 );
					int *nfp = GetIntPtrFromTemplate ( children, 4 );
					bool valid = true;

					for (int f=0;f<nf;f++)
					{
						if ( (*nfp) > 3 )
						{
							valid = false;
							break;
						}

						nfp++;
					}
					
					if ( !valid )
					{
						::AfxMessageBox  ( "A mesh with polygons made up of more than 3 vertices was found..skipping" );
						continue;

					}

				}


				//
				// Create 2 vector compressor, 1 for vertices and the other for normals
				//

				l_pTriList = children;

				C3DVectorCompressor	VList,NList;

				//
				// Get a pointer to the vertex list
				//
				int nvert;
				float *l_fPtr = NULL;
				float *l_NPtr = NULL;
				float *l_UVPtr = NULL;

				nvert = GetIntFromTemplate ( l_pShape, 2 );
				l_fPtr = GetFloatPtrFromTemplate ( l_pShape, 4 );

				l_NPtr = GetFloatPtrFromTemplate ( l_pShape, 7 );

				//
				// Check if UVs are supported
				//
				char *elements = GetStringFromTemplate ( l_pTriList,1);

				if ( strstr(elements, "TEX_COORD_UV") )
				{
					l_UVPtr = GetFloatPtrFromTemplate ( l_pShape, 10 );
				}


				//
				// Get num triangles
				//

				int		num_tri;
				int*	ilist;
				int*	nlist;
				int*	uvlist;

				if ( !type )
				{
					num_tri = GetIntFromTemplate( l_pTriList, 0 );
					ilist = GetIntPtrFromTemplate ( l_pTriList,3 );
					nlist = GetIntPtrFromTemplate ( l_pTriList,4 );

					if ( l_UVPtr != NULL )
					{
						uvlist = GetIntPtrFromTemplate ( l_pTriList,5 );
					}


				} else {

					num_tri = GetIntFromTemplate( l_pTriList, 0 );
					ilist = GetIntPtrFromTemplate ( l_pTriList,5 );
					nlist = GetIntPtrFromTemplate ( l_pTriList,6 );

					if ( l_UVPtr != NULL )
					{
						uvlist = GetIntPtrFromTemplate ( l_pTriList,7 );
					}

				}

				

				//
				// Add the triangles here, and build a new index list
				//

				tIndexList	IndexList;
				tIndexList	NormalIndexList;

				for (int i=0;i<num_tri;i++)
				{
					uvvec	new_vertex;
					uvvec	new_normal;

					int		tindex;
					int		nindex;

					for (int c=0;c<3;c++)
					{
						tindex = ilist[ (i * 3) + c ];
						new_vertex.x = l_fPtr [ (tindex * 3) + 0 ];
						new_vertex.y = l_fPtr [ (tindex * 3) + 1 ];
						new_vertex.z = l_fPtr [ (tindex * 3) + 2 ];

						nindex = nlist[ (i * 3) + c ];
						new_normal.x = l_NPtr [ (nindex * 3) + 0 ];
						new_normal.y = l_NPtr [ (nindex * 3) + 1 ];
						new_normal.z = l_NPtr [ (nindex * 3) + 2 ];
						new_normal.u = 0.0f;
						new_normal.v = 0.0f;

						if ( l_UVPtr != NULL )
						{
							int uindex = uvlist[ (i*3) + c ];
							new_vertex.u = l_UVPtr [ (uindex * 2) + 0 ];
							new_vertex.v = l_UVPtr [ (uindex * 2) + 1 ];
						} else {
							new_vertex.u = 0.0f;
							new_vertex.v = 0.0f;
						}

						NList.AddVertex ( new_normal.x, new_normal.y, new_normal.z, new_normal.u, new_normal.v );
						VList.AddVertex ( new_vertex.x, new_vertex.y, new_vertex.z, new_vertex.u, new_vertex.v );
						
						IndexList.push_back ( VList.GetIndex (new_vertex.x, new_vertex.y,new_vertex.z,new_vertex.u,new_vertex.v ) );
						NormalIndexList.push_back ( NList.GetIndex ( new_normal.x,new_normal.y, new_normal.z, 0.0f, 0.0f ) );
					}

				}

				//
				// At this point we have a list of "flatten" vertices and possible their associated UVs in the 
				// VList vector compressor. And we have a list of vertex index in the IndexList vector;
				// We are ready to add the mesh
				//

				int nMesh = msModel_AddMesh (in_pModel);
				msMesh *pMesh = msModel_GetMeshAt (in_pModel, nMesh);
				msMesh_SetName (pMesh, l_pTriList->InstanceName().GetText() );

				//
				// Set it's material index
				//

				int nMaterialIndex = msModel_FindMaterialByName (in_pModel, GetStringFromTemplate ( l_pTriList, SI_TRIANGLELIST_MATERIAL ));
				msMesh_SetMaterialIndex (pMesh, nMaterialIndex);

				//
				// Add the vertex list
				//

				for (int v=0;v<VList.GetCount ();v++)
				{
					msVec3 vec3;
					int nVertex = msMesh_AddVertex (pMesh);
					msVertex *pVertex = msMesh_GetVertexAt (pMesh, nVertex);

					uvvec tv;
					VList.GetVertex (v,&tv);

					vec3[0] = tv.x;
					vec3[1] = tv.y;
					vec3[2] = tv.z;
					msVertex_SetVertex (pVertex, vec3);

					if (l_UVPtr!=NULL)
					{
						msVec2 uv;
						uv[0] = tv.u;
						uv[1] = -tv.v;
						msVertex_SetTexCoords (pVertex, uv);
					}

					msVec3 Normal;
					uvvec nm;
					NList.GetVertex ( v, &nm );
					Normal[0] = nm.x;
					Normal[1] = nm.y;
					Normal[2] = nm.z;
					int nNormal = msMesh_AddVertexNormal (pMesh);
                    msMesh_SetVertexNormalAt (pMesh, nNormal, Normal);

				}

				//
				// Now add the triangles
				//
				
				tIndexListIter  TriList = IndexList.begin();
				tIndexListIter	NormalList = NormalIndexList.begin();

				while ( TriList != IndexList.end() )
				{
					int nTriangle = msMesh_AddTriangle (pMesh);
					msTriangle *pTriangle = msMesh_GetTriangleAt (pMesh, nTriangle);

					word nIndices[3];
					nIndices[0] = (*TriList);
					TriList++;
					nIndices[1] = (*TriList);
					TriList++;
					nIndices[2] = (*TriList);
					TriList++;

					word nNormalIndices[3];
					nNormalIndices[0] = (*NormalList);
					NormalList++;
					nNormalIndices[1] = (*NormalList);
					NormalList++;
					nNormalIndices[2] = (*NormalList);
					NormalList++;

					msTriangle_SetVertexIndices (pTriangle, nIndices);
					msTriangle_SetNormalIndices (pTriangle, nNormalIndices);
				}


			}
			
		}
	}

	return 0;
}


void GetFloatFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos, float& inout_fFloat)
{
	CdotXSIParams*	l_pPColl = &in_pTmp->Params();

	CdotXSIParam*	l_pParam = l_pPColl->Item ( in_iPos );

	SI_TinyVariant l_fFloat;
	
	l_pParam->GetValue ( &l_fFloat );

	inout_fFloat = l_fFloat.fVal;


}

char* GetStringFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos )
{
	CdotXSIParams*	l_pPColl = &in_pTmp->Params();

	CdotXSIParam*	l_pParam = l_pPColl->Item ( in_iPos );

	SI_TinyVariant l_szString;
	
	l_pParam->GetValue ( &l_szString );

	return l_szString.p_cVal;
		
}


int GetIntFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos )
{
	CdotXSIParams*	l_pPColl = &in_pTmp->Params();

	CdotXSIParam*	l_pParam = l_pPColl->Item ( in_iPos );

	SI_TinyVariant l_iInt;
	
	l_pParam->GetValue ( &l_iInt );

	return l_iInt.nVal;
		
}


float *GetFloatPtrFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos )
{
	CdotXSIParams*	l_pPColl = &in_pTmp->Params();

	CdotXSIParam*	l_pParam = l_pPColl->Item ( in_iPos );

	SI_TinyVariant l_fPtr;
	
	l_pParam->GetValue ( &l_fPtr );

	return l_fPtr.p_fVal;
}

int *GetIntPtrFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos )
{
	CdotXSIParams*	l_pPColl = &in_pTmp->Params();

	CdotXSIParam*	l_pParam = l_pPColl->Item ( in_iPos );

	SI_TinyVariant l_fPtr;
	
	l_pParam->GetValue ( &l_fPtr );

	return l_fPtr.p_nVal;
}

void	BuildLocalMatrix ( CdotXSITemplate *in_pTmp, CSIBCMatrix4x4* l_mLocal )
{
	CSIBCVector3D	l_Scale = CSIBCVector3D (1.0f, 1.0f, 1.0f );
	CSIBCVector3D	l_Rotation = CSIBCVector3D (g_vCurrentRotation[0], g_vCurrentRotation[1], g_vCurrentRotation[2] );
	CSIBCVector3D	l_Translation = CSIBCVector3D (g_vCurrentPosition[0], g_vCurrentPosition[1], g_vCurrentPosition[2] );

	l_mLocal->SetTransforms ( l_Scale,l_Rotation, l_Translation );

}

void BuildGlobalMatrix ( CSIBCMatrix4x4& l_mGlobal )
{
	tMatrixListIter  MatList = g_MatrixList.begin();
	
	while ( MatList != g_MatrixList.end() )
	{
		l_mGlobal.Multiply ( *(*MatList) );

		MatList++;
	}


}

tNullBone*	GetBone ( char *in_szBoneName )
{
	tBoneListIter	BoneList = g_BoneList.begin();

	while ( BoneList != g_BoneList.end() )
	{
		if ( !strcmp ( (*BoneList)->m_szName, in_szBoneName ) )
		{
			return (*BoneList);
		}

		BoneList++;
	}

	return NULL;
}

bool IsBone ( const char *in_szBoneName )
{
	if ( g_pEnvelopeCollection != NULL )
	{
		for (int c=0;c<g_pEnvelopeCollection->GetCount();c++)
		{
			CdotXSITemplate* children = g_pEnvelopeCollection->Item ( c );

			char *l_szBoneName = GetStringFromTemplate ( children, 1 );

			l_szBoneName+= 4;		// get rid of the MDL-
			
			if ( !strcmp ( l_szBoneName, in_szBoneName ) )
			{/*
				//
				// Now ensure that this bone is in fact affecting vertices.
				//
				int	l_iNumWeights = GetIntFromTemplate ( children, 2 );
				float*	l_pPtr = GetFloatPtrFromTemplate ( children, 3 );
				l_pPtr++;
				for (int w=0;w<l_iNumWeights;w++)
				{
					if ( (*l_pPtr) > 0.0f )
					{
						return true;
					}

					l_pPtr++;
					l_pPtr++;
				}
				*/
				return true;
			
			}

		}
	}

	return false;

}

CdotXSITemplates * FindTemplateRecursively ( CdotXSITemplates* in_pParent, const char *in_szTemplateName )
{

	if ( in_pParent != NULL )
	{
		for (int c=0;c<in_pParent->GetCount();c++)
		{
			CdotXSITemplate* children = in_pParent->Item ( c );

			if ( !strcmp ( children->Name().GetText(), in_szTemplateName ) )
			{
				return &children->Children();
			
			}

			CdotXSITemplates* l_Result = FindTemplateRecursively ( &children->Children(), in_szTemplateName );

			if ( l_Result = NULL )
				return l_Result;


		}
	}

	return NULL;

}
