/*
    msPlugInTemplates.cpp - DirectX template data for MilkShape DirectX plug-ins.

    Copyright (c) John Thompson, 2001-2004.  All rights reserved.
*/

#include "stdafx.h"
#include "msPlugInImpl.h"


    // Header GUID.
    // {3D82AB43-62DA-11cf-AB39-0020AF71E433}
ClassID oHeaderGUID(
    0x3D82AB43, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // Vector GUID.
    // {3D82AB5E-62DA-11cf-AB39-0020AF71E433}
ClassID oVectorGUID(
    0x3D82AB5E, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // Coords2d GUID.
    // {F6F23F44-7686-11cf-8F52-0040333594A3}
ClassID oCoords2dGUID(
    0xF6F23F44, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Matrix4x4 GUID.
    // {F6F23F45-7686-11cf-8F52-0040333594A3}
ClassID oMatrix4x4GUID(
    0xF6F23F45, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // ColorRGBA GUID.
    // {35FF44E0-6C7C-11cf-8F52-0040333594A3}
ClassID oColorRGBAGUID(
    0x35FF44E0, 0x6C7C, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // ColorRGB GUID.
    // {D3E16E81-7835-11cf-8F52-0040333594A3}
ClassID oColorRGBGUID(
    0xD3E16E81, 0x7835, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // IndexedColor GUID.
    // {1630B820-7842-11cf-8F52-0040333594A3}
ClassID oIndexedColorGUID(
    0x1630B820, 0x7842, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Boolean GUID.
    // {4885AE61-78E8-11cf-8F52-0040333594A3}
ClassID oBooleanGUID(
    0x4885AE61, 0x78E8, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Boolean2d GUID.
    // {4885AE63-78E8-11cf-8F52-0040333594A3}
ClassID oBoolean2dGUID(
    0x4885AE63, 0x78E8, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // MaterialWrap GUID.
    // {4885AE60-78E8-11cf-8F52-0040333594A3}
ClassID oMaterialWrapGUID(
    0x4885AE60, 0x78E8, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // TextureFilename GUID.
    // {A42790E1-7810-11cf-8F52-0040333594A3}
ClassID oTextureFilenameGUID(
    0xA42790E1, 0x7810, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Material GUID.
    // {3D82AB4D-62DA-11cf-AB39-0020AF71E433}
ClassID oMaterialGUID(
    0x3D82AB4D, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // MeshFace GUID.
    // {3D82AB5F-62DA-11cf-AB39-0020AF71E433}
ClassID oMeshFaceGUID(
    0x3D82AB5F, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // MeshFaceWraps GUID.
    // {4885AE62-78E8-11cf-8F52-0040333594A3}
ClassID oMeshFaceWrapsGUID(
    0x4885AE62, 0x78E8, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // MeshTextureCoords GUID.
    // {F6F23F40-7686-11cf-8F52-0040333594A3}
ClassID oMeshTextureCoordsGUID(
    0xF6F23F40, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // MeshMaterialList GUID.
    // {F6F23F42-7686-11cf-8F52-0040333594A3}
ClassID oMeshMaterialListGUID(
    0xF6F23F42, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // MeshNormals GUID.
    // {F6F23F43-7686-11cf-8F52-0040333594A3}
ClassID oMeshNormalsGUID(
    0xF6F23F43, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // MeshVertexColors GUID.
    // {1630B821-7842-11cf-8F52-0040333594A3}
ClassID oMeshVertexColorsGUID(
    0x1630B821, 0x7842, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Mesh GUID.
    // {3D82AB44-62DA-11cf-AB39-0020AF71E433}
ClassID oMeshGUID(
    0x3D82AB44, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // FrameTransformMatrix GUID.
    // {F6F23F41-7686-11cf-8F52-0040333594A3}
ClassID oFrameTransformMatrixGUID(
    0xF6F23F41, 0x7686, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Frame GUID.
    // {3D82AB46-62DA-11cf-AB39-0020AF71E433}
ClassID oFrameGUID(
    0x3D82AB46, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // FloatKeys GUID.
    // {10DD46A9-775B-11cf-8F52-0040333594A3}
ClassID oFloatKeysGUID(
    0x10DD46A9, 0x775B, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // TimedFloatKeys GUID.
    // {F406B180-7B3B-11cf-8F52-0040333594A3}
ClassID oTimedFloatKeysGUID(
    0xF406B180, 0x7B3B, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // AnimationKey GUID.
    // {10DD46A8-775B-11cf-8F52-0040333594A3}
ClassID oAnimationKeyGUID(
    0x10DD46A8, 0x775B, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // AnimationOptions GUID.
    // {E2BF56C0-840F-11cf-8F52-0040333594A3}
ClassID oAnimationOptionsGUID(
    0xE2BF56C0, 0x840F, 0x11cf, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);

    // Animation GUID.
    // {3D82AB4F-62DA-11cf-AB39-0020AF71E433}
ClassID oAnimationGUID(
    0x3D82AB4F, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

    // AnimationSet GUID.
    // {3D82AB50-62DA-11cf-AB39-0020AF71E433}
ClassID oAnimationSetGUID(
    0x3D82AB50, 0x62DA, 0x11cf, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);

// DirectX 8 additions.

    // XSkinMeshHeader GUID.
    // {3cf169ce-ff7c-44ab-93c0-f78f62d172e2}
ClassID oXSkinMeshHeaderGUID(
    0x3cf169ce, 0xff7c, 0x44ab, 0x93, 0xc0, 0xf7, 0x8f, 0x62, 0xd1, 0x72, 0xe2);

    // VertexDuplicationIndices GUID.
    // {b8d65549-d7c9-4995-89cf-53a9a8b031e3}
ClassID oVertexDuplicationIndicesGUID(
    0xb8d65549, 0xd7c9, 0x4995, 0x89, 0xcf, 0x53, 0xa9, 0xa8, 0xb0, 0x31, 0xe3);

    // SkinWeights GUID.
    // {6f0d123b-bad2-4167-a0d0-80224f25fabb}
ClassID oSkinWeightsGUID(
    0x6f0d123b, 0xbad2, 0x4167, 0xa0, 0xd0, 0x80, 0x22, 0x4f, 0x25, 0xfa, 0xbb);

// JTGame extension GUIDs.

    // MeshOptions GUID.
    // {3376abd0-ec20-11d3-8638-0000e856bada}
ClassID oMeshOptionsGUID(
    0x3376abd0, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // MeshBoneData GUID.
    // {3376abd1-ec20-11d3-8638-0000e856bada}
ClassID oMeshBoneDataGUID(
    0x3376abd1, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroup GUID.
    // {3376abde-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupGUID(
    0x3376abde, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroupFaceWraps GUID.
    // {3376abe0-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupFaceWrapsGUID(
    0x3376abe0, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroupTextureCoords GUID.
    // {3376abe1-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupTextureCoordsGUID(
    0x3376abe1, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroupNormals GUID.
    // {3376abe2-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupNormalsGUID(
    0x3376abe2, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroupVertexColors GUID.
    // {3376abe3-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupVertexColorsGUID(
    0x3376abe3, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // RenderGroupVertexMatrixIndices GUID.
    // {3376abdd-ec20-11d3-8638-0000e856bada}
ClassID oRenderGroupVertexMatrixIndicesGUID(
    0x3376abdd, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);

    // BoneMatrix GUID.
    // {3376abdb-ec20-11d3-8638-0000e856bada}
ClassID oBoneMatrixGUID(
    0x3376abdb, 0xec20, 0x11d3, 0x86, 0x38, 0x00, 0x00, 0xe8, 0x56, 0xba, 0xda);


    // Output templates.
bool cPlugIn::OutputTemplates()
{
    bool blRet = true;

    if (m_blAddTemplates)
    {
            //  template Header {
	        //      <3D82AB43-62DA-11cf-AB39-0020AF71E433>
	        //      WORD major;
	        //      WORD minor;
	        //      DWORD flags;
            //   }
        blRet = blRet && OutputTemplateHeader("Header", oHeaderGUID);
        blRet = blRet && OutputTemplateMember("major", TOKEN_WORD);
        blRet = blRet && OutputTemplateMember("minor", TOKEN_WORD);
        blRet = blRet && OutputTemplateMember("flags", TOKEN_DWORD);
        blRet = blRet && OutputTemplateTail();

            //template Vector {
            //    <3D82AB5E-62DA-11cf-AB39-0020AF71E433>
            //	  FLOAT x;
            //	  FLOAT y;
            //	  FLOAT z;
            // }
        blRet = blRet && OutputTemplateHeader("Vector", oVectorGUID);
        blRet = blRet && OutputTemplateMember("x", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("y", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("z", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateTail();

            //template Coords2d {
            //  <F6F23F44-7686-11cf-8F52-0040333594A3>
            //  FLOAT u;
            //  FLOAT v;
            // }
        blRet = blRet && OutputTemplateHeader("Coords2d", oCoords2dGUID);
        blRet = blRet && OutputTemplateMember("u", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("v", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateTail();

            //template Matrix4x4 {
            //  <F6F23F45-7686-11cf-8F52-0040333594A3>
            //  array FLOAT matrix[16];
            // }
        blRet = blRet && OutputTemplateHeader("Matrix4x4", oMatrix4x4GUID);
        blRet = blRet && OutputTemplateArrayMember("matrix", TOKEN_FLOAT, NULL, 16);
        blRet = blRet && OutputTemplateTail();

            //template ColorRGBA {
            //    <35FF44E0-6C7C-11cf-8F52-0040333594A3>
            //    FLOAT red;
            //    FLOAT green;
            //    FLOAT blue;
            //    FLOAT alpha;
            // }
        blRet = blRet && OutputTemplateHeader("ColorRGBA", oColorRGBAGUID);
        blRet = blRet && OutputTemplateMember("red", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("green", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("blue", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("alpha", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateTail();

            //template ColorRGB {
            //    <D3E16E81-7835-11cf-8F52-0040333594A3>
            //    FLOAT red;
            //    FLOAT green;
            //    FLOAT blue;
            // }
        blRet = blRet && OutputTemplateHeader("ColorRGB", oColorRGBGUID);
        blRet = blRet && OutputTemplateMember("red", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("green", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("blue", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateTail();

            //template IndexedColor {
            //    <1630B820-7842-11cf-8F52-0040333594A3>
            //    DWORD index;
            //    ColorRGBA indexColor;
            // }
        blRet = blRet && OutputTemplateHeader("IndexedColor", oIndexedColorGUID);
        blRet = blRet && OutputTemplateMember("index", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("indexColor", "ColorRGBA");
        blRet = blRet && OutputTemplateTail();

            //template Boolean {
            //    <4885AE61-78E8-11cf-8F52-0040333594A3>
            //    DWORD truefalse;
            // }
        blRet = blRet && OutputTemplateHeader("Boolean", oBooleanGUID);
        blRet = blRet && OutputTemplateMember("trueFalse", TOKEN_DWORD);
        blRet = blRet && OutputTemplateTail();

            //template Boolean2d {
            //    <4885AE63-78E8-11cf-8F52-0040333594A3>
            //    Boolean u;
            //    Boolean v;
            // }
        blRet = blRet && OutputTemplateHeader("Boolean2d", oBoolean2dGUID);
        blRet = blRet && OutputTemplateMember("u", "Boolean");
        blRet = blRet && OutputTemplateMember("v", "Boolean");
        blRet = blRet && OutputTemplateTail();

            //template MaterialWrap {
            //    <4885AE60-78E8-11cf-8F52-0040333594A3>
            //    Boolean u;
            //    Boolean v;
            // }
        blRet = blRet && OutputTemplateHeader("MaterialWrap", oMaterialWrapGUID);
        blRet = blRet && OutputTemplateMember("u", "Boolean");
        blRet = blRet && OutputTemplateMember("v", "Boolean");
        blRet = blRet && OutputTemplateTail();

            //template Material {
            //    <3D82AB4D-62DA-11cf-AB39-0020AF71E433>
            //    ColorRGBA faceColor;
            //    FLOAT power;
            //    ColorRGB specularColor;
            //    ColorRGB emissiveColor;
            //    [...]
            // }
        blRet = blRet && OutputTemplateHeader("Material", oMaterialGUID);
        blRet = blRet && OutputTemplateMember("faceColor", "ColorRGBA");
        blRet = blRet && OutputTemplateMember("power", TOKEN_FLOAT);
        blRet = blRet && OutputTemplateMember("specularColor", "ColorRGB");
        blRet = blRet && OutputTemplateMember("emissiveColor", "ColorRGB");
        blRet = blRet && OutputTemplateRestriction("...");
        blRet = blRet && OutputTemplateTail();

            //template TextureFilename {
            //    <A42790E1-7810-11cf-8F52-0040333594A3>
            //    STRING filename;
            // }
        blRet = blRet && OutputTemplateHeader("TextureFilename", oTextureFilenameGUID);
        blRet = blRet && OutputTemplateMember("filename", TOKEN_CSTRING);
        blRet = blRet && OutputTemplateTail();

            //template MeshFace {
            //    <3D82AB5F-62DA-11cf-AB39-0020AF71E433>
            //    DWORD nFaceVertexIndices;
            //    array DWORD faceVertexIndices[nFaceVertexIndices];
            // }
        blRet = blRet && OutputTemplateHeader("MeshFace", oMeshFaceGUID);
        blRet = blRet && OutputTemplateMember("nFaceVertexIndices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("FaceVertexIndices", TOKEN_DWORD,
            "nFaceVertexIndices", 0);
        blRet = blRet && OutputTemplateTail();

            //template Mesh {
            //    <3D82AB44-62DA-11cf-AB39-0020AF71E433>
            //    DWORD nVertices;
            //    array Vector vertices[nVertices];
            //    DWORD nFaces;
            //    array MeshFace faces[nFaces];
            //    [...]
            // }
        blRet = blRet && OutputTemplateHeader("Mesh", oMeshGUID);
        blRet = blRet && OutputTemplateMember("nVertices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertices", "Vector",
            "nVertices", 0);
        blRet = blRet && OutputTemplateMember("nFaces", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("naces", "MeshFace",
            "nFaces", 0);
        blRet = blRet && OutputTemplateRestriction("...");
        blRet = blRet && OutputTemplateTail();

            //template MeshNormals {
            //    <F6F23F43-7686-11cf-8F52-0040333594A3>
            //    DWORD nNormals;
            //    array Vector normals[nNormals];
            //    DWORD nFaceNormals;
            //    array MeshFace faceNormals[nFaceNormals];
            // }
        blRet = blRet && OutputTemplateHeader("MeshNormals", oMeshNormalsGUID);
        blRet = blRet && OutputTemplateMember("nNormals", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("normals", "Vector",
            "nNormals", 0);
        blRet = blRet && OutputTemplateMember("nFaceNormals", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("naceNormals", "MeshFace",
            "nFaceNormals", 0);
        blRet = blRet && OutputTemplateTail();

            //template MeshFaceWraps {
            //    <4885AE62-78E8-11cf-8F52-0040333594A3>
            //    DWORD nFaceWrapValues;
            //    Boolean2d faceWrapValues;
            // }
        blRet = blRet && OutputTemplateHeader("MeshFaceWraps", oMeshFaceWrapsGUID);
        blRet = blRet && OutputTemplateMember("nFaceWrapValues", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("naceWrapValues", "Boolean2d");
        blRet = blRet && OutputTemplateTail();

            //template MeshTextureCoords {
            //    <F6F23F40-7686-11cf-8F52-0040333594A3>
            //    DWORD nTextureCoords;
            //    array Coords2d textureCoords[nTextureCoords];
            // }
        blRet = blRet && OutputTemplateHeader("MeshTextureCoords", oMeshTextureCoordsGUID);
        blRet = blRet && OutputTemplateMember("nTextureCoords", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("textureCoords", "Coords2d",
            "nTextureCoords", 0);
        blRet = blRet && OutputTemplateTail();

            //template VertexDuplicationIndices {
            // <b8d65549-d7c9-4995-89cf-53a9a8b031e3>
            // DWORD nIndices;
            // DWORD nOriginalVertices;
            // array DWORD indices[nIndices];
            //}
        blRet = blRet && OutputTemplateHeader("VertexDuplicationIndices", oVertexDuplicationIndicesGUID);
        blRet = blRet && OutputTemplateMember("nIndices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nOriginalVertices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("indices", TOKEN_DWORD,
            "nIndices", 0);
        blRet = blRet && OutputTemplateTail();

            //template MeshMaterialList {
            //    <F6F23F42-7686-11cf-8F52-0040333594A3>
            //    DWORD nMaterials;
            //    DWORD nFaceIndexes;
            //    array DWORD faceIndexes[nFaceIndexes];
            //    [Material]
            // }
        blRet = blRet && OutputTemplateHeader("MeshMaterialList", oMeshMaterialListGUID);
        blRet = blRet && OutputTemplateMember("nMaterials", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nFaceIndexes", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("faceIndexes", TOKEN_DWORD,
            "nFaceIndexes", 0);
        blRet = blRet && OutputTemplateRestriction("Material");
        blRet = blRet && OutputTemplateTail();

            //template MeshVertexColors {
            //    <1630B821-7842-11cf-8F52-0040333594A3>
            //    DWORD nVertexColors;
            //    array IndexedColor vertexColors[nVertexColors];
            // }
        blRet = blRet && OutputTemplateHeader("MeshVertexColors", oMeshVertexColorsGUID);
        blRet = blRet && OutputTemplateMember("nVertexColors", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexColors", "IndexedColor",
            "nVertexColors", 0);
        blRet = blRet && OutputTemplateTail();

            //template FrameTransformMatrix {
            //    <F6F23F41-7686-11cf-8F52-0040333594A3>
            //    Matrix4x4 frameMatrix;
            // }
        blRet = blRet && OutputTemplateHeader("FrameTransformMatrix", oFrameTransformMatrixGUID);
        blRet = blRet && OutputTemplateMember("frameMatrix", "Matrix4x4");
        blRet = blRet && OutputTemplateTail();

            //template Frame {
            //    <3D82AB46-62DA-11cf-AB39-0020AF71E433>
            //    [...]
            // }
        blRet = blRet && OutputTemplateHeader("Frame", oFrameGUID);
        blRet = blRet && OutputTemplateRestriction("...");
        blRet = blRet && OutputTemplateTail();

            //template Animation {
            //    <3D82AB4F-62DA-11cf-AB39-0020AF71E433>
            //    [...]
            // }
        blRet = blRet && OutputTemplateHeader("Animation", oAnimationGUID);
        blRet = blRet && OutputTemplateRestriction("...");
        blRet = blRet && OutputTemplateTail();

            //template AnimationSet {
            //    <3D82AB50-62DA-11cf-AB39-0020AF71E433>
            //    [Animation]
            // }
        blRet = blRet && OutputTemplateHeader("AnimationSet", oAnimationSetGUID);
        blRet = blRet && OutputTemplateRestriction("Animation");
        blRet = blRet && OutputTemplateTail();

            //template FloatKeys {
            //    <10DD46A9-775B-11cf-8F52-0040333594A3>
            //    DWORD nValues;
            //    array FLOAT values[nValues];
            // }
        blRet = blRet && OutputTemplateHeader("FloatKeys", oFloatKeysGUID);
        blRet = blRet && OutputTemplateMember("nValues", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("values", TOKEN_FLOAT,
            "nValues", 0);
        blRet = blRet && OutputTemplateTail();

            //template TimedFloatKeys {
            //    <F406B180-7B3B-11cf-8F52-0040333594A3>
            //    DWORD time;
            //    FloatKeys tfkeys;
            // }
        blRet = blRet && OutputTemplateHeader("TimedFloatKeys", oTimedFloatKeysGUID);
        blRet = blRet && OutputTemplateMember("time", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("tfkeys", "FloatKeys");
        blRet = blRet && OutputTemplateTail();

            //template AnimationKey {
            //    <10DD46A8-775B-11cf-8F52-0040333594A3>
            //    DWORD keyType;
            //    DWORD nKeys;
            //    array TimedFloatKeys keys[nKeys];
            // }
        blRet = blRet && OutputTemplateHeader("AnimationKey", oAnimationKeyGUID);
        blRet = blRet && OutputTemplateMember("keyType", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nKeys", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("keys", "TimedFloatKeys",
            "nKeys", 0);
        blRet = blRet && OutputTemplateTail();

            //template AnimationOptions {
            //    <E2BF56C0-840F-11cf-8F52-0040333594A3>
            //    DWORD openclosed;
            //    DWORD positionquality;
            // }
        blRet = blRet && OutputTemplateHeader("AnimationOptions", oAnimationOptionsGUID);
        blRet = blRet && OutputTemplateMember("openclosed", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("positionquality", TOKEN_DWORD);
        blRet = blRet && OutputTemplateTail();
    }

    if ((m_eFormat == kFormatDirectXSkinAndBones) &&
        (m_blAddTemplates || m_blAddSkinAndBonesTemplates))
    {
		// DirectX 8 additions.

            //template XSkinMeshHeader {
            // <3cf169ce-ff7c-44ab-93c0-f78f62d172e2>
            // WORD nMaxSkinWeightsPerVertex;
            // WORD nMaxSkinWeightsPerFace;
            // WORD nBones;
            //}
        blRet = blRet && OutputTemplateHeader("XSkinMeshHeader", oXSkinMeshHeaderGUID);
        blRet = blRet && OutputTemplateMember("nMaxSkinWeightsPerVertex", TOKEN_WORD);
        blRet = blRet && OutputTemplateMember("nMaxSkinWeightsPerFace", TOKEN_WORD);
        blRet = blRet && OutputTemplateMember("nBones", TOKEN_WORD);
        blRet = blRet && OutputTemplateTail();

            //template VertexDuplicationIndices {
            // <b8d65549-d7c9-4995-89cf-53a9a8b031e3>
            // DWORD nIndices;
            // DWORD nOriginalVertices;
            // array DWORD indices[nIndices];
            //}
        blRet = blRet && OutputTemplateHeader("VertexDuplicationIndices", oVertexDuplicationIndicesGUID);
        blRet = blRet && OutputTemplateMember("nIndices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nOriginalVertices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("indices", TOKEN_DWORD,
            "nIndices", 0);
        blRet = blRet && OutputTemplateTail();

            //template SkinWeights {
            // <6f0d123b-bad2-4167-a0d0-80224f25fabb>
            // STRING transformNodeName;
            // DWORD nWeights;
            // array DWORD vertexIndices[nWeights];
            // array FLOAT weights[nWeights];
            // Matrix4x4 matrixOffset;
            //}
        blRet = blRet && OutputTemplateHeader("SkinWeights", oSkinWeightsGUID);
        blRet = blRet && OutputTemplateMember("transformNodeName", TOKEN_CSTRING);
        blRet = blRet && OutputTemplateMember("nWeights", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexIndices", TOKEN_DWORD,
            "nWeights", 0);
        blRet = blRet && OutputTemplateArrayMember("weights", TOKEN_FLOAT,
            "nWeights", 0);
        blRet = blRet && OutputTemplateMember("matrixOffset", "Matrix4x4");
        blRet = blRet && OutputTemplateTail();
    }

    if (((m_eFormat == kFormatJTGameSkinAndBones) ||
            (m_eFormat == kFormatJTGameRenderGroups)) &&
        (m_blAddTemplates | m_blAddSkinAndBonesTemplates))
    {
            //template BoneMatrix {
            //    <3376abdb-ec20-11d3-8638-0000e856bada>
            //    Matrix4x4 frameMatrix;
            //    [BoneMatrix]
            // }
        blRet = blRet && OutputTemplateHeader("BoneMatrix", oBoneMatrixGUID);
        blRet = blRet && OutputTemplateMember("frameMatrix", "Matrix4x4");
        blRet = blRet && OutputTemplateMember("vertexFixupMatrix", "Matrix4x4");
        blRet = blRet && OutputTemplateRestriction("BoneMatrix");
        blRet = blRet && OutputTemplateTail();
    }

    if ((m_eFormat == kFormatJTGameSkinAndBones) &&
        (m_blAddTemplates | m_blAddSkinAndBonesTemplates))
    {
            //template MeshOptions {
            //    <3376abd0-ec20-11d3-8638-0000e856bada>
            //    DWORD MeshFlags;
            //    DWORD MeshFVFFlags;
            // }
        blRet = blRet && OutputTemplateHeader("MeshOptions", oMeshOptionsGUID);
        blRet = blRet && OutputTemplateMember("MeshFlags", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("MeshFVFFlags", TOKEN_DWORD);
        blRet = blRet && OutputTemplateTail();

            //template MeshBoneData {
            //    <3376abd1-ec20-11d3-8638-0000e856bada>
            //    DWORD nVertexMatrixIndicesPerVertex;
            //    DWORD nVertexMatrixIndices;
            //    array DWORD vertexMatrixIndices[nVertexMatrixIndices];
            //    DWORD nVertexWeightsPerVertex;
            //    DWORD nVertexWeights;
            //    array DWORD vertexWeights[nVertexWeights];
            // }
        blRet = blRet && OutputTemplateHeader("MeshBoneData", oMeshBoneDataGUID);
        blRet = blRet && OutputTemplateMember("nVertexMatrixIndicesPerVertex", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nVertexMatrixIndices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexMatrixIndices", TOKEN_DWORD,
            "nVertexMatrixIndices", 0);
        blRet = blRet && OutputTemplateMember("nVertexWeightsPerVertex", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nVertexWeights", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexWeights", TOKEN_FLOAT,
            "nVertexWeights", 0);
        blRet = blRet && OutputTemplateTail();
    }

    if ((m_eFormat == kFormatJTGameRenderGroups) &&
        (m_blAddTemplates | m_blAddSkinAndBonesTemplates))
    {
        // Render group.

            //template RenderGroup {
            //    <3376abde-ec20-11d3-8638-0000e856bada>
            //    DWORD vertexFormatFlags;
            //    DWORD nVertices;
            //    array Vector vertices[nVertices];
            //    DWORD nFaces;
            //    array MeshFace faces[nFaces];
            //    [...]
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroup", oRenderGroupGUID);
        blRet = blRet && OutputTemplateMember("vertexFormatFlags", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nVertices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertices", "Vector",
            "nVertices", 0);
        blRet = blRet && OutputTemplateMember("nFaces", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("faces", "MeshFace",
            "nFaces", 0);
        blRet = blRet && OutputTemplateRestriction("...");
        blRet = blRet && OutputTemplateTail();

            //template RenderGroupNormals {
            //    <3376abe2-ec20-11d3-8638-0000e856bada>
            //    DWORD nNormals;
            //    array Vector normals[nNormals];
            //    DWORD nFaceNormals;
            //    array MeshFace faceNormals[nFaceNormals];
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroupNormals", oRenderGroupNormalsGUID);
        blRet = blRet && OutputTemplateMember("nNormals", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("normals", "Vector",
            "nNormals", 0);
        blRet = blRet && OutputTemplateMember("nFaceNormals", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("naceNormals", "MeshFace",
            "nFaceNormals", 0);
        blRet = blRet && OutputTemplateTail();

            //template RenderGroupFaceWraps {
            //    <3376abe0-ec20-11d3-8638-0000e856bada>
            //    DWORD nFaceWrapValues;
            //    Boolean2d faceWrapValues;
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroupFaceWraps", oRenderGroupFaceWrapsGUID);
        blRet = blRet && OutputTemplateMember("nFaceWrapValues", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("faceWrapValues", "Boolean2d");
        blRet = blRet && OutputTemplateTail();

            //template RenderGroupTextureCoords {
            //    <3376abe1-ec20-11d3-8638-0000e856bada>
            //    DWORD nTextureCoords;
            //    array Coords2d textureCoords[nTextureCoords];
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroupTextureCoords", oRenderGroupTextureCoordsGUID);
        blRet = blRet && OutputTemplateMember("nTextureCoords", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("textureCoords", "Coords2d",
            "nTextureCoords", 0);
        blRet = blRet && OutputTemplateTail();

            //template RenderGroupVertexColors {
            //    <3376abe3-ec20-11d3-8638-0000e856bada>
            //    DWORD nVertexColors;
            //    array IndexedColor vertexColors[nVertexColors];
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroupVertexColors", oRenderGroupVertexColorsGUID);
        blRet = blRet && OutputTemplateMember("nVertexColors", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexColors", "IndexedColor",
            "nVertexColors", 0);
        blRet = blRet && OutputTemplateTail();

            //template RenderGroupVertexMatrixIndices {
            //    <3376abe3-ec20-11d3-8638-0000e856bada>
            //    DWORD nVertexMatrixIndicesPerVertex;
            //    DWORD nVertexMatrixIndices;
            //    array DWORD vertexMatrixIndices[nVertexMatrixIndices];
            //    DWORD nVertexWeightsPerVertex;
            //    DWORD nVertexWeights;
            //    array DWORD vertexWeights[nVertexWeights];
            // }
        blRet = blRet && OutputTemplateHeader("RenderGroupVertexMatrixIndices", oRenderGroupVertexMatrixIndicesGUID);
        blRet = blRet && OutputTemplateMember("nVertexMatrixIndicesPerVertex", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nVertexMatrixIndices", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexMatrixIndices", TOKEN_DWORD,
            "nVertexMatrixIndices", 0);
        blRet = blRet && OutputTemplateMember("nVertexWeightsPerVertex", TOKEN_DWORD);
        blRet = blRet && OutputTemplateMember("nVertexWeights", TOKEN_DWORD);
        blRet = blRet && OutputTemplateArrayMember("vertexWeights", TOKEN_FLOAT,
            "nVertexWeights", 0);
        blRet = blRet && OutputTemplateTail();
    }

    return(blRet);
}
