/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "weldcmd.h"

#include "model.h"
#include "glmath.h"
#include "log.h"
#include "msg.h"
#include "modelstatus.h"

#include "weld.h"

#include <list>
#include <map>

using std::list;
using std::map;

WeldCommand::WeldCommand()
{
}

WeldCommand::~WeldCommand()
{
}

bool WeldCommand::activated( int arg, Model * model )
{
   if ( model )
   {
      list<int> vert = model->getSelectedVertices();

      if ( vert.size() > 1 )
      {
         weldSelectedVertices( model );
         return true;
      }
      else
      {
         model_status( model, StatusError, STATUSTIME_LONG, "You must have 2 or more vertices selected to weld." );
      }
   }
   
   return false;
}

