/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#ifndef __SPHERIFYWIN_H
#define __SPHERIFYWIN_H

#include "valuewin.h"

#include <list>

class Model;

class SpherifyWin : public ValueWin
{
   Q_OBJECT

   public:
      SpherifyWin( Model * model, QWidget * parent = NULL, const char * name = "" );
      virtual ~SpherifyWin();

   public slots:
      void valueEditChanged( const QString & );
      void valueSliderChanged( int );

      void accept();
      void reject();

   protected:
      virtual void showHelp();

      typedef struct SpherifyVert_t
      {
         unsigned v;
         double coords[3];
      } SpherifyVert;
      typedef std::list<SpherifyVert> SpherifyVertList;

      Model * m_model;
      double  m_center[3];
      double  m_radius;
      SpherifyVertList m_verts;
      SpherifyVertList m_joints;
};

#endif // __SPHERIFYWIN_H
