/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "rectangletool.h"
#include "pixmap/rectangletool.xpm"
#include "log.h"
#include "model.h"
#include "modelstatus.h"

RectangleTool::RectangleTool()
   : m_tracking( false ),
     m_parent( NULL )
{
}

RectangleTool::~RectangleTool()
{
}

void RectangleTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   if ( !m_tracking )
   {
      m_parent   = parent; // Keep track of which parent we're serving
      m_tracking = true;

      m_x1 = 0.0;
      m_y1 = 0.0;
      m_z1 = 0.0;

      parent->getXValue( x, y, &m_x1 );
      parent->getYValue( x, y, &m_y1 );
      parent->getZValue( x, y, &m_z1 );

      Model * model = parent->getModel();

      model->unselectAll();

      m_v1 = model->addVertex( m_x1, m_y1, m_z1 );
      m_v2 = model->addVertex( m_x1, m_y1, m_z1 );
      m_v3 = model->addVertex( m_x1, m_y1, m_z1 );
      m_v4 = model->addVertex( m_x1, m_y1, m_z1 );

      model->addTriangle( m_v1, m_v2, m_v4 );
      model->addTriangle( m_v4, m_v3, m_v1 );

      model->selectVertex( m_v1 );
      model->selectVertex( m_v2 );
      model->selectVertex( m_v3 );
      model->selectVertex( m_v4 );

      parent->updateAllViews();

      model_status( model, StatusNormal, STATUSTIME_SHORT, "Rectangle created" );
   }
}

void RectangleTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
   if ( parent != m_parent )
   {
      log_error( "Can't serve two parents at once\n" );
      return;
   }

   if ( m_tracking )
   {
      m_tracking = false;

      double x2 = 0.0;
      double y2 = 0.0;
      double z2 = 0.0;

      bool haveXVal = parent->getXValue( x, y, &x2 );
      bool haveYVal = parent->getYValue( x, y, &y2 );
      parent->getZValue( x, y, &z2 );

      Model * model = parent->getModel();

      if ( !haveXVal )
      {
         model->moveVertex( m_v2, m_x1, y2, m_z1 );
         model->moveVertex( m_v3, m_x1, m_y1, z2 );
         model->moveVertex( m_v4, m_x1, y2, z2 );
      }
      else if ( !haveYVal )
      {
         model->moveVertex( m_v2, m_x1, m_y1, z2 );
         model->moveVertex( m_v3, x2, m_y1, m_z1 );
         model->moveVertex( m_v4, x2, m_y1, z2 );
      }
      else
      {
         model->moveVertex( m_v2, m_x1, y2, m_z1 );
         model->moveVertex( m_v3, x2, m_y1, m_z1 );
         model->moveVertex( m_v4, x2, y2, m_z1 );
      }

      parent->updateAllViews();
   }
}

void RectangleTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   if ( parent != m_parent )
   {
      log_error( "Can't serve two parents at once\n" );
   }

   if ( m_tracking )
   {
      double x2 = 0.0;
      double y2 = 0.0;
      double z2 = 0.0;

      bool haveXVal = parent->getXValue( x, y, &x2 );
      bool haveYVal = parent->getYValue( x, y, &y2 );
      parent->getZValue( x, y, &z2 );

      Model * model = parent->getModel();

      if ( !haveXVal )
      {
         model->moveVertex( m_v2, m_x1, y2, m_z1 );
         model->moveVertex( m_v3, m_x1, m_y1, z2 );
         model->moveVertex( m_v4, m_x1, y2, z2 );
      }
      else if ( !haveYVal )
      {
         model->moveVertex( m_v2, m_x1, m_y1, z2 );
         model->moveVertex( m_v3, x2, m_y1, m_z1 );
         model->moveVertex( m_v4, x2, m_y1, z2 );
      }
      else
      {
         model->moveVertex( m_v2, m_x1, y2, m_z1 );
         model->moveVertex( m_v3, x2, m_y1, m_z1 );
         model->moveVertex( m_v4, x2, y2, m_z1 );
      }

      parent->updateAllViews();
   }
}

const char ** RectangleTool::getPixmap()
{
   return (const char **) rectangletool_xpm;
}

