/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __PREFERENCES_H
#define __PREFERENCES_H

#include <stdio.h>
#include <qstring.h>
#include <map>
#include <vector>

class PrefItem;

typedef std::map< QString, PrefItem > PrefItemHash;
typedef std::vector< PrefItem > PrefItemList;

class PrefItem
{
   public:
      PrefItem();
      virtual ~PrefItem();

      enum  PI_Type
      {
         PI_String,
         PI_Int,
         PI_Double,
         PI_List,
         PI_Hash
      };
      
      bool     isList();
      bool     isHash();
      unsigned count();
      unsigned keys();
      void     clear();
      void     insert( unsigned index, const PrefItem & item );
      void     remove( unsigned index );
      void     remove( const QString & key );
      bool     exists( const QString & key );
      void     print( int indent = 0, FILE * fp = stdout );

      int    operator=(int rhs);
      double operator=(double rhs);
      const QString & operator=(const QString& rhs);

      int     intValue();
      double  doubleValue();
      QString stringValue();

      operator int();
      operator double();
      operator QString();

      PrefItem & operator[](unsigned);
      PrefItem & operator()(const QString &);

   protected:
      void convertAll(void);

      bool         m_allTypes;
      PI_Type      m_type;
      QString      m_string;
      int          m_int;
      double       m_double;
      PrefItemList m_list;
      PrefItemHash m_hash;
};

class Preferences
{
   public:
      Preferences();
      virtual ~Preferences();

      PrefItem & operator[](unsigned);
      PrefItem & operator()(const QString &);

      void setRootItem( PrefItem * i );
      void print( FILE * fp = stdout );

      bool exists( const QString & );

   protected:
      PrefItem * m_rootItem;
};

// Overloaded type-specific operators for convenience
QString operator+( PrefItem &, QString );
QString operator+( QString, PrefItem & );
int     operator+( PrefItem &, int );
int     operator+( int, PrefItem & );
double  operator+( PrefItem &, double );
double  operator+( double, PrefItem & );
int     operator*( PrefItem &, int );
int     operator*( int, PrefItem & );
double  operator*( PrefItem &, double );
double  operator*( double, PrefItem & );
int     operator/( PrefItem &, int );
int     operator/( int, PrefItem & );
double  operator/( PrefItem &, double );
double  operator/( double, PrefItem & );
int     operator-( PrefItem &, int );
int     operator-( int, PrefItem & );
double  operator-( PrefItem &, double );
double  operator-( double, PrefItem & );

#endif /* __PREFERENCES_H */

