/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "movetool.h"
#include "pixmap/movetool.xpm"
#include "glmath.h"
#include "model.h"
#include "modelstatus.h"

#include <math.h>

#include "log.h"

MoveTool::MoveTool()
{
}

MoveTool::~MoveTool()
{
}

void MoveTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   m_x = 0.0;
   m_y = 0.0;
   m_z = 0.0;

   parent->getXValue( x, y, &m_x );
   parent->getYValue( x, y, &m_y );
   parent->getZValue( x, y, &m_z );

   m_allowX = true;
   m_allowY = true;
   m_allowZ = true;

   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Moving selected primitives" );
}

void MoveTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Move complete" );
}

void MoveTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   Matrix m;

   double x2 = m_x;
   double y2 = m_y;
   double z2 = m_z;

   parent->getXValue( x, y, &x2 );
   parent->getYValue( x, y, &y2 );
   parent->getZValue( x, y, &z2 );

   if ( buttonState & BS_Shift )
   {
      if ( m_allowX && m_allowY && m_allowZ )
      {
         double ax = fabs( x2 - m_x );
         double ay = fabs( y2 - m_y );
         double az = fabs( z2 - m_z );

         if ( ax > ay && ax > az )
         {
            m_allowY = false;
            m_allowZ = false;
         }
         if ( ay > ax && ay > az )
         {
            m_allowX = false;
            m_allowZ = false;
         }
         if ( az > ax && az > ay )
         {
            m_allowX = false;
            m_allowY = false;
         }
      }
   }

   if ( !m_allowX )
   {
      x2 = m_x;
   }
   if ( !m_allowY )
   {
      y2 = m_y;
   }
   if ( !m_allowZ )
   {
      z2 = m_z;
   }

   m.set( 3, 0, (float) x2 - m_x );
   m.set( 3, 1, (float) y2 - m_y );
   m.set( 3, 2, (float) z2 - m_z );

   m_x = x2;
   m_y = y2;
   m_z = z2;

   parent->getModel()->translateSelectedVertices( m );
   parent->updateAllViews();
}

const char ** MoveTool::getPixmap()
{
   return (const char **) movetool_xpm;
}

void MoveTool::activated( int argc, Model * model, QMainWindow * mainwin )
{
   model_status( model, StatusNormal, STATUSTIME_NONE, "Tip: Hold shift to restrict movement to one dimension" );
}

